/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis.decode;

import codeAnalysis.decode.CompiledAttribute;
import codeAnalysis.decode.CompiledField;
import codeAnalysis.decode.CompiledMethod;
import codeAnalysis.decode.cp.Cp;
import codeAnalysis.decode.cp.CpClass;
import codeAnalysis.decode.cp.CpDouble;
import codeAnalysis.decode.cp.CpLong;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.PureLogWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;

public class CompiledClass
implements Comparable {
    public long magic;
    public int minor_version;
    public int major_version;
    public int constant_pool_count;
    public Cp[] constant_pool;
    public int access_flags;
    public int this_class;
    public int super_class;
    public int interfaces_count;
    public int[] interfaces;
    public int fields_count;
    public CompiledField[] fields;
    public int methods_count;
    public CompiledMethod[] methods;
    public int attributes_count;
    public CompiledAttribute[] attributes;
    static LogWriter debugLog;
    static PrintStream debugStream;

    public static CompiledClass getInstance(File classFile) throws IOException {
        FileInputStream fstream = new FileInputStream(classFile);
        DataInputStream source = new DataInputStream(fstream);
        CompiledClass instance = new CompiledClass(source);
        fstream.close();
        return instance;
    }

    public static CompiledClass getInstance(InputStream classStream) throws IOException {
        DataInputStream source = new DataInputStream(classStream);
        CompiledClass instance = new CompiledClass(source);
        classStream.close();
        return instance;
    }

    public CompiledClass(DataInputStream source) throws IOException {
        int idx;
        this.magic = source.readInt();
        this.minor_version = source.readUnsignedShort();
        this.major_version = source.readUnsignedShort();
        this.constant_pool_count = source.readUnsignedShort();
        this.constant_pool = new Cp[this.constant_pool_count];
        this.constant_pool[0] = null;
        for (idx = 1; idx < this.constant_pool_count; ++idx) {
            this.constant_pool[idx] = Cp.readCp(source);
            if (!(this.constant_pool[idx] instanceof CpLong) && !(this.constant_pool[idx] instanceof CpDouble)) continue;
            ++idx;
        }
        this.access_flags = source.readUnsignedShort();
        this.this_class = source.readUnsignedShort();
        this.super_class = source.readUnsignedShort();
        this.interfaces_count = source.readUnsignedShort();
        this.interfaces = new int[this.interfaces_count];
        for (idx = 0; idx < this.interfaces_count; ++idx) {
            this.interfaces[idx] = source.readUnsignedShort();
        }
        this.fields_count = source.readUnsignedShort();
        this.fields = new CompiledField[this.fields_count];
        for (idx = 0; idx < this.fields_count; ++idx) {
            this.fields[idx] = new CompiledField(source, this);
        }
        this.methods_count = source.readUnsignedShort();
        this.methods = new CompiledMethod[this.methods_count];
        for (idx = 0; idx < this.methods_count; ++idx) {
            this.methods[idx] = new CompiledMethod(source, this);
        }
        this.attributes_count = source.readUnsignedShort();
        this.attributes = new CompiledAttribute[this.attributes_count];
        for (idx = 0; idx < this.attributes_count; ++idx) {
            this.attributes[idx] = new CompiledAttribute(source);
        }
    }

    String accessString() {
        StringBuffer result = new StringBuffer();
        if ((this.access_flags & 1) != 0) {
            result.append("public ");
        }
        if ((this.access_flags & 2) != 0) {
            result.append("(private?) ");
        }
        if ((this.access_flags & 4) != 0) {
            result.append("(protected?) ");
        }
        if ((this.access_flags & 8) != 0) {
            result.append("(static?) ");
        }
        if ((this.access_flags & 0x10) != 0) {
            result.append("final ");
        }
        if ((this.access_flags & 0x20) != 0) {
            result.append("(??0x20??) ");
        }
        if ((this.access_flags & 0x40) != 0) {
            result.append("(volatile?) ");
        }
        if ((this.access_flags & 0x80) != 0) {
            result.append("(transient?) ");
        }
        if ((this.access_flags & 0x100) != 0) {
            result = result.append("(??0x100??) ");
        }
        if ((this.access_flags & 0x200) != 0) {
            result = result.append("interface ");
        }
        if ((this.access_flags & 0x400) != 0) {
            result = result.append("abstract ");
        }
        if ((this.access_flags & 0x800) != 0) {
            result = result.append("(??0x800??) ");
        }
        return result.toString();
    }

    public boolean isInterface() {
        return (this.access_flags & 0x200) != 0;
    }

    public boolean isSerializableAndNotDataSerializable() {
        String name = this.fullyQualifiedName().replace('/', '.');
        if (name.startsWith("com.gemstone.gemfire.internal.shared.NativeCallsJNAImpl") || name.startsWith("com.gemstone.gemfire.internal.HostStatHelper")) {
            return false;
        }
        try {
            debugLog.info("isSerializableAndNotDataSerializable loading class " + name);
            debugStream.flush();
            Class<?> realClass = Class.forName(name);
            return Serializable.class.isAssignableFrom(realClass) && !DataSerializable.class.isAssignableFrom(realClass) && !DataSerializableFixedID.class.isAssignableFrom(realClass);
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Unable to load actual class " + name + " external JNI dependencies");
        }
        catch (NoClassDefFoundError e) {
            System.out.println("Unable to load actual class " + name + " not in JUnit classpath");
        }
        catch (Throwable e) {
            System.out.println("Unable to load actual class " + name + ": " + e);
        }
        return false;
    }

    public String fullyQualifiedName() {
        return ((CpClass)this.constant_pool[this.this_class]).className(this);
    }

    public String superClassName() {
        return ((CpClass)this.constant_pool[this.super_class]).className(this);
    }

    public int compareTo(Object other) {
        if (!(other instanceof CompiledClass)) {
            return -1;
        }
        String otherName = ((CompiledClass)other).fullyQualifiedName();
        return this.fullyQualifiedName().compareTo(otherName);
    }

    public static void main(String[] argv) {
        File classFile = null;
        try {
            classFile = new File(argv[0]);
        }
        catch (NullPointerException e) {
            System.err.println("You must give the name of a class file on the command line");
            CompiledClass.exit(3);
        }
        if (classFile == null) {
            System.err.println("Unable to access " + argv[0]);
            CompiledClass.exit(3);
        }
        if (!classFile.canRead()) {
            System.err.println("Unable to read " + argv[0]);
            CompiledClass.exit(3);
        }
        try {
            int idx;
            CompiledClass instance = CompiledClass.getInstance(classFile);
            System.out.println("Class name is " + instance.fullyQualifiedName());
            System.out.println("Class access is " + instance.accessString());
            System.out.println("Superclass name is " + instance.superClassName());
            System.out.println("Fields:");
            for (idx = 0; idx < instance.fields_count; ++idx) {
                System.out.println("    " + instance.fields[idx].signature());
            }
            System.out.println("Methods:");
            for (idx = 0; idx < instance.methods_count; ++idx) {
                System.out.println("    " + instance.methods[idx].signature());
                System.out.println("..method attributes");
                for (int i = 0; i < instance.methods[idx].attributes_count; ++i) {
                    System.out.println(".." + instance.methods[idx].attributes[i].name(instance));
                }
            }
        }
        catch (Throwable e) {
            System.err.println("Error reading file: " + e.getMessage());
            CompiledClass.exit(3);
        }
        CompiledClass.exit(0);
    }

    private static void exit(int exitCode) {
        System.exit(exitCode);
    }

    static {
        try {
            debugStream = new PrintStream("loadedClasses.log");
            debugLog = new PureLogWriter(Integer.MIN_VALUE, debugStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

