/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis;

import codeAnalysis.ClassAndMethodDetails;
import codeAnalysis.ClassAndMethods;
import codeAnalysis.ClassAndVariableDetails;
import codeAnalysis.ClassAndVariables;
import codeAnalysis.decode.CompiledClass;
import codeAnalysis.decode.CompiledField;
import codeAnalysis.decode.CompiledMethod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CompiledClassUtils {
    public static Map<String, CompiledClass> parseClassFiles(List<File> classFiles) {
        HashMap<String, CompiledClass> result = new HashMap<String, CompiledClass>();
        for (File file : classFiles) {
            try {
                CompiledClass parsed = CompiledClass.getInstance(file);
                if (parsed.isInterface()) continue;
                result.put(parsed.fullyQualifiedName(), parsed);
            }
            catch (IOException e) {
                System.err.println("Exception while parsing " + file.getName() + ": " + e.getMessage());
            }
        }
        return result;
    }

    public static Map<String, CompiledClass> parseClassFiles(File jar) {
        HashMap<String, CompiledClass> result = new HashMap<String, CompiledClass>();
        try {
            JarFile jarfile = new JarFile(jar);
            Enumeration<JarEntry> entries = jarfile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try {
                    CompiledClass parsed = CompiledClass.getInstance(jarfile.getInputStream(entry));
                    if (parsed.isInterface()) continue;
                    result.put(parsed.fullyQualifiedName(), parsed);
                }
                catch (IOException e) {
                    System.err.println("Exception while parsing " + entry.getName() + ": " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error opening jar file:");
            e.printStackTrace(System.err);
        }
        return result;
    }

    public static List<File> findClassFiles(String parentPath, String[] filenames, boolean recursive) {
        ArrayList<File> classFiles = new ArrayList<File>();
        for (int i = 0; i < filenames.length; ++i) {
            File f = new File(parentPath + filenames[i]);
            String n = f.getAbsolutePath();
            if (!f.exists()) {
                System.err.println("File " + n + " does not exist - skipping");
                continue;
            }
            if (f.isFile() && f.getName().endsWith(".class")) {
                classFiles.add(f);
                continue;
            }
            if (!f.isDirectory() || !recursive) continue;
            classFiles.addAll(CompiledClassUtils.findClassFiles(f.getAbsolutePath() + "/", f.list(), true));
        }
        Collections.sort(classFiles);
        return classFiles;
    }

    public static List<ClassAndMethodDetails> loadClassesAndMethods(File file) throws IOException {
        ClassAndMethodDetails cam;
        LinkedList<ClassAndMethodDetails> result = new LinkedList<ClassAndMethodDetails>();
        FileReader fr = new FileReader(file);
        LineNumberReader in = new LineNumberReader(fr);
        while ((cam = ClassAndMethodDetails.create(in)) != null) {
            result.add(cam);
        }
        fr.close();
        return result;
    }

    public static String diffSortedClassesAndMethods(List<ClassAndMethodDetails> goldRecord, List<ClassAndMethods> toDatas) throws IOException {
        StringBuilder newClassesSb = new StringBuilder(10000);
        StringBuilder changedClassesSb = new StringBuilder(10000);
        newClassesSb.append("New or moved classes----------------------------------------\n");
        int newBase = newClassesSb.length();
        changedClassesSb.append("Modified classes--------------------------------------------\n");
        int changedBase = changedClassesSb.length();
        Iterator<ClassAndMethods> it = toDatas.iterator();
        ClassAndMethods newclass = null;
        for (ClassAndMethodDetails gold : goldRecord) {
            if (newclass == null) {
                if (!it.hasNext()) {
                    changedClassesSb.append(gold).append(": deleted or moved\n");
                    continue;
                }
                newclass = it.next();
            }
            int comparison = -1;
            while (newclass != null && (comparison = gold.className.compareTo(newclass.dclass.fullyQualifiedName())) > 0) {
                newClassesSb.append(newclass).append("\n");
                if (it.hasNext()) {
                    newclass = it.next();
                    continue;
                }
                newclass = null;
            }
            if (comparison != 0) continue;
            ClassAndMethods nc = newclass;
            newclass = null;
            if (gold.methodCode.size() != nc.numMethods()) {
                changedClassesSb.append(nc).append(": method count\n");
                continue;
            }
            boolean comma = false;
            for (Map.Entry<String, CompiledMethod> entry : nc.methods.entrySet()) {
                CompiledMethod method = entry.getValue();
                String name = method.name();
                byte[] goldCode = gold.methodCode.get(name);
                if (goldCode == null) {
                    if (comma) {
                        changedClassesSb.append(", and ");
                    } else {
                        changedClassesSb.append(nc).append(":  ");
                        comma = true;
                    }
                    changedClassesSb.append(name).append(" was added");
                    continue;
                }
                String diff = CompiledClassUtils.codeDiff(goldCode, method.getCode().code);
                if (diff == null) continue;
                if (comma) {
                    changedClassesSb.append(", and ");
                } else {
                    changedClassesSb.append(nc).append(":  ");
                    comma = true;
                }
                changedClassesSb.append(name).append(diff);
            }
            for (Map.Entry<String, CompiledMethod> entry : gold.methodCode.entrySet()) {
                if (nc.methods.containsKey(entry.getKey())) continue;
                if (comma) {
                    changedClassesSb.append(", and ");
                } else {
                    changedClassesSb.append(nc).append(":  ");
                }
                changedClassesSb.append(entry.getKey()).append(" is missing");
            }
            if (!comma) continue;
            changedClassesSb.append("\n");
        }
        while (it.hasNext()) {
            newclass = it.next();
            newClassesSb.append(newclass).append(": new class\n");
        }
        String result = "";
        if (newClassesSb.length() > newBase) {
            if (changedClassesSb.length() > changedBase) {
                newClassesSb.append("\n");
                newClassesSb.append((CharSequence)changedClassesSb);
            }
            result = newClassesSb.toString();
        } else if (changedClassesSb.length() > changedBase) {
            result = changedClassesSb.toString();
        }
        return result;
    }

    public static void storeClassesAndMethods(List<ClassAndMethods> cams, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fw);
        for (ClassAndMethods entry : cams) {
            out.append(ClassAndMethodDetails.convertForStoring(entry));
            out.newLine();
        }
        out.flush();
        out.close();
    }

    static String codeDiff(byte[] method1, byte[] method2) {
        if (method1.length != method2.length) {
            return " (len=" + method2.length + ",expected=" + method1.length + ")";
        }
        return null;
    }

    public static List<ClassAndVariableDetails> loadClassesAndVariables(File file) throws IOException {
        String line;
        LinkedList<ClassAndVariableDetails> result = new LinkedList<ClassAndVariableDetails>();
        FileReader fr = new FileReader(file);
        BufferedReader in = new BufferedReader(fr);
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
            result.add(new ClassAndVariableDetails(line));
        }
        fr.close();
        return result;
    }

    public static String diffSortedClassesAndVariables(List<ClassAndVariableDetails> goldRecord, List<ClassAndVariables> cavs) throws IOException {
        StringBuilder newClassesSb = new StringBuilder(10000);
        StringBuilder changedClassesSb = new StringBuilder(10000);
        newClassesSb.append("New or moved classes----------------------------------------\n");
        int newBase = newClassesSb.length();
        changedClassesSb.append("Modified classes--------------------------------------------\n");
        int changedBase = changedClassesSb.length();
        Iterator<ClassAndVariables> it = cavs.iterator();
        ClassAndVariables newclass = null;
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> changed = new ArrayList<String>();
        for (ClassAndVariableDetails gold : goldRecord) {
            added.clear();
            removed.clear();
            changed.clear();
            if (newclass == null) {
                if (!it.hasNext()) {
                    changedClassesSb.append(gold).append(": deleted or moved\n");
                    continue;
                }
                newclass = it.next();
            }
            int comparison = -1;
            while (newclass != null && (comparison = gold.className.compareTo(newclass.dclass.fullyQualifiedName())) > 0) {
                newClassesSb.append(ClassAndVariableDetails.convertForStoring(newclass)).append("\n");
                newclass = null;
                if (!it.hasNext()) continue;
                newclass = it.next();
            }
            if (comparison != 0) continue;
            ClassAndVariables nc = newclass;
            newclass = null;
            for (Map.Entry<String, CompiledField> entry : nc.variables.entrySet()) {
                CompiledField field = entry.getValue();
                String name = entry.getKey();
                String type = gold.variables.get(name);
                if (type == null) {
                    added.add(name);
                    continue;
                }
                String newType = field.descriptor();
                if (newType.equals(type)) continue;
                changed.add(name + " type changed to " + newType);
            }
            for (Map.Entry<String, Object> entry : gold.variables.entrySet()) {
                if (nc.variables.containsKey(entry.getKey())) continue;
                removed.add(entry.getKey());
            }
            if (!(added.isEmpty() && removed.isEmpty() && changed.isEmpty())) {
                changedClassesSb.append(nc).append('\n');
            }
            if (!added.isEmpty()) {
                changedClassesSb.append("\t\t added fields: ").append(added).append('\n');
            }
            if (!changed.isEmpty()) {
                changedClassesSb.append("\t\t changed fields: ").append(changed).append('\n');
            }
            if (gold.hasSerialVersionUID) {
                if (nc.hasSerialVersionUID) {
                    if (Long.valueOf(gold.serialVersionUID).equals(nc.serialVersionUID)) continue;
                    changedClassesSb.append("\t\t " + nc.dclass.fullyQualifiedName() + " serialVersionUID was changed from " + gold.serialVersionUID + " to " + nc.serialVersionUID + " this may break client/server compatibility as well as server/server compatibility \n");
                    continue;
                }
                changedClassesSb.append("\t\t " + nc.dclass.fullyQualifiedName() + " serialVersionUID was removed, this may break client/server compatibility as well as server/server compatibility \n");
                continue;
            }
            if (!nc.hasSerialVersionUID) continue;
            changedClassesSb.append("\t\t " + nc.dclass.fullyQualifiedName() + " serialVersionUID was added \n");
        }
        while (it.hasNext()) {
            newclass = it.next();
            newClassesSb.append(ClassAndVariableDetails.convertForStoring(newclass)).append(": new class\n");
        }
        String result = "";
        if (newClassesSb.length() > newBase) {
            if (changedClassesSb.length() > changedBase) {
                newClassesSb.append("\n");
                newClassesSb.append((CharSequence)changedClassesSb);
            }
            result = newClassesSb.toString();
        } else if (changedClassesSb.length() > changedBase) {
            result = changedClassesSb.toString();
        }
        return result;
    }

    public static void storeClassesAndVariables(List<ClassAndVariables> cams, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fw);
        for (ClassAndVariables entry : cams) {
            out.append(ClassAndVariableDetails.convertForStoring(entry));
            out.newLine();
        }
        out.flush();
        out.close();
    }
}

