/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis;

import codeAnalysis.ClassAndVariables;
import codeAnalysis.decode.CompiledClass;
import codeAnalysis.decode.CompiledField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClassAndVariableDetails
implements Comparable {
    public String className;
    public boolean hasSerialVersionUID;
    public String serialVersionUID;
    public Map<String, String> variables = new HashMap<String, String>();

    public ClassAndVariableDetails(CompiledClass dclass) {
        this.className = dclass.fullyQualifiedName();
    }

    public ClassAndVariableDetails(String storedValues) throws IOException {
        String[] fields = storedValues.split(",");
        try {
            int fieldIndex = 2;
            this.className = fields[0];
            this.hasSerialVersionUID = Boolean.valueOf(fields[1]);
            if (this.hasSerialVersionUID) {
                this.serialVersionUID = fields[2];
                ++fieldIndex;
            }
            for (int i = fieldIndex; i < fields.length; ++i) {
                String[] nameAndType = fields[i].split(":");
                this.variables.put(nameAndType[0], nameAndType[1]);
            }
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + storedValues, e);
        }
    }

    public String valuesAsString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(this.className);
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            sb.append(',').append(entry.getKey()).append(':').append(entry.getValue());
        }
        return sb.toString();
    }

    public static String convertForStoring(ClassAndVariables cam) {
        StringBuilder sb = new StringBuilder(150);
        sb.append(cam.dclass.fullyQualifiedName());
        sb.append(',').append(cam.hasSerialVersionUID);
        if (cam.hasSerialVersionUID) {
            sb.append(',').append(cam.serialVersionUID);
        }
        ArrayList<CompiledField> fields = new ArrayList<CompiledField>(cam.variables.values());
        Collections.sort(fields);
        for (CompiledField field : fields) {
            sb.append(',').append(field.name()).append(':').append(field.descriptor());
        }
        return sb.toString();
    }

    public String toString() {
        return this.valuesAsString();
    }

    public int compareTo(Object other) {
        return this.className.compareTo(((ClassAndVariableDetails)other).className);
    }
}

