/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis;

import codeAnalysis.ClassAndMethodDetails;
import codeAnalysis.ClassAndMethods;
import codeAnalysis.ClassAndVariableDetails;
import codeAnalysis.ClassAndVariables;
import codeAnalysis.CompiledClassUtils;
import codeAnalysis.decode.CompiledClass;
import codeAnalysis.decode.CompiledField;
import codeAnalysis.decode.CompiledMethod;
import com.pivotal.gemfirexd.TestUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class AnalyzeSerializablesJUnitTest
extends TestCase {
    private static Map<String, CompiledClass> classes = new HashMap<String, CompiledClass>();
    private static boolean DISABLED = true;
    private static boolean ClassesNotFound;

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testLoadClasses() throws Exception {
        System.out.println("testLoadClasses starting");
        List<String> excludedClasses = this.loadExcludedClasses();
        excludedClasses.addAll(this.loadOpenBugs());
        String cp = System.getProperty("java.class.path");
        String[] entries = cp.split(File.pathSeparator);
        String gfxdjar = null;
        for (int i = 0; i < entries.length; ++i) {
            System.out.println("examining '" + entries[i] + "'");
            if (!entries[i].matches(".*gemfirexd-core-[0-9\\.]*(-(SNAPSHOT|BETA))?[0-9]*.jar")) continue;
            gfxdjar = entries[i];
            break;
        }
        if (gfxdjar != null) {
            System.out.println("loading class files from " + gfxdjar);
            long start = System.currentTimeMillis();
            this.loadClasses(new File(gfxdjar), excludedClasses);
            long finish = System.currentTimeMillis();
            System.out.println("done loading classes.  elapsed time = " + (finish - start) / 1000L + " seconds");
        } else {
            System.out.println("...unable to locate gemfirexd.jar");
            String classesDir = "/home/shobhit/gemfire/cedar_dev_Oct12/build-artifacts/linux/classes";
            if (!new File(classesDir).exists()) {
                System.out.println("error: unable to locate product classes tree using " + classesDir);
                ClassesNotFound = true;
                throw new AssertionError((Object)"unable to locate product classes. gemfirexd.jar not found in classpath");
            }
            System.out.println("loading class files from " + classesDir);
            long start = System.currentTimeMillis();
            this.loadClasses(classesDir, true, excludedClasses);
            long finish = System.currentTimeMillis();
            System.out.println("done loading classes.  elapsed time = " + (finish - start) / 1000L + " seconds");
        }
        DISABLED = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadExcludedClasses() throws Exception {
        String testsDir = TestUtil.getResourcesDir();
        String recordsDir = testsDir + "/codeAnalysis/";
        LinkedList<String> excludedClasses = new LinkedList<String>();
        File exclusionsFile = new File(recordsDir + "excludedClasses.txt");
        FileReader fr = new FileReader(exclusionsFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                excludedClasses.add(line);
            }
        }
        finally {
            fr.close();
        }
        return excludedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadOpenBugs() throws Exception {
        String testsDir = TestUtil.getResourcesDir();
        String recordsDir = testsDir + "/codeAnalysis/";
        LinkedList<String> excludedClasses = new LinkedList<String>();
        File exclusionsFile = new File(recordsDir + "openBugs.txt");
        FileReader fr = new FileReader(exclusionsFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                String[] split = line.split(",");
                if (split.length != 2) {
                    DISABLED = true;
                    AnalyzeSerializablesJUnitTest.fail((String)("unable to load classes due to misformatted line in openBugs.txt: " + line));
                }
                excludedClasses.add(line.split(",")[1].trim());
            }
        }
        finally {
            fr.close();
        }
        return excludedClasses;
    }

    private void removeExclusions(Map<String, CompiledClass> classes, List<String> exclusions) {
        for (String exclusion : exclusions) {
            exclusion = exclusion.replace('.', '/');
            classes.remove(exclusion);
        }
    }

    public void testDataSerializables() throws Exception {
        System.out.println("testDataSerializables starting");
        if (ClassesNotFound) {
            System.out.println("... test not run due to not being able to locate product class files");
            return;
        }
        if (DISABLED) {
            System.out.println("... test is disabled");
            return;
        }
        String testsDir = TestUtil.getResourcesDir();
        String recordsDir = testsDir + "/codeAnalysis/";
        String compareToFileName = recordsDir + "sanctionedDataSerializables.txt";
        String storeInFileName = "actualDataSerializables.dat";
        File storeInFile = new File(storeInFileName);
        if (storeInFile.exists() && !storeInFile.canWrite()) {
            throw new RuntimeException("can't write " + storeInFileName);
        }
        List<ClassAndMethods> toDatas = this.findToDatasAndFromDatas();
        CompiledClassUtils.storeClassesAndMethods(toDatas, storeInFile);
        File compareToFile = new File(compareToFileName);
        if (!compareToFile.exists()) {
            throw new RuntimeException("can't find " + compareToFileName);
        }
        if (!compareToFile.canRead()) {
            throw new RuntimeException("can't read " + compareToFileName);
        }
        List<ClassAndMethodDetails> goldRecord = CompiledClassUtils.loadClassesAndMethods(compareToFile);
        Collections.sort(goldRecord);
        String diff = CompiledClassUtils.diffSortedClassesAndMethods(goldRecord, toDatas);
        if (diff.length() > 0) {
            System.out.println("++++++++++++++++++++++++++++++testDataSerializables found discrepencies++++++++++++++++++++++++++++++++++++");
            System.out.println(diff);
            AnalyzeSerializablesJUnitTest.fail((String)("\n\nCruise Control monitors:  DO NOT DISABLE THIS TEST!\nFile bugs against each failing class and add to junit/codeAnalysis/openBugs.txt\n\n" + diff + "\n\nDevelopers: If the class is not persisted or sent over the wire add it to the excludedClasses.txt file in the " + "\ngemfirexd/GemFireXDTests/junit/codeAnalysis directory.  Otherwise copy actualDataSerializables.dat " + "\nto that directory and rename to sanctionedDataSerializables.txt."));
        }
    }

    public void testSerializables() throws Exception {
        System.out.println("testSerializables starting");
        if (ClassesNotFound) {
            System.out.println("... test not run due to not being able to locate product class files");
            return;
        }
        if (DISABLED) {
            System.out.println("... test is disabled");
            return;
        }
        String testsDir = TestUtil.getResourcesDir();
        String recordsDir = testsDir + "/codeAnalysis/";
        String compareToFileName = recordsDir + "sanctionedSerializables.txt";
        File compareToFile = new File(compareToFileName);
        String storeInFileName = "actualSerializables.dat";
        File storeInFile = new File(storeInFileName);
        if (storeInFile.exists() && !storeInFile.canWrite()) {
            throw new RuntimeException("can't write " + storeInFileName);
        }
        List<ClassAndVariables> serializables = this.findSerializables();
        this.reset();
        CompiledClassUtils.storeClassesAndVariables(serializables, storeInFile);
        if (!compareToFile.exists()) {
            throw new RuntimeException("can't find " + compareToFileName);
        }
        if (!compareToFile.canRead()) {
            throw new RuntimeException("can't read " + compareToFileName);
        }
        List<ClassAndVariableDetails> goldRecord = CompiledClassUtils.loadClassesAndVariables(compareToFile);
        Collections.sort(goldRecord);
        String diff = CompiledClassUtils.diffSortedClassesAndVariables(goldRecord, serializables);
        classes.clear();
        if (diff.length() > 0) {
            System.out.println("++++++++++++++++++++++++++++++testSerializables found discrepencies++++++++++++++++++++++++++++++++++++");
            System.out.println(diff);
            AnalyzeSerializablesJUnitTest.fail((String)("\n\nCruise Control monitors:  DO NOT DISABLE THIS TEST!\nFile bugs against each failing class and add to junit/codeAnalysis/openBugs.txt\n\n" + diff + "\n\nDevelopers: If the class is not persisted or sent over the wire add it to the excludedClasses.txt file in the " + "\ngemfirexd/GemFireXDTests/junit/codeAnalysis directory.  Otherwise if this doesn't " + "\nbreak backward compatibility move the file actualSerializables.dat to the " + "\ncodeAnalysis test directory and rename to sanctionedSerializables.txt"));
        }
    }

    public void loadClasses(String directory, boolean recursive, List<String> excludedClasses) {
        String[] filenames = new String[]{directory};
        List<File> classFiles = CompiledClassUtils.findClassFiles("", filenames, recursive);
        Map<String, CompiledClass> newClasses = CompiledClassUtils.parseClassFiles(classFiles);
        this.removeExclusions(newClasses, excludedClasses);
        classes.putAll(newClasses);
    }

    public void loadClasses(File jar, List<String> excludedClasses) {
        Map<String, CompiledClass> newClasses = CompiledClassUtils.parseClassFiles(jar);
        this.removeExclusions(newClasses, excludedClasses);
        classes.putAll(newClasses);
    }

    public void reset() {
        classes.clear();
    }

    public List<ClassAndMethods> findToDatasAndFromDatas() {
        ArrayList<ClassAndMethods> result = new ArrayList<ClassAndMethods>();
        for (Map.Entry<String, CompiledClass> dentry : classes.entrySet()) {
            CompiledClass dclass = dentry.getValue();
            ClassAndMethods entry = null;
            for (int i = 0; i < dclass.methods.length; ++i) {
                String name;
                CompiledMethod method = dclass.methods[i];
                if (method.isAbstract() || !method.descriptor().equals("void") || !(name = method.name()).startsWith("toData") && !name.startsWith("fromData")) continue;
                if (entry == null) {
                    entry = new ClassAndMethods(dclass);
                }
                entry.methods.put(method.name(), method);
            }
            if (entry == null) continue;
            result.add(entry);
        }
        Collections.sort(result);
        return result;
    }

    public List<ClassAndVariables> findSerializables() {
        ArrayList<ClassAndVariables> result = new ArrayList<ClassAndVariables>(2000);
        for (Map.Entry<String, CompiledClass> entry : classes.entrySet()) {
            CompiledClass dclass = entry.getValue();
            if (dclass.isInterface() || !dclass.isSerializableAndNotDataSerializable()) continue;
            ClassAndVariables cav = new ClassAndVariables(dclass);
            for (int i = 0; i < dclass.fields_count; ++i) {
                CompiledField f = dclass.fields[i];
                if (f.isStatic() || f.isTransient()) continue;
                cav.variables.put(f.name(), f);
            }
            result.add(cav);
        }
        Collections.sort(result);
        return result;
    }
}

