/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.thrift.server;

import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.thrift.common.GfxdTSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GfxdThriftServerThreadPool
extends TServer {
    private final Logger LOGGER = LoggerFactory.getLogger((String)GfxdThriftServerThreadPool.class.getName());
    private final ExecutorService executorService;
    private final NetworkInterface.ConnectionListener connListener;
    private volatile boolean stopped;
    private final TimeUnit stopTimeoutUnit;
    private final long stopTimeoutVal;
    private final AtomicInteger connectionCounter;

    public GfxdThriftServerThreadPool(Args args) {
        super((TServer.AbstractServerArgs)args);
        this.stopTimeoutUnit = args.stopTimeoutUnit;
        this.stopTimeoutVal = args.stopTimeoutVal;
        this.executorService = args.executorService != null ? args.executorService : GfxdThriftServerThreadPool.createDefaultExecutorService(args);
        this.connListener = args.connListener;
        this.connectionCounter = new AtomicInteger(0);
    }

    private static ExecutorService createDefaultExecutorService(Args args) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, 60L, TimeUnit.SECONDS, executorQueue);
    }

    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException tte) {
            this.LOGGER.error("Error occurred during listening.", (Throwable)tte);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.stopped = false;
        this.setServing(true);
        while (!this.stopped) {
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client, this.connectionCounter.incrementAndGet());
                this.executorService.execute(wp);
            }
            catch (TTransportException tte) {
                if (this.stopped) continue;
                this.LOGGER.warn("Transport error occurred during accept of message.", (Throwable)tte);
            }
        }
        this.executorService.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.stopTimeoutUnit.toMillis(this.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
        this.setServing(false);
    }

    public void stop() {
        this.stopped = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private final TTransport client;
        private final int connectionNumber;

        private WorkerProcess(TTransport client, int connectionNumber) {
            this.client = client;
            this.connectionNumber = connectionNumber;
        }

        @Override
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            TServerEventHandler eventHandler = GfxdThriftServerThreadPool.this.getEventHandler();
            ServerContext connectionContext = null;
            NetworkInterface.ConnectionListener listener = GfxdThriftServerThreadPool.this.connListener;
            TTransport client = this.client;
            Socket clientSocket = null;
            try {
                processor = GfxdThriftServerThreadPool.this.processorFactory_.getProcessor(client);
                inputTransport = GfxdThriftServerThreadPool.this.inputTransportFactory_.getTransport(client);
                outputTransport = GfxdThriftServerThreadPool.this.outputTransportFactory_.getTransport(client);
                inputProtocol = GfxdThriftServerThreadPool.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = GfxdThriftServerThreadPool.this.outputProtocolFactory_.getProtocol(outputTransport);
                if (eventHandler != null) {
                    connectionContext = eventHandler.createContext(inputProtocol, outputProtocol);
                }
                if (listener != null) {
                    if (client instanceof GfxdTSocket) {
                        clientSocket = ((GfxdTSocket)client).getSocket();
                    } else if (client instanceof TSocket) {
                        clientSocket = ((TSocket)client).getSocket();
                    }
                    listener.connectionOpened(clientSocket, this.connectionNumber);
                }
                do {
                    if (eventHandler == null) continue;
                    eventHandler.processContext(connectionContext, inputTransport, outputTransport);
                } while (!GfxdThriftServerThreadPool.this.stopped && processor.process(inputProtocol, outputProtocol));
            }
            catch (TTransportException tTransportException) {
            }
            catch (TException te) {
                GfxdThriftServerThreadPool.this.LOGGER.error("Thrift error occurred during processing of message.", (Throwable)te);
            }
            catch (Exception e) {
                GfxdThriftServerThreadPool.this.LOGGER.error("Error occurred during processing of message.", (Throwable)e);
            }
            if (eventHandler != null) {
                eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
            if (listener != null) {
                listener.connectionClosed(clientSocket, this.connectionNumber);
            }
        }
    }

    public static final class Args
    extends TServer.AbstractServerArgs<Args> {
        private NetworkInterface.ConnectionListener connListener;
        private int minWorkerThreads = 5;
        private int maxWorkerThreads = Integer.MAX_VALUE;
        private ExecutorService executorService;
        private int stopTimeoutVal = 60;
        private TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;

        public Args(TServerTransport transport) {
            super(transport);
        }

        public NetworkInterface.ConnectionListener getConnectionListener() {
            return this.connListener;
        }

        public Args setConnectionListener(NetworkInterface.ConnectionListener connListener) {
            this.connListener = connListener;
            return this;
        }

        public int getMinWorkerThreads() {
            return this.minWorkerThreads;
        }

        public Args setMinWorkerThreads(int n) {
            this.minWorkerThreads = n;
            return this;
        }

        public int getMaxWorkerThreads() {
            return this.maxWorkerThreads;
        }

        public Args setMaxWorkerThreads(int n) {
            this.maxWorkerThreads = n;
            return this;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        public Args setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public int getStopTimeoutVal() {
            return this.stopTimeoutVal;
        }

        public TimeUnit getStopTimeoutUnit() {
            return this.stopTimeoutUnit;
        }

        public Args setStopTimeout(int timeout, TimeUnit timeoutUnit) {
            this.stopTimeoutVal = timeout;
            this.stopTimeoutUnit = timeoutUnit;
            return this;
        }
    }
}

