/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.thrift.server;

import com.pivotal.gemfirexd.thrift.common.GfxdTSSLSocketFactory;
import com.pivotal.gemfirexd.thrift.common.SocketParameters;
import com.pivotal.gemfirexd.thrift.server.GfxdTSSLServerSocket;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.thrift.transport.TTransportException;

public abstract class GfxdTSSLServerSocketFactory {
    private GfxdTSSLServerSocketFactory() {
    }

    public static GfxdTSSLServerSocket getServerSocket(InetSocketAddress bindAddress, SocketParameters params) throws TTransportException {
        if (params.hasSSLParams()) {
            if (!params.isSSLKeyStoreSet() && !params.isSSLTrustStoreSet()) {
                throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SocketParameters having SSL parameters");
            }
            SSLContext ctx = GfxdTSSLSocketFactory.createSSLContext((SocketParameters)params);
            return GfxdTSSLServerSocketFactory.createServer(ctx.getServerSocketFactory(), bindAddress, params);
        }
        SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        return GfxdTSSLServerSocketFactory.createServer(factory, bindAddress, params);
    }

    private static GfxdTSSLServerSocket createServer(SSLServerSocketFactory factory, InetSocketAddress bindAddress, SocketParameters params) throws TTransportException {
        try {
            SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket(bindAddress.getPort(), 100, bindAddress.getAddress());
            if (params != null) {
                if (params.getSSLEnabledProtocols() != null) {
                    serverSocket.setEnabledProtocols(params.getSSLEnabledProtocols());
                }
                if (params.getSSLCipherSuites() != null) {
                    serverSocket.setEnabledCipherSuites(params.getSSLCipherSuites());
                }
                serverSocket.setNeedClientAuth(params.getSSLClientAuth());
            }
            return new GfxdTSSLServerSocket(serverSocket, bindAddress, params);
        }
        catch (Exception e) {
            throw new TTransportException(1, "Could not bind to host:port " + bindAddress.toString(), (Throwable)e);
        }
    }
}

