/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.log;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogCounter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CheckpointOperation
implements Loggable {
    protected long redoLWM;
    protected long undoLWM;
    protected Formatable transactionTable;

    public CheckpointOperation(long redoLWM, long undoLWM, Formatable ttab) {
        this.redoLWM = redoLWM;
        this.undoLWM = undoLWM;
        this.transactionTable = ttab;
    }

    public CheckpointOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.redoLWM);
        CompressedNumber.writeLong(out, this.undoLWM);
        CompressedNumber.writeInt(out, 0);
        if (this.transactionTable == null) {
            CompressedNumber.writeInt(out, 0);
        } else {
            CompressedNumber.writeInt(out, 1);
            out.writeObject(this.transactionTable);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.redoLWM = CompressedNumber.readLong(in);
        this.undoLWM = CompressedNumber.readLong(in);
        int tsize = CompressedNumber.readInt(in);
        int haveTTab = CompressedNumber.readInt(in);
        this.transactionTable = haveTTab == 1 ? (Formatable)in.readObject() : (Formatable)null;
    }

    @Override
    public int getTypeFormatId() {
        return 263;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException {
        if (((RawTransaction)xact).inRollForwardRecovery()) {
            ((RawTransaction)xact).checkpointInRollForwardRecovery(instant, this.redoLWM, this.undoLWM);
        }
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public boolean needsRedo(Transaction xact) {
        return ((RawTransaction)xact).inRollForwardRecovery();
    }

    @Override
    public void releaseResource(Transaction xact) {
    }

    @Override
    public int group() {
        return 256;
    }

    public long redoLWM() {
        return this.redoLWM;
    }

    public long undoLWM() {
        return this.undoLWM;
    }

    public Formatable getTransactionTable() {
        return this.transactionTable;
    }

    public String toString() {
        LogCounter undolwm = new LogCounter(this.undoLWM);
        LogCounter redolwm = new LogCounter(this.redoLWM);
        StringBuilder str = new StringBuilder(1000).append("Checkpoint : \tredoLWM ").append(redolwm.toString()).append("\n\t\tundoLWM ").append(undolwm.toString());
        if (this.transactionTable != null) {
            str.append(this.transactionTable.toString());
        }
        return str.toString();
    }
}

