/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegion;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarMessage;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class GfxdJarResource
implements FileResource {
    private final GfxdDDLRegionQueue ddlRegionQ = Misc.getMemStoreBooting().getDDLStmtQueue();
    private final LinkedHashMap<String, Long> sqlNameToIdMap = new LinkedHashMap();

    public GfxdJarResource(boolean persistDD, GemFireCacheImpl cache) throws TimeoutException, RegionExistsException, IOException, ClassNotFoundException, StandardException {
    }

    public final Map<String, Long> getNameToIDMap() {
        return Collections.unmodifiableMap(this.sqlNameToIdMap);
    }

    private byte[] getByteArrayFromInputStream(String name, InputStream source) throws StandardException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: getting byte array from input stream for " + name));
        }
        if (source != null) {
            byte[] data = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int len;
                while ((len = source.read(data)) != -1) {
                    bos.write(data, 0, len);
                }
                byte[] barr = bos.toByteArray();
                if (GemFireXDUtils.TraceApplicationJars) {
                    SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: getting byte array for " + name + " returning " + Arrays.toString(barr)));
                }
                return bos.toByteArray();
            }
            catch (IOException ioe) {
                throw StandardException.newException("XSDFF.S", ioe);
            }
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: getting byte array for " + name + " returning " + null));
        }
        return null;
    }

    @Override
    public long add(String name, InputStream source, LanguageConnectionContext lcc) throws StandardException {
        if (this.sqlNameToIdMap.containsKey(name)) {
            throw StandardException.newException("XSDF0.S", name);
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: add called for " + name));
        }
        byte[] bytes = this.getByteArrayFromInputStream(name, source);
        GfxdJarMessage sjm = new GfxdJarMessage(name, 1, bytes, lcc);
        long id = -1L;
        try {
            id = GemFireXDUtils.newUUIDForDD();
            sjm.setReplayKey(id);
            sjm.setCurrId(id);
            this.ddlRegionQ.put(id, sjm);
            sjm.sendByteArray(false);
            Set<DistributedMember> members = GfxdMessage.getOtherServers();
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: sending GfxdJarMessage to add to " + members + " with id " + id));
            }
            if (members.size() > 0) {
                sjm.send(Misc.getDistributedSystem(), members);
            }
        }
        catch (Exception e) {
            throw StandardException.newException("46001", name);
        }
        finally {
            sjm.sendByteArray(true);
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: putting in the map name:value " + name + ":" + id));
        }
        this.sqlNameToIdMap.put(name, id);
        return id;
    }

    @Override
    public void remove(String name, long currentGenerationId, LanguageConnectionContext lcc) throws StandardException {
        long id = this.sqlNameToIdMap.get(name);
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: removing jar " + name + " with id " + id));
        }
        if (id != currentGenerationId) {
            Assert.fail((Object)("id not same as stored, id=" + id + ", currentGenerationId=" + currentGenerationId));
        }
        GfxdJarMessage sjm = new GfxdJarMessage(name, 2, null, lcc);
        try {
            id = GemFireXDUtils.newUUIDForDD();
            sjm.setReplayKey(id);
            sjm.setCurrId(currentGenerationId);
            this.ddlRegionQ.put(id, sjm);
            Set<DistributedMember> members = GfxdMessage.getOtherServers();
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: sending GfxdJarMessage to remove to " + members + " with id " + id));
            }
            if (members.size() > 0) {
                sjm.send(Misc.getDistributedSystem(), members);
            }
        }
        catch (InterruptedException ie) {
            Misc.getDistributedSystem().getCancelCriterion().checkCancelInProgress((Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (SQLException sqle) {
            throw Misc.wrapSQLException(sqle, sqle);
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: removing from the map name " + name));
        }
        this.sqlNameToIdMap.remove(name);
        InternalDataSerializer.flushClassCache();
    }

    @Override
    public long replace(String name, long currentGenerationId, InputStream source, LanguageConnectionContext lcc) throws StandardException {
        long id = this.sqlNameToIdMap.get(name);
        if (id != currentGenerationId) {
            Assert.fail((Object)("id not same as stored, id=" + id + ", currentGenerationId=" + currentGenerationId));
        }
        byte[] bytes = this.getByteArrayFromInputStream(name, source);
        GfxdJarMessage sjm = new GfxdJarMessage(name, 4, bytes, lcc);
        try {
            id = GemFireXDUtils.newUUIDForDD();
            sjm.setReplayKey(id);
            sjm.setOldId(currentGenerationId);
            sjm.setCurrId(id);
            this.ddlRegionQ.put(id, sjm);
            sjm.sendByteArray(false);
            Set<DistributedMember> members = GfxdMessage.getOtherServers();
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: sending replacing jar for " + name + " with id " + id + " and old id " + currentGenerationId + " to members " + members));
            }
            if (members.size() > 0) {
                sjm.send(Misc.getDistributedSystem(), members);
            }
        }
        catch (InterruptedException ie) {
            Misc.getDistributedSystem().getCancelCriterion().checkCancelInProgress((Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (SQLException sqle) {
            throw Misc.wrapSQLException(sqle, sqle);
        }
        finally {
            sjm.sendByteArray(true);
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: replacing from the map for name " + name + " with id " + id + " old id " + currentGenerationId));
        }
        this.sqlNameToIdMap.put(name, id);
        InternalDataSerializer.flushClassCache();
        return id;
    }

    @Override
    public StorageFile getAsFile(String name, long generationId) {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource#getAsFile called for name " + name + " with id " + generationId));
        }
        assert (this.sqlNameToIdMap.containsKey(name));
        long id = this.sqlNameToIdMap.get(name);
        if (id != generationId) {
            Assert.fail((Object)("id not same as stored, id=" + id + ", currentGenerationId=" + generationId));
        }
        GfxdDDLRegion.RegionValue value = (GfxdDDLRegion.RegionValue)this.ddlRegionQ.getRegion().get(id);
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource#getAsFile called for name " + name + " with id " + generationId + " value returned is " + value));
        }
        if (value != null) {
            return (StorageFile)value.getValue();
        }
        return null;
    }

    @Override
    public char getSeparatorChar() {
        throw new UnsupportedOperationException("GfxdJarResource.getSeparatorChar() should not be called");
    }

    @Override
    public long add(String name, byte[] source, long id) throws StandardException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: adding entry for " + name + " on remote node"));
        }
        if (this.sqlNameToIdMap.containsKey(name)) {
            throw StandardException.newException("XSDF0.S", name);
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: putting in map name:value " + name + ":" + id));
        }
        this.sqlNameToIdMap.put(name, id);
        return id;
    }

    @Override
    public void remove(String name, long currentGenerationId, boolean remote) throws StandardException {
        Long id = this.sqlNameToIdMap.get(name);
        if (id == null) {
            int dotIndex = name.indexOf(46);
            String schema = "";
            if (dotIndex > 0) {
                schema = name.substring(0, dotIndex);
                name = name.substring(dotIndex + 1);
            }
            throw StandardException.newException("X0X13.S", (Object)name, (Object)schema);
        }
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: removing entry for " + name + " with id " + id));
        }
        if (id != currentGenerationId) {
            Assert.fail((Object)("id not same as stored, id=" + id + ", currentGenerationId=" + currentGenerationId));
        }
        this.sqlNameToIdMap.remove(name);
        InternalDataSerializer.flushClassCache();
    }

    @Override
    public long replace(String name, long currentGenerationId, long newGenerationId, byte[] source) throws StandardException {
        long id;
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarResource: replacing entry for " + name + " with id " + newGenerationId + " old is " + currentGenerationId));
        }
        if ((id = this.sqlNameToIdMap.get(name).longValue()) != currentGenerationId) {
            Assert.fail((Object)("id not same as stored, id=" + id + ", currentGenerationId=" + currentGenerationId));
        }
        this.sqlNameToIdMap.put(name, newGenerationId);
        InternalDataSerializer.flushClassCache();
        return 0L;
    }
}

