/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColPermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TablePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GranteeIterator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PrivilegeInfo;
import java.util.Arrays;
import java.util.List;

public class TablePrivilegeInfo
extends PrivilegeInfo {
    public static final int SELECT_ACTION = 0;
    public static final int DELETE_ACTION = 1;
    public static final int INSERT_ACTION = 2;
    public static final int UPDATE_ACTION = 3;
    public static final int REFERENCES_ACTION = 4;
    public static final int TRIGGER_ACTION = 5;
    public static final int ALTER_ACTION = 6;
    public static final int ACTION_COUNT = 7;
    private static final String YES_WITH_GRANT_OPTION = "Y";
    public static final String YES_WITHOUT_GRANT_OPTION = "y";
    public static final String NO = "N";
    private static final String[][] actionString = new String[][]{{"s", "S"}, {"d", "D"}, {"i", "I"}, {"u", "U"}, {"r", "R"}, {"t", "T"}, {"a", "A"}};
    private TableDescriptor td;
    private boolean[] actionAllowed;
    private FormatableBitSet[] columnBitSets;
    private List descriptorList;

    public TablePrivilegeInfo(TableDescriptor td, boolean[] actionAllowed, FormatableBitSet[] columnBitSets, List descriptorList) {
        this.actionAllowed = actionAllowed;
        this.columnBitSets = columnBitSets;
        this.td = td;
        this.descriptorList = descriptorList;
    }

    protected void checkOwnership(String user, TableDescriptor td, SchemaDescriptor sd, DataDictionary dd, LanguageConnectionContext lcc, boolean grant) throws StandardException {
        super.checkOwnership(user, td, sd, dd);
        if (grant) {
            this.checkPrivileges(user, td, sd, dd, lcc);
        }
    }

    private void checkPrivileges(String user, TableDescriptor td, SchemaDescriptor sd, DataDictionary dd, LanguageConnectionContext lcc) throws StandardException {
        if (user.equals(dd.getAuthorizationDatabaseOwner())) {
            return;
        }
        if (td.getTableType() == 2 && this.descriptorList != null) {
            TransactionController tc = lcc.getTransactionExecute();
            int siz = this.descriptorList.size();
            for (int i = 0; i < siz; ++i) {
                SchemaDescriptor s = null;
                TupleDescriptor p = (TupleDescriptor)this.descriptorList.get(i);
                if (p instanceof TableDescriptor) {
                    TableDescriptor t = (TableDescriptor)p;
                    s = t.getSchemaDescriptor();
                } else if (p instanceof ViewDescriptor) {
                    ViewDescriptor v = (ViewDescriptor)p;
                    s = dd.getSchemaDescriptor(v.getCompSchemaId(), tc);
                } else if (p instanceof AliasDescriptor) {
                    AliasDescriptor a = (AliasDescriptor)p;
                    s = dd.getSchemaDescriptor(a.getSchemaUUID(), tc);
                }
                if (s == null || user.equals(s.getAuthorizationId())) continue;
                throw StandardException.newException("4250A", user, (Object)"grant", (Object)sd.getSchemaName(), (Object)td.getName());
            }
        }
    }

    @Override
    public void executeGrantRevoke(Activation activation, boolean grant, List grantees) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String currentUser = lcc.getAuthorizationId();
        TransactionController tc = lcc.getTransactionExecute();
        SchemaDescriptor sd = this.td.getSchemaDescriptor();
        dd.startWriting(lcc);
        this.schemaName = sd.getSchemaName();
        this.tableName = this.td.getName();
        this.checkOwnership(currentUser, this.td, sd, dd, lcc, grant);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TablePermsDescriptor tablePermsDesc = ddg.newTablePermsDescriptor(this.td, this.getPermString(0, false), this.getPermString(1, false), this.getPermString(2, false), this.getPermString(3, false), this.getPermString(4, false), this.getPermString(5, false), this.getPermString(6, false), currentUser);
        Object[] colPermsDescs = new ColPermsDescriptor[this.columnBitSets.length];
        for (int i = 0; i < this.columnBitSets.length; ++i) {
            if (this.columnBitSets[i] == null && (grant || !this.hasColumnPermissions(i) || !this.actionAllowed[i])) continue;
            colPermsDescs[i] = ddg.newColPermsDescriptor(this.td, this.getActionString(i, false), this.columnBitSets[i], currentUser);
        }
        GranteeIterator itr = new GranteeIterator(grantees, tablePermsDesc, grant, 16, 2, 12, dd, tc);
        while (itr.hasNext()) {
            boolean privileges_revoked = false;
            String grantee = itr.moveNext();
            if (tablePermsDesc != null && dd.addRemovePermissionsDescriptor(grant, tablePermsDesc, grantee, tc)) {
                privileges_revoked = true;
                dd.getDependencyManager().invalidateFor(tablePermsDesc, 44, lcc);
                dd.getDependencyManager().invalidateFor(this.td, 23, lcc);
            }
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)((grant ? " grant column permissions " : "revoke column permissions ") + GemFireXDUtils.addressOf(this) + " table=" + this.td.getDescriptorName() + " grantee=" + grantee + " columnBitSets=" + Arrays.toString(this.columnBitSets) + " colPermsDesc=" + Arrays.toString(colPermsDescs)));
            }
            for (int i = 0; i < this.columnBitSets.length; ++i) {
                if (colPermsDescs[i] == null || !dd.addRemovePermissionsDescriptor(grant, colPermsDescs[i], grantee, tc)) continue;
                privileges_revoked = true;
                dd.getDependencyManager().invalidateFor(colPermsDescs[i], 44, lcc);
                dd.getDependencyManager().invalidateFor(this.td, 23, lcc);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, grant, privileges_revoked, grantee);
        }
    }

    private String getPermString(int action, boolean forGrantOption) {
        if (this.actionAllowed[action] && this.columnBitSets[action] == null) {
            return forGrantOption ? YES_WITH_GRANT_OPTION : YES_WITHOUT_GRANT_OPTION;
        }
        return NO;
    }

    private String getActionString(int action, boolean forGrantOption) {
        return actionString[action][forGrantOption ? 1 : 0];
    }

    private boolean hasColumnPermissions(int action) {
        return action == 0 || action == 3 || action == 4;
    }
}

