/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class DropViewConstantAction
extends DDLConstantAction {
    private String fullTableName;
    private String tableName;
    private SchemaDescriptor sd;
    private boolean onlyIfExists;

    DropViewConstantAction(String fullTableName, String tableName, SchemaDescriptor sd, boolean onlyIfExists) {
        this.fullTableName = fullTableName;
        this.tableName = tableName;
        this.sd = sd;
        this.onlyIfExists = onlyIfExists;
        if (!onlyIfExists) {
            SanityManager.ASSERT((sd != null ? 1 : 0) != 0, (String)"SchemaDescriptor is null");
        }
    }

    public String toString() {
        return "DROP VIEW " + this.fullTableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        if (this.sd == null && this.onlyIfExists) {
            this.invalidatePreparedStatement(activation, 9);
            return;
        }
        TableDescriptor td = dd.getTableDescriptor(this.tableName, this.sd, lcc.getTransactionExecute());
        if (td == null) {
            if (this.onlyIfExists) {
                this.invalidatePreparedStatement(activation, 9);
                return;
            }
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        if (td.getTableType() != 2) {
            throw StandardException.newException("X0Y16.S", this.fullTableName);
        }
        ViewDescriptor vd = dd.getViewDescriptor(td);
        vd.drop(lcc, this.sd, td);
    }

    @Override
    public String getSchemaName() {
        return this.sd == null ? null : this.sd.getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isDropStatement() {
        return true;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }
}

