/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class DropStatisticsConstantAction
extends DDLConstantAction {
    private final String objectName;
    private final boolean forTable;
    private final SchemaDescriptor sd;
    private final String fullTableName;

    DropStatisticsConstantAction(SchemaDescriptor sd, String fullTableName, String objectName, boolean forTable) {
        this.objectName = objectName;
        this.sd = sd;
        this.forTable = forTable;
        this.fullTableName = fullTableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        ConglomerateDescriptor cd = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        if (this.forTable) {
            td = dd.getTableDescriptor(this.objectName, this.sd, tc);
        } else {
            cd = dd.getConglomerateDescriptor(this.objectName, this.sd, false);
            td = dd.getTableDescriptor(cd.getTableID());
        }
        dm.invalidateFor(td, 39, lcc);
        dd.dropStatisticsDescriptors(td.getUUID(), cd != null ? cd.getUUID() : null, tc);
    }

    public String toString() {
        return "DROP STATISTICS FOR " + (this.forTable ? "table " : "index ") + this.fullTableName;
    }

    @Override
    public String getSchemaName() {
        return this.sd.getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.fullTableName;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

