/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.depend;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependency;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DependencyDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateViewNode;
import com.pivotal.gemfirexd.internal.impl.sql.depend.BasicDependency;
import com.pivotal.gemfirexd.internal.impl.sql.depend.BasicProviderInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BasicDependencyManager
implements DependencyManager {
    private final DataDictionary dd;
    private final ConcurrentHashMap<UUID, List<Dependency>> dependents = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, List<Dependency>> providers = new ConcurrentHashMap();
    private static final ProviderInfo[] EMPTY_PROVIDER_INFO = new ProviderInfo[0];

    @Override
    public void addDependency(Dependent d, Provider p, ContextManager cm) throws StandardException {
        this.addDependency(d, p, cm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependency(Dependent d, Provider p, ContextManager cm, TransactionController tc) throws StandardException {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            BasicDependency dy = new BasicDependency(d, p);
            if (!d.isDescriptorPersistent() || !p.isDescriptorPersistent()) {
                StatementContext sc;
                boolean addedToDeps = false;
                boolean addedToProvs = false;
                addedToProvs = (addedToDeps = this.addDependencyToTable(this.dependents, d.getObjectID(), dy)) ? this.addDependencyToTable(this.providers, p.getObjectID(), dy) : this.addDependencyToTable(this.providers, p.getObjectID(), dy);
                if (addedToDeps != addedToProvs) {
                    SanityManager.THROWASSERT((String)("addedToDeps (" + addedToDeps + ") and addedToProvs (" + addedToProvs + ") are expected to agree"));
                }
                if ((sc = (StatementContext)cm.getContext("StatementContext")) != null && !"TriggerMap".equals(d.getClassType()) && sc.inUse()) {
                    sc.addDependency(dy);
                }
            } else {
                LanguageConnectionContext lcc = this.getLanguageConnectionContext(cm);
                boolean wait = tc == null;
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(d, p);
                this.dd.addDescriptor(dependencyDescriptor, null, 6, true, wait ? lcc.getTransactionExecute() : tc, wait);
            }
        }
    }

    private void dropDependency(LanguageConnectionContext lcc, Dependent d, Provider p) throws StandardException {
        if (!d.isDescriptorPersistent() || !p.isDescriptorPersistent()) {
            SanityManager.NOTREACHED();
        }
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(d, p);
        this.dd.dropStoredDependency(dependencyDescriptor, lcc.getTransactionExecute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List invalidateFor(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        if (p.isDescriptorPersistent()) {
            return this.coreInvalidateFor(p, action, lcc);
        }
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            return this.coreInvalidateFor(p, action, lcc);
        }
    }

    private List coreInvalidateFor(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        List list = this.getDependents(p);
        if (list == null || list.size() == 0) {
            return null;
        }
        FormatableBitSet affectedCols = null;
        FormatableBitSet subsetCols = null;
        if (p instanceof TableDescriptor && (affectedCols = ((TableDescriptor)p).getReferencedColumnMap()) != null) {
            subsetCols = new FormatableBitSet(affectedCols.getLength());
        }
        StandardException noInvalidate = null;
        for (int ei = list.size() - 1; ei >= 0; --ei) {
            if (ei >= list.size()) continue;
            Dependency dependency = (Dependency)list.get(ei);
            Dependent dep = dependency.getDependent();
            if (affectedCols != null) {
                TableDescriptor td = (TableDescriptor)dependency.getProvider();
                FormatableBitSet providingCols = td.getReferencedColumnMap();
                if (providingCols == null) {
                    if (dep instanceof ViewDescriptor) {
                        ViewDescriptor vd = (ViewDescriptor)dep;
                        SchemaDescriptor compSchema = this.dd.getSchemaDescriptor(vd.getCompSchemaId(), null);
                        CompilerContext newCC = lcc.pushCompilerContext(compSchema, true);
                        Parser pa = newCC.getParser();
                        CreateViewNode cvn = (CreateViewNode)pa.parseStatement(vd.getViewText());
                        newCC.setCurrentDependent(dep);
                        cvn.bindStatement();
                        ProviderInfo[] providerInfos = cvn.getProviderInfo();
                        lcc.popCompilerContext(newCC);
                        boolean interferent = false;
                        for (int i = 0; i < providerInfos.length; ++i) {
                            TableDescriptor tab;
                            FormatableBitSet colMap;
                            Provider provider = null;
                            provider = (Provider)providerInfos[i].getDependableFinder().getDependable(this.dd, providerInfos[i].getObjectId());
                            if (!(provider instanceof TableDescriptor) || (colMap = (tab = (TableDescriptor)provider).getReferencedColumnMap()) == null) continue;
                            tab.setReferencedColumnMap(null);
                            this.dropDependency(lcc, vd, tab);
                            tab.setReferencedColumnMap(colMap);
                            this.addDependency(vd, tab, lcc.getContextManager());
                            if (!tab.getObjectID().equals(td.getObjectID())) continue;
                            System.arraycopy(affectedCols.getByteArray(), 0, subsetCols.getByteArray(), 0, affectedCols.getLengthInBytes());
                            subsetCols.and(colMap);
                            if (subsetCols.anySetBit() == -1) continue;
                            interferent = true;
                            ((TableDescriptor)p).setReferencedColumnMap(subsetCols);
                        }
                        if (!interferent) {
                            continue;
                        }
                    } else {
                        ((TableDescriptor)p).setReferencedColumnMap(null);
                    }
                } else {
                    System.arraycopy(affectedCols.getByteArray(), 0, subsetCols.getByteArray(), 0, affectedCols.getLengthInBytes());
                    subsetCols.and(providingCols);
                    if (subsetCols.anySetBit() == -1) continue;
                    ((TableDescriptor)p).setReferencedColumnMap(subsetCols);
                }
            }
            try {
                dep.prepareToInvalidate(p, action, lcc);
            }
            catch (StandardException sqle) {
                if (noInvalidate == null) {
                    noInvalidate = sqle;
                }
                try {
                    sqle.initCause(noInvalidate);
                    noInvalidate = sqle;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (noInvalidate != null) continue;
            if (affectedCols != null) {
                ((TableDescriptor)p).setReferencedColumnMap(affectedCols);
            }
            dep.makeInvalid(action, lcc);
        }
        if (noInvalidate != null) {
            throw noInvalidate;
        }
        return list;
    }

    @Override
    public void clearDependencies(LanguageConnectionContext lcc, Dependent d) throws StandardException {
        this.clearDependencies(lcc, d, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDependencies(LanguageConnectionContext lcc, Dependent d, TransactionController tc) throws StandardException {
        List<Dependency> deps = this.dependents.get(d.getObjectID());
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            if (d.isDescriptorPersistent()) {
                boolean wait = tc == null;
                this.dd.dropDependentsStoredDependencies(d.getObjectID(), wait ? lcc.getTransactionExecute() : tc, wait);
            }
            if (deps == null) {
                return;
            }
            ListIterator<Dependency> depsIterator = deps.listIterator();
            while (depsIterator.hasNext()) {
                Dependency dy = depsIterator.next();
                this.clearProviderDependency(dy.getProviderKey(), dy);
            }
            this.dependents.remove(d.getObjectID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInMemoryDependency(Dependency dy) {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List<Dependency> deps = this.dependents.get(dy.getDependent().getObjectID());
            List<Dependency> provs = this.providers.get(dy.getProvider().getObjectID());
            if (deps != null || provs != null) {
                int depCount = 0;
                if (deps != null) {
                    for (int ci = 0; ci < deps.size(); ++ci) {
                        if (!dy.equals(deps.get(ci))) continue;
                        ++depCount;
                    }
                }
                int provCount = 0;
                if (provs != null) {
                    for (int ci = 0; ci < provs.size(); ++ci) {
                        if (!dy.equals(provs.get(ci))) continue;
                        ++provCount;
                    }
                }
                if (depCount != provCount) {
                    SanityManager.THROWASSERT((String)("Dependency count mismatch count in deps: " + depCount + ", count in provs " + provCount + ", dy.getDependent().getObjectID() = " + dy.getDependent().getObjectID() + ", dy.getProvider().getObjectID() = " + dy.getProvider().getObjectID()));
                }
            }
            if (deps == null) {
                return;
            }
            if (provs == null) {
                return;
            }
            deps.remove(dy);
            if (deps.size() == 0) {
                this.dependents.remove(dy.getDependent().getObjectID());
            }
            provs.remove(dy);
            if (provs.size() == 0) {
                this.providers.remove(dy.getProvider().getObjectID());
            }
        }
    }

    @Override
    public synchronized ProviderInfo[] getPersistentProviderInfos(Dependent dependent) throws StandardException {
        List list = this.getProviders(dependent);
        if (list == null) {
            return EMPTY_PROVIDER_INFO;
        }
        ArrayList<BasicProviderInfo> pih = new ArrayList<BasicProviderInfo>();
        ListIterator depsIterator = list.listIterator();
        while (depsIterator.hasNext()) {
            Dependency dep = (Dependency)depsIterator.next();
            if (!dep.getProvider().isDescriptorPersistent()) continue;
            pih.add(new BasicProviderInfo(dep.getProvider().getObjectID(), dep.getProvider().getDependableFinder(), dep.getProvider().getObjectName()));
        }
        return pih.toArray(EMPTY_PROVIDER_INFO);
    }

    @Override
    public ProviderInfo[] getPersistentProviderInfos(ProviderList pl) throws StandardException {
        Enumeration e = pl.elements();
        int numProviders = 0;
        while (e != null && e.hasMoreElements()) {
            Provider prov = (Provider)e.nextElement();
            if (!prov.isDescriptorPersistent()) continue;
            ++numProviders;
        }
        e = pl.elements();
        ProviderInfo[] retval = new ProviderInfo[numProviders];
        int piCtr = 0;
        while (e != null && e.hasMoreElements()) {
            Provider prov = (Provider)e.nextElement();
            if (!prov.isDescriptorPersistent()) continue;
            retval[piCtr++] = new BasicProviderInfo(prov.getObjectID(), prov.getDependableFinder(), prov.getObjectName());
        }
        return retval;
    }

    @Override
    public void clearColumnInfoInProviders(ProviderList pl) throws StandardException {
        Enumeration e = pl.elements();
        while (e.hasMoreElements()) {
            Provider pro = (Provider)e.nextElement();
            if (!(pro instanceof TableDescriptor)) continue;
            ((TableDescriptor)pro).setReferencedColumnMap(null);
        }
    }

    @Override
    public void copyDependencies(Dependent copy_From, Dependent copyTo, boolean persistentOnly, ContextManager cm) throws StandardException {
        this.copyDependencies(copy_From, copyTo, persistentOnly, cm, null);
    }

    @Override
    public synchronized void copyDependencies(Dependent copy_From, Dependent copyTo, boolean persistentOnly, ContextManager cm, TransactionController tc) throws StandardException {
        List list = this.getProviders(copy_From);
        if (list == null) {
            return;
        }
        ListIterator depsIterator = list.listIterator();
        while (depsIterator.hasNext()) {
            Provider provider = ((Dependency)depsIterator.next()).getProvider();
            if (persistentOnly && !provider.isDescriptorPersistent()) continue;
            this.addDependency(copyTo, provider, cm, tc);
        }
    }

    @Override
    public String getActionString(int action) {
        switch (action) {
            case 12: {
                return "ALTER TABLE";
            }
            case 34: {
                return "RENAME";
            }
            case 41: {
                return "RENAME INDEX";
            }
            case 0: {
                return "COMPILE FAILED";
            }
            case 1: {
                return "DROP TABLE";
            }
            case 2: {
                return "DROP INDEX";
            }
            case 9: {
                return "DROP VIEW";
            }
            case 3: {
                return "CREATE INDEX";
            }
            case 4: {
                return "ROLLBACK";
            }
            case 5: {
                return "CHANGED CURSOR";
            }
            case 22: {
                return "CREATE CONSTRAINT";
            }
            case 19: {
                return "DROP CONSTRAINT";
            }
            case 6: {
                return "DROP ROUTINE";
            }
            case 11: {
                return "PREPARED STATEMENT RELEASE";
            }
            case 13: {
                return "DROP STORED PREPARED STATEMENT";
            }
            case 14: {
                return "USER REQUESTED INVALIDATION";
            }
            case 15: {
                return "BULK INSERT";
            }
            case 10: {
                return "CREATE_VIEW";
            }
            case 17: {
                return "DROP_JAR";
            }
            case 18: {
                return "REPLACE_JAR";
            }
            case 20: {
                return "SET_CONSTRAINTS_ENABLE";
            }
            case 21: {
                return "SET_CONSTRAINTS_DISABLE";
            }
            case 23: {
                return "INTERNAL RECOMPILE REQUEST";
            }
            case 28: {
                return "CREATE TRIGGER";
            }
            case 27: {
                return "DROP TRIGGER";
            }
            case 29: {
                return "SET TRIGGERS ENABLED";
            }
            case 30: {
                return "SET TRIGGERS DISABLED";
            }
            case 31: {
                return "MODIFY COLUMN DEFAULT";
            }
            case 33: {
                return "COMPRESS TABLE";
            }
            case 37: {
                return "DROP COLUMN";
            }
            case 46: {
                return "DROP COLUMN RESTRICT";
            }
            case 39: {
                return "DROP STATISTICS";
            }
            case 40: {
                return "UPDATE STATISTICS";
            }
            case 42: {
                return "TRUNCATE TABLE";
            }
            case 43: {
                return "DROP SYNONYM";
            }
            case 44: {
                return "REVOKE PRIVILEGE";
            }
            case 45: {
                return "REVOKE PRIVILEGE RESTRICT";
            }
            case 50: {
                return "DROP TYPE";
            }
        }
        SanityManager.THROWASSERT((String)("getActionString() passed an invalid value (" + action + ")"));
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countDependencies() throws StandardException {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            int numDependencies = 0;
            Enumeration<List<Dependency>> deps = this.dependents.elements();
            Enumeration<List<Dependency>> provs = this.providers.elements();
            List storedDeps = this.dd.getAllDependencyDescriptorsList();
            while (deps.hasMoreElements()) {
                numDependencies += deps.nextElement().size();
            }
            while (provs.hasMoreElements()) {
                numDependencies += provs.nextElement().size();
            }
            return numDependencies += storedDeps.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpDependencies() throws StandardException, SQLException {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            boolean foundInMemory = false;
            boolean foundStored = false;
            StringBuilder debugBuf = new StringBuilder();
            Enumeration<UUID> deps = this.dependents.keys();
            UUID[] depKeys = new UUID[this.dependents.size()];
            int i = 0;
            while (deps.hasMoreElements()) {
                depKeys[i] = deps.nextElement();
                ++i;
            }
            this.bubbleSort(depKeys);
            for (i = 0; i < depKeys.length; ++i) {
                List<Dependency> depsSList = this.dependents.get(depKeys[i]);
                ListIterator<Dependency> depsIterator = depsSList.listIterator();
                while (depsIterator.hasNext()) {
                    Dependency dy = depsIterator.next();
                    if (!foundInMemory) {
                        debugBuf.append("In Memory Dependencies:\n");
                        foundInMemory = true;
                    }
                    debugBuf.append(dy.getDependent().toString() + ", type " + dy.getDependent().getClassType() + ", " + " is dependent on " + dy.getProvider().getObjectName() + ", type " + dy.getProvider().getClassType() + "\n");
                }
            }
            Enumeration<UUID> provs = this.providers.keys();
            UUID[] provKeys = new UUID[this.providers.size()];
            int i2 = 0;
            while (provs.hasMoreElements()) {
                provKeys[i2] = provs.nextElement();
                ++i2;
            }
            this.bubbleSort(provKeys);
            for (i2 = 0; i2 < provKeys.length; ++i2) {
                List<Dependency> depsSList = this.providers.get(provKeys[i2]);
                ListIterator<Dependency> depsIterator = depsSList.listIterator();
                while (depsIterator.hasNext()) {
                    Dependency dy = depsIterator.next();
                    if (!foundInMemory) {
                        debugBuf.append("In Memory Dependencies:\n");
                        foundInMemory = true;
                    }
                    debugBuf.append(dy.getProvider().toString() + ", type " + dy.getProvider().getClassType() + ", provides for " + dy.getDependent().getObjectName() + ", type " + dy.getDependent().getClassType() + "\n");
                }
            }
            List storedDeps = this.dd.getAllDependencyDescriptorsList();
            String[] dependStr = new String[storedDeps.size()];
            int i3 = 0;
            ListIterator depsIterator = storedDeps.listIterator();
            while (depsIterator.hasNext()) {
                DependencyDescriptor dependDescr = (DependencyDescriptor)depsIterator.next();
                if (!foundStored) {
                    debugBuf.append("Stored Dependencies:\n");
                    foundStored = true;
                }
                DependableFinder providerFinder = dependDescr.getProviderFinder();
                DependableFinder dependentFinder = dependDescr.getDependentFinder();
                dependStr[i3++] = providerFinder.getDependable(this.dd, dependDescr.getProviderID()).getObjectName() + ", type " + providerFinder.getSQLObjectType() + ", provides for " + dependentFinder.getDependable(this.dd, dependDescr.getUUID()).getObjectName() + ", type " + dependentFinder.getSQLObjectType() + "\n";
            }
            for (i3 = 0; i3 < dependStr.length; ++i3) {
                for (int j = i3 + 1; j < dependStr.length; ++j) {
                    if (dependStr[i3].compareTo(dependStr[j]) <= 0) continue;
                    String save = dependStr[i3];
                    dependStr[i3] = dependStr[j];
                    dependStr[j] = save;
                }
            }
            for (i3 = 0; i3 < dependStr.length; ++i3) {
                debugBuf.append(dependStr[i3]);
            }
            return debugBuf.toString();
        }
    }

    public BasicDependencyManager(DataDictionary dd) {
        this.dd = dd;
    }

    private boolean addDependencyToTable(Map table, Object key, Dependency dy) {
        List deps = (List)table.get(key);
        if (deps == null) {
            deps = BasicDependencyManager.newSList();
            deps.add(dy);
            table.put(key, deps);
        } else {
            UUID provKey = dy.getProvider().getObjectID();
            UUID depKey = dy.getDependent().getObjectID();
            ListIterator depsIT = deps.listIterator();
            while (depsIT.hasNext()) {
                Dependency curDY = (Dependency)depsIT.next();
                if (!curDY.getProvider().getObjectID().equals(provKey) || !curDY.getDependent().getObjectID().equals(depKey)) continue;
                return false;
            }
            deps.add(dy);
        }
        if (SanityManager.TraceMemoryLeak) {
            if (table.size() > 100) {
                System.out.println("TraceMemoryLeak:BasicDependencyManager:table " + table.size());
            }
            if (deps.size() > 50) {
                System.out.println("TraceMemoryLeak:BasicDependencyManager:deps " + deps.size());
            }
        }
        return true;
    }

    protected void clearProviderDependency(UUID p, Dependency d) {
        List<Dependency> deps = this.providers.get(p);
        if (deps == null) {
            return;
        }
        deps.remove(d);
        if (deps.size() == 0) {
            this.providers.remove(p);
        }
    }

    private List getDependencyDescriptorList(List storedList, Provider providerForList) throws StandardException {
        if (storedList.size() != 0) {
            ListIterator<BasicDependency> depsIterator = storedList.listIterator();
            while (depsIterator.hasNext()) {
                Provider tempP;
                DependableFinder finder = null;
                DependencyDescriptor depDesc = (DependencyDescriptor)depsIterator.next();
                finder = depDesc.getDependentFinder();
                Dependent tempD = (Dependent)finder.getDependable(this.dd, depDesc.getUUID());
                if (providerForList != null) {
                    tempP = providerForList;
                    if (!tempP.getObjectID().equals(depDesc.getProviderID())) {
                        SanityManager.THROWASSERT((String)"mismatch providers");
                    }
                } else {
                    finder = depDesc.getProviderFinder();
                    tempP = (Provider)finder.getDependable(this.dd, depDesc.getProviderID());
                }
                depsIterator.set(new BasicDependency(tempD, tempP));
            }
        }
        return storedList;
    }

    private LanguageConnectionContext getLanguageConnectionContext(ContextManager cm) {
        return (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
    }

    private void bubbleSort(UUID[] uuids) {
        for (int i = 0; i < uuids.length; ++i) {
            for (int j = i + 1; j < uuids.length; ++j) {
                if (uuids[i].toString().compareTo(uuids[j].toString()) <= 0) continue;
                UUID save = uuids[i];
                uuids[i] = uuids[j];
                uuids[j] = save;
            }
        }
    }

    private List getProviders(Dependent d) throws StandardException {
        List deps = this.dependents.get(d.getObjectID());
        if (!d.isDescriptorPersistent()) {
            return deps == null ? null : deps;
        }
        deps = deps == null ? BasicDependencyManager.newSList() : BasicDependencyManager.newSList(deps);
        List storedList = this.getDependencyDescriptorList(this.dd.getDependentsDescriptorList(d.getObjectID().toString()), null);
        if (storedList.size() > 0) {
            deps.addAll(0, storedList);
        }
        return deps;
    }

    public List getDependents(Provider p) throws StandardException {
        List deps = this.providers.get(p.getObjectID());
        if (!p.isDescriptorPersistent()) {
            return deps;
        }
        deps = deps == null ? BasicDependencyManager.newSList() : BasicDependencyManager.newSList(deps);
        List storedList = this.getDependencyDescriptorList(this.dd.getProvidersDescriptorList(p.getObjectID().toString()), p);
        if (storedList.size() > 0) {
            deps.addAll(0, storedList);
        }
        return deps;
    }

    private static List newSList() {
        return Collections.synchronizedList(new LinkedList());
    }

    private static List newSList(List list) {
        return Collections.synchronizedList(new LinkedList(list));
    }

    @Override
    public boolean isDependent(Provider p, Dependent d) throws StandardException {
        List deps = this.getDependents(p);
        for (Dependency dy : deps) {
            if (!d.equals(dy.getDependent())) continue;
            return true;
        }
        return false;
    }
}

