/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UserDefinedTypeCompiler;

public class TypeCompilerFactoryImpl
implements TypeCompilerFactory {
    private static final String PACKAGE_NAME = "com.pivotal.gemfirexd.internal.impl.sql.compile.";
    static TypeCompiler bitTypeCompiler;
    static TypeCompiler booleanTypeCompiler;
    static TypeCompiler charTypeCompiler;
    static TypeCompiler decimalTypeCompiler;
    static TypeCompiler doubleTypeCompiler;
    static TypeCompiler intTypeCompiler;
    static TypeCompiler longintTypeCompiler;
    static TypeCompiler longvarbitTypeCompiler;
    static TypeCompiler longvarcharTypeCompiler;
    static TypeCompiler realTypeCompiler;
    static TypeCompiler smallintTypeCompiler;
    static TypeCompiler tinyintTypeCompiler;
    static TypeCompiler dateTypeCompiler;
    static TypeCompiler timeTypeCompiler;
    static TypeCompiler timestampTypeCompiler;
    static TypeCompiler varbitTypeCompiler;
    static TypeCompiler varcharTypeCompiler;
    static TypeCompiler refTypeCompiler;
    static TypeCompiler blobTypeCompiler;
    static TypeCompiler clobTypeCompiler;
    static TypeCompiler jsonTypeCompiler;
    static TypeCompiler xmlTypeCompiler;

    @Override
    public TypeCompiler getTypeCompiler(TypeId typeId) {
        return TypeCompilerFactoryImpl.staticGetTypeCompiler(typeId);
    }

    static TypeCompiler staticGetTypeCompiler(TypeId typeId) {
        switch (typeId.getJDBCTypeId()) {
            case -2: {
                bitTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.BitTypeCompiler", bitTypeCompiler, typeId);
                return bitTypeCompiler;
            }
            case -7: 
            case 16: {
                booleanTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanTypeCompiler", booleanTypeCompiler, typeId);
                return booleanTypeCompiler;
            }
            case 1: {
                String sqlTypeName = typeId.getSQLTypeName();
                charTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.CharTypeCompiler", charTypeCompiler, typeId);
                return charTypeCompiler;
            }
            case 2: 
            case 3: {
                decimalTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", decimalTypeCompiler, typeId);
                return decimalTypeCompiler;
            }
            case 8: {
                doubleTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", doubleTypeCompiler, typeId);
                return doubleTypeCompiler;
            }
            case 4: {
                intTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", intTypeCompiler, typeId);
                return intTypeCompiler;
            }
            case -5: {
                longintTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", longintTypeCompiler, typeId);
                return longintTypeCompiler;
            }
            case 2004: {
                blobTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.LOBTypeCompiler", blobTypeCompiler, typeId);
                return blobTypeCompiler;
            }
            case -4: {
                longvarbitTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.BitTypeCompiler", longvarbitTypeCompiler, typeId);
                return longvarbitTypeCompiler;
            }
            case 2005: {
                String sqlTypeName = typeId.getSQLTypeName();
                clobTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.CLOBTypeCompiler", clobTypeCompiler, typeId);
                return clobTypeCompiler;
            }
            case -1: {
                String sqlTypeName = typeId.getSQLTypeName();
                longvarcharTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.CharTypeCompiler", longvarcharTypeCompiler, typeId);
                return longvarcharTypeCompiler;
            }
            case 7: {
                realTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", realTypeCompiler, typeId);
                return realTypeCompiler;
            }
            case 5: {
                smallintTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", smallintTypeCompiler, typeId);
                return smallintTypeCompiler;
            }
            case -6: {
                tinyintTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler", tinyintTypeCompiler, typeId);
                return tinyintTypeCompiler;
            }
            case 91: {
                dateTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.DateTypeCompiler", dateTypeCompiler, typeId);
                return dateTypeCompiler;
            }
            case 92: {
                timeTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.TimeTypeCompiler", timeTypeCompiler, typeId);
                return timeTypeCompiler;
            }
            case 93: {
                timestampTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.TimestampTypeCompiler", timestampTypeCompiler, typeId);
                return timestampTypeCompiler;
            }
            case -3: {
                varbitTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.BitTypeCompiler", varbitTypeCompiler, typeId);
                return varbitTypeCompiler;
            }
            case 12: {
                String sqlTypeName = typeId.getSQLTypeName();
                varcharTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.CharTypeCompiler", varcharTypeCompiler, typeId);
                return varcharTypeCompiler;
            }
            case 1111: 
            case 2000: {
                if (typeId.isRefTypeId()) {
                    refTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.RefTypeCompiler", refTypeCompiler, typeId);
                    return refTypeCompiler;
                }
                UserDefinedTypeCompiler btc = new UserDefinedTypeCompiler();
                btc.setTypeId(typeId);
                return btc;
            }
            case 4001: {
                String sqlTypeName = typeId.getSQLTypeName();
                jsonTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.JSONTypeCompiler", jsonTypeCompiler, typeId);
                return jsonTypeCompiler;
            }
            case 2009: {
                xmlTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("com.pivotal.gemfirexd.internal.impl.sql.compile.XMLTypeCompiler", xmlTypeCompiler, typeId);
                return xmlTypeCompiler;
            }
        }
        SanityManager.THROWASSERT((String)("Unexpected JDBC type id " + typeId.getJDBCTypeId() + " for typeId of class " + typeId.getClass().getName()));
        return null;
    }

    private static TypeCompiler getAnInstance(String className, TypeCompiler anInstance, TypeId typeId) {
        if (anInstance == null) {
            ReflectiveOperationException exc = null;
            Class<?> typeCompilerClass = null;
            try {
                typeCompilerClass = Class.forName(className);
                anInstance = (TypeCompiler)typeCompilerClass.newInstance();
                ((BaseTypeCompiler)anInstance).setTypeId(typeId);
            }
            catch (ClassNotFoundException cnfe) {
                exc = cnfe;
            }
            catch (IllegalAccessException iae) {
                exc = iae;
            }
            catch (InstantiationException ie) {
                exc = ie;
            }
            if (exc != null) {
                SanityManager.THROWASSERT((String)("Exception " + exc + " while trying to get new instance of a " + typeCompilerClass.getName()));
            }
        }
        return anInstance;
    }
}

