/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateDefinition;

public class SumAvgAggregateDefinition
implements AggregateDefinition {
    private boolean isSum;
    private boolean distinct = false;

    @Override
    public final DataTypeDescriptor getAggregator(DataTypeDescriptor inputType, StringBuilder aggregatorClass, boolean isAvg) {
        try {
            if (isAvg) {
                inputType = this.promoteDataTypeDescriptor(inputType);
            }
            TypeId compType = inputType.getTypeId();
            CompilerContext cc = (CompilerContext)ContextService.getContext("CompilerContext");
            TypeCompilerFactory tcf = cc.getTypeCompilerFactory();
            TypeCompiler tc = tcf.getTypeCompiler(compType);
            if (compType.isNumericTypeId()) {
                aggregatorClass.append(this.getAggregatorClassName());
                DataTypeDescriptor outDts = tc.resolveArithmeticOperation(inputType, inputType, isAvg ? "avg" : this.getOperator());
                if (!cc.createQueryInfo() && !cc.allTablesAreReplicatedOnRemote() && this.distinct) {
                    TypeId cti = TypeId.getUserDefinedTypeId(DVDSet.class.getName(), inputType, false);
                    outDts = new DataTypeDescriptor(cti, false);
                }
                return outDts.getNullabilityType(true);
            }
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)e);
        }
        return null;
    }

    protected final DataTypeDescriptor promoteDataTypeDescriptor(DataTypeDescriptor value) throws StandardException {
        switch (value.getTypeId().getTypeFormatId()) {
            case 7: {
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, false);
            }
            case 10: 
            case 195: {
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(4, false);
            }
            case 8: {
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(8, false);
            }
        }
        return value;
    }

    private String getAggregatorClassName() {
        if (this.isSum) {
            return "com.pivotal.gemfirexd.internal.impl.sql.execute.SumAggregator";
        }
        return "com.pivotal.gemfirexd.internal.impl.sql.execute.AvgAggregator";
    }

    protected String getOperator() {
        if (this.isSum) {
            return "sum";
        }
        return "avg";
    }

    public final void setSumOrAvg(boolean isSum) {
        this.isSum = isSum;
    }

    public void markDistinct() {
        this.distinct = true;
    }
}

