/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasCorrelatedCRsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasVariantValueNodeVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MaterializeSubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowCountNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SetOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SubqueryNode
extends ValueNode {
    ResultSetNode resultSet;
    private ValueNode offset;
    private ValueNode fetchFirst;
    int subqueryType;
    boolean underTopAndNode;
    boolean preprocessed;
    boolean distinctExpression;
    boolean whereSubquery;
    ValueNode leftOperand;
    boolean pushedNewPredicate;
    boolean havingSubquery = false;
    BinaryComparisonOperatorNode parentComparisonOperator;
    private BooleanConstantNode trueNode;
    private int subqueryNumber = -1;
    private int pointOfAttachment = -1;
    private boolean foundCorrelation;
    private boolean doneCorrelationCheck;
    private boolean foundVariant;
    private boolean doneInvariantCheck;
    private String subQueryString = null;
    private SelectQueryInfo subSqi = null;
    private PreparedStatement subqueryPS = null;
    private DataTypeDescriptor[] subqueryDTDs = null;
    private List<Integer> params = null;
    private int subqueryLevel = -1;
    private byte flag = 0;
    private static final byte SUB_ACTIVATION_NEEDED = 1;
    private static final byte CORRELATION_CHECK_DONE = 2;
    private static final byte FOUND_CORRELATION = 4;
    private static final byte IS_PREP_STMT = 8;
    private static final byte IS_OPTIMIZE_LITERAL = 16;
    public static final int NOTIMPLEMENTED_SUBQUERY = -1;
    public static final int FROM_SUBQUERY = 0;
    public static final int IN_SUBQUERY = 1;
    public static final int NOT_IN_SUBQUERY = 2;
    public static final int EQ_ANY_SUBQUERY = 3;
    public static final int EQ_ALL_SUBQUERY = 4;
    public static final int NE_ANY_SUBQUERY = 5;
    public static final int NE_ALL_SUBQUERY = 6;
    public static final int GT_ANY_SUBQUERY = 7;
    public static final int GT_ALL_SUBQUERY = 8;
    public static final int GE_ANY_SUBQUERY = 9;
    public static final int GE_ALL_SUBQUERY = 10;
    public static final int LT_ANY_SUBQUERY = 11;
    public static final int LT_ALL_SUBQUERY = 12;
    public static final int LE_ANY_SUBQUERY = 13;
    public static final int LE_ALL_SUBQUERY = 14;
    public static final int EXISTS_SUBQUERY = 15;
    public static final int NOT_EXISTS_SUBQUERY = 16;
    public static final int EXPRESSION_SUBQUERY = 17;

    @Override
    public void init(Object resultSet, Object offset, Object fetchFirst, Object subqueryType, Object leftOperand) {
        this.resultSet = (ResultSetNode)resultSet;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
        this.subqueryType = (Integer)subqueryType;
        this.underTopAndNode = false;
        this.leftOperand = (ValueNode)leftOperand;
    }

    @Override
    public String toString() {
        return "subqueryType: " + this.subqueryType + "\n" + "underTopAndNode: " + this.underTopAndNode + "\n" + "subqueryNumber: " + this.subqueryNumber + "\n" + "pointOfAttachment: " + this.pointOfAttachment + "\n" + "preprocessed: " + this.preprocessed + "\n" + "distinctExpression: " + this.distinctExpression + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultSet != null) {
            this.printLabel(depth, "resultSet: ");
            this.resultSet.treePrint(depth + 1);
        }
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
    }

    public ResultSetNode getResultSet() {
        return this.resultSet;
    }

    public int getSubqueryType() {
        return this.subqueryType;
    }

    public void setSubqueryType(int subqueryType) {
        this.subqueryType = subqueryType;
    }

    public void setPointOfAttachment(int pointOfAttachment) throws StandardException {
        if (!this.isMaterializable()) {
            this.pointOfAttachment = pointOfAttachment;
        }
    }

    public boolean getUnderTopAndNode() {
        return this.underTopAndNode;
    }

    public int getPointOfAttachment() {
        SanityManager.ASSERT((this.pointOfAttachment >= 0 ? 1 : 0) != 0, (String)"pointOfAttachment expected to be >= 0");
        return this.pointOfAttachment;
    }

    boolean getPreprocessed() {
        return this.preprocessed;
    }

    void setParentComparisonOperator(BinaryComparisonOperatorNode parent) {
        this.parentComparisonOperator = parent;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.resultSet instanceof SelectNode) {
            ResultColumnList selectRCL = this.resultSet.getResultColumns();
            SelectNode select = (SelectNode)this.resultSet;
            PredicateList selectPL = select.getWherePredicates();
            SanityManager.ASSERT((selectPL != null ? 1 : 0) != 0, (String)"selectPL expected to be non-null");
            selectRCL.remapColumnReferencesToExpressions();
            selectPL.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.checkReliability(32, "42Z91");
        ResultColumnList resultColumns = this.resultSet.getResultColumns();
        if (resultColumns.visibleSize() != 1) {
            throw StandardException.newException("42X39");
        }
        this.resultSet.verifySelectStarSubquery(fromList, this.subqueryType);
        if (this.subqueryType == 15) {
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(true);
        }
        CompilerContext cc = this.getCompilerContext();
        this.resultSet = this.resultSet.bindNonVTITables(this.getDataDictionary(), fromList);
        this.resultSet = this.resultSet.bindVTITables(fromList);
        if (this.subqueryNumber == -1) {
            this.subqueryNumber = cc.getNextSubqueryNumber();
        }
        this.resultSet.rejectParameters();
        if (this.subqueryType == 15) {
            this.resultSet.bindTargetExpressions(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(false);
        }
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        }
        this.resultSet.bindExpressions(fromList);
        this.resultSet.bindResultColumns(fromList);
        this.resultSet.bindUntypedNullsToResultColumns(null);
        resultColumns = this.resultSet.getResultColumns();
        if (this.leftOperand != null && this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(((ResultColumn)resultColumns.elementAt(0)).getTypeServices());
        }
        this.setDataTypeServices(resultColumns);
        subqueryList.addSubqueryNode(this);
        if (this.resultSet instanceof SelectNode) {
            this.subqueryLevel = ((SelectNode)this.resultSet).getNestingLevel();
        }
        return this;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        SelectNode select;
        boolean flattenable;
        if (this.preprocessed) {
            return this;
        }
        this.preprocessed = true;
        ValueNode topNode = this;
        this.resultSet = this.resultSet.preprocess(numTables, null, null);
        if (this.resultSet instanceof SelectNode && ((SelectNode)this.resultSet).hasDistinct()) {
            ((SelectNode)this.resultSet).clearDistinct();
            if (this.subqueryType == 17) {
                this.distinctExpression = true;
            }
        }
        boolean isNonCorrelated = !this.hasCorrelatedCRsFromOuterScope();
        CompilerContext cc = this.getCompilerContext();
        if (isNonCorrelated) {
            cc.setNoncorrelatedSubqueryFound();
        }
        if ((this.isIN() || this.isANY()) && this.resultSet.returnsAtMostOneRow() && isNonCorrelated) {
            this.changeToCorrespondingExpressionType();
        }
        boolean bl = flattenable = this.resultSet instanceof RowResultSetNode && this.underTopAndNode && !this.havingSubquery && !this.isWhereExistsAnyInWithWhereSubquery() && !this.hasWindowFunctionColumn() && this.parentComparisonOperator instanceof BinaryComparisonOperatorNode && (cc.subqueryFlatteningAllowed() || this.hasCorrelatedCRs());
        if (flattenable) {
            this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            RowResultSetNode rrsn = (RowResultSetNode)this.resultSet;
            FromList fl = new FromList();
            outerSubqueryList.removeElement(this);
            if (rrsn.subquerys.size() != 0) {
                fl.addElement(rrsn);
                outerFromList.destructiveAppend(fl);
            }
            outerSubqueryList.destructiveAppend(rrsn.subquerys);
            ValueNode rightOperand = ((ResultColumn)rrsn.getResultColumns().elementAt(0)).getExpression();
            return this.getNewJoinCondition(this.leftOperand, rightOperand);
        }
        boolean flattenableNotExists = this.isNOT_EXISTS() || this.canAllBeFlattened();
        boolean bl2 = flattenable = this.resultSet instanceof SelectNode && this.underTopAndNode && !this.havingSubquery && !this.isWhereExistsAnyInWithWhereSubquery() && !this.hasWindowFunctionColumn() && (this.isIN() || this.isANY() || this.isEXISTS() || flattenableNotExists || this.parentComparisonOperator != null) && cc.subqueryFlatteningAllowed();
        if (flattenable && (this.isANY() || this.isIN() || this.isEXISTS())) {
            boolean isGfxdCriteriaSatisfied = this.isFlattenableBasedOnReplcatePartitionCriteria(outerFromList);
            if (flattenable && !isGfxdCriteriaSatisfied) {
                cc.setSubqueryFlatteningFlag(false);
                flattenable = false;
            }
        }
        if (flattenable && !(select = (SelectNode)this.resultSet).hasAggregatesInSelectList() && select.havingClause == null) {
            ValueNode origLeftOperand = this.leftOperand;
            boolean additionalEQ = this.subqueryType == 1 || this.subqueryType == 3;
            boolean bl3 = additionalEQ = additionalEQ && (this.leftOperand instanceof ConstantNode || this.leftOperand instanceof ColumnReference || this.leftOperand.requiresTypeFromContext());
            if (this.parentComparisonOperator instanceof BinaryComparisonOperatorNode) {
                this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            }
            if (!flattenableNotExists && select.uniqueSubquery(additionalEQ)) {
                return this.flattenToNormalJoin(numTables, outerFromList, outerSubqueryList, outerPredicateList);
            }
            if ((this.isIN() || this.isANY() || this.isEXISTS() || flattenableNotExists) && (this.leftOperand == null || this.leftOperand.categorize(new JBitSet(numTables), false)) && select.getWherePredicates().allPushable() && this.singleFromBaseTable(select.getFromList())) {
                return this.flattenToExistsJoin(numTables, outerFromList, outerSubqueryList, outerPredicateList, flattenableNotExists);
            }
            this.leftOperand = origLeftOperand;
        }
        if (this.leftOperand != null) {
            topNode = this.pushNewPredicate(numTables);
            this.pushedNewPredicate = true;
        } else if (this.subqueryType == 16) {
            topNode = this.genIsNullTree();
            this.subqueryType = 15;
        }
        this.isInvariant();
        this.hasCorrelatedCRs();
        if (this.parentComparisonOperator != null) {
            this.parentComparisonOperator.setRightOperand(topNode);
            return this.parentComparisonOperator;
        }
        return topNode;
    }

    private boolean isFlattenableBasedOnReplcatePartitionCriteria(FromList outerFromList) throws StandardException {
        final HashSet regions = new HashSet();
        VisitorAdaptor regionCollector = new VisitorAdaptor(){

            @Override
            public boolean skipChildren(Visitable node) throws StandardException {
                return !(node instanceof ProjectRestrictNode) && !(node instanceof SelectNode);
            }

            @Override
            public boolean stopTraversal() {
                return false;
            }

            @Override
            public Visitable visit(Visitable node) throws StandardException {
                if (node instanceof FromBaseTable) {
                    FromBaseTable fbt = (FromBaseTable)node;
                    TableDescriptor td = fbt.getTableDescriptor();
                    Region rgn = Misc.getRegionByPath(td, SubqueryNode.this.getLanguageConnectionContext(), true);
                    regions.add(rgn);
                }
                return node;
            }
        };
        outerFromList.accept(regionCollector);
        Iterator itr = regions.iterator();
        boolean allReplicates = true;
        while (itr.hasNext()) {
            DataPolicy dataPolicy = ((Region)itr.next()).getAttributes().getDataPolicy();
            if (!dataPolicy.withPartitioning()) continue;
            allReplicates = false;
            break;
        }
        if (allReplicates) {
            regions.clear();
            boolean foundPartition = false;
            if (this.resultSet instanceof SelectNode) {
                FromList frmList = ((SelectNode)this.resultSet).fromList;
                frmList.accept(regionCollector);
                itr = regions.iterator();
                while (itr.hasNext()) {
                    DataPolicy dataPolicy = ((Region)itr.next()).getAttributes().getDataPolicy();
                    if (!dataPolicy.withPartitioning()) continue;
                    foundPartition = true;
                    break;
                }
            }
            return !foundPartition;
        }
        return true;
    }

    private boolean singleFromBaseTable(FromList fromList) {
        FromTable ft;
        boolean retCode;
        boolean bl = retCode = fromList.size() == 1;
        if (!(!retCode || (ft = (FromTable)fromList.elementAt(0)) instanceof ProjectRestrictNode && ((ProjectRestrictNode)ft).getChildResult() instanceof FromBaseTable || ft instanceof FromBaseTable)) {
            retCode = false;
        }
        return retCode;
    }

    private boolean canAllBeFlattened() throws StandardException {
        boolean result = false;
        if (this.isNOT_IN()) {
            return false;
        }
        if (this.isALL()) {
            ValueNode rightOperand = ((ResultColumn)this.resultSet.getResultColumns().elementAt(0)).getExpression();
            result = !this.leftOperand.getTypeServices().isNullable() && !rightOperand.getTypeServices().isNullable();
        }
        return result;
    }

    private ValueNode flattenToNormalJoin(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        SelectNode select = (SelectNode)this.resultSet;
        FromList fl = select.getFromList();
        int[] tableNumbers = fl.getTableNumbers();
        outerSubqueryList.removeElement(this);
        select.decrementLevel(1);
        outerFromList.destructiveAppend(fl);
        outerPredicateList.destructiveAppend(select.getWherePredicates());
        outerSubqueryList.destructiveAppend(select.getWhereSubquerys());
        outerSubqueryList.destructiveAppend(select.getSelectSubquerys());
        if (this.leftOperand == null) {
            return (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        }
        ValueNode rightOperand = ((ResultColumn)select.getResultColumns().elementAt(0)).getExpression();
        if (rightOperand instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)rightOperand;
            int tableNumber = cr.getTableNumber();
            for (int index = 0; index < tableNumbers.length; ++index) {
                if (tableNumber != tableNumbers[index]) continue;
                cr.setSourceLevel(cr.getSourceLevel() - 1);
                break;
            }
        }
        return this.getNewJoinCondition(this.leftOperand, rightOperand);
    }

    private ValueNode flattenToExistsJoin(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList, boolean flattenableNotExists) throws StandardException {
        SelectNode select = (SelectNode)this.resultSet;
        select.getFromList().genExistsBaseTables(this.resultSet.getReferencedTableMap(), outerFromList, flattenableNotExists);
        return this.flattenToNormalJoin(numTables, outerFromList, outerSubqueryList, outerPredicateList);
    }

    private boolean isInvariant() throws StandardException {
        if (this.doneInvariantCheck) {
            return !this.foundVariant;
        }
        this.doneInvariantCheck = true;
        HasVariantValueNodeVisitor visitor = new HasVariantValueNodeVisitor();
        this.resultSet.accept(visitor);
        this.foundVariant = visitor.hasVariant();
        return !this.foundVariant;
    }

    public boolean hasCorrelatedCRs() throws StandardException {
        if (this.doneCorrelationCheck) {
            return this.foundCorrelation;
        }
        this.doneCorrelationCheck = true;
        ResultSetNode realSubquery = this.resultSet;
        ResultColumnList oldRCL = null;
        if (this.pushedNewPredicate) {
            SanityManager.ASSERT((boolean)(this.resultSet instanceof ProjectRestrictNode), (String)"resultSet expected to be a ProjectRestrictNode!");
            realSubquery = ((ProjectRestrictNode)this.resultSet).getChildResult();
            oldRCL = realSubquery.getResultColumns();
            if (oldRCL.size() > 1) {
                ResultColumnList newRCL = new ResultColumnList();
                newRCL.addResultColumn(oldRCL.getResultColumn(1));
                realSubquery.setResultColumns(newRCL);
            }
        }
        HasCorrelatedCRsVisitor visitor = new HasCorrelatedCRsVisitor();
        realSubquery.accept(visitor);
        this.foundCorrelation = visitor.hasCorrelatedCRs();
        if (this.pushedNewPredicate && oldRCL.size() > 1) {
            realSubquery.setResultColumns(oldRCL);
        }
        return this.foundCorrelation;
    }

    private UnaryComparisonOperatorNode pushNewPredicate(int numTables) throws StandardException {
        BinaryComparisonOperatorNode bcoNode = null;
        UnaryComparisonOperatorNode ucoNode = null;
        this.resultSet = this.resultSet.ensurePredicateList(numTables);
        ResultColumnList resultColumns = this.resultSet.getResultColumns();
        ResultColumnList newRCL = resultColumns.copyListAndObjects();
        newRCL.genVirtualColumnNodes(this.resultSet, resultColumns);
        this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(151, this.resultSet, newRCL, null, null, null, null, null, this.getContextManager());
        resultColumns = newRCL;
        ResultColumn firstRC = (ResultColumn)resultColumns.elementAt(0);
        ValueNode rightOperand = firstRC.getExpression();
        BinaryOperatorNode andLeft = bcoNode = this.getNewJoinCondition(this.leftOperand, rightOperand);
        if (this.isNOT_IN() || this.isALL()) {
            boolean leftNullable = this.leftOperand.getTypeServices().isNullable();
            boolean rightNullable = rightOperand.getTypeServices().isNullable();
            if (leftNullable || rightNullable) {
                BooleanConstantNode falseNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
                OrNode newOr = (OrNode)this.getNodeFactory().getNode(52, bcoNode, falseNode, this.getContextManager());
                newOr.postBindFixup();
                andLeft = newOr;
                if (leftNullable) {
                    UnaryComparisonOperatorNode leftIsNull = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(25, this.leftOperand, this.getContextManager());
                    leftIsNull.bindComparisonOperator();
                    newOr = (OrNode)this.getNodeFactory().getNode(52, leftIsNull, andLeft, this.getContextManager());
                    newOr.postBindFixup();
                    andLeft = newOr;
                }
                if (rightNullable) {
                    UnaryComparisonOperatorNode rightIsNull = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(25, rightOperand, this.getContextManager());
                    rightIsNull.bindComparisonOperator();
                    newOr = (OrNode)this.getNodeFactory().getNode(52, rightIsNull, andLeft, this.getContextManager());
                    newOr.postBindFixup();
                    andLeft = newOr;
                }
            }
        }
        AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, andLeft, this.getTrueNode(), this.getContextManager());
        JBitSet tableMap = new JBitSet(numTables);
        andNode.postBindFixup();
        Predicate predicate = (Predicate)this.getNodeFactory().getNode(78, andNode, tableMap, this.getContextManager());
        predicate.categorize();
        this.resultSet = this.resultSet.addNewPredicate(predicate);
        this.leftOperand = null;
        firstRC.setType(this.getTypeServices());
        firstRC.setExpression(this.getTrueNode());
        switch (this.subqueryType) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                ucoNode = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(24, this, this.getContextManager());
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                ucoNode = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(25, this, this.getContextManager());
            }
        }
        ucoNode.bindComparisonOperator();
        return ucoNode;
    }

    private BinaryComparisonOperatorNode getNewJoinCondition(ValueNode leftOperand, ValueNode rightOperand) throws StandardException {
        BinaryComparisonOperatorNode bcoNode = null;
        int operatorType = this.subqueryType;
        if (this.subqueryType == 17) {
            SanityManager.ASSERT((this.parentComparisonOperator != null ? 1 : 0) != 0, (String)"parentComparisonOperator expected to be non-null");
            int parentOperator = -1;
            if (this.parentComparisonOperator.isRelationalOperator()) {
                RelationalOperator ro = (RelationalOperator)((Object)this.parentComparisonOperator);
                parentOperator = ro.getOperator();
            }
            if (parentOperator == 1) {
                operatorType = 3;
            } else if (parentOperator == 2) {
                operatorType = 5;
            } else if (parentOperator == 6) {
                operatorType = 13;
            } else if (parentOperator == 5) {
                operatorType = 11;
            } else if (parentOperator == 4) {
                operatorType = 9;
            } else if (parentOperator == 3) {
                operatorType = 7;
            }
        }
        boolean bcoType = false;
        int nodeType = 0;
        switch (operatorType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                nodeType = 41;
                break;
            }
            case 4: 
            case 5: {
                nodeType = 47;
                break;
            }
            case 8: 
            case 13: {
                nodeType = 44;
                break;
            }
            case 10: 
            case 11: {
                nodeType = 45;
                break;
            }
            case 9: 
            case 12: {
                nodeType = 42;
                break;
            }
            case 7: 
            case 14: {
                nodeType = 43;
                break;
            }
            default: {
                SanityManager.ASSERT((boolean)false, (String)("subqueryType (" + this.subqueryType + ") is an unexpected type"));
            }
        }
        bcoNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(nodeType, leftOperand, rightOperand, this.getContextManager());
        bcoNode.bindComparisonOperator();
        return bcoNode;
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        ValueNode result = this;
        if (underNotNode) {
            switch (this.subqueryType) {
                case 17: {
                    result = this.genEqualsFalseTree();
                    break;
                }
                case 15: {
                    this.subqueryType = 16;
                    break;
                }
                case 1: 
                case 3: {
                    this.subqueryType = 2;
                    break;
                }
                case 5: {
                    this.subqueryType = 4;
                    break;
                }
                case 9: {
                    this.subqueryType = 12;
                    break;
                }
                case 7: {
                    this.subqueryType = 14;
                    break;
                }
                case 13: {
                    this.subqueryType = 8;
                    break;
                }
                case 11: {
                    this.subqueryType = 10;
                    break;
                }
                case 4: {
                    this.subqueryType = 5;
                    break;
                }
                case 6: {
                    this.subqueryType = 3;
                    break;
                }
                case 10: {
                    this.subqueryType = 11;
                    break;
                }
                case 8: {
                    this.subqueryType = 13;
                    break;
                }
                case 14: {
                    this.subqueryType = 7;
                    break;
                }
                case 12: {
                    this.subqueryType = 9;
                    break;
                }
                default: {
                    SanityManager.ASSERT((boolean)false, (String)"NOT is not supported for this time of subquery");
                }
            }
        }
        return result;
    }

    @Override
    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        this.underTopAndNode = underTopAndNode;
        return this;
    }

    @Override
    public boolean categorize(final JBitSet referencedTabs, final boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        VisitorAdaptor categorizationVisitor = new VisitorAdaptor(){
            boolean stopTraversal = false;

            @Override
            public Visitable visit(Visitable node) throws StandardException {
                ProjectRestrictNode prn;
                PredicateList pl;
                if (node instanceof SelectNode) {
                    SelectNode sn = (SelectNode)node;
                    sn.categorize(referencedTabs, simplePredsOnly);
                    this.stopTraversal = true;
                } else if (node instanceof ProjectRestrictNode && (pl = (prn = (ProjectRestrictNode)node).getRestrictionList()) != null) {
                    int size = pl.size();
                    for (int i = 0; i < size; ++i) {
                        referencedTabs.or(((Predicate)pl.elementAt(i)).getReferencedSet());
                    }
                }
                return node;
            }

            @Override
            public boolean stopTraversal() {
                return this.stopTraversal;
            }
        };
        this.resultSet.accept(categorizationVisitor);
        return this.isMaterializable();
    }

    boolean isMaterializable() throws StandardException {
        boolean retval;
        boolean bl = retval = this.subqueryType == 17 && !this.hasCorrelatedCRs() && this.isInvariant();
        if (retval && this.resultSet instanceof SelectNode) {
            SelectNode select = (SelectNode)this.resultSet;
            FromList fromList = select.getFromList();
            fromList.setLevel(0);
        }
        return retval;
    }

    public void optimize(DataDictionary dataDictionary, double outerRows) throws StandardException {
        this.resultSet = this.resultSet.optimize(dataDictionary, null, outerRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAccessPaths() throws StandardException {
        this.resultSet = this.resultSet.modifyAccessPaths();
        if (this.offset != null || this.fetchFirst != null) {
            this.resultSet = this.wrapRowCountNode(this.resultSet, this.offset, this.fetchFirst);
        }
        if (GemFireXDUtils.isSet(this.flag, (byte)1) && !this.hasCorrelatedCRsFromOuterScope()) {
            QueryInfoContext qic = this.params != null && this.params.size() > 0 ? new QueryInfoContext(true, this.params.size(), this.params.get(0), GemFireXDUtils.isSet(this.flag, (byte)8)) : new QueryInfoContext(true, 0, GemFireXDUtils.isSet(this.flag, (byte)8));
            try {
                this.subSqi = new SelectQueryInfo(qic);
                this.subSqi.setIsSubQueryFlag(true);
                qic.setRootQueryInfo(this.subSqi);
                if (this.resultSet != null && !this.subSqi.stopTraversal()) {
                    if (this.resultSet instanceof SetOperatorNode) {
                        this.resultSet.accept(this.subSqi);
                        this.subSqi.verifySetOperationSupported();
                    } else {
                        ((ProjectRestrictNode)this.resultSet).getChildResult().accept(this.subSqi);
                    }
                }
                this.subSqi.init();
            }
            finally {
                qic.cleanUp();
            }
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            CompilerContext cc = this.getCompilerContext();
            Statement stmt = lcc.createGenericStatement(this.subQueryString);
            if (!this.params.isEmpty()) {
                this.subqueryDTDs = new DataTypeDescriptor[this.params.size()];
            }
            ProjectRestrictNode prn = (ProjectRestrictNode)this.resultSet;
            CursorNode cn = new CursorNode();
            cn.init(prn.childResult);
            cn.setContextManager(this.getContextManager());
            this.subqueryPS = stmt.prepareStatement(lcc, this.subSqi, this.subqueryDTDs, cn, cc);
            ((GenericPreparedStatement)this.subqueryPS).setParentPS(cc.getParentPS());
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                List<SubQueryInfo> sqis;
                observer.queryInfoObjectFromOptmizedParsedTree(this.subSqi, (GenericPreparedStatement)this.subqueryPS, lcc);
                if (this.subSqi != null && this.subSqi.isSelect() && !(sqis = this.subSqi.getSubqueryInfoList()).isEmpty()) {
                    observer.subQueryInfoObjectFromOptmizedParsedTree(sqis, (GenericPreparedStatement)this.subqueryPS, lcc);
                }
            }
        }
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.resultSet.optimizeForOffHeap(shouldOptimize);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        if (this.isInvariant()) {
            if (!this.hasCorrelatedCRs() && this.subqueryType == 17) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder expressionBuilder, MethodBuilder mbex) throws StandardException {
        int nargs;
        String resultSetString;
        CompilerContext cc = this.getCompilerContext();
        if (GemFireXDUtils.isSet(this.flag, (byte)1) && this.hasCorrelatedCRsFromOuterScope()) {
            this.flag = GemFireXDUtils.set(this.flag, (byte)1, false);
        }
        SanityManager.ASSERT((boolean)(expressionBuilder instanceof ActivationClassBuilder), (String)"Expecting an ActivationClassBuilder");
        ActivationClassBuilder acb = (ActivationClassBuilder)expressionBuilder;
        if (this.subqueryType == 17) {
            this.resultSet.optimizeForOffHeap(false);
            resultSetString = "getOnceResultSet";
        } else {
            resultSetString = "getAnyResultSet";
        }
        CostEstimate costEstimate = this.resultSet.getFinalCostEstimate();
        String subqueryTypeString = this.getTypeCompiler().interfaceName();
        MethodBuilder mb = acb.newGeneratedFun(subqueryTypeString, 4);
        LocalField rsFieldLF = acb.newFieldDeclaration(2, "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
        ResultSetNode subNode = null;
        boolean processedSubqueryResult = false;
        if (!this.isMaterializable()) {
            MethodBuilder executeMB = acb.getExecuteMethod();
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                SanityManager.ASSERT((boolean)(this.resultSet instanceof ProjectRestrictNode), (String)"resultSet expected to be a ProjectRestrictNode!");
                subNode = ((ProjectRestrictNode)this.resultSet).getChildResult();
                LocalField subRS = acb.newFieldDeclaration(2, "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
                mb.getField(subRS);
                mb.conditionalIfNull();
                MaterializeSubqueryNode materialSubNode = new MaterializeSubqueryNode(subRS);
                subNode.optimizeForOffHeap(true);
                materialSubNode.costEstimate = this.resultSet.getFinalCostEstimate();
                ((ProjectRestrictNode)this.resultSet).setChildResult(materialSubNode);
                if (GemFireXDUtils.isSet(this.flag, (byte)1)) {
                    int resultSetNumber = cc.getNextResultSetNumber();
                    this.generateGFEResultSet(acb, mb, resultSetNumber, cc);
                    processedSubqueryResult = true;
                    ResultColumnList nonRedundantRCL = null;
                    ResultSetNode rsn = subNode;
                    boolean found = false;
                    while (!found) {
                        if (rsn instanceof ProjectRestrictNode) {
                            if (((ProjectRestrictNode)rsn).nopProjectRestrict()) {
                                ResultColumnList rcl = rsn.getResultColumns();
                                rcl.setRedundant();
                                rsn = ((ProjectRestrictNode)rsn).childResult;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        found = true;
                    }
                    nonRedundantRCL = rsn.getResultColumns();
                    nonRedundantRCL.setResultSetNumber(resultSetNumber);
                } else {
                    subNode.generate(acb, mb);
                }
                mb.startElseCode();
                mb.getField(subRS);
                mb.completeConditional();
                mb.setField(subRS);
                executeMB.pushNull("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
                executeMB.setField(subRS);
            }
            executeMB.pushNull("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
            executeMB.setField(rsFieldLF);
            mb.getField(rsFieldLF);
            mb.conditionalIfNull();
        }
        if (!GemFireXDUtils.isSet(this.flag, (byte)1) || processedSubqueryResult) {
            acb.pushGetResultSetFactoryExpression(mb);
            this.resultSet.generate(acb, mb);
        } else if (this.isMaterializable()) {
            acb.pushGetResultSetFactoryExpression(mb);
            int resultSetNumber = cc.getNextResultSetNumber();
            this.generateGFEResultSet(acb, mb, resultSetNumber, cc);
            processedSubqueryResult = true;
        } else {
            acb.pushGetResultSetFactoryExpression(mb);
            ((ProjectRestrictNode)this.resultSet).handleSubqueryProcessing(this, acb, mb);
            processedSubqueryResult = true;
        }
        int subqResultSetNumber = cc.getNextResultSetNumber();
        this.resultSet.getResultColumns().setResultSetNumber(subqResultSetNumber);
        this.resultSet.getResultColumns().generateNulls(acb, mb);
        if (this.subqueryType == 17) {
            int cardinalityCheck = this.distinctExpression ? 3 : (this.resultSet.returnsAtMostOneRow() ? 2 : 1);
            mb.push(cardinalityCheck);
            nargs = 8;
        } else {
            nargs = 7;
        }
        mb.push(subqResultSetNumber);
        mb.push(this.subqueryNumber);
        mb.push(this.pointOfAttachment);
        mb.push(costEstimate.rowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, resultSetString, "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", nargs);
        if (!this.isMaterializable()) {
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                ((ProjectRestrictNode)this.resultSet).setChildResult(subNode);
            }
            mb.startElseCode();
            mb.getField(rsFieldLF);
            mb.completeConditional();
        }
        mb.setField(rsFieldLF);
        mb.getField(rsFieldLF);
        mb.callMethod((short)185, null, "openCore", "void", 0);
        mb.getField(rsFieldLF);
        mb.callMethod((short)185, null, "getNextRowCore", "com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow", 0);
        mb.push(1);
        mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.sql.Row", "getColumn", "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", 1);
        mb.cast(subqueryTypeString);
        if (this.isMaterializable()) {
            mb.getField(rsFieldLF);
            mb.push(false);
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", "close", "void", 1);
        }
        mb.methodReturn();
        mb.complete();
        if (this.isMaterializable()) {
            LocalField lf = this.generateMaterialization(acb, mb, subqueryTypeString);
            mbex.getField(lf);
        } else {
            mbex.pushThis();
            mbex.callMethod((short)182, null, mb.getName(), subqueryTypeString, 0);
        }
    }

    public void generateGFEResultSet(ExpressionClassBuilder acb, MethodBuilder mb, int rsNum, CompilerContext cc) throws StandardException {
        if (!this.params.isEmpty()) {
            DataTypeDescriptor[] allDtds = this.getParameterTypes();
            int j = 0;
            for (Integer posn : this.params) {
                this.subqueryDTDs[j++] = allDtds[posn];
            }
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.subQueryString);
        mb.push(this.whereSubquery);
        mb.push(acb.addItem(this.subSqi));
        mb.push(acb.addItem(this.params));
        if (this.subqueryPS.getStatementStats() != null && cc.getStatementStats() != null) assert (this.subqueryPS.getStatementStats() == cc.getStatementStats());
        this.subqueryPS.setStatementStats(cc.getStatementStats());
        mb.push(acb.addItem(this.subqueryPS));
        mb.push(rsNum);
        mb.push(this.subSqi.createGFEActivation());
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.subqueryNodeProcessedData(this.subSqi, (GenericPreparedStatement)this.subqueryPS, this.subQueryString, this.params);
        }
        mb.callMethod((short)185, null, "getGfxdSubqueryResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 8);
    }

    private LocalField generateMaterialization(ActivationClassBuilder acb, MethodBuilder mbsq, String type) {
        MethodBuilder mb = acb.getExecuteMethod();
        LocalField field = acb.newFieldDeclaration(2, type);
        mb.pushThis();
        mb.callMethod((short)182, null, mbsq.getName(), type, 0);
        mb.setField(field);
        return field;
    }

    private BooleanConstantNode getTrueNode() throws StandardException {
        if (this.trueNode == null) {
            this.trueNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        }
        return this.trueNode;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v instanceof HasCorrelatedCRsVisitor && this.doneCorrelationCheck) {
            ((HasCorrelatedCRsVisitor)v).setHasCorrelatedCRs(this.foundCorrelation);
            return returnNode;
        }
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.resultSet != null && !v.stopTraversal()) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(v);
        }
        if (this.leftOperand != null && !v.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        return returnNode;
    }

    private boolean isIN() {
        return this.subqueryType == 1;
    }

    private boolean isNOT_IN() {
        return this.subqueryType == 2;
    }

    private boolean isANY() {
        switch (this.subqueryType) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isALL() {
        switch (this.subqueryType) {
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private boolean isEXISTS() {
        return this.subqueryType == 15;
    }

    private boolean isNOT_EXISTS() {
        return this.subqueryType == 16;
    }

    private void changeToCorrespondingExpressionType() throws StandardException {
        BinaryOperatorNode bcon = null;
        switch (this.subqueryType) {
            case 1: 
            case 3: {
                bcon = (BinaryOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, this, this.getContextManager());
                break;
            }
            case 5: {
                bcon = (BinaryOperatorNode)this.getNodeFactory().getNode(47, this.leftOperand, this, this.getContextManager());
                break;
            }
            case 13: {
                bcon = (BinaryOperatorNode)this.getNodeFactory().getNode(44, this.leftOperand, this, this.getContextManager());
                break;
            }
            case 11: {
                bcon = (BinaryOperatorNode)this.getNodeFactory().getNode(45, this.leftOperand, this, this.getContextManager());
                break;
            }
            case 9: {
                bcon = (BinaryOperatorNode)this.getNodeFactory().getNode(42, this.leftOperand, this, this.getContextManager());
                break;
            }
            case 7: {
                bcon = (BinaryOperatorNode)this.getNodeFactory().getNode(43, this.leftOperand, this, this.getContextManager());
            }
        }
        this.subqueryType = 17;
        this.setDataTypeServices(this.resultSet.getResultColumns());
        this.parentComparisonOperator = (BinaryComparisonOperatorNode)bcon;
        this.parentComparisonOperator.bindComparisonOperator();
        this.leftOperand = null;
    }

    private void setDataTypeServices(ResultColumnList resultColumns) throws StandardException {
        DataTypeDescriptor dts = this.subqueryType == 17 ? ((ResultColumn)resultColumns.elementAt(0)).getTypeServices() : this.getTrueNode().getTypeServices();
        this.setType(dts.getNullabilityType(true));
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        return false;
    }

    public boolean isHavingSubquery() {
        return this.havingSubquery;
    }

    public void setHavingSubquery(boolean havingSubquery) {
        this.havingSubquery = havingSubquery;
    }

    public boolean isWhereSubquery() {
        return this.whereSubquery;
    }

    public void setWhereSubquery(boolean whereSubquery) {
        this.whereSubquery = whereSubquery;
    }

    public boolean isWhereExistsAnyInWithWhereSubquery() throws StandardException {
        if (this.isWhereSubquery() && (this.isEXISTS() || this.isANY() || this.isIN())) {
            if (this.resultSet instanceof SelectNode) {
                SelectNode sn = (SelectNode)this.resultSet;
                if (sn.originalWhereClauseHadSubqueries) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean hasWindowFunctionColumn() throws StandardException {
        if (this.resultSet instanceof SelectNode) {
            SelectNode sn = (SelectNode)this.resultSet;
            ResultColumnList rcl = sn.getResultColumns();
            rcl.containsWindowFunctionResultColumn();
        }
        return false;
    }

    public void setSubqueryString(String subq) {
        this.subQueryString = subq;
    }

    public String getSubqueryString() {
        return this.subQueryString;
    }

    public void setGfxdSubactivationFlag(boolean on) {
        this.flag = GemFireXDUtils.set(this.flag, (byte)1, on);
    }

    public boolean getGfxdSubactivationFlag() {
        return GemFireXDUtils.isSet(this.flag, (byte)1);
    }

    public void setParams(List<Integer> params) {
        this.params = params;
    }

    public void setIsPreparedStatement(boolean isPrep) {
        this.flag = GemFireXDUtils.set(this.flag, (byte)8, isPrep);
    }

    public void setIsOptimizeLiteralAllowed(boolean allowed) {
        this.flag = GemFireXDUtils.set(this.flag, (byte)16, allowed);
    }

    private ResultSetNode wrapRowCountNode(ResultSetNode resultSet, ValueNode offset, ValueNode fetchFirst) throws StandardException {
        ResultSetNode topRS = resultSet;
        ResultColumnList selectRCs = topRS.getResultColumns().copyListAndObjects();
        selectRCs.genVirtualColumnNodes(topRS, topRS.getResultColumns());
        return (RowCountNode)this.getNodeFactory().getNode(230, topRS, selectRCs, offset, fetchFirst, this.getContextManager());
    }

    public boolean hasCorrelatedCRsFromOuterScope() throws StandardException {
        if (GemFireXDUtils.isSet(this.flag, (byte)2)) {
            return GemFireXDUtils.isSet(this.flag, (byte)4);
        }
        this.flag = GemFireXDUtils.set(this.flag, (byte)2);
        ResultSetNode realSubquery = this.resultSet;
        ResultColumnList oldRCL = null;
        if (this.pushedNewPredicate) {
            SanityManager.ASSERT((boolean)(this.resultSet instanceof ProjectRestrictNode), (String)"resultSet expected to be a ProjectRestrictNode!");
            realSubquery = ((ProjectRestrictNode)this.resultSet).getChildResult();
            oldRCL = realSubquery.getResultColumns();
            if (oldRCL.size() > 1) {
                ResultColumnList newRCL = new ResultColumnList();
                newRCL.addResultColumn(oldRCL.getResultColumn(1));
                realSubquery.setResultColumns(newRCL);
            }
        }
        HasGfxdCorrelatedCRsVisitor visitor = new HasGfxdCorrelatedCRsVisitor(this.subqueryLevel);
        realSubquery.accept(visitor);
        boolean foundGfxdCorrelation = visitor.hasCorrelatedCRs();
        this.flag = GemFireXDUtils.set(this.flag, (byte)4, foundGfxdCorrelation);
        return foundGfxdCorrelation;
    }

    @Override
    public String printExplainInfo() {
        return "SUBQUERY : " + this.subQueryString;
    }

    private static class HasGfxdCorrelatedCRsVisitor
    extends VisitorAdaptor {
        private boolean hasCorrelatedCRs;
        private final int subqueryLevel;

        public HasGfxdCorrelatedCRsVisitor(int subqueryLevel) {
            this.subqueryLevel = subqueryLevel;
        }

        @Override
        public Visitable visit(Visitable node) {
            if (node instanceof ColumnReference) {
                if (((ColumnReference)node).getSourceLevel() < this.subqueryLevel) {
                    this.hasCorrelatedCRs = true;
                }
            } else if (node instanceof VirtualColumnNode) {
                if (((VirtualColumnNode)node).getCorrelated()) {
                    this.hasCorrelatedCRs = true;
                }
            } else if (node instanceof MethodCallNode && (((MethodCallNode)node).getMethodName().equals("getTriggerExecutionContext") || ((MethodCallNode)node).getMethodName().equals("TriggerOldTransitionRows") || ((MethodCallNode)node).getMethodName().equals("TriggerNewTransitionRows"))) {
                this.hasCorrelatedCRs = true;
            }
            return node;
        }

        @Override
        public boolean stopTraversal() {
            return this.hasCorrelatedCRs;
        }

        @Override
        public boolean skipChildren(Visitable v) {
            return false;
        }

        public boolean hasCorrelatedCRs() {
            return this.hasCorrelatedCRs;
        }

        public void setHasCorrelatedCRs(boolean value) {
            this.hasCorrelatedCRs = value;
        }
    }
}

