/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class SimpleStringOperatorNode
extends UnaryOperatorNode {
    @Override
    public void init(Object operand, Object methodName) {
        super.init(operand, methodName, methodName);
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId operandType = this.operand.getTypeId();
        switch (operandType.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case 1111: 
            case 2000: {
                throw StandardException.newException("42X25", (Object)this.methodName, (Object)operandType.getSQLTypeName());
            }
            default: {
                DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices()));
                this.operand = (ValueNode)this.getNodeFactory().getNode(60, this.operand, dtd, this.getContextManager());
                this.operand.setCollationUsingCompilationSchema();
                ((CastNode)this.operand).bindCastNodeOnly();
                operandType = this.operand.getTypeId();
            }
        }
        this.setType(new DataTypeDescriptor(operandType, this.operand.getTypeServices().isNullable(), this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices())));
        this.setCollationInfo(this.operand.getTypeServices());
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(12));
        this.operand.setCollationUsingCompilationSchema();
    }

    @Override
    public String getReceiverInterfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.StringDataValue";
    }
}

