/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.WindowFunctionColumnNode;
import java.util.Vector;

public class ResultColumn
extends ValueNode
implements ResultColumnDescriptor,
Comparable {
    String name;
    String exposedName;
    String tableName;
    String sourceTableName;
    String sourceSchemaName;
    ValueNode expression;
    ColumnDescriptor columnDescriptor;
    boolean isGenerated;
    boolean isGeneratedForUnmatchedColumnInInsert;
    boolean isGroupingColumn;
    boolean isReferenced;
    boolean isRedundant;
    boolean isNameGenerated;
    boolean updated;
    boolean updatableByCursor;
    boolean isExpanded;
    private boolean defaultColumn;
    boolean autoincrementGenerated;
    boolean autoincrement;
    private int resultSetNumber = -1;
    ColumnReference reference;
    private int virtualColumnId;
    private short primaryKey = (short)-1;

    @Override
    public void init(Object arg1, Object arg2) throws StandardException {
        if (arg1 instanceof String || arg1 == null) {
            this.exposedName = this.name = (String)arg1;
            this.expression = (ValueNode)arg2;
        } else if (arg1 instanceof ColumnReference) {
            ColumnReference ref = (ColumnReference)arg1;
            this.name = ref.getColumnName();
            this.exposedName = ref.getColumnName();
            this.reference = ref;
            this.expression = (ValueNode)arg2;
        } else if (arg1 instanceof ColumnDescriptor) {
            ColumnDescriptor coldes = (ColumnDescriptor)arg1;
            this.exposedName = this.name = coldes.getColumnName();
            this.setType(coldes.getType());
            this.columnDescriptor = coldes;
            this.expression = (ValueNode)arg2;
            this.autoincrement = coldes.isAutoincrement();
        } else {
            this.setType((DataTypeDescriptor)arg1);
            this.expression = (ValueNode)arg2;
            if (arg2 instanceof ColumnReference) {
                this.reference = (ColumnReference)arg2;
            }
        }
        if (this.expression != null && this.expression.isInstanceOf(100)) {
            this.defaultColumn = true;
        }
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(boolean value) {
        this.defaultColumn = value;
    }

    boolean columnNameMatches(String columnName) {
        return columnName.equals(this.exposedName) || columnName.equals(this.name) || columnName.equals(this.getSourceColumnName());
    }

    public String getSourceColumnName() {
        if (this.expression instanceof ColumnReference) {
            return ((ColumnReference)this.expression).getColumnName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.exposedName;
    }

    @Override
    public String getSchemaName() {
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getSchemaName();
        }
        if (this.expression != null) {
            return this.expression.getSchemaName();
        }
        return null;
    }

    @Override
    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getName();
        }
        return this.expression.getTableName();
    }

    @Override
    public String getSourceTableName() {
        return this.sourceTableName;
    }

    @Override
    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void clearTableName() {
        if (this.expression instanceof ColumnReference) {
            ((ColumnReference)this.expression).setTableNameNode(null);
        }
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.getTypeServices();
    }

    @Override
    public int getColumnPosition() {
        if (this.columnDescriptor != null) {
            return this.columnDescriptor.getPosition();
        }
        return this.virtualColumnId;
    }

    public void setExpression(ValueNode expression) {
        this.expression = expression;
    }

    public ValueNode getExpression() {
        return this.expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.expression = this.getNullNode(this.getTypeServices());
    }

    public void setName(String name) {
        if (this.name == null) {
            this.name = name;
        } else {
            SanityManager.ASSERT((this.reference == null || name.equals(this.reference.getColumnName()) ? 1 : 0) != 0, (String)"don't change name from reference name");
        }
        this.exposedName = name;
    }

    public boolean isNameGenerated() {
        return this.isNameGenerated;
    }

    public void setNameGenerated(boolean value) {
        this.isNameGenerated = value;
    }

    public void setResultSetNumber(int resultSetNumber) {
        this.resultSetNumber = resultSetNumber;
    }

    public void ncjSetResultSetNumber(int resultSetNumber) {
        this.setResultSetNumber(resultSetNumber);
        if (this.expression != null && this.expression instanceof VirtualColumnNode) {
            ((VirtualColumnNode)this.expression).ncjSetResultSetNumber(resultSetNumber);
        }
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public void adjustVirtualColumnId(int adjust) {
        this.virtualColumnId += adjust;
    }

    public void setVirtualColumnId(int id) {
        this.virtualColumnId = id;
    }

    public int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    public void collapseVirtualColumnIdGap(int removedColumnId) {
        if (this.columnDescriptor == null && this.virtualColumnId > removedColumnId) {
            --this.virtualColumnId;
        }
    }

    public void guaranteeColumnName() throws StandardException {
        if (this.exposedName == null) {
            this.exposedName = "SQLCol" + this.getCompilerContext().getNextColumnNumber();
            this.isNameGenerated = true;
        }
    }

    @Override
    public String toString() {
        return "exposedName: " + this.exposedName + "\n" + "name: " + this.name + "\n" + "tableName: " + this.tableName + "\n" + "isNameGenerated: " + this.isNameGenerated + "\n" + "sourceTableName: " + this.sourceTableName + "\n" + "type: " + this.getTypeServices() + "\n" + "columnDescriptor: " + this.columnDescriptor + "\n" + "isGenerated: " + this.isGenerated + "\n" + "isGeneratedForUnmatchedColumnInInsert: " + this.isGeneratedForUnmatchedColumnInInsert + "\n" + "isGroupingColumn: " + this.isGroupingColumn + "\n" + "isReferenced: " + this.isReferenced + "\n" + "isRedundant: " + this.isRedundant + "\n" + "virtualColumnId: " + this.virtualColumnId + "\n" + "resultSetNumber: " + this.resultSetNumber + "\n" + "expression: " + (this.expression != null ? this.expression.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this.expression)) : "(null)") + '\n' + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.expression != null) {
            this.printLabel(depth, "expression: ");
            this.expression.treePrint(depth + 1);
        }
        if (this.reference != null) {
            this.printLabel(depth, "reference: ");
            this.reference.treePrint(depth + 1);
        }
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.expression.requiresTypeFromContext() && this.getTypeServices() != null) {
            this.expression.setType(this.getTypeServices());
        }
        this.expression = this.expression.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.expression instanceof ColumnReference) {
            this.autoincrement = ((ColumnReference)this.expression).getSource().isAutoincrement();
        }
        return this;
    }

    void bindResultColumnByPosition(TableDescriptor tableDescriptor, int columnId) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(columnId);
        if (columnDescriptor == null) {
            String errorString = "";
            String schemaName = tableDescriptor.getSchemaName();
            if (schemaName != null) {
                errorString = errorString + schemaName + ".";
            }
            errorString = errorString + tableDescriptor.getName();
            throw StandardException.newException("42X06", errorString);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(columnId);
    }

    public void bindResultColumnByName(TableDescriptor tableDescriptor, int columnId) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.exposedName);
        if (columnDescriptor == null) {
            String errorString = "";
            String schemaName = tableDescriptor.getSchemaName();
            if (schemaName != null) {
                errorString = errorString + schemaName + ".";
            }
            errorString = errorString + tableDescriptor.getName();
            throw StandardException.newException("42X14", (Object)this.exposedName, (Object)errorString);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(columnId);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
        }
    }

    public void typeUntypedNullExpression(ResultColumn bindingRC) throws StandardException {
        TypeId typeId = bindingRC.getTypeId();
        if (typeId == null) {
            throw StandardException.newException("42X07");
        }
        if (this.expression instanceof UntypedNullConstantNode) {
            this.expression = this.getNullNode(bindingRC.getTypeServices());
        } else if (this.expression instanceof ColumnReference && this.expression.getTypeServices() == null) {
            this.expression.setType(bindingRC.getType());
        }
    }

    void setColumnDescriptor(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        SanityManager.ASSERT((columnDescriptor != null ? 1 : 0) != 0, (String)"Caller is responsible for verifying that column exists");
        this.setType(columnDescriptor.getType());
        this.columnDescriptor = columnDescriptor;
        if (this.reference != null && this.reference.getTableName() != null && !tableDescriptor.getName().equals(this.reference.getTableName())) {
            String realName = tableDescriptor.getName();
            String refName = this.reference.getTableName();
            throw StandardException.newException("42X55", (Object)realName, (Object)refName);
        }
    }

    public void bindResultColumnToExpression() throws StandardException {
        this.setType(this.expression.getTypeServices());
        if (this.expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.expression;
            this.tableName = cr.getTableName();
            this.sourceTableName = cr.getSourceTableName();
            this.sourceSchemaName = cr.getSourceSchemaName();
        }
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.expression == null) {
            return this;
        }
        this.expression = this.expression.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    public void checkStorableExpression(ResultColumn toStore) throws StandardException {
        this.checkStorableExpression((ValueNode)toStore);
    }

    private void checkStorableExpression(ValueNode source) throws StandardException {
        TypeId toStoreTypeId = source.getTypeId();
        if (!this.getTypeCompiler().storable(toStoreTypeId, this.getClassFactory())) {
            throw StandardException.newException("42821", (Object)this.getTypeId().getSQLTypeName(), (Object)toStoreTypeId.getSQLTypeName(), (Object)("column: " + (this.exposedName != null ? this.exposedName : this.getSourceColumnName()) + ", table: " + (this.tableName != null ? this.tableName : this.getTableName()) + ", schema: " + this.getSchemaName()));
        }
    }

    public void checkStorableExpression() throws StandardException {
        this.checkStorableExpression(this.getExpression());
    }

    @Override
    public void generateExpression(ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        if (!(this.expression instanceof ColumnReference)) {
            mb.pushThis();
            if (this.exposedName != null) {
                mb.push(this.exposedName);
            } else {
                String colName = this.getSourceColumnName();
                if (colName != null) {
                    mb.push(colName);
                } else {
                    mb.pushNull("java.lang.String");
                }
            }
            mb.putField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "currentColumnName", "java.lang.String");
            mb.endStatement();
        }
        this.expression.generateExpression(ecb, mb);
    }

    public void generateHolder(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
    }

    boolean columnTypeAndLengthMatch() throws StandardException {
        if (this.getExpression().requiresTypeFromContext() && !this.getExpression().isParameterizedConstantNode()) {
            return false;
        }
        if (this.getTypeId().isXMLTypeId()) {
            return false;
        }
        DataTypeDescriptor expressionType = this.getExpression().getTypeServices();
        if (!this.getTypeServices().isExactTypeAndLengthMatch(expressionType)) {
            return false;
        }
        return this.getTypeServices().isNullable() || !expressionType.isNullable();
    }

    boolean columnTypeAndLengthMatch(ResultColumn otherColumn) throws StandardException {
        ValueNode otherExpression = otherColumn.getExpression();
        DataTypeDescriptor resultColumnType = this.getTypeServices();
        DataTypeDescriptor otherResultColumnType = otherColumn.getTypeServices();
        if (resultColumnType == null) {
            SanityManager.ASSERT((resultColumnType != null ? 1 : 0) != 0, (String)("Type is null for column " + this));
        }
        if (otherResultColumnType == null) {
            SanityManager.ASSERT((otherResultColumnType != null ? 1 : 0) != 0, (String)("Type is null for column " + otherColumn));
        }
        if (otherExpression != null && (otherExpression.requiresTypeFromContext() || this.expression.requiresTypeFromContext())) {
            return false;
        }
        if (resultColumnType.getTypeId().isXMLTypeId()) {
            return false;
        }
        if (!resultColumnType.getTypeId().equals(otherResultColumnType.getTypeId())) {
            if (otherExpression instanceof ConstantNode) {
                DataValueDescriptor newValue;
                ConstantNode constant = (ConstantNode)otherColumn.getExpression();
                DataValueDescriptor oldValue = constant.getValue();
                if (oldValue != (newValue = this.convertConstant(resultColumnType.getTypeId(), resultColumnType.getMaximumWidth(), oldValue)) && oldValue instanceof StringDataValue == newValue instanceof StringDataValue) {
                    constant.setValue(newValue);
                    constant.setType(this.getTypeServices());
                    otherColumn.bindResultColumnToExpression();
                    otherResultColumnType = otherColumn.getType();
                }
                if (newValue instanceof StringDataValue) {
                    constant.setCollationInfo(resultColumnType);
                    DataValueFactory dvf = this.getDataValueFactory();
                    newValue = ((StringDataValue)newValue).getValue(dvf.getCharacterCollator(constant.getTypeServices().getCollationType()));
                    constant.setValue(newValue);
                }
            }
            if (!resultColumnType.getTypeId().equals(otherResultColumnType.getTypeId())) {
                return false;
            }
        }
        if (resultColumnType.getPrecision() != otherResultColumnType.getPrecision()) {
            return false;
        }
        if (resultColumnType.getScale() != otherResultColumnType.getScale()) {
            return false;
        }
        if (resultColumnType.getMaximumWidth() != otherResultColumnType.getMaximumWidth()) {
            return false;
        }
        return resultColumnType.isNullable() || !otherResultColumnType.isNullable() && !otherColumn.isGeneratedForUnmatchedColumnInInsert();
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public boolean isGeneratedForUnmatchedColumnInInsert() {
        return this.isGeneratedForUnmatchedColumnInInsert;
    }

    public void markGenerated() {
        this.isGenerated = true;
        this.isReferenced = true;
    }

    public void markGeneratedForUnmatchedColumnInInsert() {
        this.isGeneratedForUnmatchedColumnInInsert = true;
        this.isReferenced = true;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setReferenced() {
        this.isReferenced = true;
    }

    void pullVirtualIsReferenced() {
        if (this.isReferenced()) {
            return;
        }
        ValueNode expr = this.expression;
        while (expr != null && expr instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)expr;
            ResultColumn src = vcn.getSourceColumn();
            if (src.isReferenced()) {
                this.setReferenced();
                return;
            }
            expr = src.getExpression();
        }
    }

    public void setUnreferenced() {
        this.isReferenced = false;
    }

    void markAllRCsInChainReferenced() {
        this.setReferenced();
        ValueNode vn = this.expression;
        while (vn instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)vn;
            ResultColumn rc = vcn.getSourceColumn();
            rc.setReferenced();
            vn = rc.getExpression();
        }
    }

    public boolean isRedundant() {
        return this.isRedundant;
    }

    public void setRedundant() {
        this.isRedundant = true;
    }

    public void markAsGroupingColumn() {
        this.isGroupingColumn = true;
    }

    void rejectParameter() throws StandardException {
        if (this.expression != null && this.expression.isParameterNode()) {
            throw StandardException.newException("42X34");
        }
    }

    public int compareTo(Object other) {
        ResultColumn otherResultColumn = (ResultColumn)other;
        return this.getColumnPosition() - otherResultColumn.getColumnPosition();
    }

    void markUpdated() {
        this.updated = true;
    }

    void markUpdatableByCursor() {
        this.updatableByCursor = true;
    }

    public final String getActualName() {
        return this.name;
    }

    public boolean updated() {
        return this.updated;
    }

    @Override
    public final short primaryKey(EngineConnection conn) throws StandardException {
        if (this.primaryKey == -1) {
            TableDescriptor td;
            if (this.isGenerated) {
                this.primaryKey = 0;
            } else if (!GfxdDataDictionary.isSystemSchema(this.sourceSchemaName)) {
                GemFireContainer container = GemFireXDUtils.getGemFireContainer(this.sourceSchemaName, this.sourceTableName, this.lcc);
                this.primaryKey = ResultColumn.checkPrimaryKey(container.getExtraTableInfo(), this.name, this.getSourceColumnName());
            } else if (this.columnDescriptor != null && (td = this.columnDescriptor.getTableDescriptor()) != null) {
                this.primaryKey = ResultColumn.checkPrimaryKey(td, this.columnDescriptor.getPosition());
            }
        }
        return this.primaryKey;
    }

    public static short checkPrimaryKey(TableDescriptor td, int columnPosition) throws StandardException {
        int[] pkColumns;
        short numPrimaryKeys = 0;
        ReferencedKeyConstraintDescriptor rkcd = td.getPrimaryKey();
        if (rkcd != null && (pkColumns = rkcd.getReferencedColumns()) != null) {
            for (int pkColumn : pkColumns) {
                if (columnPosition != pkColumn) continue;
                numPrimaryKeys = (short)pkColumns.length;
                break;
            }
        }
        return numPrimaryKeys;
    }

    public static short checkPrimaryKey(ExtraTableInfo tableInfo, String columnName, String sourceColumnName) {
        String[] colNames;
        short numPrimaryKeys = 0;
        if (tableInfo != null && (colNames = tableInfo.getPrimaryKeyColumnNames()) != null) {
            for (String colName : colNames) {
                if (!colName.equals(columnName) && (sourceColumnName == null || !colName.equals(sourceColumnName))) continue;
                numPrimaryKeys = (short)colNames.length;
                break;
            }
        }
        return numPrimaryKeys;
    }

    @Override
    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    @Override
    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        if (this.expression != null) {
            this.expression.disablePrivilegeCollection();
        }
    }

    public ResultColumn cloneMe() throws StandardException {
        ResultColumn newResultColumn;
        ValueNode cloneExpr = this.expression instanceof ColumnReference ? ((ColumnReference)this.expression).getClone() : this.expression;
        if (this.columnDescriptor != null) {
            newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.columnDescriptor, this.expression, this.getContextManager());
            newResultColumn.setExpression(cloneExpr);
        } else {
            newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.getName(), cloneExpr, this.getContextManager());
        }
        newResultColumn.setVirtualColumnId(this.getVirtualColumnId());
        newResultColumn.setName(this.getName());
        newResultColumn.setType(this.getTypeServices());
        newResultColumn.setNameGenerated(this.isNameGenerated());
        if (this.isGeneratedForUnmatchedColumnInInsert()) {
            newResultColumn.markGeneratedForUnmatchedColumnInInsert();
        }
        if (this.isReferenced()) {
            newResultColumn.setReferenced();
        }
        if (this.updated()) {
            newResultColumn.markUpdated();
        }
        if (this.updatableByCursor()) {
            newResultColumn.markUpdatableByCursor();
        }
        if (this.isAutoincrementGenerated()) {
            newResultColumn.setAutoincrementGenerated();
        }
        if (this.isAutoincrement()) {
            newResultColumn.setAutoincrement();
        }
        if (this.isGroupingColumn()) {
            newResultColumn.markAsGroupingColumn();
        }
        if (this.isGenerated()) {
            newResultColumn.markGenerated();
        }
        return newResultColumn;
    }

    public int getMaximumColumnSize() {
        return this.getTypeServices().getTypeId().getApproximateLengthInBytes(this.getTypeServices());
    }

    @Override
    public DataTypeDescriptor getTypeServices() {
        DataTypeDescriptor type = super.getTypeServices();
        if (type != null) {
            return type;
        }
        if (this.getExpression() != null) {
            return this.getExpression().getTypeServices();
        }
        return null;
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int expType = this.isAutoincrementGenerated() ? 0 : (this.expression != null ? this.expression.getOrderableVariantType() : 3);
        switch (expType) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 3;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.expression != null && !v.stopTraversal()) {
            this.expression = (ValueNode)this.expression.accept(v);
        }
        return returnNode;
    }

    public boolean foundInList(String[] list) {
        return this.foundString(list, this.name);
    }

    void verifyOrderable() throws StandardException {
        if (!this.getTypeId().orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", this.getTypeId().getSQLTypeName());
        }
    }

    public final ColumnDescriptor getTableColumnDescriptor() {
        return this.columnDescriptor;
    }

    public boolean isAutoincrementGenerated() {
        return this.autoincrementGenerated;
    }

    public void setAutoincrementGenerated() {
        this.autoincrementGenerated = true;
    }

    public void resetAutoincrementGenerated() {
        this.autoincrementGenerated = false;
    }

    @Override
    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement() {
        this.autoincrement = true;
    }

    public boolean isGroupingColumn() {
        return this.isGroupingColumn;
    }

    private DataValueDescriptor convertConstant(TypeId toTypeId, int maxWidth, DataValueDescriptor constantValue) throws StandardException {
        int formatId = toTypeId.getTypeFormatId();
        DataValueFactory dvf = this.getDataValueFactory();
        switch (formatId) {
            default: {
                return constantValue;
            }
            case 13: {
                String sourceValue = constantValue.getString();
                int sourceWidth = sourceValue.length();
                if (sourceWidth <= maxWidth && formatId == 13) {
                    return dvf.getVarcharDataValue(sourceValue);
                }
                for (int posn = maxWidth; posn < sourceWidth; ++posn) {
                    if (sourceValue.charAt(posn) == ' ') continue;
                    String typeName = null;
                    if (formatId == 13) {
                        typeName = "VARCHAR";
                    }
                    throw StandardException.newException("22001", (Object)typeName, (Object)StringUtil.formatForPrint(sourceValue), (Object)String.valueOf(maxWidth));
                }
                if (formatId != 13) break;
                return dvf.getVarcharDataValue(sourceValue.substring(0, maxWidth));
            }
            case 230: 
        }
        return dvf.getLongvarcharDataValue(constantValue.getString());
    }

    public TableName getTableNameObject() {
        return null;
    }

    public ColumnReference getReference() {
        return this.reference;
    }

    public BaseColumnNode getBaseColumnNode() {
        ValueNode vn = this.expression;
        while (true) {
            if (vn instanceof ResultColumn) {
                vn = ((ResultColumn)vn).expression;
                continue;
            }
            if (vn instanceof ColumnReference) {
                vn = ((ColumnReference)vn).getSource();
                continue;
            }
            if (!(vn instanceof VirtualColumnNode)) break;
            vn = ((VirtualColumnNode)vn).getSourceColumn();
        }
        if (vn instanceof BaseColumnNode) {
            return (BaseColumnNode)vn;
        }
        return null;
    }

    public int getTableNumber() throws StandardException {
        if (this.expression instanceof ColumnReference) {
            return ((ColumnReference)this.expression).getTableNumber();
        }
        if (this.expression instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)this.expression;
            if (vcn.getSourceResultSet() instanceof FromBaseTable) {
                return ((FromBaseTable)vcn.getSourceResultSet()).getTableNumber();
            }
            return vcn.getSourceColumn().getTableNumber();
        }
        return -1;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (o.getNodeType() == this.getNodeType()) {
            ResultColumn other = (ResultColumn)o;
            if (this.expression != null) {
                return this.expression.isEquivalent(other.expression);
            }
        }
        return false;
    }

    public boolean expressionIsWindowFunction() {
        return this.getExpression() instanceof WindowFunctionColumnNode;
    }

    public boolean isWindowFunction() {
        ValueNode expr = this.getExpression();
        return expr instanceof WindowFunctionColumnNode || expr instanceof VirtualColumnNode && expr.getSourceResultColumn().getExpression() instanceof WindowFunctionColumnNode;
    }

    public void unmarkGenerated() {
        this.isGenerated = false;
    }

    public void markExpanded() {
        this.isExpanded = true;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        this.expression = this.expression.genExpressionOperands(outerResultColumns, parentRC, remapToNew);
        return this;
    }

    public ResultColumn getChildResultColumn() {
        ValueNode vn = this.expression;
        while (true) {
            if (vn instanceof ColumnReference) {
                vn = ((ColumnReference)vn).getSource();
                continue;
            }
            if (!(vn instanceof VirtualColumnNode)) break;
            vn = ((VirtualColumnNode)vn).getSourceColumn();
        }
        if (vn instanceof ResultColumn) {
            return (ResultColumn)vn;
        }
        return null;
    }

    @Override
    public boolean hasExpression() {
        return this.expression.hasExpression();
    }

    @Override
    public String findSourceSchemaName() {
        TableDescriptor td;
        if (this.sourceSchemaName != null) {
            return this.sourceSchemaName;
        }
        if (this.columnDescriptor != null && (td = this.columnDescriptor.getTableDescriptor()) != null) {
            return td.getSchemaName();
        }
        if (this.expression != null) {
            return this.expression.findSourceSchemaName();
        }
        return null;
    }

    @Override
    public String findSourceTableName() {
        TableDescriptor td;
        if (this.sourceTableName != null) {
            return this.sourceTableName;
        }
        if (this.columnDescriptor != null && (td = this.columnDescriptor.getTableDescriptor()) != null) {
            return td.getName();
        }
        if (this.expression != null) {
            return this.expression.findSourceTableName();
        }
        return this.tableName;
    }

    @Override
    public String findSourceColumnName() {
        if (this.expression != null) {
            return this.expression.findSourceColumnName();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.getName();
    }
}

