/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLModStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DeleteNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromSubquery;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasNodeVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowCountNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StaticMethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UpdateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.ArrayList;
import java.util.Vector;

public abstract class DMLStatementNode
extends StatementNode {
    ResultSetNode resultSet;
    protected Optimizer optimizer;

    @Override
    public void init(Object resultSet) {
        this.resultSet = (ResultSetNode)resultSet;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultSet != null) {
            this.printLabel(depth, "resultSet: ");
            this.resultSet.treePrint(depth + 1);
        }
    }

    public ResultSetNode getResultSetNode() {
        return this.resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryTreeNode bind(DataDictionary dataDictionary) throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            this.bindTables(dataDictionary);
            this.bindExpressions();
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        return this;
    }

    public QueryTreeNode bindResultSetsWithTables(DataDictionary dataDictionary) throws StandardException {
        this.bindTables(dataDictionary);
        this.bindExpressionsWithTables();
        return this;
    }

    protected void bindTables(DataDictionary dataDictionary) throws StandardException {
        this.resultSet = this.resultSet.bindNonVTITables(dataDictionary, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.resultSet = this.resultSet.bindVTITables((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
    }

    protected void bindExpressions() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressions(fromList);
        SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
    }

    protected void bindExpressionsWithTables() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressionsWithTables(fromList);
        SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
    }

    @Override
    int activationKind() {
        Vector<ValueNode> parameterList = this.getCompilerContext().getParameterList();
        if (parameterList != null && parameterList.size() > 0) {
            return 2;
        }
        return 1;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        this.optimizeStatement(null, null);
    }

    protected void optimizeStatement(ValueNode offset, ValueNode fetchFirst) throws StandardException {
        boolean isOffsetOrFetchNext = offset != null || fetchFirst != null;
        this.getCompilerContext().setIsOffsetOrFetchNext();
        this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        this.resultSet = this.resultSet.optimize(this.getDataDictionary(), null, 1.0);
        this.optimizer = this.resultSet.getOptimizerImpl();
        this.optimizer.saveBestJoinOrderPrIDs();
        this.resultSet = this.resultSet.modifyAccessPaths();
        if (isOffsetOrFetchNext) {
            this.resultSet = this.wrapRowCountNode(this.resultSet, offset, fetchFirst);
        }
        if (this instanceof CursorNode) {
            ResultSetNode siChild = this.resultSet;
            ResultColumnList siRCList = this.resultSet.getResultColumns();
            ResultColumnList childRCList = siRCList.copyListAndObjects();
            this.resultSet.setResultColumns(childRCList);
            siRCList.genVirtualColumnNodes(this.resultSet, childRCList);
            this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(123, this.resultSet, siRCList, null, this.getContextManager());
            if (siChild.getReferencedTableMap() != null) {
                this.resultSet.setReferencedTableMap((JBitSet)siChild.getReferencedTableMap().clone());
            }
        }
    }

    private ResultSetNode wrapRowCountNode(ResultSetNode resultSet, ValueNode offset, ValueNode fetchFirst) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (cc != null && !cc.createQueryInfo() && cc.isOrderByListNullified()) {
            return resultSet;
        }
        ResultSetNode topRS = resultSet;
        ResultColumnList selectRCs = topRS.getResultColumns().copyListAndObjects();
        selectRCs.genVirtualColumnNodes(topRS, topRS.getResultColumns());
        return (RowCountNode)this.getNodeFactory().getNode(230, topRS, selectRCs, offset, fetchFirst, this.getContextManager());
    }

    @Override
    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] colDescs = this.resultSet.makeResultDescriptors();
        String statementType = this.statementToString();
        return this.getExecutionFactory().getResultDescription(colDescs, statementType);
    }

    void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        int numberOfParameters;
        Vector<ValueNode> parameterList = this.getCompilerContext().getParameterList();
        int n = numberOfParameters = parameterList == null ? 0 : parameterList.size();
        if (numberOfParameters <= 0 || !this.getCompilerContext().isPreparedStatement()) {
            return;
        }
        ParameterNode.generateParameterValueSet(acb, numberOfParameters, parameterList);
    }

    @Override
    public boolean isAtomic() throws StandardException {
        HasNodeVisitor visitor = new HasNodeVisitor(FromBaseTable.class, StaticMethodCallNode.class);
        this.accept(visitor);
        return visitor.hasNode();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        if (this.resultSet != null && !v.stopTraversal()) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(v);
        }
        return this;
    }

    int getPrivType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder makeShortDescription(StringBuilder buffer) {
        if (this.resultSet == null) {
            return buffer;
        }
        String statementType = this.statementToString().replaceAll(" ", "_");
        buffer.append(statementType.toLowerCase()).append("_");
        StringBuilder columnList = new StringBuilder();
        ResultColumnList rcl = this.resultSet.getResultColumns();
        if (!(this instanceof DeleteNode)) {
            for (int idx = 0; idx <= rcl.size() - 1; ++idx) {
                ResultColumn rc = (ResultColumn)rcl.elementAt(idx);
                if (rc == null || rc.isGenerated() || this instanceof UpdateNode && !rc.updated()) continue;
                if (idx != 0) {
                    columnList.append(",");
                }
                columnList.append(rc.getName().toLowerCase());
            }
        }
        if (this instanceof DMLModStatementNode) {
            buffer.append((CharSequence)columnList);
            buffer.append("_").append(((DMLModStatementNode)this).targetTableName);
        } else if (this instanceof CursorNode) {
            final StringBuilder tableList = new StringBuilder();
            VisitorAdaptor v = new VisitorAdaptor(){
                private int numTables = 0;
                private ArrayList<String> visitedTables = new ArrayList();

                @Override
                public boolean skipChildren(Visitable node) throws StandardException {
                    return node instanceof FromSubquery || node instanceof FromBaseTable;
                }

                @Override
                public boolean stopTraversal() {
                    return tableList.length() >= 190;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Visitable visit(Visitable node) throws StandardException {
                    String tabName = null;
                    if (node instanceof FromBaseTable) {
                        tabName = ((FromBaseTable)node).getActualTableName().toString();
                    } else if (node instanceof FromVTI) {
                        tabName = ((FromVTI)node).getExposedTableName().toString();
                    } else if (node instanceof FromSubquery) {
                        int parentNumTables = this.numTables;
                        ArrayList<String> parentVisitedTables = this.visitedTables;
                        try {
                            this.numTables = 0;
                            this.visitedTables = new ArrayList();
                            tableList.append("(_SELECT");
                            ((FromSubquery)node).getSubquery().accept(this);
                            tableList.append("_)");
                        }
                        finally {
                            this.numTables = parentNumTables;
                            this.visitedTables = parentVisitedTables;
                        }
                    }
                    if (tabName != null && !this.visitedTables.contains(tabName)) {
                        if (this.numTables == 0) {
                            tableList.append("__");
                        } else {
                            tableList.append(",");
                        }
                        tableList.append(tabName);
                        this.visitedTables.add(tabName);
                        ++this.numTables;
                    }
                    return node;
                }
            };
            boolean columnListAdded = false;
            try {
                this.resultSet.accept(v);
                if (columnList.length() + tableList.length() + buffer.length() > 190) {
                    int reduceLength = columnList.length() - tableList.length() - buffer.length();
                    if (reduceLength > 0) {
                        buffer.append(columnList.subSequence(0, reduceLength));
                    }
                } else {
                    buffer.append((CharSequence)columnList);
                }
                columnListAdded = true;
                buffer.append((CharSequence)tableList);
            }
            catch (StandardException e) {
                if (GemFireXDUtils.TraceStatsGeneration) {
                    SanityManager.DEBUG_PRINT((String)"warningTraceStatsGeneration", (String)("Error while extracting table information " + this), (Throwable)e);
                }
            }
            finally {
                if (!columnListAdded) {
                    buffer.append((CharSequence)columnList);
                }
            }
        }
        return buffer;
    }

    @Override
    public void optimizeForOffHeap(boolean shouldOptimize) {
        if (GemFireXDUtils.isOffHeapEnabled() && this.resultSet != null) {
            this.resultSet.optimizeForOffHeap(shouldOptimize);
        }
    }
}

