/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.CustomEvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdEvictionCriteria;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateConstraintConstantAction;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class CreateTableNode
extends DDLStatementNode {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private Properties properties;
    private TableElementList tableElementList;
    protected int tableType;
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;
    private DistributionDescriptor distributionDesc;
    private int textToBeReplacedBegin;
    private int textToBeReplacedEnd;
    String sqlText;
    String generatedSqlTextForCTAS;

    @Override
    public void init(Object newObjectName, Object tableElementList, Object properties, Object lockGranularity) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = ((Character)lockGranularity).charValue();
        this.implicitCreateSchema = true;
        if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
            SanityManager.THROWASSERT((String)("Unexpected value for lockGranularity = " + this.lockGranularity));
        }
        this.initAndCheck(newObjectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.properties = (Properties)properties;
    }

    @Override
    public void init(Object newObjectName, Object tableElementList, Object properties, Object onCommitDeleteRows, Object onRollbackDeleteRows) throws StandardException {
        this.tableType = 3;
        newObjectName = this.tempTableSchemaNameCheck(newObjectName);
        this.onCommitDeleteRows = (Boolean)onCommitDeleteRows;
        this.onRollbackDeleteRows = (Boolean)onRollbackDeleteRows;
        this.initAndCheck(newObjectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.properties = (Properties)properties;
        if (!this.onRollbackDeleteRows) {
            SanityManager.THROWASSERT((String)("Unexpected value for onRollbackDeleteRows = " + this.onRollbackDeleteRows));
        }
    }

    @Override
    public void init(Object newObjectName, Object resultColumns, Object queryExpression) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.initAndCheck(newObjectName);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.queryExpression = (ResultSetNode)queryExpression;
    }

    @Override
    public void init(Object newObjectName, Object resultColumns, Object queryExpression, Object textToBeReplacedBegin, Object textToBeReplacedEnd, Object statementText) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.initAndCheck(newObjectName);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.queryExpression = (ResultSetNode)queryExpression;
        this.textToBeReplacedBegin = (Integer)textToBeReplacedBegin;
        this.textToBeReplacedEnd = (Integer)textToBeReplacedEnd;
        this.sqlText = (String)statementText;
        this.properties = this.queryExpression.getDistributionNode().getTableProperties();
    }

    private Object tempTableSchemaNameCheck(Object objectName) throws StandardException {
        TableName tempTableName = (TableName)objectName;
        if (tempTableName != null) {
            if (tempTableName.getSchemaName() == null) {
                tempTableName.setSchemaName("SESSION");
            } else if (!this.isSessionSchema(tempTableName.getSchemaName())) {
                throw StandardException.newException("428EK");
            }
        }
        return tempTableName;
    }

    @Override
    public String toString() {
        String tempString = "tableElementList: \n" + this.tableElementList + "\n";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: " + "\n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: " + "\n" + this.onRollbackDeleteRows + "\n";
        } else {
            tempString = tempString + "properties: " + "\n" + this.properties + "\n" + "lockGranularity: " + "\n" + this.lockGranularity + "\n";
        }
        return super.toString() + tempString;
    }

    @Override
    public String statementToString() {
        if (this.tableType == 3) {
            return "DECLARE GLOBAL TEMPORARY TABLE";
        }
        return "CREATE TABLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        int numPrimaryKeys = 0;
        int numCheckConstraints = 0;
        int numReferenceConstraints = 0;
        int numUniqueConstraints = 0;
        if (this.queryExpression != null) {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            CompilerContext cc = this.getCompilerContext();
            ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
            ProviderList apl = new ProviderList();
            try {
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.pushCurrentPrivType(0);
                this.queryExpression = this.queryExpression.bindNonVTITables(dataDictionary, fromList);
                this.queryExpression = this.queryExpression.bindVTITables(fromList);
                this.queryExpression.bindExpressions(fromList);
                this.queryExpression.bindResultColumns(fromList);
                this.queryExpression.bindUntypedNullsToResultColumns(null);
            }
            finally {
                cc.popCurrentPrivType();
                cc.setCurrentAuxiliaryProviderList(prevAPL);
            }
            ResultColumnList qeRCL = this.queryExpression.getResultColumns();
            if (this.resultColumns != null) {
                if (this.resultColumns.size() != qeRCL.visibleSize()) {
                    throw StandardException.newException("42X70", this.getFullName());
                }
                qeRCL.copyResultColumnNames(this.resultColumns);
            }
            SchemaDescriptor sd = this.getSchemaDescriptor(this.tableType != 3);
            int schemaCollationType = sd.getCollationType();
            this.tableElementList = new TableElementList();
            for (int index = 0; index < qeRCL.size(); ++index) {
                ResultColumn rc = (ResultColumn)qeRCL.elementAt(index);
                if (rc.isGenerated()) continue;
                if (rc.isNameGenerated()) {
                    throw StandardException.newException("42909");
                }
                DataTypeDescriptor dtd = rc.getExpression().getTypeServices();
                if (dtd != null && !dtd.isUserCreatableType()) {
                    throw StandardException.newException("42X71", (Object)dtd.getFullSQLTypeName(), (Object)rc.getName());
                }
                if (dtd.getTypeId().isStringTypeId() && dtd.getCollationType() != schemaCollationType) {
                    throw StandardException.newException("42ZA3", (Object)dtd.getCollationName(), (Object)DataTypeDescriptor.getCollationName(schemaCollationType));
                }
                ColumnDefinitionNode column = (ColumnDefinitionNode)this.getNodeFactory().getNode(116, rc.getName(), null, rc.getType(), null, this.getContextManager());
                this.tableElementList.addTableElement(column);
            }
            this.tableElementList.setContextManager(this.getContextManager());
            this.tableElementList.addTableElement(this.queryExpression.getDistributionNode());
        } else {
            this.tableElementList.setCollationTypesOnCharacterStringColumns(this.getSchemaDescriptor(this.tableType != 3));
        }
        this.tableElementList.validate(this, dataDictionary, null);
        if (this.tableElementList.countNumberOfColumns() > 1012) {
            throw StandardException.newException("54011", (Object)String.valueOf(this.tableElementList.countNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
        }
        numPrimaryKeys = this.tableElementList.countConstraints(2);
        if (numPrimaryKeys > 1) {
            throw StandardException.newException("42X90", this.getRelativeName());
        }
        numCheckConstraints = this.tableElementList.countConstraints(4);
        numReferenceConstraints = this.tableElementList.countConstraints(6);
        numUniqueConstraints = this.tableElementList.countConstraints(3);
        if (this.tableType == 3 && (numPrimaryKeys > 0 || numCheckConstraints > 0 || numReferenceConstraints > 0 || numUniqueConstraints > 0)) {
            throw StandardException.newException("42995");
        }
        if (numPrimaryKeys + numReferenceConstraints + numUniqueConstraints > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(numPrimaryKeys + numReferenceConstraints + numUniqueConstraints), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        RegionAttributes<?, ?> attrs = this.getRegionAttributes();
        GfxdPartitionResolver resolver = null;
        GfxdEvictionCriteria evictionCriteria = null;
        if (attrs != null) {
            CustomEvictionAttributes ceAttrs;
            PartitionAttributes pattrs = attrs.getPartitionAttributes();
            if (pattrs != null) {
                resolver = (GfxdPartitionResolver)pattrs.getPartitionResolver();
            }
            if ((ceAttrs = attrs.getCustomEvictionAttributes()) != null) {
                evictionCriteria = (GfxdEvictionCriteria)ceAttrs.getCriteria();
            }
        }
        if (numCheckConstraints > 0 || resolver != null || evictionCriteria != null) {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            FromBaseTable table = (FromBaseTable)this.getNodeFactory().getNode(135, this.getObjectName(), null, null, null, this.getContextManager());
            table.setTableNumber(0);
            fromList.addFromTable(table);
            table.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
            this.tableElementList.appendNewColumnsToRCL(table);
            if (resolver != null) {
                Vector aggregateVector = new Vector();
                resolver.bindExpression(fromList, null, aggregateVector);
                if (aggregateVector.size() > 0) {
                    throw StandardException.newException("42903");
                }
            }
            if (numCheckConstraints > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (evictionCriteria != null) {
                evictionCriteria.bindExpression(fromList, this.lcc);
            }
        }
        if (this.tableType != 3) {
            this.distributionDesc = this.tableElementList.validateAndResolveDistributionPolicy();
        }
        if (resolver != null) {
            resolver.setDistributionDescriptor(this.distributionDesc);
        }
    }

    private void validateWanServerGroups() throws StandardException {
        if (!ServerGroupUtils.isDataStore() || this.distributionDesc == null || this.distributionDesc.getServerGroups().isEmpty()) {
            return;
        }
        Set<String> senderIds = this.getGatewaySenderIds();
        if (senderIds != null && !senderIds.isEmpty()) {
            for (String id : senderIds) {
                TransactionController tc = this.lcc.getTransactionExecute();
                ExecIndexRow keyRow = this.getDataDictionary().getExecutionFactory().getIndexableRow(1);
                keyRow.setColumn(1, new SQLChar(id));
                TabInfoImpl ti = ((DataDictionaryImpl)this.getDataDictionary()).getNonCoreTI(21);
                ExecRow oldRow = ti.getRow(tc, keyRow, 0);
                if (oldRow == null) continue;
                DataValueDescriptor dvd = oldRow.getColumn(3);
                String senderGroups = dvd.getString();
                String tableGroups = "";
                for (String group : this.distributionDesc.getServerGroups()) {
                    if (tableGroups.isEmpty()) {
                        tableGroups = tableGroups.concat(group);
                        continue;
                    }
                    tableGroups = tableGroups.concat("," + group);
                }
                if (!SortedCSVProcedures.groupsIntersection(senderGroups, tableGroups).isEmpty()) continue;
                throw StandardException.newException("Can not attatch a GatewaySender " + id + " to this table. At they should have one common server group. Table's server group are " + tableGroups + " server groups for GatewaySender are " + senderGroups);
            }
        }
    }

    private void validateAsycnEventListenerServerGroups() throws StandardException {
        if (!ServerGroupUtils.isDataStore() || this.distributionDesc == null || this.distributionDesc.getServerGroups().isEmpty()) {
            return;
        }
        Set<String> senderIds = this.getGatewaySenderIds();
        if (senderIds != null && !senderIds.isEmpty()) {
            for (String id : senderIds) {
                TransactionController tc = this.lcc.getTransactionExecute();
                ExecIndexRow keyRow = this.getDataDictionary().getExecutionFactory().getIndexableRow(1);
                keyRow.setColumn(1, new SQLChar(id));
                TabInfoImpl ti = ((DataDictionaryImpl)this.getDataDictionary()).getNonCoreTI(22);
                ExecRow oldRow = ti.getRow(tc, keyRow, 0);
                if (oldRow == null) continue;
                DataValueDescriptor dvd = oldRow.getColumn(3);
                String listenerGropus = dvd.getString();
                String tableGroups = "";
                for (String group : this.distributionDesc.getServerGroups()) {
                    if (tableGroups.isEmpty()) {
                        tableGroups = tableGroups.concat(group);
                        continue;
                    }
                    tableGroups = tableGroups.concat("," + group);
                }
                if (!SortedCSVProcedures.groupsIntersection(listenerGropus, tableGroups).isEmpty()) continue;
                throw StandardException.newException("Can not attatch a AsyncEventListener " + id + " to this table. At they should have one common server group. Table's server group are " + tableGroups + " server groups for AsyncEventListener are " + listenerGropus);
            }
        }
    }

    private RegionAttributes<?, ?> getRegionAttributes() {
        Properties props = null;
        if (this.properties != null) {
            props = this.properties;
        } else {
            if (this.queryExpression == null) {
                return null;
            }
            if (this.queryExpression.getDistributionNode() != null) {
                props = this.queryExpression.getDistributionNode().getTableProperties();
            }
        }
        if (props != null) {
            return (RegionAttributes)props.get("GEMFIRE_REGION_ATTRIBUTES");
        }
        return null;
    }

    private Set<String> getGatewaySenderIds() {
        RegionAttributes attrs;
        Properties props = null;
        if (this.properties != null) {
            props = this.properties;
        } else {
            if (this.queryExpression == null) {
                return null;
            }
            if (this.queryExpression.getDistributionNode() != null) {
                props = this.queryExpression.getDistributionNode().getTableProperties();
            }
        }
        if (props != null && (attrs = (RegionAttributes)props.get("GEMFIRE_REGION_ATTRIBUTES")) != null) {
            Set ids = attrs.getGatewaySenderIds();
            return ids;
        }
        return null;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.getSchemaDescriptor(this.tableType != 3));
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String[] partition_columns;
        PartitionAttributes pattrs;
        TableElementList coldefs = this.tableElementList;
        ColumnInfo[] colInfos = new ColumnInfo[coldefs.countNumberOfColumns()];
        int numConstraints = coldefs.genColumnInfos(colInfos);
        RegionAttributes<?, ?> attrs = this.getRegionAttributes();
        GfxdPartitionResolver resolver = null;
        if (attrs != null && (pattrs = attrs.getPartitionAttributes()) != null && (partition_columns = (resolver = (GfxdPartitionResolver)pattrs.getPartitionResolver()).getColumnNames()) != null && partition_columns.length > 0) {
            for (String c : partition_columns) {
                for (int i = 0; i < colInfos.length; ++i) {
                    if (!c.equalsIgnoreCase(colInfos[i].name) || !colInfos[i].dataType.getTypeId().isJSONTypeId()) continue;
                    throw StandardException.newException("0A000.S", "JSON column '" + c + "' in partition by clause");
                }
            }
        }
        ConstraintConstantAction[] conActions = null;
        SchemaDescriptor sd = this.getSchemaDescriptor(this.tableType != 3);
        if (numConstraints > 0) {
            conActions = new CreateConstraintConstantAction[numConstraints];
            coldefs.genConstraintActions(true, conActions, this.getRelativeName(), sd, this.getDataDictionary());
        }
        if (this.properties == null && this.queryExpression != null) {
            this.properties = this.queryExpression.getDistributionNode().getTableProperties();
        }
        if (this.tableType != 3) {
            this.properties.put("GEMFIREXD_DISTRIBUTION_DESCRIPTOR", this.distributionDesc);
        }
        if (this.queryExpression != null) {
            this.generatedSqlTextForCTAS = this.getSQLTextForCTAS(colInfos);
        }
        boolean table_has_long_column = false;
        int approxLength = 0;
        for (int i = 0; i < colInfos.length; ++i) {
            DataTypeDescriptor dts = colInfos[i].dataType;
            if (dts.getTypeId().isLongConcatableTypeId()) {
                table_has_long_column = true;
                break;
            }
            approxLength += dts.getTypeId().getApproximateLengthInBytes(dts);
        }
        if (!(!table_has_long_column && approxLength <= 4096 || this.properties != null && this.properties.get("gemfirexd.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "gemfirexd.storage.pageSize") != null)) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("gemfirexd.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateTableConstantAction(sd.getSchemaName(), this.getRelativeName(), this.tableType, colInfos, (CreateConstraintConstantAction[])conActions, this.properties, this.lockGranularity, this.onCommitDeleteRows, this.onRollbackDeleteRows, this.generatedSqlTextForCTAS);
    }

    public String getSQLTextForCTAS(ColumnInfo[] colInfos) {
        if (this.sqlText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.sqlText.substring(0, this.textToBeReplacedBegin));
        sb.append("(");
        for (int i = 0; i < colInfos.length; ++i) {
            sb.append(colInfos[i].name);
            sb.append(" ");
            if (colInfos[i].getDefaultInfo() != null) {
                sb.append(colInfos[i].getDefaultInfo().getDefaultText());
            } else {
                sb.append(colInfos[i].getType().toString());
            }
            if (i == colInfos.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        sb.append(this.sqlText.substring(this.textToBeReplacedEnd + 1));
        return sb.toString();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableElementList != null) {
            this.tableElementList.accept(v);
        }
    }
}

