/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.AccessibleByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.InputStreamUtil;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependency;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdAsyncEventListenerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.services.reflect.UpdateLoader;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DDdependableFinder;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.depend.BasicDependencyManager;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public final class JarLoader
extends SecureClassLoader
implements Provider {
    final String[] name;
    private StorageFile installedJar;
    private JarFile jar;
    private boolean isStream;
    private UpdateLoader updateLoader;
    private final HeaderPrintWriter vs;
    private UUID oid;
    private int invalidAction;
    private List deps;

    JarLoader(UpdateLoader updateLoader, String[] name, HeaderPrintWriter vs) {
        block2: {
            this.updateLoader = updateLoader;
            this.name = name;
            this.vs = vs;
            GfxdDataDictionary gfxddd = Misc.getMemStore().getDatabase().getDataDictionary();
            this.oid = gfxddd.getUUIDFactory().createUUID();
            String schemaName = name[0];
            String sqlName = name[1];
            try {
                this.installedJar = updateLoader.getJarReader().getJarFile(schemaName, sqlName);
            }
            catch (StandardException se) {
                if (vs == null) break block2;
                vs.println(MessageService.getTextMessage("C003", this.getJarName(), se));
            }
        }
    }

    void initialize() {
        Exception e;
        if (this.jar != null) {
            return;
        }
        String schemaName = this.name[0];
        String sqlName = this.name[1];
        try {
            if (this.installedJar == null) {
                this.installedJar = this.updateLoader.getJarReader().getJarFile(schemaName, sqlName);
            }
            if (this.installedJar instanceof File) {
                try {
                    this.jar = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new JarFile((File)((Object)JarLoader.this.installedJar));
                        }
                    });
                    if (GemFireXDUtils.TraceApplicationJars) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("JarLoader#initialize Loaded jar sqlName=").append(sqlName).append(" schemaName=").append(schemaName).append(" installedJar=").append(this.installedJar.getClass().getSimpleName());
                        msg.append(" with entries:").append(SanityManager.lineSeparator);
                        Enumeration<JarEntry> jarEntries = this.jar.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry entry = jarEntries.nextElement();
                            msg.append(entry).append(SanityManager.lineSeparator);
                        }
                        SanityManager.DEBUG_PRINT((String)"TraceJars", (String)msg.toString());
                    }
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
                return;
            }
            this.isStream = true;
            if (GemFireXDUtils.TraceApplicationJars) {
                StringBuilder msg = new StringBuilder();
                msg.append("JarLoader#initialize Loaded jar as stream sqlName=").append(sqlName).append(" schemaName=").append(schemaName).append(" installedJar=").append(this.installedJar.getClass().getSimpleName());
                msg.append(" with entries:").append(SanityManager.lineSeparator);
                JarInputStream jarIn = new JarInputStream(this.installedJar.getInputStream());
                JarEntry entry = null;
                while ((entry = jarIn.getNextJarEntry()) != null) {
                    msg.append(entry).append(SanityManager.lineSeparator);
                }
                if (entry == null) {
                    jarIn.close();
                }
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)msg.toString());
            }
            return;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (StandardException se) {
            e = se;
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C003", this.getJarName(), e));
        }
        this.setInvalid();
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (className.startsWith("com.pivotal.gemfirexd.internal.") && !className.startsWith("com.pivotal.gemfirexd.internal.jdbc.") && !className.startsWith("com.pivotal.gemfirexd.internal.vti.")) {
            ClassNotFoundException cnfe = new ClassNotFoundException(className);
            throw cnfe;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.updateLoader == null) {
                throw new ClassNotFoundException(MessageService.getTextMessage("C004", className));
            }
            Class c = this.updateLoader.loadClass(className, resolve);
            if (c == null) {
                throw cnfe;
            }
            return c;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.updateLoader == null) {
            return null;
        }
        return this.updateLoader.getResourceAsStream(name);
    }

    final String getJarName() {
        return IdUtil.mkQualifiedName(this.name);
    }

    final String getJarNameAsString() {
        return this.name[0] + "." + this.name[1];
    }

    public Class loadClassData(String className, String jvmClassName, boolean resolve) {
        if (this.updateLoader == null) {
            return null;
        }
        try {
            if (this.jar != null) {
                return this.loadClassDataFromJar(className, jvmClassName, resolve);
            }
            if (this.isStream) {
                return this.loadClassData(this.installedJar.getInputStream(), className, jvmClassName, resolve);
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (IOException ioe) {
            if (this.vs != null) {
                this.vs.println(MessageService.getTextMessage("C007", className, this.getJarName(), ioe));
            }
            return null;
        }
    }

    InputStream getStream(String name) {
        if (this.updateLoader == null) {
            return null;
        }
        if (this.jar != null) {
            return this.getRawStream(name);
        }
        if (this.isStream) {
            try {
                return this.getRawStream(this.installedJar.getInputStream(), name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassDataFromJar(String className, String jvmClassName, boolean resolve) throws IOException {
        JarEntry e = this.jar.getJarEntry(jvmClassName);
        if (e == null) {
            return null;
        }
        try (InputStream in = this.jar.getInputStream(e);){
            Class clazz = this.loadClassData(e, in, className, resolve);
            return clazz;
        }
    }

    private Class loadClassData(InputStream in, String className, String jvmClassName, boolean resolve) throws IOException {
        JarEntry e;
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("JarLoader#loadClassData Attempting to load class " + className + " jvmClassName " + jvmClassName + " name " + Arrays.toString(this.name)));
        }
        JarInputStream jarIn = new JarInputStream(in);
        do {
            if ((e = jarIn.getNextJarEntry()) != null) continue;
            jarIn.close();
            return null;
        } while (!e.getName().equals(jvmClassName));
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("JarLoader#loadClassData found jar entry " + e.getName() + " attempting to load classData "));
        }
        Class c = this.loadClassData(e, jarIn, className, resolve);
        jarIn.close();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassData(JarEntry e, InputStream in, String className, boolean resolve) throws IOException {
        byte[] data = this.readData(e, in, className);
        Object[] signers = this.getSigners(className, e);
        UpdateLoader updateLoader = this.updateLoader;
        synchronized (updateLoader) {
            Class<?> c = this.updateLoader.checkLoaded(className, resolve);
            if (c == null) {
                try {
                    c = this.defineClass(className, data, 0, data.length, (CodeSource)null);
                    if (signers != null) {
                        this.setSigners(c, signers);
                    }
                    if (resolve) {
                        if (GemFireXDUtils.TraceApplicationJars) {
                            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("JarLoader#loadClassData resolving defined class " + c.getClass().getCanonicalName()));
                        }
                        this.resolveClass(c);
                    }
                }
                catch (Throwable t) {
                    if (GemFireXDUtils.TraceApplicationJars) {
                        SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("JarLoader#loadClassData error while defining or resolving class from stream for " + className), (Throwable)t);
                    }
                    throw new IOException("JarLoader#loadClassData error while defining or resolving class from stream for " + className, t);
                }
            }
            return c;
        }
    }

    Class checkLoaded(String className, boolean resolve) {
        if (this.updateLoader == null) {
            return null;
        }
        Class<?> c = this.findLoadedClass(className);
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    void setInvalid() {
        this.updateLoader = null;
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jar = null;
        }
        this.isStream = false;
    }

    boolean isInvalid() {
        return this.updateLoader == null;
    }

    private InputStream getRawStream(String name) {
        try {
            JarEntry e = this.jar.getJarEntry(name);
            if (e == null) {
                return null;
            }
            return this.jar.getInputStream(e);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getRawStream(InputStream in, String name) {
        JarInputStream jarIn = null;
        try {
            JarEntry e;
            jarIn = new JarInputStream(in);
            while ((e = jarIn.getNextJarEntry()) != null) {
                if (!e.getName().equals(name)) continue;
                int size = (int)e.getSize();
                if (size == -1) {
                    size = 8192;
                }
                InputStream inputStream = AccessibleByteArrayOutputStream.copyStream(jarIn, size);
                return inputStream;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarIn != null) {
                try {
                    jarIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    byte[] readData(JarEntry ze, InputStream in, String className) throws IOException {
        try {
            int r;
            int size = (int)ze.getSize();
            if (size != -1) {
                byte[] data = new byte[size];
                InputStreamUtil.readFully((InputStream)in, (byte[])data, (int)0, (int)size);
                return data;
            }
            byte[] data = new byte[1024];
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            while ((r = in.read(data)) != -1) {
                os.write(data, 0, r);
            }
            data = os.toByteArray();
            return data;
        }
        catch (SecurityException se) {
            throw this.handleException(se, className);
        }
    }

    private Certificate[] getSigners(String className, JarEntry je) throws IOException {
        try {
            Certificate[] list = je.getCertificates();
            if (list == null || list.length == 0) {
                return null;
            }
            for (int i = 0; i < list.length; ++i) {
                if (!(list[i] instanceof X509Certificate)) {
                    String msg = MessageService.getTextMessage("C001", className, this.getJarName());
                    throw new SecurityException(msg);
                }
                X509Certificate cert = (X509Certificate)list[i];
                cert.checkValidity();
            }
            return list;
        }
        catch (GeneralSecurityException gse) {
            throw this.handleException(gse, className);
        }
    }

    private SecurityException handleException(Exception e, String className) {
        String msg = MessageService.getTextMessage("C002", className, this.getJarName(), e.getLocalizedMessage());
        return new SecurityException(msg);
    }

    public String toString() {
        return this.getJarName() + ":" + super.toString();
    }

    @Override
    public DependableFinder getDependableFinder() {
        return new DDdependableFinder(139);
    }

    @Override
    public String getObjectName() {
        return null;
    }

    @Override
    public UUID getObjectID() {
        return this.oid;
    }

    @Override
    public boolean isDescriptorPersistent() {
        return true;
    }

    @Override
    public String getClassType() {
        return null;
    }

    public void invalidateDependents(int action) {
        DependencyManager dd = Misc.getMemStore().getDatabase().getDataDictionary().getDependencyManager();
        try {
            if (action == 17) {
                List dependencies = ((BasicDependencyManager)dd).getDependents(this);
                for (Object o : dependencies) {
                    Dependent d = ((Dependency)o).getDependent();
                    if (!(d instanceof GfxdAsyncEventListenerDescriptor)) continue;
                    throw StandardException.newException("X0Y25.S", "drop jar", (Object)this.getJarNameAsString(), (Object)((GfxdAsyncEventListenerDescriptor)d).getSenderId(), (Object)"");
                }
            }
            LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
            this.invalidAction = action;
            this.deps = dd.invalidateFor(this, action, lcc);
        }
        catch (StandardException e) {
            throw new GemFireXDRuntimeException(e);
        }
    }

    public void refreshDependents() throws StandardException {
        if (this.invalidAction != 18) {
            return;
        }
        if (this.deps != null) {
            for (Object o : this.deps) {
                Dependent d = ((Dependency)o).getDependent();
                d.makeInvalid(this.invalidAction, null);
            }
        }
    }
}

