/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

final class ClobAsciiStream
extends OutputStream {
    private final Writer writer;
    private final char[] buffer = new char[1024];

    ClobAsciiStream(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(b & 0xFF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int clen = Math.min(len, this.buffer.length);
            for (int i = 0; i < clen; ++i) {
                this.buffer[i] = (char)(b[off + i] & 0xFF);
            }
            this.writer.write(this.buffer, 0, clen);
            off += clen;
            len -= clen;
        }
    }
}

