/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.ConsistencyToken;
import com.pivotal.gemfirexd.internal.impl.drda.FdocaConstants;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

final class DRDAResultSet {
    protected static final int NOT_OPENED = 1;
    protected static final int SUSPENDED = 2;
    public static final int QRYCLSIMP_DEFAULT = 2;
    boolean explicitlyClosed = false;
    int state = 1;
    protected boolean hasdata = true;
    protected int[] rsLens;
    private int[] rsDRDATypes;
    private int[] rsPrecision;
    private int[] rsScale;
    protected int[] outovr_drdaType;
    protected int withHoldCursor;
    protected int scrollType = 1003;
    protected int concurType;
    protected long rowCount;
    private ResultSet rs;
    protected int blksize;
    protected int maxblkext;
    protected int outovropt;
    protected int qryclsimp = 2;
    protected boolean qryrelscr;
    protected long qryrownbr;
    protected boolean qryrfrtbl;
    protected int qryscrorn;
    protected boolean qryrowsns;
    protected boolean qryblkrst;
    protected boolean qryrtndta;
    protected int qryrowset;
    private int qryprctyp;
    private boolean gotPrctyp;
    protected int rtnextdta;
    protected int nbrrow;
    protected byte[] rslsetflg;
    private ArrayList extDtaObjects;
    private ArrayList rsExtPositions;
    protected ConsistencyToken pkgcnstkn;
    private byte[] splitQRYDTA;

    DRDAResultSet() {
    }

    void setResultSet(ResultSet value) throws SQLException {
        this.rs = value;
        this.gotPrctyp = false;
        int numCols = this.rs.getMetaData().getColumnCount();
        this.rsDRDATypes = new int[numCols];
        this.explicitlyClosed = false;
    }

    protected void setPkgcnstkn(ConsistencyToken pkgcnstkn) {
        this.pkgcnstkn = pkgcnstkn;
    }

    protected ResultSet getResultSet() {
        return this.rs;
    }

    public void setSplitQRYDTA(byte[] data) {
        this.splitQRYDTA = data;
    }

    public byte[] getSplitQRYDTA() {
        return this.splitQRYDTA;
    }

    protected int[] getRsDRDATypes() {
        if (this.outovr_drdaType != null) {
            return this.outovr_drdaType;
        }
        return this.rsDRDATypes;
    }

    protected void setRsPrecision(int index, int precision) {
        if (this.rsPrecision == null) {
            this.rsPrecision = new int[this.rsDRDATypes.length];
        }
        this.rsPrecision[index - 1] = precision;
    }

    protected int getRsPrecision(int index) {
        if (this.rsPrecision == null) {
            return 0;
        }
        return this.rsPrecision[index - 1];
    }

    protected void setRsScale(int index, int scale) {
        if (this.rsScale == null) {
            this.rsScale = new int[this.rsDRDATypes.length];
        }
        this.rsScale[index - 1] = scale;
    }

    protected int getRsScale(int index) {
        if (this.rsScale == null) {
            return 0;
        }
        return this.rsScale[index - 1];
    }

    protected void setRsDRDAType(int index, int type) {
        this.rsDRDATypes[index - 1] = type;
    }

    protected int getRsDRDAType(int index) {
        if (this.outovr_drdaType != null && this.outovr_drdaType[index - 1] != 0) {
            return this.outovr_drdaType[index - 1];
        }
        return this.rsDRDATypes[index - 1];
    }

    @SuppressWarnings(value={"UWF_NULL_FIELD"})
    protected int getRsLen(int index) {
        return this.rsLens[index - 1];
    }

    protected void addExtDtaObject(Object o, int jdbcIndex) {
        if (this.extDtaObjects == null) {
            this.extDtaObjects = new ArrayList();
        }
        this.extDtaObjects.add(o);
        if (this.rsExtPositions == null) {
            this.rsExtPositions = new ArrayList();
        }
        this.rsExtPositions.add(jdbcIndex - 1);
    }

    protected void clearExtDtaObjects() {
        if (this.extDtaObjects != null) {
            this.extDtaObjects.clear();
        }
        if (this.rsExtPositions != null) {
            this.rsExtPositions.clear();
        }
    }

    protected boolean isExtDtaValueNullable(int index) {
        if (this.rsExtPositions == null || this.rsExtPositions.get(index) == null) {
            return false;
        }
        int colnum = (Integer)this.rsExtPositions.get(index) + 1;
        if (this.rsDRDATypes == null) {
            return true;
        }
        return FdocaConstants.isNullable(this.getRsDRDAType(colnum));
    }

    protected ArrayList getExtDtaObjects() {
        return this.extDtaObjects;
    }

    protected void setExtDtaObjects(ArrayList a) {
        this.extDtaObjects = a;
    }

    protected void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        this.rs = null;
        this.outovr_drdaType = null;
        this.rsLens = null;
        this.rsDRDATypes = null;
        this.rsPrecision = null;
        this.rsScale = null;
        this.extDtaObjects = null;
        this.splitQRYDTA = null;
        this.rsExtPositions = null;
    }

    protected void reset() {
        this.explicitlyClosed = false;
        this.state = 1;
        this.hasdata = true;
        this.rsLens = null;
        this.rsDRDATypes = null;
        this.rsPrecision = null;
        this.rsScale = null;
        this.outovr_drdaType = null;
        this.withHoldCursor = 0;
        this.scrollType = 1003;
        this.concurType = 0;
        this.rowCount = 0L;
        this.rs = null;
        this.blksize = 0;
        this.maxblkext = 0;
        this.outovropt = 0;
        this.qryclsimp = 2;
        this.qryrelscr = false;
        this.qryrownbr = 0L;
        this.qryrfrtbl = false;
        this.qryscrorn = 0;
        this.qryrowsns = false;
        this.qryblkrst = false;
        this.qryrtndta = false;
        this.qryrowset = 0;
        this.qryprctyp = 0;
        this.gotPrctyp = false;
        this.rtnextdta = 0;
        this.nbrrow = 0;
        this.rslsetflg = null;
        this.extDtaObjects = null;
        this.rsExtPositions = null;
        this.pkgcnstkn = null;
        this.splitQRYDTA = null;
    }

    protected void CLSQRY() {
        this.explicitlyClosed = true;
    }

    protected boolean wasExplicitlyClosed() {
        return this.explicitlyClosed;
    }

    protected boolean hasLobColumns() throws SQLException {
        ResultSetMetaData rsmd = this.rs.getMetaData();
        int ncols = rsmd.getColumnCount();
        for (int i = 1; i <= ncols; ++i) {
            int type = rsmd.getColumnType(i);
            if (type != 2004 && type != 2005 && type != 4001) continue;
            return true;
        }
        return false;
    }

    public String getResultSetCursorName() throws SQLException {
        if (this.rs != null) {
            return this.rs.getCursorName();
        }
        return null;
    }

    protected int getQryprctyp() throws SQLException {
        if (!this.gotPrctyp && this.qryprctyp == 9239) {
            this.gotPrctyp = true;
            if (this.rs == null || this.rs instanceof EmbedResultSet && ((EmbedResultSet)this.rs).isForUpdate() || this.hasLobColumns()) {
                this.qryprctyp = 9240;
            }
        }
        return this.qryprctyp;
    }

    protected void setQryprctyp(int qryprctyp) {
        this.qryprctyp = qryprctyp;
    }

    protected boolean isClosed() {
        return this.state == 1;
    }

    protected void suspend() {
        this.state = 2;
    }

    protected String toDebugString(String indent) {
        String s = indent + "***** DRDASResultSet toDebugString ******\n";
        s = s + indent + "State:" + this.getStateString(this.state) + "\n";
        s = s + indent + "pkgcnstkn: {" + this.pkgcnstkn + "}\n";
        s = s + indent + "cursor Name: ";
        String cursorName = null;
        try {
            if (this.rs != null) {
                cursorName = this.rs.getCursorName();
            }
        }
        catch (SQLException se) {
            cursorName = "invalid rs";
        }
        s = s + indent + cursorName + "\n";
        return s;
    }

    private String getStateString(int i) {
        switch (i) {
            case 1: {
                return "NOT_OPENED";
            }
            case 2: {
                return "SUSPENDED";
            }
        }
        return "UNKNOWN_STATE";
    }

    protected void setOPNQRYOptions(int blksize, int qryblkctl, int maxblkext, int outovropt, int qryrowset, int qryclsimpl) {
        this.blksize = blksize;
        this.setQryprctyp(qryblkctl);
        this.maxblkext = maxblkext;
        this.outovropt = outovropt;
        this.qryrowset = qryrowset;
        this.qryclsimp = qryclsimpl == 0 ? 2 : qryclsimpl;
        this.qryrtndta = true;
        this.qryscrorn = 1;
        this.qryrownbr = 1L;
    }
}

