/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeParser;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class SQLTime
extends DataType
implements DateTimeDataValue {
    private int encodedTime;
    private int encodedTimeFraction;
    private String valueString;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTime.class);
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_OR_END = new char[]{'.', '\u0000'};
    static final char JIS_SEPARATOR = ':';
    private static final char[] US_OR_JIS_MINUTE_END = new char[]{':', ' ', '\u0000'};
    private static final char[] ANY_SEPARATOR = new char[]{'.', ':', ' '};
    private static final String[] AM_PM = new String[]{"AM", "PM"};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};
    public static final int TIME_CHARS = 8;

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.valueString);
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            if (this.valueString == null) {
                this.valueString = SQLTime.encodedTimeToString(this.encodedTime);
            }
            return this.valueString;
        }
        if (this.valueString != null) {
            SanityManager.THROWASSERT((String)("valueString expected to be null, not " + this.valueString));
        }
        return null;
    }

    @Override
    public final int getEncodedTime() {
        return this.encodedTime;
    }

    @Override
    public final int getEncodedDate() {
        return 0;
    }

    @Override
    public final int getNanos() {
        return 0;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        if (cal == null) {
            cal = ClientSharedData.getDefaultCleanCalendar();
        } else {
            cal.clear();
        }
        cal.setTimeInMillis(System.currentTimeMillis());
        SQLTime.setTimeInCalendar(cal, this.encodedTime);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public Object getObject() {
        return this.getTime(null);
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getTypeName() {
        return "TIME";
    }

    @Override
    public int getTypeFormatId() {
        return 299;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        out.writeInt(this.encodedTime);
        out.writeInt(this.encodedTimeFraction);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.encodedTime = in.readInt();
        this.encodedTimeFraction = in.readInt();
        this.valueString = null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.encodedTime = in.readInt();
        this.encodedTimeFraction = in.readInt();
        this.valueString = null;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLTime(this.encodedTime, this.encodedTimeFraction);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTime();
    }

    @Override
    public void restoreToNull() {
        this.encodedTime = -1;
        this.encodedTimeFraction = 0;
        this.valueString = null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.restoreToNull();
        this.encodedTime = this.computeEncodedTime(resultSet.getTime(colNumber));
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        int otherEncodedTime = 0;
        otherEncodedTime = other instanceof SQLTime ? ((SQLTime)other).encodedTime : this.computeEncodedTime(other.getTime(null));
        int comparison = this.encodedTime < otherEncodedTime ? -1 : (this.encodedTime > otherEncodedTime ? 1 : 0);
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public SQLTime() {
        this.encodedTime = -1;
    }

    public SQLTime(Time value) throws StandardException {
        this.parseTime(value);
    }

    private void parseTime(java.util.Date value) throws StandardException {
        this.encodedTime = this.computeEncodedTime(value);
    }

    private SQLTime(int encodedTime, int encodedTimeFraction) {
        this.encodedTime = encodedTime;
        this.encodedTimeFraction = encodedTimeFraction;
    }

    public SQLTime(String timeStr, boolean isJdbcEscape, LocaleFinder localeFinder) throws StandardException {
        this.parseTime(timeStr, isJdbcEscape, localeFinder, null);
    }

    public SQLTime(String timeStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        this.parseTime(timeStr, isJdbcEscape, localeFinder, cal);
    }

    private void parseTime(String timeStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        boolean validSyntax = true;
        DateTimeParser parser = new DateTimeParser(timeStr);
        StandardException thrownSE = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int amPm = -1;
        try {
            if (parser.nextSeparator() == '-') {
                this.encodedTime = SQLTimestamp.parseDateOrTimestamp(parser, true)[1];
                this.valueString = parser.getTrimmedString();
                return;
            }
            hour = parser.parseInt(2, true, ANY_SEPARATOR, false);
            block3 : switch (parser.getCurrentSeparator()) {
                case '.': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    minute = parser.parseInt(2, false, IBM_EUR_SEPARATOR_OR_END, false);
                    if (parser.getCurrentSeparator() == '.') {
                        second = parser.parseInt(2, false, END_OF_STRING, false);
                    }
                    break;
                }
                case ':': {
                    minute = parser.parseInt(2, false, US_OR_JIS_MINUTE_END, false);
                    switch (parser.getCurrentSeparator()) {
                        case ' ': {
                            if (isJdbcEscape) {
                                validSyntax = false;
                                break block3;
                            }
                            amPm = parser.parseChoice(AM_PM);
                            parser.checkEnd();
                            break block3;
                        }
                        case ':': {
                            second = parser.parseInt(2, false, END_OF_STRING, false);
                        }
                    }
                    break;
                }
                case ' ': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    amPm = parser.parseChoice(AM_PM);
                    break;
                }
                default: {
                    validSyntax = false;
                    break;
                }
            }
        }
        catch (StandardException se) {
            validSyntax = false;
            thrownSE = se;
        }
        if (validSyntax) {
            if (amPm == 0) {
                if (hour == 12) {
                    hour = minute == 0 && second == 0 ? 24 : 0;
                } else if (hour > 12) {
                    throw StandardException.newException("22007.S.180", timeStr);
                }
            } else if (amPm == 1) {
                if (hour < 12) {
                    hour += 12;
                } else if (hour > 12) {
                    throw StandardException.newException("22007.S.180", timeStr);
                }
            }
            this.valueString = parser.checkEnd();
            this.encodedTime = SQLTime.computeEncodedTime(hour, minute, second);
        } else {
            timeStr = StringUtil.trimTrailing(timeStr);
            DateFormat timeFormat = null;
            timeFormat = localeFinder == null ? DateFormat.getTimeInstance() : (cal == null ? localeFinder.getTimeFormat() : (DateFormat)localeFinder.getTimeFormat().clone());
            if (cal != null) {
                timeFormat.setCalendar(cal);
            }
            try {
                this.encodedTime = SQLTime.computeEncodedTime(timeFormat.parse(timeStr), cal);
            }
            catch (ParseException pe) {
                try {
                    this.encodedTime = SQLTimestamp.parseLocalTimestamp(timeStr, localeFinder, cal)[1];
                }
                catch (ParseException pe2) {
                    if (thrownSE != null) {
                        throw thrownSE;
                    }
                    throw StandardException.newException("22007.S.181", timeStr);
                }
            }
            this.valueString = timeStr;
        }
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Time)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLTime) {
            this.restoreToNull();
            SQLTime tvst = (SQLTime)theValue;
            this.encodedTime = tvst.encodedTime;
            this.encodedTimeFraction = tvst.encodedTimeFraction;
        } else {
            GregorianCalendar cal = ClientSharedData.getDefaultCleanCalendar();
            this.setValue(theValue.getTime(cal), (Calendar)cal);
        }
    }

    @Override
    public void setValue(Time value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedTime = SQLTime.computeEncodedTime(value, cal);
    }

    @Override
    public void setValue(Timestamp value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedTime = SQLTime.computeEncodedTime(value, cal);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.restoreToNull();
        if (theValue != null) {
            this.parseTime(theValue, false, Misc.getMemStore().getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getYear", (Object)"Time");
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getMonth", (Object)"Time");
    }

    @Override
    public NumberDataValue getDate(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getDate", (Object)"Time");
    }

    @Override
    public NumberDataValue getHours(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getSecond(this.encodedTime), result);
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTime(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedTime + this.encodedTimeFraction + 1;
    }

    @Override
    public int typePrecedence() {
        return 120;
    }

    @Override
    public final boolean isNull() {
        return this.encodedTime == -1;
    }

    @Override
    public Time getTime(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        return SQLTime.getTime(cal, this.encodedTime, 0);
    }

    public static void setTimeInCalendar(Calendar cal, int encodedTime) {
        cal.set(11, SQLTime.getHour(encodedTime));
        cal.set(12, SQLTime.getMinute(encodedTime));
        cal.set(13, SQLTime.getSecond(encodedTime));
    }

    public static Time getTime(Calendar cal, int encodedTime, int nanos) {
        if (cal == null) {
            cal = ClientSharedData.getDefaultCalendar();
        }
        cal.clear();
        cal.set(1970, 0, 1);
        SQLTime.setTimeInCalendar(cal, encodedTime);
        cal.set(14, nanos / 1000000);
        return new Time(cal.getTimeInMillis());
    }

    protected static int getHour(int encodedTime) {
        return encodedTime >>> 16 & 0xFF;
    }

    protected static int getMinute(int encodedTime) {
        return encodedTime >>> 8 & 0xFF;
    }

    protected static int getSecond(int encodedTime) {
        return encodedTime & 0xFF;
    }

    static int computeEncodedTime(Calendar cal) throws StandardException {
        return SQLTime.computeEncodedTime(cal.get(11), cal.get(12), cal.get(13));
    }

    public static int computeEncodedTime(int hour, int minute, int second) throws StandardException {
        if (hour == 24) {
            if (minute != 0 || second != 0) {
                throw StandardException.newException("22007.S.180", "Hour 24 but minute " + minute + " or second " + second + " is not zero");
            }
        } else if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
            throw StandardException.newException("22007.S.180", "Hour = " + hour + " Minute = " + minute + " Second =" + second);
        }
        return (hour << 16) + (minute << 8) + second;
    }

    static void timeToString(int hour, int minute, int second, StringBuilder sb) {
        String hourStr = Integer.toString(hour);
        String minStr = Integer.toString(minute);
        String secondStr = Integer.toString(second);
        if (hourStr.length() == 1) {
            sb.append("0");
        }
        sb.append(hourStr);
        sb.append(':');
        if (minStr.length() == 1) {
            sb.append("0");
        }
        sb.append(minStr);
        sb.append(':');
        if (secondStr.length() == 1) {
            sb.append("0");
        }
        sb.append(secondStr);
    }

    protected static String encodedTimeToString(int encodedTime) {
        StringBuilder vstr = new StringBuilder();
        SQLTime.timeToString(SQLTime.getHour(encodedTime), SQLTime.getMinute(encodedTime), SQLTime.getSecond(encodedTime), vstr);
        return vstr.toString();
    }

    @Override
    protected String getNationalString(LocaleFinder localeFinder) throws StandardException {
        if (this.isNull()) {
            return this.getString();
        }
        return localeFinder.getTimeFormat().format(this.getTime(null));
    }

    private int computeEncodedTime(java.util.Date value) throws StandardException {
        return SQLTime.computeEncodedTime(value, null);
    }

    static int computeEncodedTime(java.util.Date value, Calendar currentCal) throws StandardException {
        if (value == null) {
            return -1;
        }
        if (currentCal == null) {
            currentCal = ClientSharedData.getDefaultCleanCalendar();
        }
        currentCal.setTime(value);
        return SQLTime.computeEncodedTime(currentCal);
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setTime(position, this.getTime(null));
    }

    @Override
    public DateTimeDataValue timestampAdd(int intervalType, NumberDataValue intervalCount, Date currentDate, DateTimeDataValue resultHolder) throws StandardException {
        return this.toTimestamp(currentDate).timestampAdd(intervalType, intervalCount, currentDate, resultHolder);
    }

    private SQLTimestamp toTimestamp(Date currentDate) throws StandardException {
        return new SQLTimestamp(SQLDate.computeEncodedDate(currentDate, null), this.getEncodedTime(), 0);
    }

    @Override
    public NumberDataValue timestampDiff(int intervalType, DateTimeDataValue time1, Date currentDate, NumberDataValue resultHolder) throws StandardException {
        return this.toTimestamp(currentDate).timestampDiff(intervalType, time1, currentDate, resultHolder);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            this.toDataForOptimizedResultHolder(out);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.encodedTime = dis.readInt();
        this.encodedTimeFraction = dis.readInt();
        this.valueString = null;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeInt(this.encodedTime);
        dos.writeInt(this.encodedTimeFraction);
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        int bytesWritten = 0;
        assert ((bytesWritten += RowFormatter.writeInt(outBytes, this.encodedTime, offset)) == 4);
        bytesWritten += RowFormatter.writeInt(outBytes, this.encodedTimeFraction, offset + bytesWritten);
        assert (bytesWritten == 8);
        return bytesWritten;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        this.valueString = null;
        this.encodedTime = RowFormatter.readInt(inBytes, offset);
        this.encodedTimeFraction = RowFormatter.readInt(inBytes, offset += 4);
        assert (columnWidth == 8);
        return 8;
    }

    @Override
    public int readBytes(UnsafeWrapper unsafe, long memOffset, int columnWidth, ByteSource bs) {
        this.valueString = null;
        this.encodedTime = RowFormatter.readInt(unsafe, memOffset);
        this.encodedTimeFraction = RowFormatter.readInt(unsafe, memOffset += 4L);
        assert (columnWidth == 8);
        return 8;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        int typeId = this.getTypeFormatId();
        hash = ResolverUtils.addIntToBucketHash((int)this.encodedTime, (int)hash, (int)typeId);
        return ResolverUtils.addIntToBucketHash((int)this.encodedTimeFraction, (int)hash, (int)typeId);
    }

    static final Time getAsTime(byte[] bytes, int offset, Calendar cal) {
        int encodedTime = RowFormatter.readInt(bytes, offset);
        if (encodedTime == -1) {
            return null;
        }
        int encodedTimeFraction = RowFormatter.readInt(bytes, offset += 4);
        return SQLTime.getTime(cal, encodedTime, encodedTimeFraction);
    }

    static final Time getAsTime(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedTime = RowFormatter.readInt(unsafe, memOffset);
        if (encodedTime == -1) {
            return null;
        }
        int encodedTimeFraction = RowFormatter.readInt(unsafe, memOffset += 4L);
        return SQLTime.getTime(cal, encodedTime, encodedTimeFraction);
    }

    static final Timestamp getAsTimestamp(byte[] bytes, int offset, Calendar cal) {
        int encodedTime = RowFormatter.readInt(bytes, offset);
        if (encodedTime == -1) {
            return null;
        }
        int encodedTimeFraction = RowFormatter.readInt(bytes, offset += 4);
        SQLTime.setTimeInCalendar(cal, encodedTime);
        cal.set(14, encodedTimeFraction / 1000000);
        return new Timestamp(cal.getTimeInMillis());
    }

    static final Timestamp getAsTimestamp(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedTime = RowFormatter.readInt(unsafe, memOffset);
        if (encodedTime == -1) {
            return null;
        }
        int encodedTimeFraction = RowFormatter.readInt(unsafe, memOffset += 4L);
        SQLTime.setTimeInCalendar(cal, encodedTime);
        cal.set(14, encodedTimeFraction / 1000000);
        return new Timestamp(cal.getTimeInMillis());
    }

    static String getAsString(byte[] inBytes, int offset) {
        int encodedTime = RowFormatter.readInt(inBytes, offset);
        if (encodedTime == -1) {
            return null;
        }
        char[] str = new char[8];
        SharedUtils.dateTimeToString((char[])str, (int)0, (int)-1, (int)-1, (int)-1, (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)-1, (int)-1, (boolean)false);
        return ClientSharedUtils.getJdkHelper().newWrappedString(str, 0, 8);
    }

    static String getAsString(UnsafeWrapper unsafe, long memOffset) {
        int encodedTime = RowFormatter.readInt(unsafe, memOffset);
        if (encodedTime == -1) {
            return null;
        }
        char[] str = new char[8];
        SharedUtils.dateTimeToString((char[])str, (int)0, (int)-1, (int)-1, (int)-1, (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)-1, (int)-1, (boolean)false);
        return ClientSharedUtils.getJdkHelper().newWrappedString(str, 0, 8);
    }

    static void writeAsString(byte[] inBytes, int offset, ByteArrayDataOutput buffer) {
        int encodedTime = RowFormatter.readInt(inBytes, offset);
        if (encodedTime == -1) {
            return;
        }
        int bufferPos = buffer.ensureCapacity(8, buffer.position());
        SharedUtils.dateTimeToChars((byte[])buffer.getData(), (int)bufferPos, (int)-1, (int)-1, (int)-1, (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)-1, (int)-1, (boolean)false);
        buffer.advance(8);
    }

    static void writeAsString(UnsafeWrapper unsafe, long memOffset, ByteArrayDataOutput buffer) {
        int encodedTime = RowFormatter.readInt(unsafe, memOffset);
        if (encodedTime == -1) {
            return;
        }
        int bufferPos = buffer.ensureCapacity(8, buffer.position());
        SharedUtils.dateTimeToChars((byte[])buffer.getData(), (int)bufferPos, (int)-1, (int)-1, (int)-1, (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)-1, (int)-1, (boolean)false);
        buffer.advance(8);
    }

    @Override
    public byte getTypeId() {
        return 68;
    }
}

