/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.tools.i18n;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.shared.common.StopWatch;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class PagedLocalizedOutput
extends LocalizedOutput {
    private final InputStream in;
    private final int terminalWidth;
    private final int terminalHeight;
    private final String continuePrompt;
    private final StopWatch timer;
    private char[] cbuf;
    private static final int BUFSIZE = 1024;
    private int currentWidth;
    private int currentLines;

    public PagedLocalizedOutput(OutputStream o, InputStream in, int terminalWidth, int terminalHeight, String continuePrompt, StopWatch timer) {
        super(o);
        this.in = in;
        this.terminalWidth = terminalWidth - 1;
        this.terminalHeight = terminalHeight - 1;
        this.continuePrompt = continuePrompt;
        this.timer = timer;
    }

    public PagedLocalizedOutput(OutputStream o, String enc, InputStream in, int terminalWidth, int terminalHeight, String continuePrompt, StopWatch timer) throws UnsupportedEncodingException {
        super(o, enc);
        this.in = in;
        this.terminalWidth = terminalWidth - 1;
        this.terminalHeight = terminalHeight - 1;
        this.continuePrompt = continuePrompt;
        this.timer = timer;
    }

    public PagedLocalizedOutput(Writer writer, InputStream in, int terminalWidth, int terminalHeight, String continuePrompt, StopWatch timer) {
        super(writer);
        this.in = in;
        this.terminalWidth = terminalWidth - 1;
        this.terminalHeight = terminalHeight - 1;
        this.continuePrompt = continuePrompt;
        this.timer = timer;
    }

    @Override
    public void write(String s, int off, int len) {
        if (this.cbuf == null) {
            this.cbuf = new char[1024 > len ? 1024 : len];
        } else if (this.cbuf.length < len) {
            this.cbuf = new char[len];
        }
        s.getChars(off, off + len, this.cbuf, 0);
        this.checkPage(this.cbuf, 0, len);
        super.write(this.cbuf, 0, len);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.checkPage(buf, off, len);
        super.write(buf, off, len);
    }

    @Override
    public void println() {
        super.println();
        ++this.currentLines;
        if (this.currentLines >= this.terminalHeight) {
            if (this.waitForPage()) {
                throw new IllegalStateException("user ending output");
            }
            this.currentLines = 0;
        }
        this.currentWidth = 0;
    }

    private void checkPage(char[] buf, int off, int len) throws IllegalStateException {
        int lineWidth = this.currentWidth;
        int newLines = 0;
        for (int index = off; index < off + len; ++index) {
            if (buf[index] != '\n' && ++lineWidth < this.terminalWidth) continue;
            lineWidth = 0;
            if (this.currentLines + ++newLines < this.terminalHeight) continue;
            if (this.waitForPage()) {
                throw new IllegalStateException("user ending output");
            }
            this.currentLines = newLines;
            newLines = 0;
        }
        this.currentLines += newLines;
        this.currentWidth = lineWidth;
    }

    private boolean waitForPage() {
        if (this.timer != null) {
            this.timer.stop();
        }
        super.write(this.continuePrompt, 0, this.continuePrompt.length());
        super.flush();
        String chars = ClientSharedUtils.getJdkHelper().readChars(this.in, false);
        super.println();
        if (chars != null && chars.length() > 0 && (chars.charAt(0) == 'q' || chars.charAt(0) == 'Q')) {
            super.flush();
            if (this.timer != null) {
                this.timer.start();
            }
            return true;
        }
        if (this.timer != null) {
            this.timer.start();
        }
        return false;
    }
}

