/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.UniqueTupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;

public final class ConglomerateDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider {
    private long conglomerateNumber;
    private String name;
    private transient String[] columnNames;
    private final boolean indexable;
    private final boolean forConstraint;
    private final IndexRowGenerator indexRowGenerator;
    private final UUID uuid;
    private final UUID tableID;
    private final UUID schemaID;

    ConglomerateDescriptor(DataDictionary dataDictionary, long conglomerateNumber, String name, boolean indexable, IndexRowGenerator indexRowGenerator, boolean forConstraint, UUID uuid, UUID tableID, UUID schemaID) {
        super(dataDictionary);
        this.conglomerateNumber = conglomerateNumber;
        this.name = name;
        this.indexable = indexable;
        this.indexRowGenerator = indexRowGenerator;
        this.forConstraint = forConstraint;
        if (uuid == null) {
            UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
            uuid = uuidFactory.createUUID();
        }
        this.uuid = uuid;
        this.tableID = tableID;
        this.schemaID = schemaID;
    }

    public long getConglomerateNumber() {
        return this.conglomerateNumber;
    }

    public void setConglomerateNumber(long conglomerateNumber) {
        this.conglomerateNumber = conglomerateNumber;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public UUID getTableID() {
        return this.tableID;
    }

    public UUID getSchemaID() {
        return this.schemaID;
    }

    public boolean isIndex() {
        return this.indexable;
    }

    public boolean isConstraint() {
        return this.forConstraint;
    }

    public String getConglomerateName() {
        return this.name;
    }

    public void setConglomerateName(String newName) {
        this.name = newName;
    }

    public IndexRowGenerator getIndexDescriptor() {
        return this.indexRowGenerator;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(135);
    }

    @Override
    public String getObjectName() {
        SanityManager.ASSERT((this.name != null ? 1 : 0) != 0, (String)"ConglomerateDescriptor only expected to be provider for indexes");
        return this.name;
    }

    @Override
    public UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public String getClassType() {
        if (this.indexable) {
            return "Index";
        }
        return "Heap";
    }

    public String toString() {
        String keyString = "";
        if (this.indexable && this.columnNames != null) {
            int[] keyColumns = this.indexRowGenerator.baseColumnPositions();
            keyString = ", key columns = {" + this.columnNames[keyColumns[0] - 1];
            for (int index = 1; index < keyColumns.length; ++index) {
                keyString = keyString + ", " + this.columnNames[keyColumns[index] - 1];
            }
            keyString = keyString + "}";
        }
        return "ConglomerateDescriptor: conglomerateNumber = " + this.conglomerateNumber + " name = " + this.name + " uuid = " + this.uuid + " heap = " + Misc.getMemStoreBooting().findConglomerate(ContainerKey.valueOf(0L, this.conglomerateNumber)) + " indexable = " + this.indexable + keyString;
    }

    @Override
    public String getDescriptorType() {
        if (this.indexable) {
            return "Index";
        }
        return "Table";
    }

    @Override
    public String getDescriptorName() {
        return this.name;
    }

    public ConglomerateDescriptor drop(LanguageConnectionContext lcc, TableDescriptor td) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(this, 2, lcc);
        GfxdIndexManager indexManager = GfxdIndexManager.getGfxdIndexManager(td, lcc);
        if (indexManager != null) {
            indexManager.invalidateFor(lcc);
        }
        ConglomerateDescriptor[] congDescs = dd.getConglomerateDescriptors(this.getConglomerateNumber());
        boolean dropConglom = false;
        ConglomerateDescriptor physicalCD = null;
        if (congDescs.length == 1) {
            dropConglom = true;
        } else {
            boolean needNewConglomerate;
            physicalCD = this.describeSharedConglomerate(congDescs, true);
            IndexRowGenerator othersIRG = physicalCD.getIndexDescriptor();
            boolean bl = needNewConglomerate = this.indexRowGenerator.isUnique() && !othersIRG.isUnique() || this.indexRowGenerator.isUniqueWithDuplicateNulls() && !othersIRG.isUniqueWithDuplicateNulls();
            if (needNewConglomerate) {
                dropConglom = true;
            } else {
                physicalCD = null;
            }
        }
        if (dropConglom) {
            dd.dropStatisticsDescriptors(td.getUUID(), this.getUUID(), tc);
            tc.dropConglomerate(this.getConglomerateNumber());
        }
        dd.dropConglomerateDescriptor(this, tc);
        td.removeConglomerateDescriptor(this);
        return physicalCD;
    }

    public ConglomerateDescriptor describeSharedConglomerate(ConglomerateDescriptor[] descriptors, boolean ignoreThis) throws StandardException {
        if (!this.isIndex()) {
            ConglomerateDescriptor heap = null;
            for (int i = 0; i < descriptors.length; ++i) {
                if (this.getConglomerateNumber() != descriptors[i].getConglomerateNumber()) continue;
                if (!descriptors[i].getUUID().equals(this.getUUID())) {
                    SanityManager.THROWASSERT((String)("Should not have multiple descriptors for heap conglomerate " + this.getConglomerateNumber()));
                }
                heap = descriptors[i];
            }
            return heap;
        }
        ConglomerateDescriptor returnDesc = null;
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].isIndex() || this.getConglomerateNumber() != descriptors[i].getConglomerateNumber() || ignoreThis && this.getUUID().equals(descriptors[i].getUUID())) continue;
            if (descriptors[i].getIndexDescriptor().isUnique()) {
                returnDesc = descriptors[i];
                break;
            }
            if (descriptors[i].getIndexDescriptor().isUniqueWithDuplicateNulls()) {
                returnDesc = descriptors[i];
                continue;
            }
            if (returnDesc != null) continue;
            returnDesc = descriptors[i];
        }
        if (returnDesc == null) {
            SanityManager.THROWASSERT((String)("Failed to find sharable conglomerate descriptor for index conglomerate # " + this.getConglomerateNumber()));
        }
        return returnDesc;
    }
}

