/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.EventErrorHandler;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntry;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntryWithStats;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.SortedIndexContainer;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholdListener;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.ServerResolverUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.EventErrorHandlerWrapper;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.NonLocalRowLocationRegionEntry;
import com.pivotal.gemfirexd.internal.engine.store.NonLocalRowLocationRegionEntryWithStats;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.WrapperRowLocationForTxn;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public final class RegionEntryUtils {
    public static final GemFireCacheImpl.StaticSystemCallbacks gfxdSystemCallbacks = new GemFireCacheImpl.StaticSystemCallbacks(){

        public void logAsync(Object[] line) {
            SanityManager.DEBUG_PRINT_COMPACT_LINE((Object[])line);
        }

        public final boolean initializeForDeferredRegionsRecovery(long timeout) {
            return GemFireXDUtils.waitForNodeInitialization(timeout, true, false);
        }

        public final boolean waitBeforeAsyncDiskTask(long waitMillis, DiskStoreImpl ds) {
            GemFireStore memStore;
            GfxdDataDictionary dd;
            if (GemFireXDUtils.TracePersistIndex) {
                SanityManager.DEBUG_PRINT((String)"TracePersistIndex", (String)"RegionEntryUtils#waitBeforeAsyncDiskTask: called");
            }
            if (ds.waitForIndexRecoveryEnd(waitMillis) && (dd = (memStore = Misc.getMemStoreBooting()).getDatabase().getDataDictionary()) != null) {
                if (!memStore.initialDDLReplayDone()) {
                    return dd.lockForReadingInDDLReplayNoThrow(memStore, waitMillis, false);
                }
                return dd.lockForReadingNoThrow(null, waitMillis);
            }
            return false;
        }

        public final void endAsyncDiskTask(DiskStoreImpl ds) {
            GemFireStore memStore;
            GfxdDataDictionary dd;
            if (GemFireXDUtils.TracePersistIndex) {
                SanityManager.DEBUG_PRINT((String)"TracePersistIndex", (String)"RegionEntryUtils#endAsyncDiskTask: called");
            }
            if ((dd = (memStore = Misc.getMemStoreBooting()).getDatabase().getDataDictionary()) != null) {
                dd.unlockAfterReading(null);
            }
        }

        public boolean persistIndexes(DiskStoreImpl ds) {
            return !ds.isUsedForInternalUse() && !ds.isOffline() && Misc.getMemStoreBooting().isPersistIndexes();
        }

        public void waitForAsyncIndexRecovery(DiskStoreImpl dsi) {
            if (dsi.isUsedForInternalUse() || dsi.isOffline()) {
                return;
            }
            GemFireStore memStore = Misc.getMemStoreBooting();
            if (GemFireXDUtils.TracePersistIndex) {
                SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("RegionEntryUtils#waitForAsyncIndexRecovery: waiting for index creation for " + dsi));
            }
            memStore.waitForIndexLoadBegin(-1L);
            if (GemFireXDUtils.TracePersistIndex) {
                SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("RegionEntryUtils#waitForAsyncIndexRecovery: done wait for index creation for " + dsi));
            }
        }

        public Set<SortedIndexContainer> getAllLocalIndexes(DiskStoreImpl ds) {
            GemFireStore memStore = Misc.getMemStoreBooting();
            THashSet allIndexes = new THashSet();
            for (GemFireContainer container : memStore.getAllContainers()) {
                if (!container.isLocalIndex() || !container.isInitialized() || ds != null && !ds.getName().equals(container.getBaseContainer().getRegionAttributes().getDiskStoreName())) continue;
                assert (ds == null || ds == container.getBaseContainer().getRegion().getDiskStore()) : "ds=" + ds + ", regionDS=" + container.getBaseContainer().getRegion().getDiskStore();
                allIndexes.add(container);
            }
            return allIndexes;
        }

        public MemoryThresholdListener getMemoryThresholdListener() {
            return Misc.getMemStoreBooting().thresholdListener();
        }

        public String getSystemPropertyNamePrefix() {
            return GfxdConstants.GFXD_PREFIX;
        }

        public String getSystemProperty(String key, SystemProperties properties) {
            boolean hasPrefix;
            String propValue;
            GemFireStore store = GemFireStore.getBootingInstance();
            try {
                if (store != null && (propValue = PropertyUtil.getDatabaseProperty(store, key)) != null) {
                    return propValue;
                }
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException(null, se);
            }
            String lookupKey = key;
            boolean bl = hasPrefix = key.startsWith(GfxdConstants.GFXD_PREFIX) || key.startsWith("gemfire.");
            if (!hasPrefix) {
                lookupKey = GfxdConstants.GFXD_PREFIX + key;
            }
            if ((propValue = PropertyUtil.getSystemProperty(lookupKey, null)) != null) {
                return propValue;
            }
            if (!hasPrefix && (propValue = PropertyUtil.getSystemProperty(lookupKey = "gemfire." + key, null)) != null) {
                return propValue;
            }
            return null;
        }

        public void initializeForOffline() {
            if (GfxdDataSerializable.initTypes()) {
                DataType.init();
            }
        }

        public boolean isConstraintViolation(Exception ex) {
            if (ex instanceof StandardException && (((StandardException)ex).getSQLState().equals("23505") || ((StandardException)ex).getSQLState().equals("23503"))) {
                return true;
            }
            for (Throwable failure = ex; failure != null; failure = failure.getCause()) {
                if (!(failure instanceof EntryExistsException)) continue;
                return true;
            }
            return false;
        }

        public boolean supportsRegionConcurrencyChecks(LocalRegion region) {
            if (this.defaultRegionConcurrencyChecksEnabled()) {
                return (!region.isSecret() || region.getDataPolicy().withPersistence()) && !"_DDL_STMTS_META_REGION".equals(region.getName());
            }
            return !region.isSecret() && !"_DDL_STMTS_META_REGION".equals(region.getName());
        }

        public boolean allowConcurrencyChecksOverride(LocalRegion region) {
            if (this.defaultRegionConcurrencyChecksEnabled()) {
                return !"_DDL_STMTS_META_REGION".equals(region.getName());
            }
            return false;
        }

        public boolean shouldDeleteWinOnConflict() {
            return true;
        }

        public boolean defaultRegionConcurrencyChecksEnabled() {
            return GfxdConstants.TABLE_DEFAULT_CONCURRENCY_CHECKS_ENABLED;
        }

        public boolean createUUIDPersistentRegion(LocalRegion region) {
            return true;
        }

        public final Object entryRefreshKey(Object key, Object oldValue, Object newValue, Object containerInfo) throws IllegalAccessException {
            Class<?> newValClass;
            ExtraTableInfo tableInfo = (ExtraTableInfo)containerInfo;
            if (newValue != null && ((newValClass = newValue.getClass()) == byte[].class || newValClass == byte[][].class || newValClass == OffHeapRow.class || newValClass == OffHeapRowWithLobs.class || newValClass == SimpleMemoryAllocatorImpl.DataAsAddress.class)) {
                if (tableInfo != null && tableInfo.regionKeyPartOfValue()) {
                    return null;
                }
            } else {
                if (key == null) {
                    if (oldValue != null) {
                        Class<?> oldValClass = oldValue.getClass();
                        if (oldValClass == byte[].class) {
                            byte[] rowBytes = (byte[])oldValue;
                            ExtraTableInfo rowInfo = tableInfo.getExtraTableInfo(rowBytes);
                            return rowInfo.getRowFormatter().generateColumns(rowBytes, rowInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter());
                        }
                        if (oldValClass == byte[][].class) {
                            byte[] rowBytes = ((byte[][])oldValue)[0];
                            ExtraTableInfo rowInfo = tableInfo.getExtraTableInfo(rowBytes);
                            return rowInfo.getRowFormatter().generateColumns(rowBytes, rowInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter());
                        }
                        if (oldValClass == OffHeapRow.class) {
                            OffHeapRow bs = (OffHeapRow)((Object)oldValue);
                            return tableInfo.getRowFormatter(bs).generateColumns(bs, tableInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter());
                        }
                        if (oldValClass == OffHeapRowWithLobs.class) {
                            OffHeapRowWithLobs bs = (OffHeapRowWithLobs)((Object)oldValue);
                            return tableInfo.getRowFormatter(bs).generateColumns(bs, tableInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter());
                        }
                        if (oldValClass == SimpleMemoryAllocatorImpl.DataAsAddress.class) {
                            byte[] rowBytes = (byte[])RegionEntryUtils.encodedAddressToObject(((SimpleMemoryAllocatorImpl.DataAsAddress)oldValue).getEncodedAddress());
                            ExtraTableInfo rowInfo = tableInfo.getExtraTableInfo(rowBytes);
                            return rowInfo.getRowFormatter().generateColumns(rowBytes, rowInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter());
                        }
                        if (!RegionEntryUtils.isValueToken(oldValue)) {
                            GemFireXDUtils.throwAssert("entryRefreshKey:: unexpected oldValue type: " + oldValClass.getName());
                        }
                    }
                    throw new IllegalAccessException("key and value both invalid");
                }
                if (newValue == null && key.getClass() == CompactCompositeRegionKey.class) {
                    return ((CompactCompositeRegionKey)key).snapshotKeyFromValue(false);
                }
            }
            return key;
        }

        public final Object entryGetKey(Object key, AbstractRegionEntry entry) {
            Class<?> keyClass;
            Class<?> clazz = keyClass = key != null ? key.getClass() : null;
            if (keyClass == byte[].class) {
                return entry;
            }
            ExtraTableInfo tableInfo = (ExtraTableInfo)entry.getContainerInfo();
            if (tableInfo != null) {
                if (tableInfo.regionKeyPartOfValue() && keyClass != CompactCompositeRegionKey.class) {
                    return entry;
                }
                return key;
            }
            return key;
        }

        public final Object entryGetKeyCopy(Object key, AbstractRegionEntry entry) {
            Class<?> keyClass;
            ExtraTableInfo tableInfo = (ExtraTableInfo)entry.getContainerInfo();
            Class<?> clazz = keyClass = key != null ? key.getClass() : null;
            if (keyClass == byte[].class) {
                return new CompactCompositeRegionKey(tableInfo, (byte[])key);
            }
            if (tableInfo != null) {
                if (tableInfo.regionKeyPartOfValue()) {
                    if (keyClass == CompactCompositeRegionKey.class) {
                        return key;
                    }
                    if (entry instanceof OffHeapRegionEntry) {
                        return new CompactCompositeRegionKey((OffHeapRegionEntry)entry, tableInfo);
                    }
                    Object val = entry._getValue();
                    if (val != null) {
                        Class<?> valClass = val.getClass();
                        if (valClass == byte[].class) {
                            byte[] vbytes = (byte[])val;
                            tableInfo = tableInfo.getExtraTableInfo(vbytes);
                            return new CompactCompositeRegionKey(vbytes, tableInfo);
                        }
                        if (valClass == byte[][].class) {
                            byte[] vbytes = ((byte[][])val)[0];
                            tableInfo = tableInfo.getExtraTableInfo(vbytes);
                            return new CompactCompositeRegionKey(vbytes, tableInfo);
                        }
                        if (RegionEntryUtils.isValueToken(val)) {
                            return null;
                        }
                        GemFireXDUtils.throwAssert("entryGetKeyCopy:: unexpected key,value types: " + (keyClass != null ? keyClass.getName() : "(null)") + ',' + valClass.getName());
                    }
                    return null;
                }
                return key;
            }
            return key;
        }

        public final void entryCheckValue(Object val) {
            Class<?> valClass;
            if (val != null && (valClass = val.getClass()) != byte[].class && valClass != byte[][].class && valClass != OffHeapRow.class && valClass != OffHeapRowWithLobs.class && !RegionEntryUtils.isValueToken(val)) {
                GemFireXDUtils.throwAssert("entryCheckValue:: unexpected value type: " + valClass.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int entryKeySizeInBytes(Object key, AbstractRegionEntry entry) {
            block24: {
                ExtraTableInfo tableInfo;
                if (key != null) {
                    Class<?> keyClass = key.getClass();
                    if (keyClass == byte[].class) {
                        byte[] kbytes = (byte[])key;
                        return ReflectionSingleObjectSizer.OBJECT_SIZE + kbytes.length + ReflectionSingleObjectSizer.REFERENCE_SIZE;
                    }
                    if (keyClass == CompactCompositeRegionKey.class) {
                        return (int)((CompactCompositeRegionKey)key).estimateMemoryUsage();
                    }
                    if (keyClass == Long.class) {
                        return 8 + ReflectionSingleObjectSizer.OBJECT_SIZE;
                    }
                    if (keyClass == CompositeRegionKey.class) {
                        return (int)((CompositeRegionKey)key).estimateMemoryUsage();
                    }
                    if (keyClass == DataValueDescriptor[].class) {
                        DataValueDescriptor[] arr = (DataValueDescriptor[])key;
                        int memoryUsage = 2 * ReflectionSingleObjectSizer.OBJECT_SIZE;
                        for (int i = 0; i < arr.length; ++i) {
                            memoryUsage += arr[i].estimateMemoryUsage();
                        }
                        return memoryUsage;
                    }
                    if (DataValueDescriptor.class.isAssignableFrom(keyClass)) {
                        return ((DataValueDescriptor)key).estimateMemoryUsage();
                    }
                    GemFireXDUtils.throwAssert("entryKeySizeInBytes:: unexpected key type: " + keyClass.getName());
                }
                if ((tableInfo = (ExtraTableInfo)entry.getContainerInfo()) != null) {
                    OffHeapByteSource ohValue = null;
                    GemFireContainer gfc = null;
                    try {
                        gfc = tableInfo.getGemFireContainer();
                    }
                    catch (StandardException se) {
                        throw new GemFireXDRuntimeException(se);
                    }
                    Object value = RegionEntryUtils.getByteSource((RowLocation)entry, gfc, false, true);
                    try {
                        if (value != null) {
                            Class<?> valueClass = value.getClass();
                            if (valueClass == byte[].class) {
                                byte[] heapValue = (byte[])value;
                                RowFormatter rf = tableInfo.getRowFormatter(heapValue);
                                int n = ReflectionSingleObjectSizer.OBJECT_SIZE + rf.getColumnsWidth(heapValue, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), tableInfo.getPrimaryKeyFormatter()) + ReflectionSingleObjectSizer.REFERENCE_SIZE;
                                return n;
                            }
                            if (valueClass == byte[][].class) {
                                byte[] heapValue = ((byte[][])value)[0];
                                RowFormatter rf = tableInfo.getRowFormatter(heapValue);
                                int n = ReflectionSingleObjectSizer.OBJECT_SIZE + rf.getColumnsWidth(heapValue, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), tableInfo.getPrimaryKeyFormatter()) + ReflectionSingleObjectSizer.REFERENCE_SIZE;
                                return n;
                            }
                            if (OffHeapByteSource.isOffHeapBytesClass(valueClass)) {
                                ohValue = (OffHeapByteSource)((Object)value);
                                RowFormatter rf = tableInfo.getRowFormatter(ohValue);
                                int n = ReflectionSingleObjectSizer.OBJECT_SIZE + rf.getColumnsWidth(ohValue, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), tableInfo.getPrimaryKeyFormatter()) + ReflectionSingleObjectSizer.REFERENCE_SIZE;
                                return n;
                            }
                            if (RegionEntryUtils.isValueToken(value)) {
                                int n = -1;
                                return n;
                            }
                            GemFireXDUtils.throwAssert("entryKeySizeInBytes:: unexpected value type: " + valueClass.getName());
                            break block24;
                        }
                        int n = -1;
                        return n;
                    }
                    finally {
                        if (ohValue != null) {
                            ohValue.release();
                        }
                    }
                }
            }
            throw RegionEntryUtils.checkCacheForNullTableInfo("entryKeySizeInBytes");
        }

        public final Object fromVersion(byte[] bytes, int bytesLen, boolean serialized, Version version, ByteArrayDataInput in) {
            if (bytes != null) {
                if (serialized) {
                    try {
                        if (in == null) {
                            in = new ByteArrayDataInput();
                        }
                        in.initialize(bytes, 0, bytesLen, version);
                        if (bytes[0] == 91 && Version.SQLF_1099.compareTo(version) > 0) {
                            in.readByte();
                            return RowFormatter.convertPre11RowWithLobs(in);
                        }
                        return BlobHelper.deserializeBuffer((ByteArrayDataInput)in, (int)bytes.length);
                    }
                    catch (IOException e) {
                        throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_DESERIALIZING.toLocalizedString(), (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new SerializationException(LocalizedStrings.EntryEventImpl_A_CLASSNOTFOUNDEXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE_CACHED_VALUE.toLocalizedString(), (Throwable)e);
                    }
                }
                if (Version.SQLF_1099.compareTo(version) > 0) {
                    return RowFormatter.convertPre11Row(bytes);
                }
                return bytes;
            }
            return null;
        }

        public final byte[] fromVersionToBytes(byte[] bytes, int bytesLen, boolean serialized, Version version, ByteArrayDataInput in, HeapDataOutputStream hdos) {
            if (bytes != null) {
                if (serialized) {
                    try {
                        byte dscode = bytes[0];
                        switch (dscode) {
                            case 91: {
                                if (Version.SQLF_1099.compareTo(version) > 0) {
                                    in.initialize(bytes, 0, bytesLen, version);
                                    in.readByte();
                                    return RowFormatter.convertPre11RowWithLobsToBytes(in, (byte)91);
                                }
                                return bytes;
                            }
                            case 1: {
                                if (bytes[1] == -20 && bytes[2] == 98 || bytes[1] == -17 || bytes[1] == -18 || bytes[1] == -16 || bytes[2] != 80) {
                                    return bytes;
                                }
                                in.initialize(bytes, 0, bytesLen, version);
                                hdos.clearForReuse();
                                if (GfxdDataSerializable.initTypes()) {
                                    DataType.init();
                                }
                                Object o = BlobHelper.deserializeBuffer((ByteArrayDataInput)in, (int)bytes.length);
                                DataSerializer.writeObject((Object)o, (DataOutput)hdos);
                                return hdos.toByteArray();
                            }
                        }
                        return bytes;
                    }
                    catch (IOException e) {
                        throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_DESERIALIZING.toLocalizedString(), (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new SerializationException(LocalizedStrings.EntryEventImpl_A_CLASSNOTFOUNDEXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE_CACHED_VALUE.toLocalizedString(), (Throwable)e);
                    }
                }
                if (Version.SQLF_1099.compareTo(version) > 0) {
                    return RowFormatter.convertPre11Row(bytes);
                }
                return bytes;
            }
            return null;
        }

        public final Object entryGetContainerInfoForKey(AbstractRegionEntry entry) {
            Object tableInfo = entry.getContainerInfo();
            return tableInfo != null && ((ExtraTableInfo)tableInfo).regionKeyPartOfValue() ? tableInfo : null;
        }

        public LocalRegion getRegionFromContainerInfo(Object containerInfo) {
            if (containerInfo != null) {
                try {
                    ExtraTableInfo tableInfo = (ExtraTableInfo)containerInfo;
                    return tableInfo.getGemFireContainer().getRegion();
                }
                catch (StandardException se) {
                    throw GemFireXDRuntimeException.newRuntimeException("unexpected failure in getting GemFireContainer from ExtraTableInfo", se);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int entryHashCode(Object key, AbstractRegionEntry entry) throws IllegalAccessException {
            block20: {
                Class<?> keyClass;
                Class<?> clazz = keyClass = key != null ? key.getClass() : null;
                if (keyClass == byte[].class) {
                    return ResolverUtils.addBytesToHash((byte[])((byte[])key), (int)0);
                }
                ExtraTableInfo tableInfo = (ExtraTableInfo)entry.getContainerInfo();
                if (tableInfo != null) {
                    if (tableInfo.regionKeyPartOfValue()) {
                        if (keyClass == CompactCompositeRegionKey.class) {
                            return key.hashCode();
                        }
                        if (keyClass != null) {
                            GemFireXDUtils.throwAssert("entryHashCode:: unexpected key type: " + keyClass.getName());
                        }
                        GemFireContainer gfc = null;
                        try {
                            gfc = tableInfo.getGemFireContainer();
                        }
                        catch (StandardException se) {
                            throw new GemFireXDRuntimeException(se);
                        }
                        Object value = RegionEntryUtils.getByteSource((RowLocation)entry, gfc, false, false);
                        OffHeapByteSource ohValue = null;
                        try {
                            if (value != null) {
                                Class<?> valueClass = value.getClass();
                                if (valueClass == byte[].class) {
                                    int n = RegionEntryUtils.entryValueHashCode((byte[])value, tableInfo);
                                    return n;
                                }
                                if (valueClass == byte[][].class) {
                                    int n = RegionEntryUtils.entryValueHashCode(((byte[][])value)[0], tableInfo);
                                    return n;
                                }
                                if (OffHeapByteSource.isOffHeapBytesClass(valueClass)) {
                                    ohValue = (OffHeapByteSource)((Object)value);
                                    int n = RegionEntryUtils.entryValueHashCode(ohValue, tableInfo);
                                    return n;
                                }
                                if (!RegionEntryUtils.isValueToken(value)) {
                                    GemFireXDUtils.throwAssert("entryHashCode:: unexpected value type: " + valueClass.getName());
                                    break block20;
                                }
                                throw new IllegalAccessException("key and value both invalid");
                            }
                            throw new IllegalAccessException("key and value both invalid");
                        }
                        finally {
                            if (ohValue != null) {
                                ohValue.release();
                            }
                        }
                    }
                    return key.hashCode();
                }
                if (key != null) {
                    return key.hashCode();
                }
            }
            throw RegionEntryUtils.checkCacheForNullTableInfo("entryHashCode");
        }

        public final boolean entryEquals(Object key, Object value, AbstractRegionEntry entry, Object other) throws IllegalAccessException {
            if (other != null) {
                Class<?> keyClass;
                Class<?> otherClass = other.getClass();
                if (entry.getClass() == otherClass) {
                    return entry == other;
                }
                ExtraTableInfo tableInfo = (ExtraTableInfo)entry.getContainerInfo();
                Class<?> clazz = keyClass = key != null ? key.getClass() : null;
                if (keyClass == byte[].class) {
                    return RegionEntryUtils.entryEqualsKeyBytes((byte[])key, value, tableInfo, other, otherClass);
                }
                if (tableInfo != null) {
                    if (tableInfo.regionKeyPartOfValue() && keyClass != CompactCompositeRegionKey.class) {
                        return RegionEntryUtils.entryEqualsInternal(key, value, null, null, tableInfo, (RegionEntry)entry, other, otherClass);
                    }
                    return key.equals(other);
                }
                if (key != null) {
                    return key.equals(other);
                }
                throw RegionEntryUtils.checkCacheForNullTableInfo("entryEquals");
            }
            return false;
        }

        public final RuntimeException checkCacheForNullKeyValue(String method) {
            return RegionEntryUtils.checkCacheForNullKeyValue(method);
        }

        public final void waitingForDataSync(String regionPath, Set<PersistentMemberID> membersToWaitFor, Set<Integer> missingBuckets, PersistentMemberID myId, String message) {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                ((FabricServiceImpl)service).notifyWaiting(regionPath, membersToWaitFor, missingBuckets, myId, message);
            } else {
                FabricServiceImpl.notifyWaitingInLauncher(regionPath, membersToWaitFor, missingBuckets, myId, message);
            }
        }

        public final void endWaitingForDataSync(String regionPath, PersistentMemberID myId) {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                ((FabricServiceImpl)service).endNotifyWaiting();
            }
        }

        public final void stopNetworkServers() {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                service.stopAllNetworkServers();
            }
        }

        public final void emergencyClose() {
            this.stopNetworkServers();
        }

        public final NonLocalRegionEntry newNonLocalRegionEntry() {
            return new NonLocalRowLocationRegionEntry();
        }

        public final NonLocalRegionEntry newNonLocalRegionEntry(RegionEntry re, LocalRegion region, boolean allowTombstones) {
            return new NonLocalRowLocationRegionEntry(re, region, allowTombstones);
        }

        public final NonLocalRegionEntry newNonLocalRegionEntry(Object key, Object value, LocalRegion region, VersionTag<?> versionTag) {
            return new NonLocalRowLocationRegionEntry(key, value, region, versionTag);
        }

        public final NonLocalRegionEntryWithStats newNonLocalRegionEntryWithStats() {
            return new NonLocalRowLocationRegionEntryWithStats();
        }

        public final NonLocalRegionEntryWithStats newNonLocalRegionEntryWithStats(RegionEntry re, LocalRegion region, boolean allowTombstones) {
            return new NonLocalRowLocationRegionEntryWithStats(re, region, allowTombstones);
        }

        public final boolean supportsCommandService() {
            return false;
        }

        public boolean destroyExistingRegionInCreate(DiskStoreImpl ds, LocalRegion region) {
            GemFireStore store = Misc.getMemStoreBooting();
            return store != null && store.initialDDLReplayDone();
        }

        public long getRegionUUID(LocalRegion region, InternalRegionArguments ira) {
            LanguageConnectionContext lcc;
            long uuid = ira.getUUID();
            if ((uuid == 0L || uuid == -1L) && (lcc = Misc.getLanguageConnectionContext()) != null) {
                uuid = ((GemFireTransaction)lcc.getTransactionExecute()).getDDLId();
            }
            return uuid;
        }

        public long getGatewayUUID(AbstractGatewaySender sender, GatewaySenderAttributes attrs) {
            LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
            if (lcc != null) {
                return ((GemFireTransaction)lcc.getTransactionExecute()).getDDLId();
            }
            return 0L;
        }

        public void printStacks(PrintWriter pw) {
            Misc.getMemStoreBooting().getDDLLockService().getLocalLockService().dumpAllRWLocks("PRINTSTACKS", pw, true);
        }

        public TXStateProxy getJTAEnlistedTX(LocalRegion region) {
            return null;
        }

        public void beforeReturningOffHeapMemoryToAllocator(long parentAddress, SimpleMemoryAllocatorImpl.ChunkType chunkType, int dataSizeDelta) {
            OffHeapRowWithLobs.freeLobsIfPresent(parentAddress, chunkType, dataSizeDelta);
        }

        public EventErrorHandler getEventErrorHandler() {
            return EventErrorHandlerWrapper.getInstance();
        }

        public boolean tracePersistFinestON() {
            return GemFireXDUtils.TracePersistIndexFinest;
        }

        public String getDDLStatementRegionName() {
            return "_DDL_STMTS_META_REGION";
        }

        public boolean isAdmin() {
            GemFireStore.VMKind myVMKind = GemFireXDUtils.getMyVMKind();
            return myVMKind != null && myVMKind.isAdmin();
        }

        public boolean isOperationNode() {
            GemFireStore.VMKind myVMKind = GemFireXDUtils.getMyVMKind();
            return myVMKind != null && myVMKind.isAccessorOrStore();
        }

        public void log(String traceFlag, String logLine, Throwable t) {
            SanityManager.DEBUG_PRINT((String)traceFlag, (String)logLine, (Throwable)t);
        }

        public boolean isPRForGlobalIndex(PartitionedRegion pr) {
            GemFireContainer container = (GemFireContainer)pr.getUserAttribute();
            if (container != null) {
                return container.isGlobalIndex();
            }
            return false;
        }

        public String dumpCompactCompositeRegionKey(Object key, String regionPath) {
            if (key instanceof CompactCompositeRegionKey && regionPath != null) {
                CompactCompositeRegionKey ccrk = (CompactCompositeRegionKey)key;
                Region reg = Misc.getRegion(regionPath, false, false);
                if (reg != null && reg instanceof LocalRegion) {
                    LocalRegion lr = (LocalRegion)reg;
                    ccrk.setRegionContext(lr);
                    return ccrk.toString() + ":" + regionPath;
                }
            }
            return key.getClass().getSimpleName() + ":region[" + regionPath + "]:" + key;
        }

        public Set<DistributedMember> getDataStores() {
            return null;
        }

        public int getBucketIdFromRegionEntry(RegionEntry val) {
            RowLocation rl = (RowLocation)val;
            return rl.getBucketID();
        }

        public Properties getSecurityPropertiesForReconnect() {
            FabricServiceImpl impl = (FabricServiceImpl)FabricServiceImpl.getInstance();
            if (impl != null) {
                return impl.getSecurityPropertiesFromRestarter();
            }
            return null;
        }
    };
    public static final RowFormatter.ColumnProcessor<byte[]> checkColumnEqualityWithRow = new RowFormatter.ColumnProcessor<byte[]>(){

        private final int compareBytes(byte[] row, int columnOffset, int columnWidth, byte[] columnBytes, int columnPos) {
            int endColumnPos = columnPos + columnWidth;
            while (columnPos < endColumnPos) {
                if (columnBytes[columnPos] != row[columnOffset]) {
                    return -1;
                }
                ++columnPos;
                ++columnOffset;
            }
            return 0;
        }

        private final int compareCharBytes(byte[] row, int columnOffset, int columnWidth, byte[] targetColumnBytes, int targetOffset, int targetWidth) {
            block4: {
                block3: {
                    int shorter;
                    int n = shorter = columnWidth < targetWidth ? columnWidth : targetWidth;
                    if (this.compareBytes(row, columnOffset, shorter, targetColumnBytes, targetOffset) == -1) {
                        return -1;
                    }
                    if (columnWidth >= targetWidth) break block3;
                    for (int targetCurPos = targetOffset + shorter; targetCurPos < targetOffset + targetWidth; ++targetCurPos) {
                        if (targetColumnBytes[targetCurPos] == 32) continue;
                        return -1;
                    }
                    break block4;
                }
                if (columnWidth <= targetWidth) break block4;
                for (int columnCurPos = columnOffset + shorter; columnCurPos < columnOffset + columnWidth; ++columnCurPos) {
                    if (row[columnCurPos] == 32) continue;
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public final int handleNull(byte[] columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset;
            int offset;
            if (targetOffsetFromMap < 0 ? (offset = targetFormat.readVarDataOffset(columnBytes, offsetOffset = columnBytes.length + targetOffsetFromMap)) < 0 && !targetFormat.isVarDataOffsetDefaultToken(offset) : targetOffsetFromMap == 0 && cd.columnDefault == null) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int handleDefault(byte[] columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset;
            int offset;
            if (targetOffsetFromMap < 0 && targetFormat.isVarDataOffsetDefaultToken(offset = targetFormat.readVarDataOffset(columnBytes, offsetOffset = columnBytes.length + targetOffsetFromMap))) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int handleFixed(byte[] row, int columnOffset, int columnWidth, byte[] columnBytes, int pos, RowFormatter formatter, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int targetWidth = targetFormat.columns[targetIndex].fixedWidth;
            if (columnWidth == targetWidth) {
                return this.compareBytes(row, columnOffset, columnWidth, columnBytes, targetOffsetFromMap);
            }
            return -1;
        }

        @Override
        public final int handleVariable(byte[] row, int columnOffset, int columnWidth, byte[] columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            ColumnDescriptor targetCD = targetFormat.columns[targetIndex];
            long offsetAndWidth = targetFormat.getOffsetAndWidth(targetIndex, columnBytes, targetOffsetFromMap, targetCD);
            if (offsetAndWidth >= 0L) {
                int targetWidth = (int)(offsetAndWidth & 0xFFFFFFFFL);
                if (columnWidth == targetWidth) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareBytes(row, columnOffset, columnWidth, columnBytes, targetOffset);
                }
                int typeId = cd.getType().getTypeId().getTypeFormatId();
                if (typeId == 13 || typeId == 5 || typeId == 27) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareCharBytes(row, columnOffset, columnWidth, columnBytes, targetOffset, targetWidth);
                }
            }
            return -1;
        }

        @Override
        public final int handleLob(byte[] row, byte[] output, int outputPosition, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            throw new UnsupportedOperationException("not expected to be invoked for cd " + cd);
        }
    };
    public static final RowFormatter.ColumnProcessorOffHeap<byte[]> checkColumnEqualityWithRowOffHeap = new RowFormatter.ColumnProcessorOffHeap<byte[]>(){

        private final int compareBytes(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, byte[] columnBytes, int columnPos) {
            int endColumnPos = columnPos + columnWidth;
            long rowAddr = memAddr + (long)columnOffset;
            while (columnPos < endColumnPos) {
                if (columnBytes[columnPos] != unsafe.getByte(rowAddr)) {
                    return -1;
                }
                ++columnPos;
                ++rowAddr;
            }
            return 0;
        }

        private final int compareCharBytes(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, byte[] targetColumnBytes, int targetOffset, int targetWidth) {
            block4: {
                long rowAddr;
                int shorter;
                block3: {
                    int n = shorter = columnWidth < targetWidth ? columnWidth : targetWidth;
                    if (this.compareBytes(unsafe, memAddr, columnOffset, shorter, targetColumnBytes, targetOffset) == -1) {
                        return -1;
                    }
                    if (columnWidth >= targetWidth) break block3;
                    for (int targetCurPos = targetOffset + shorter; targetCurPos < targetOffset + targetWidth; ++targetCurPos) {
                        if (targetColumnBytes[targetCurPos] == 32) continue;
                        return -1;
                    }
                    break block4;
                }
                if (columnWidth <= targetWidth) break block4;
                long rowAddrEnd = rowAddr + (long)(columnWidth - shorter);
                for (rowAddr = memAddr + (long)columnOffset + (long)shorter; rowAddr < rowAddrEnd; ++rowAddr) {
                    if (unsafe.getByte(rowAddr) == 32) continue;
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public final int handleNull(byte[] columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset;
            int offset;
            if (targetOffsetFromMap < 0 ? (offset = targetFormat.readVarDataOffset(columnBytes, offsetOffset = columnBytes.length + targetOffsetFromMap)) < 0 && !targetFormat.isVarDataOffsetDefaultToken(offset) : targetOffsetFromMap == 0 && cd.columnDefault == null) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int handleDefault(byte[] columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int offsetOffset;
            int offset;
            if (targetOffsetFromMap < 0 && targetFormat.isVarDataOffsetDefaultToken(offset = targetFormat.readVarDataOffset(columnBytes, offsetOffset = columnBytes.length + targetOffsetFromMap))) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int handleFixed(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, byte[] columnBytes, int pos, RowFormatter formatter, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int targetWidth = targetFormat.columns[targetIndex].fixedWidth;
            if (columnWidth == targetWidth) {
                return this.compareBytes(unsafe, memAddr, columnOffset, columnWidth, columnBytes, targetOffsetFromMap);
            }
            return -1;
        }

        @Override
        public final int handleVariable(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, byte[] columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            ColumnDescriptor targetCD = targetFormat.columns[targetIndex];
            long offsetAndWidth = targetFormat.getOffsetAndWidth(targetIndex, columnBytes, targetOffsetFromMap, targetCD);
            if (offsetAndWidth >= 0L) {
                int targetWidth = (int)(offsetAndWidth & 0xFFFFFFFFL);
                if (columnWidth == targetWidth) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareBytes(unsafe, memAddr, columnOffset, columnWidth, columnBytes, targetOffset);
                }
                int typeId = cd.getType().getTypeId().getTypeFormatId();
                if (typeId == 13 || typeId == 5 || typeId == 27) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareCharBytes(unsafe, memAddr, columnOffset, columnWidth, columnBytes, targetOffset, targetWidth);
                }
            }
            return -1;
        }

        @Override
        public final int handleLob(UnsafeWrapper unsafe, long memAddr, byte[] output, int outputPosition, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            throw new UnsupportedOperationException("not expected to be invoked for cd " + cd);
        }
    };
    public static final RowFormatter.ColumnProcessor<OffHeapByteSource> checkOffHeapColumnEqualityWithRow = new RowFormatter.ColumnProcessor<OffHeapByteSource>(){

        private final int compareBytes(byte[] typedRow, int columnOffset, int columnWidth, UnsafeWrapper unsafe, long columnAddr) {
            if (columnWidth == 0) {
                return 0;
            }
            long columnEndPos = columnAddr + (long)columnWidth;
            while (columnAddr < columnEndPos) {
                if (unsafe.getByte(columnAddr) != typedRow[columnOffset]) {
                    return -1;
                }
                ++columnAddr;
                ++columnOffset;
            }
            return 0;
        }

        private final int compareCharBytes(byte[] row, int columnOffset, int columnWidth, UnsafeWrapper unsafe, long targetColumnAddr, int targetWidth) {
            block5: {
                block4: {
                    int shorter;
                    int n = shorter = columnWidth < targetWidth ? columnWidth : targetWidth;
                    if (this.compareBytes(row, columnOffset, shorter, unsafe, targetColumnAddr) == -1) {
                        return -1;
                    }
                    if (columnWidth >= targetWidth) break block4;
                    long targetColumnEndPos = targetColumnAddr + (long)targetWidth;
                    targetColumnAddr += (long)shorter;
                    while (targetColumnAddr < targetColumnEndPos) {
                        if (unsafe.getByte(targetColumnAddr) != 32) {
                            return -1;
                        }
                        ++targetColumnAddr;
                    }
                    break block5;
                }
                if (columnWidth <= targetWidth) break block5;
                int columnEndPos = columnOffset + columnWidth;
                for (int columnCurPos = columnOffset + shorter; columnCurPos < columnEndPos; ++columnCurPos) {
                    if (row[columnCurPos] == 32) continue;
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public final int handleNull(OffHeapByteSource columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            if (targetOffsetFromMap < 0) {
                int bytesLen = columnBytes.getLength();
                long memAddr = columnBytes.getUnsafeAddress(0, bytesLen);
                int offsetOffset = bytesLen + targetOffsetFromMap;
                int offset = targetFormat.readVarDataOffset(UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, offsetOffset);
                if (offset < 0 && !targetFormat.isVarDataOffsetDefaultToken(offset)) {
                    return 0;
                }
            } else if (targetOffsetFromMap == 0 && cd.columnDefault == null) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int handleDefault(OffHeapByteSource columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            if (targetOffsetFromMap < 0) {
                int bytesLen = columnBytes.getLength();
                long memAddr = columnBytes.getUnsafeAddress(0, bytesLen);
                int offsetOffset = bytesLen + targetOffsetFromMap;
                int offset = targetFormat.readVarDataOffset(UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, offsetOffset);
                if (targetFormat.isVarDataOffsetDefaultToken(offset)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public final int handleFixed(byte[] row, int columnOffset, int columnWidth, OffHeapByteSource columnBytes, int pos, RowFormatter formatter, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int targetWidth = targetFormat.columns[targetIndex].fixedWidth;
            if (columnWidth == targetWidth) {
                long columnAddr = columnBytes.getUnsafeAddress(targetOffsetFromMap, columnWidth);
                return this.compareBytes(row, columnOffset, columnWidth, UnsafeMemoryChunk.getUnsafeWrapper(), columnAddr);
            }
            return -1;
        }

        @Override
        public final int handleVariable(byte[] row, int columnOffset, int columnWidth, OffHeapByteSource columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            ColumnDescriptor targetCD;
            int bytesLen;
            long targetMemAddr;
            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
            long offsetAndWidth = targetFormat.getOffsetAndWidth(targetIndex, unsafe, targetMemAddr = columnBytes.getUnsafeAddress(0, bytesLen = columnBytes.getLength()), bytesLen, targetOffsetFromMap, targetCD = targetFormat.columns[targetIndex]);
            if (offsetAndWidth >= 0L) {
                int targetWidth = (int)(offsetAndWidth & 0xFFFFFFFFL);
                if (columnWidth == targetWidth) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareBytes(row, columnOffset, columnWidth, unsafe, targetMemAddr + (long)targetOffset);
                }
                int typeId = cd.getType().getTypeId().getTypeFormatId();
                if (typeId == 13 || typeId == 5 || typeId == 27) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareCharBytes(row, columnOffset, columnWidth, unsafe, targetMemAddr + (long)targetOffset, targetWidth);
                }
            }
            return -1;
        }

        @Override
        public final int handleLob(byte[] row, OffHeapByteSource output, int outputPosition, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            throw new UnsupportedOperationException("not expected to be invoked for cd " + cd);
        }
    };
    public static final RowFormatter.ColumnProcessorOffHeap<OffHeapByteSource> checkOffHeapColumnEqualityWithRowOffHeap = new RowFormatter.ColumnProcessorOffHeap<OffHeapByteSource>(){

        private final int compareBytes(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, long columnAddr) {
            if (columnWidth == 0) {
                return 0;
            }
            long rowAddr = memAddr + (long)columnOffset;
            long rowEndPos = rowAddr + (long)columnWidth;
            while (rowAddr < rowEndPos) {
                if (unsafe.getByte(rowAddr) != unsafe.getByte(columnAddr)) {
                    return -1;
                }
                ++rowAddr;
                ++columnAddr;
            }
            return 0;
        }

        private final int compareCharBytes(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, long targetColumnAddr, int targetWidth) {
            block5: {
                long rowColumnAddr;
                int shorter;
                block4: {
                    int n = shorter = columnWidth < targetWidth ? columnWidth : targetWidth;
                    if (this.compareBytes(unsafe, memAddr, columnOffset, shorter, targetColumnAddr) == -1) {
                        return -1;
                    }
                    if (columnWidth >= targetWidth) break block4;
                    long targetEndPos = targetColumnAddr + (long)targetWidth;
                    targetColumnAddr += (long)shorter;
                    while (targetColumnAddr < targetEndPos) {
                        if (unsafe.getByte(targetColumnAddr) != 32) {
                            return -1;
                        }
                        ++targetColumnAddr;
                    }
                    break block5;
                }
                if (columnWidth <= targetWidth) break block5;
                long rowColumnEnd = rowColumnAddr + (long)columnWidth - (long)shorter;
                for (rowColumnAddr = memAddr + (long)columnOffset + (long)shorter; rowColumnAddr < rowColumnEnd; ++rowColumnAddr) {
                    if (unsafe.getByte(rowColumnAddr) == 32) continue;
                    return -1;
                }
            }
            return 0;
        }

        @Override
        public final int handleNull(OffHeapByteSource columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            if (targetOffsetFromMap < 0) {
                int bytesLen = columnBytes.getLength();
                long memAddr = columnBytes.getUnsafeAddress(0, bytesLen);
                int offsetOffset = bytesLen + targetOffsetFromMap;
                int offset = targetFormat.readVarDataOffset(UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, offsetOffset);
                if (offset < 0 && !targetFormat.isVarDataOffsetDefaultToken(offset)) {
                    return 0;
                }
            } else if (targetOffsetFromMap == 0 && cd.columnDefault == null) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int handleDefault(OffHeapByteSource columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            if (targetOffsetFromMap < 0) {
                int bytesLen = columnBytes.getLength();
                long memAddr = columnBytes.getUnsafeAddress(0, bytesLen);
                int offsetOffset = bytesLen + targetOffsetFromMap;
                int offset = targetFormat.readVarDataOffset(UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, offsetOffset);
                if (targetFormat.isVarDataOffsetDefaultToken(offset)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public final int handleFixed(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, OffHeapByteSource columnBytes, int pos, RowFormatter formatter, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            int targetWidth = targetFormat.columns[targetIndex].fixedWidth;
            if (columnWidth == targetWidth) {
                long columnAddr = columnBytes.getUnsafeAddress(targetOffsetFromMap, columnWidth);
                return this.compareBytes(unsafe, memAddr, columnOffset, columnWidth, columnAddr);
            }
            return -1;
        }

        @Override
        public final int handleVariable(UnsafeWrapper unsafe, long memAddr, int columnOffset, int columnWidth, OffHeapByteSource columnBytes, int pos, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            ColumnDescriptor targetCD;
            int bytesLen = columnBytes.getLength();
            long targetMemAddr = columnBytes.getUnsafeAddress(0, bytesLen);
            long offsetAndWidth = targetFormat.getOffsetAndWidth(targetIndex, unsafe, targetMemAddr, bytesLen, targetOffsetFromMap, targetCD = targetFormat.columns[targetIndex]);
            if (offsetAndWidth >= 0L) {
                int targetWidth = (int)(offsetAndWidth & 0xFFFFFFFFL);
                if (columnWidth == targetWidth) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareBytes(unsafe, memAddr, columnOffset, columnWidth, targetMemAddr + (long)targetOffset);
                }
                int typeId = cd.getType().getTypeId().getTypeFormatId();
                if (typeId == 13 || typeId == 5 || typeId == 27) {
                    int targetOffset = (int)(offsetAndWidth >>> 32);
                    return this.compareCharBytes(unsafe, memAddr, columnOffset, columnWidth, targetMemAddr + (long)targetOffset, targetWidth);
                }
            }
            return -1;
        }

        @Override
        public final int handleLob(UnsafeWrapper unsafe, long memAddr, OffHeapByteSource output, int outputPosition, RowFormatter formatter, ColumnDescriptor cd, int colIndex, RowFormatter targetFormat, int targetIndex, int targetOffsetFromMap) {
            throw new UnsupportedOperationException("not expected to be invoked for cd " + cd);
        }
    };

    private RegionEntryUtils() {
    }

    private static final boolean isValueToken(Object value) {
        if (Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
            return Token.isInvalidOrRemoved((Object)value);
        }
        return Token.isInvalidOrRemoved((Object)value) || value == Token.NOT_AVAILABLE;
    }

    public static Object getValue(LocalRegion region, RegionEntry entry) {
        Object value = entry.getValue((RegionEntryContext)RegionEntryUtils.getDataRegion(region, entry));
        if (!RegionEntryUtils.isValueToken(value)) {
            return value;
        }
        return null;
    }

    public static Object getValueWithoutFaultIn(LocalRegion region, RegionEntry entry) {
        Object value = entry.getValueOffHeapOrDiskWithoutFaultIn(RegionEntryUtils.getDataRegion(region, entry));
        if (!RegionEntryUtils.isValueToken(value)) {
            return value;
        }
        return null;
    }

    public static Object getValueWithoutFaultInOrOffHeapEntry(LocalRegion region, RowLocation entry) {
        Object value = entry.getValueWithoutFaultInOrOffHeapEntry(region);
        if (!RegionEntryUtils.isValueToken(value)) {
            return value;
        }
        return null;
    }

    public static Object getValueOrOffHeapEntry(LocalRegion region, RowLocation entry) {
        Object value = entry.getValueOrOffHeapEntry(region);
        if (!RegionEntryUtils.isValueToken(value)) {
            return value;
        }
        return null;
    }

    private static LocalRegion getDataRegion(LocalRegion region, RegionEntry entry) {
        if (region == null || region.getPartitionAttributes() == null) {
            return region;
        }
        PartitionedRegion pr = (PartitionedRegion)region;
        if (region.getPartitionAttributes().getPartitionResolver() == null) {
            int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Object)entry.getKey());
            return RegionEntryUtils.getBucketRegion(pr, bucketId);
        }
        Assert.fail((Object)("unexpected call to getDataRegion for " + region + ", entry: " + entry));
        return null;
    }

    public static Object getByteSource(RowLocation rowLocation, GemFireContainer container, boolean faultIn, boolean valueInVMOnly) {
        LocalRegion localRgn = null;
        if (container != null) {
            localRgn = container.getRegion();
            if (!valueInVMOnly && container.isPartitioned()) {
                localRgn = RegionEntryUtils.getBucketRegion((PartitionedRegion)localRgn, rowLocation.getBucketID());
            }
        }
        return RegionEntryUtils.convertOffHeapEntrytoByteSourceRetain((RegionEntry)rowLocation, localRgn, faultIn, valueInVMOnly);
    }

    public static Object getValueInVM(RegionEntry entry, RegionEntryContext context) {
        Object value = entry.getValueInVM(context);
        if (!RegionEntryUtils.isValueToken(value)) {
            return value;
        }
        return null;
    }

    public static Object getValue(GemFireContainer baseContainer, int bucketId, RegionEntry entry) throws BucketMovedException {
        assert (bucketId != -1) : "The bucket ID should not be -1: " + baseContainer;
        PartitionedRegion pr = (PartitionedRegion)baseContainer.getRegion();
        return RegionEntryUtils.getValue((LocalRegion)RegionEntryUtils.getBucketRegion(pr, bucketId), entry);
    }

    public static Object getValueWithoutFaultIn(GemFireContainer baseContainer, int bucketId, RegionEntry entry) {
        assert (bucketId != -1) : "The bucket ID should not be -1: " + baseContainer;
        PartitionedRegion pr = (PartitionedRegion)baseContainer.getRegion();
        return RegionEntryUtils.getValueWithoutFaultIn((LocalRegion)RegionEntryUtils.getBucketRegion(pr, bucketId), entry);
    }

    public static DataValueDescriptor getDVDFromValue(Object val, int validColumn, GemFireContainer gfContainer) {
        RowFormatter rf = gfContainer.getCurrentRowFormatter();
        assert (val != null) : "the value is supposed to be non-null!";
        try {
            Class<?> cls = val.getClass();
            if (cls == byte[].class) {
                return rf.getColumn(validColumn, (byte[])val);
            }
            if (cls == byte[][].class) {
                return rf.getColumn(validColumn, (byte[][])val);
            }
            if (cls == OffHeapRow.class) {
                return rf.getColumn(validColumn, (OffHeapRow)((Object)val));
            }
            if (cls == OffHeapRowWithLobs.class) {
                return rf.getColumn(validColumn, (OffHeapRowWithLobs)((Object)val));
            }
            if (cls == DataValueDescriptor[].class) {
                return ((DataValueDescriptor[])val)[validColumn - 1];
            }
            throw new AssertionError((Object)("Unexpected value type: " + val.getClass().getName()));
        }
        catch (StandardException ex) {
            LogWriter logger = Misc.getCacheLogWriter();
            if (logger.warningEnabled()) {
                logger.warning("Got exception while getting DVD from value", (Throwable)ex);
            }
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception while getting DVD from value", ex);
        }
    }

    public static DataValueDescriptor[] getDVDArrayFromValue(Object val, int[] validColumns, GemFireContainer gfContainer) {
        DataValueDescriptor[] dvdarr;
        block10: {
            RowFormatter rf = gfContainer.getCurrentRowFormatter();
            int length = validColumns == null ? rf.getNumColumns() : validColumns.length;
            dvdarr = new DataValueDescriptor[length];
            assert (val != null) : "the value is supposed to be non-null!";
            try {
                Class<?> cls = val.getClass();
                if (cls == byte[].class) {
                    rf.getColumns((byte[])val, dvdarr, validColumns);
                    break block10;
                }
                if (cls == byte[][].class) {
                    rf.getColumns((byte[][])val, dvdarr, validColumns);
                    break block10;
                }
                if (cls == OffHeapRow.class) {
                    rf.getColumns((OffHeapRow)((Object)val), dvdarr, validColumns);
                    break block10;
                }
                if (cls == OffHeapRowWithLobs.class) {
                    rf.getColumns((OffHeapRowWithLobs)((Object)val), dvdarr, validColumns);
                    break block10;
                }
                if (cls == DataValueDescriptor[].class) {
                    DataValueDescriptor[] valarr = (DataValueDescriptor[])val;
                    for (int i = 0; i < validColumns.length; ++i) {
                        dvdarr[i] = valarr[validColumns[i] - 1];
                    }
                    break block10;
                }
                throw new AssertionError((Object)("Unexpected value type: " + val.getClass().getName()));
            }
            catch (StandardException ex) {
                LogWriter logger = Misc.getCacheLogWriter();
                if (logger.warningEnabled()) {
                    logger.warning("Got exception while getting DVD[] from value", (Throwable)ex);
                }
                throw GemFireXDRuntimeException.newRuntimeException("unexpected exception while getting DVD[] from value", ex);
            }
        }
        return dvdarr;
    }

    public static final BucketRegion getBucketRegion(PartitionedRegion pr, int bucketId) throws BucketMovedException {
        ProxyBucketRegion pbr = pr.getRegionAdvisor().getProxyBucketArray()[bucketId];
        BucketRegion br = pbr.getCreatedBucketRegion();
        if (br != null) {
            return br;
        }
        throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), bucketId, pr.getFullPath());
    }

    public static ExecRow getRow(GemFireContainer baseContainer, LocalRegion region, RegionEntry entry, ExtraTableInfo tableInfo) {
        Object value = RegionEntryUtils.getValueOrOffHeapEntry(RegionEntryUtils.getDataRegion(region, entry), (RowLocation)entry);
        if (value != null) {
            return baseContainer.newExecRow(value, tableInfo, true);
        }
        return null;
    }

    public static ExecRow getRow(GemFireContainer baseContainer, int bucketId, RegionEntry entry, ExtraTableInfo tableInfo) {
        assert (bucketId != -1) : "The bucket ID should not be -1: " + baseContainer;
        PartitionedRegion pr = (PartitionedRegion)baseContainer.getRegion();
        Object value = RegionEntryUtils.getValueOrOffHeapEntry((LocalRegion)RegionEntryUtils.getBucketRegion(pr, bucketId), (RowLocation)entry);
        if (value != null) {
            return baseContainer.newExecRow(value, tableInfo, true);
        }
        return null;
    }

    public static ExecRow getRowWithoutFaultIn(GemFireContainer baseContainer, LocalRegion region, RegionEntry entry, ExtraTableInfo tableInfo) {
        Object value = RegionEntryUtils.getValueWithoutFaultInOrOffHeapEntry(RegionEntryUtils.getDataRegion(region, entry), (RowLocation)entry);
        if (value != null) {
            return baseContainer.newExecRow(value, tableInfo, false);
        }
        return null;
    }

    public static ExecRow getRowWithoutFaultIn(GemFireContainer baseContainer, int bucketId, RegionEntry entry, ExtraTableInfo tableInfo) {
        assert (bucketId != -1) : "The bucket ID should not be -1: " + baseContainer;
        PartitionedRegion pr = (PartitionedRegion)baseContainer.getRegion();
        Object value = RegionEntryUtils.getValueWithoutFaultInOrOffHeapEntry((LocalRegion)RegionEntryUtils.getBucketRegion(pr, bucketId), (RowLocation)entry);
        if (value != null) {
            return baseContainer.newExecRow(value, tableInfo, false);
        }
        return null;
    }

    public static Object convertOffHeapEntrytoByteSourceRetain(RegionEntry offheap, LocalRegion rgn, boolean faultIn, boolean useValueInVMOnly) {
        Object obj = null;
        obj = useValueInVMOnly ? offheap.getValueInVM(null) : (faultIn ? offheap.getValue((RegionEntryContext)rgn) : offheap.getValueOffHeapOrDiskWithoutFaultIn(rgn));
        if (!RegionEntryUtils.isValueToken(obj)) {
            if (!(obj instanceof SimpleMemoryAllocatorImpl.DataAsAddress)) {
                return obj;
            }
            return RegionEntryUtils.encodedAddressToObject(((SimpleMemoryAllocatorImpl.DataAsAddress)obj).getEncodedAddress());
        }
        return null;
    }

    public static Object convertLOBAddresstoByteSourceNoRetain(long ohAddress) {
        Object obj = null;
        if (OffHeapRegionEntryHelper.isOffHeap((long)ohAddress)) {
            return OffHeapRow.TYPE.newChunk(ohAddress);
        }
        obj = RegionEntryUtils.encodedAddressToObject(ohAddress);
        if (!RegionEntryUtils.isValueToken(obj)) {
            return obj;
        }
        return null;
    }

    public static byte[] convertLOBAddresstoBytes(UnsafeWrapper unsafe, long ohAddress) {
        if (OffHeapRegionEntryHelper.isOffHeap((long)ohAddress)) {
            return OffHeapRow.getBaseRowBytes(unsafe, OffHeapByteSource.getBaseDataAddress((long)ohAddress), OffHeapByteSource.getDataSize((UnsafeWrapper)unsafe, (long)ohAddress));
        }
        return OffHeapRegionEntryHelper.encodedAddressToExpectedRawBytes((long)ohAddress, (boolean)true);
    }

    public static void serializeLOBAddresstoBytes(UnsafeWrapper unsafe, long ohAddress, DataOutput out) throws IOException {
        if (OffHeapRegionEntryHelper.isOffHeap((long)ohAddress)) {
            OffHeapRow.serializeBaseRowBytes(unsafe, OffHeapByteSource.getBaseDataAddress((long)ohAddress), OffHeapByteSource.getDataSize((UnsafeWrapper)unsafe, (long)ohAddress), out);
        } else {
            InternalDataSerializer.writeByteArray((byte[])OffHeapRegionEntryHelper.encodedAddressToExpectedRawBytes((long)ohAddress, (boolean)true), (DataOutput)out);
        }
    }

    private static Object encodedAddressToObject(long address) {
        return OffHeapRegionEntryHelper.encodedAddressToObject((long)address, (boolean)false, (boolean)true);
    }

    public static AbstractCompactExecRow fillRowWithoutFaultIn(GemFireContainer baseContainer, LocalRegion region, RegionEntry entry, AbstractCompactExecRow row) throws StandardException {
        Object value = RegionEntryUtils.getValueWithoutFaultInOrOffHeapEntry(region, (RowLocation)entry);
        if (value != null) {
            Class<?> valClass = value.getClass();
            if (valClass == byte[].class) {
                RegionEntryUtils.fillRowUsingByteArray(baseContainer, row, (byte[])value);
            } else if (valClass == byte[][].class) {
                RegionEntryUtils.fillRowUsingByteArrayArray(baseContainer, row, (byte[][])value);
            } else if (value == Token.NOT_AVAILABLE && Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
                Object containerInfo = entry.getContainerInfo();
                ExtraTableInfo tableInfo = containerInfo != null ? (ExtraTableInfo)containerInfo : baseContainer.getExtraTableInfo();
                int[] keyColumns = tableInfo.getPrimaryKeyColumns();
                if (keyColumns != null) {
                    RowFormatter kf = tableInfo.getPrimaryKeyFormatter();
                    RowFormatter rf = row.getRowFormatter();
                    Object key = entry.getRawKey();
                    if (key != null) {
                        byte[] newRow = key.getClass() == byte[].class ? rf.copyColumns(keyColumns, false, (byte[])key, kf) : rf.copyColumns(keyColumns, false, (OffHeapByteSource)((Object)key), kf);
                        row.setRowArray(newRow, rf);
                    }
                } else {
                    row.resetRowArray();
                }
            } else if (OffHeapRegionEntry.class.isAssignableFrom(valClass)) {
                AbstractCompactExecRow filledRow = RegionEntryUtils.fillRowUsingAddress(baseContainer, region, (OffHeapRegionEntry)entry, row, false);
                if (filledRow == null) {
                    return null;
                }
            } else {
                if (Delta.class.isAssignableFrom(valClass)) {
                    return null;
                }
                GemFireXDUtils.throwAssert("fillRow:: unexpected value type: " + valClass.getName());
            }
            return row;
        }
        return null;
    }

    private static void fillRowUsingByteArray(GemFireContainer baseContainer, AbstractCompactExecRow row, byte[] value) {
        RowFormatter rf = baseContainer.getRowFormatter(value);
        if (!rf.hasLobs()) {
            row.setRowArray(value, rf);
        } else {
            row.setRowArray(rf.createByteArraysWithDefaultLobs(value), rf);
        }
    }

    private static void fillRowUsingByteArrayArray(GemFireContainer baseContainer, AbstractCompactExecRow row, byte[][] value) {
        RowFormatter rf = baseContainer.getRowFormatter(value[0]);
        if (rf.hasLobs()) {
            row.setRowArray(value, rf);
        } else {
            row.setRowArray(value[0], rf);
        }
    }

    private static AbstractCompactExecRow fillRowUsingAddress(GemFireContainer baseContainer, LocalRegion region, OffHeapRegionEntry entry, AbstractCompactExecRow row, boolean faultIn) {
        SimpleMemoryAllocatorImpl.setReferenceCountOwner((Object)row);
        Object source = RegionEntryUtils.convertOffHeapEntrytoByteSourceRetain((RegionEntry)entry, region, faultIn, false);
        SimpleMemoryAllocatorImpl.setReferenceCountOwner(null);
        if (source == null) {
            return null;
        }
        RowFormatter rf = baseContainer.getRowFormatter(source);
        row.setByteSource(source, rf);
        return row;
    }

    public static int getBucketId(Object b) {
        if (b.getClass() == PlaceHolderDiskRegion.class) {
            return PartitionedRegionHelper.getBucketId((String)((PlaceHolderDiskRegion)b).getName());
        }
        return ((Bucket)b).getId();
    }

    private static void getFixedAndVarColumns(RowFormatter pkrf, TIntArrayList fixedCols, TIntArrayList varCols) {
        int[] positionMap = pkrf.positionMap;
        for (int i = 0; i < positionMap.length; ++i) {
            ColumnDescriptor cd = pkrf.getColumnDescriptor(i);
            if (cd.isLob) continue;
            if (positionMap[i] < 0 && cd.fixedWidth == -1) {
                varCols.add(i + 1);
                continue;
            }
            if (positionMap[i] < 0 || cd.fixedWidth == -1) continue;
            fixedCols.add(i + 1);
        }
    }

    public static final int entryHashCode(byte[] key, byte[] vbytes, OffHeapByteSource bs, ExtraInfo tableInfo) throws IllegalAccessException {
        if (key != null) {
            RowFormatter pkrf;
            int hash = 0;
            boolean needSpacePadding = false;
            boolean varcharTrimmed = false;
            if (tableInfo != null && (pkrf = tableInfo.getPrimaryKeyFormatter()) != null) {
                int width;
                int offsetFromMap;
                int keyIndex;
                TIntArrayList fixedCols = new TIntArrayList(pkrf.getNumColumns());
                TIntArrayList varCols = new TIntArrayList(pkrf.getNumColumns());
                RegionEntryUtils.getFixedAndVarColumns(pkrf, fixedCols, varCols);
                int[] fixedColumnPositions = null;
                int[] varColumnPositions = null;
                if (fixedCols.size() > 0) {
                    fixedColumnPositions = fixedCols.toNativeArray();
                }
                if (varCols.size() > 0) {
                    varColumnPositions = varCols.toNativeArray();
                }
                int varOffset = 0;
                if (fixedColumnPositions != null) {
                    for (int index = 0; index < fixedColumnPositions.length; ++index) {
                        keyIndex = fixedColumnPositions[index] - 1;
                        offsetFromMap = pkrf.positionMap[keyIndex];
                        width = pkrf.getColumnDescriptor((int)keyIndex).fixedWidth;
                        hash = ResolverUtils.addBytesToHash((byte[])key, (int)offsetFromMap, (int)width, (int)hash);
                        varOffset += width;
                    }
                }
                if (varColumnPositions != null) {
                    int numVarWidths = varColumnPositions.length;
                    int[] varOffsets = new int[numVarWidths];
                    for (int index = 0; index < numVarWidths; ++index) {
                        keyIndex = varColumnPositions[index] - 1;
                        offsetFromMap = pkrf.positionMap[keyIndex];
                        assert (offsetFromMap <= 0) : "unexpected offsetFromMap=" + offsetFromMap;
                        if (offsetFromMap < 0) {
                            long offsetAndWidth = pkrf.getOffsetAndWidth(keyIndex, key, offsetFromMap, pkrf.columns[keyIndex]);
                            if (offsetAndWidth >= 0L) {
                                int idx = 0;
                                int offset = (int)(offsetAndWidth >>> 32);
                                width = (int)(offsetAndWidth & 0xFFFFFFFFL);
                                int typeId = pkrf.getColumnDescriptor(keyIndex).getType().getTypeId().getTypeFormatId();
                                if (typeId == 13) {
                                    for (idx = offset + width - 1; idx >= offset && key[idx] == 32; --idx) {
                                    }
                                    hash = ResolverUtils.addBytesToHash((byte[])key, (int)offset, (int)(idx + 1 - offset), (int)hash);
                                    varcharTrimmed = true;
                                } else {
                                    hash = ResolverUtils.addBytesToHash((byte[])key, (int)offset, (int)width, (int)hash);
                                }
                                if (typeId == 5 || typeId == 27) {
                                    int maxWidth = pkrf.getColumnDescriptor(keyIndex).getType().getMaximumWidth();
                                    if (width < maxWidth) {
                                        needSpacePadding = true;
                                    }
                                    while (width++ < maxWidth) {
                                        hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                                    }
                                    --width;
                                }
                                varOffsets[index] = varOffset;
                                if (typeId == 13) {
                                    varOffset += idx + 1 - offset;
                                    continue;
                                }
                                varOffset += width;
                                continue;
                            }
                            if (offsetAndWidth == -7L) {
                                varOffsets[index] = pkrf.getNullIndicator(varOffset);
                                continue;
                            }
                            assert (offsetAndWidth == -6L);
                            varOffsets[index] = pkrf.offsetIsDefault;
                            continue;
                        }
                        varOffsets[index] = pkrf.offsetIsDefault;
                    }
                    int offsetBytes = pkrf.offsetBytes;
                    for (int index = 0; index < numVarWidths; ++index) {
                        hash = RegionEntryUtils.computeIntHash(varOffsets[index], offsetBytes, hash);
                    }
                }
            }
            if (needSpacePadding || varcharTrimmed) {
                return hash;
            }
            return ResolverUtils.addBytesToHash((byte[])key, (int)0);
        }
        if (tableInfo != null && tableInfo.regionKeyPartOfValue()) {
            if (vbytes != null) {
                return RegionEntryUtils.entryValueHashCode(vbytes, tableInfo);
            }
            if (bs != null) {
                return RegionEntryUtils.entryValueHashCode(bs, tableInfo);
            }
            throw new IllegalAccessException("key and value both invalid");
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entryHashCode");
    }

    private static final int entryValueHashCode(byte[] vbytes, ExtraInfo tableInfo) {
        int width;
        int offsetFromMap;
        int keyIndex;
        int hash = 0;
        int[] fixedColumnPositions = tableInfo.getPrimaryKeyFixedColumns();
        int[] varColumnPositions = tableInfo.getPrimaryKeyVarColumns();
        RowFormatter rf = tableInfo.getRowFormatter(vbytes);
        int varOffset = 0;
        if (fixedColumnPositions != null) {
            for (int index = 0; index < fixedColumnPositions.length; ++index) {
                keyIndex = fixedColumnPositions[index] - 1;
                offsetFromMap = rf.positionMap[keyIndex];
                assert (offsetFromMap > 0) : "unexpected offsetFromMap=" + offsetFromMap;
                width = rf.getColumnDescriptor((int)keyIndex).fixedWidth;
                hash = ResolverUtils.addBytesToHash((byte[])vbytes, (int)offsetFromMap, (int)width, (int)hash);
                varOffset += width;
            }
        }
        if (varColumnPositions != null) {
            int numVarWidths = varColumnPositions.length;
            int[] varOffsets = new int[numVarWidths];
            RowFormatter pkrf = tableInfo.getPrimaryKeyFormatter();
            for (int index = 0; index < numVarWidths; ++index) {
                keyIndex = varColumnPositions[index] - 1;
                offsetFromMap = rf.positionMap[keyIndex];
                assert (offsetFromMap <= 0) : "unexpected offsetFromMap=" + offsetFromMap;
                if (offsetFromMap < 0) {
                    long offsetAndWidth = rf.getOffsetAndWidth(keyIndex, vbytes, offsetFromMap, rf.columns[keyIndex]);
                    if (offsetAndWidth >= 0L) {
                        int varCharWidth = 0;
                        int offset = (int)(offsetAndWidth >>> 32);
                        width = (int)(offsetAndWidth & 0xFFFFFFFFL);
                        int typeId = rf.getColumnDescriptor(keyIndex).getType().getTypeId().getTypeFormatId();
                        if (typeId == 13) {
                            int idx;
                            for (idx = offset + width - 1; idx >= offset && vbytes[idx] == 32; --idx) {
                            }
                            varCharWidth = idx + 1 - offset;
                            hash = ResolverUtils.addBytesToHash((byte[])vbytes, (int)offset, (int)varCharWidth, (int)hash);
                        } else {
                            hash = ResolverUtils.addBytesToHash((byte[])vbytes, (int)offset, (int)width, (int)hash);
                        }
                        if (typeId == 5 || typeId == 27) {
                            int maxWidth = rf.getColumnDescriptor(keyIndex).getType().getMaximumWidth();
                            while (width++ < maxWidth) {
                                hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                            }
                            --width;
                        }
                        varOffsets[index] = varOffset;
                        if (typeId == 13) {
                            varOffset += varCharWidth;
                            continue;
                        }
                        varOffset += width;
                        continue;
                    }
                    if (offsetAndWidth == -7L) {
                        varOffsets[index] = rf.getNullIndicator(varOffset);
                        continue;
                    }
                    assert (offsetAndWidth == -6L);
                    varOffsets[index] = pkrf.offsetIsDefault;
                    continue;
                }
                varOffsets[index] = pkrf.offsetIsDefault;
            }
            int offsetBytes = pkrf.offsetBytes;
            for (int index = 0; index < numVarWidths; ++index) {
                hash = RegionEntryUtils.computeIntHash(varOffsets[index], offsetBytes, hash);
            }
        }
        return hash;
    }

    private static final int entryValueHashCode(OffHeapByteSource bs, ExtraInfo tableInfo) {
        int width;
        int offsetFromMap;
        int keyIndex;
        int hash = 0;
        int[] fixedColumnPositions = tableInfo.getPrimaryKeyFixedColumns();
        int[] varColumnPositions = tableInfo.getPrimaryKeyVarColumns();
        RowFormatter rf = tableInfo.getRowFormatter(bs);
        int varOffset = 0;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bs.getLength();
        long memAddr = bs.getUnsafeAddress(0, bytesLen);
        if (fixedColumnPositions != null) {
            for (int index = 0; index < fixedColumnPositions.length; ++index) {
                keyIndex = fixedColumnPositions[index] - 1;
                offsetFromMap = rf.positionMap[keyIndex];
                assert (offsetFromMap > 0) : "unexpected offsetFromMap=" + offsetFromMap;
                width = rf.getColumnDescriptor((int)keyIndex).fixedWidth;
                hash = ServerResolverUtils.addBytesToHash(unsafe, memAddr + (long)offsetFromMap, width, hash);
                varOffset += width;
            }
        }
        if (varColumnPositions != null) {
            int numVarWidths = varColumnPositions.length;
            int[] varOffsets = new int[numVarWidths];
            RowFormatter pkrf = tableInfo.getPrimaryKeyFormatter();
            for (int index = 0; index < numVarWidths; ++index) {
                keyIndex = varColumnPositions[index] - 1;
                offsetFromMap = rf.positionMap[keyIndex];
                assert (offsetFromMap <= 0) : "unexpected offsetFromMap=" + offsetFromMap;
                if (offsetFromMap < 0) {
                    long offsetAndWidth = rf.getOffsetAndWidth(keyIndex, unsafe, memAddr, bytesLen, offsetFromMap, rf.columns[keyIndex]);
                    if (offsetAndWidth >= 0L) {
                        int varCharWidth = 0;
                        int offset = (int)(offsetAndWidth >>> 32);
                        width = (int)(offsetAndWidth & 0xFFFFFFFFL);
                        int typeId = rf.getColumnDescriptor(keyIndex).getType().getTypeId().getTypeFormatId();
                        if (typeId == 13) {
                            long memOffset = memAddr + (long)offset;
                            varCharWidth = RegionEntryUtils.getVarLengthWithWhiteSpaceTruncated(unsafe, memOffset, width);
                            hash = ServerResolverUtils.addBytesToHash(unsafe, memOffset, varCharWidth, hash);
                        } else {
                            hash = ServerResolverUtils.addBytesToHash(unsafe, memAddr + (long)offset, width, hash);
                        }
                        if (typeId == 5 || typeId == 27) {
                            int maxWidth = rf.getColumnDescriptor(keyIndex).getType().getMaximumWidth();
                            while (width++ < maxWidth) {
                                hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                            }
                            --width;
                        }
                        varOffsets[index] = varOffset;
                        if (typeId == 13) {
                            varOffset += varCharWidth;
                            continue;
                        }
                        varOffset += width;
                        continue;
                    }
                    if (offsetAndWidth == -7L) {
                        varOffsets[index] = rf.getNullIndicator(varOffset);
                        continue;
                    }
                    assert (offsetAndWidth == -6L);
                    varOffsets[index] = pkrf.offsetIsDefault;
                    continue;
                }
                varOffsets[index] = pkrf.offsetIsDefault;
            }
            int offsetBytes = pkrf.offsetBytes;
            for (int index = 0; index < numVarWidths; ++index) {
                hash = RegionEntryUtils.computeIntHash(varOffsets[index], offsetBytes, hash);
            }
        }
        return hash;
    }

    private static int getVarLengthWithWhiteSpaceTruncated(UnsafeWrapper unsafe, long memOffset, int width) {
        long memIdx;
        for (memIdx = memOffset + (long)width - 1L; memIdx >= memOffset && unsafe.getByte(memIdx) == 32; --memIdx) {
        }
        return (int)(memIdx + 1L - memOffset);
    }

    public static final int entryKeySizeInBytes(Object key, Object vbytes, ExtraInfo tableInfo) {
        if (key != null) {
            Class<?> keyClass = key.getClass();
            if (keyClass == byte[].class) {
                byte[] kbytes = (byte[])key;
                return ReflectionSingleObjectSizer.OBJECT_SIZE + kbytes.length + ReflectionSingleObjectSizer.REFERENCE_SIZE;
            }
            if (keyClass == CompactCompositeRegionKey.class) {
                return (int)((CompactCompositeRegionKey)key).estimateMemoryUsage();
            }
            if (keyClass == Long.class) {
                return 8 + ReflectionSingleObjectSizer.OBJECT_SIZE;
            }
            if (keyClass == CompositeRegionKey.class) {
                return (int)((CompositeRegionKey)key).estimateMemoryUsage();
            }
            GemFireXDUtils.throwAssert("entryKeySizeInBytes:: unexpected key type: " + keyClass.getName());
        }
        if (tableInfo != null) {
            if (vbytes != null) {
                byte[] bytes;
                Class<?> vclass = vbytes.getClass();
                if (vclass == byte[].class) {
                    bytes = (byte[])vbytes;
                } else if (vclass == byte[][].class) {
                    bytes = ((byte[][])vbytes)[0];
                } else {
                    OffHeapByteSource bs = (OffHeapByteSource)((Object)vbytes);
                    RowFormatter rf = tableInfo.getRowFormatter(bs);
                    return ReflectionSingleObjectSizer.OBJECT_SIZE + rf.getColumnsWidth(bs, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), tableInfo.getPrimaryKeyFormatter()) + ReflectionSingleObjectSizer.REFERENCE_SIZE;
                }
                RowFormatter rf = tableInfo.getRowFormatter(bytes);
                return ReflectionSingleObjectSizer.OBJECT_SIZE + rf.getColumnsWidth(bytes, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), tableInfo.getPrimaryKeyFormatter()) + ReflectionSingleObjectSizer.REFERENCE_SIZE;
            }
            return -1;
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entryKeySizeInBytes");
    }

    public static final DataValueDescriptor entryKeyColumn(byte[] kbytes, Object vbytes, ExtraInfo tableInfo, int index) {
        if (tableInfo != null) {
            try {
                if (kbytes != null) {
                    RowFormatter rf = tableInfo.getPrimaryKeyFormatter();
                    return rf.getColumn(index + 1, kbytes);
                }
                if (vbytes != null) {
                    int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                    Class<?> vclass = vbytes.getClass();
                    if (vclass == byte[].class) {
                        byte[] bytes = (byte[])vbytes;
                        RowFormatter rf = tableInfo.getRowFormatter(bytes);
                        return rf.getColumn(keyPositions[index], bytes);
                    }
                    if (vclass == byte[][].class) {
                        byte[] bytes = ((byte[][])vbytes)[0];
                        RowFormatter rf = tableInfo.getRowFormatter(bytes);
                        return rf.getColumn(keyPositions[index], bytes);
                    }
                    if (vclass == OffHeapRow.class) {
                        OffHeapRow bs = (OffHeapRow)((Object)vbytes);
                        RowFormatter rf = tableInfo.getRowFormatter(bs);
                        return rf.getColumn(keyPositions[index], bs);
                    }
                    OffHeapRowWithLobs bs = (OffHeapRowWithLobs)((Object)vbytes);
                    RowFormatter rf = tableInfo.getRowFormatter(bs);
                    return rf.getColumn(keyPositions[index], bs);
                }
                return null;
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("entryKeyColumn: unexpected exception", se);
            }
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entryKeyColumn");
    }

    public static final boolean entrySetKeyColumn(DataValueDescriptor dvd, byte[] kbytes, Object vbytes, ExtraInfo tableInfo, int index) {
        if (tableInfo != null) {
            try {
                if (kbytes != null) {
                    RowFormatter rf = tableInfo.getPrimaryKeyFormatter();
                    rf.setDVDColumn(dvd, index, kbytes);
                    return true;
                }
                if (vbytes != null) {
                    int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                    Class<?> vclass = vbytes.getClass();
                    if (vclass == byte[].class) {
                        byte[] bytes = (byte[])vbytes;
                        RowFormatter rf = tableInfo.getRowFormatter(bytes);
                        rf.setDVDColumn(dvd, keyPositions[index] - 1, bytes);
                    } else if (vclass == OffHeapRow.class) {
                        OffHeapRow bs = (OffHeapRow)((Object)vbytes);
                        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                        int bytesLen = bs.getLength();
                        long memAddr = bs.getUnsafeAddress(0, bytesLen);
                        RowFormatter rf = tableInfo.getRowFormatter(unsafe, memAddr, bs);
                        rf.setDVDColumn(dvd, keyPositions[index] - 1, unsafe, memAddr, bytesLen, bs);
                    } else {
                        OffHeapRowWithLobs bs = (OffHeapRowWithLobs)((Object)vbytes);
                        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                        int bytesLen = bs.getLength();
                        long memAddr = bs.getUnsafeAddress(0, bytesLen);
                        RowFormatter rf = tableInfo.getRowFormatter(unsafe, memAddr, bs);
                        rf.setDVDColumn(dvd, keyPositions[index] - 1, unsafe, memAddr, bytesLen, bs);
                    }
                    return true;
                }
                return false;
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("entryKeyColumn: unexpected exception", se);
            }
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entrySetKeyColumn");
    }

    public static final boolean entryKeyColumns(byte[] kbytes, Object vbytes, ExtraInfo tableInfo, DataValueDescriptor[] keys) {
        if (tableInfo != null) {
            try {
                if (kbytes != null) {
                    RowFormatter rf = tableInfo.getPrimaryKeyFormatter();
                    for (int index = 0; index < keys.length; ++index) {
                        DataValueDescriptor dvd = rf.getColumn(index + 1, kbytes);
                        if (keys[index] == null) {
                            keys[index] = dvd;
                            continue;
                        }
                        keys[index].setValue(dvd);
                    }
                } else if (vbytes != null) {
                    int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                    Class<?> vclass = vbytes.getClass();
                    if (vclass == byte[].class) {
                        byte[] bytes = (byte[])vbytes;
                        RowFormatter rf = tableInfo.getRowFormatter(bytes);
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], bytes);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                    } else if (vclass == byte[][].class) {
                        byte[] bytes = ((byte[][])vbytes)[0];
                        RowFormatter rf = tableInfo.getRowFormatter(bytes);
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], bytes);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                    } else if (vclass == OffHeapRow.class) {
                        OffHeapRow bs = (OffHeapRow)((Object)vbytes);
                        RowFormatter rf = tableInfo.getRowFormatter(bs);
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], bs);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                    } else {
                        OffHeapRowWithLobs bs = (OffHeapRowWithLobs)((Object)vbytes);
                        RowFormatter rf = tableInfo.getRowFormatter(bs);
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], bs);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                    }
                } else {
                    return false;
                }
                return true;
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("entryKeyColumns: unexpected exception", se);
            }
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entryKeyColumns");
    }

    public static final DataValueDescriptor entryKeyColumn(Object key, Object value, ExtraInfo tableInfo, int index) {
        if (tableInfo != null) {
            try {
                Class<?> keyClass;
                if (key != null) {
                    keyClass = key.getClass();
                    if (keyClass == byte[].class) {
                        RowFormatter rf = tableInfo.getPrimaryKeyFormatter();
                        byte[] kbytes = (byte[])key;
                        return rf.getColumn(index + 1, kbytes);
                    }
                    if (key instanceof CompactCompositeKey) {
                        return ((CompactCompositeKey)key).getKeyColumn(index);
                    }
                } else {
                    if (value != null) {
                        Class<?> valClass = value.getClass();
                        if (valClass == byte[].class) {
                            byte[] heapValue = (byte[])value;
                            RowFormatter rf = tableInfo.getRowFormatter(heapValue);
                            int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                            return rf.getColumn(keyPositions[index], heapValue);
                        }
                        if (valClass == byte[][].class) {
                            byte[] heapValue = ((byte[][])value)[0];
                            RowFormatter rf = tableInfo.getRowFormatter(heapValue);
                            int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                            return rf.getColumn(keyPositions[index], heapValue);
                        }
                        if (valClass == OffHeapRow.class) {
                            OffHeapRow ohValue = (OffHeapRow)((Object)value);
                            RowFormatter rf = tableInfo.getRowFormatter(ohValue);
                            int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                            return rf.getColumn(keyPositions[index], ohValue);
                        }
                        if (valClass == OffHeapRowWithLobs.class) {
                            OffHeapRowWithLobs ohValue = (OffHeapRowWithLobs)((Object)value);
                            RowFormatter rf = tableInfo.getRowFormatter(ohValue);
                            int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                            return rf.getColumn(keyPositions[index], ohValue);
                        }
                        if (RegionEntryUtils.isValueToken(value)) {
                            return null;
                        }
                        GemFireXDUtils.throwAssert("entryKeyColumn:: unexpected value type: " + valClass.getName());
                    }
                    return null;
                }
                GemFireXDUtils.throwAssert("entryKeyColumn:: unexpected key type: " + keyClass.getName());
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("entryKeyColumn: unexpected exception", se);
            }
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entryKeyColumn");
    }

    public static final boolean entryKeyColumns(Object key, Object value, ExtraInfo tableInfo, DataValueDescriptor[] keys) {
        if (tableInfo != null) {
            try {
                if (key != null) {
                    Class<?> keyClass = key.getClass();
                    if (keyClass == byte[].class) {
                        byte[] kbytes = (byte[])key;
                        assert (kbytes != null) : "unexpected null kbytes";
                        RowFormatter rf = tableInfo.getPrimaryKeyFormatter();
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(index + 1, kbytes);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                    } else if (key instanceof CompactCompositeKey) {
                        ((CompactCompositeKey)key).getKeyColumns(keys);
                    } else {
                        GemFireXDUtils.throwAssert("entryKeyColumns:: unexpected key type: " + keyClass.getName());
                    }
                    return true;
                }
                if (value != null) {
                    Class<?> valClass = value.getClass();
                    if (valClass == byte[].class) {
                        byte[] heapValue = (byte[])value;
                        RowFormatter rf = tableInfo.getRowFormatter(heapValue);
                        int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], heapValue);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                        return true;
                    }
                    if (valClass == byte[][].class) {
                        byte[] heapValue = ((byte[][])value)[0];
                        RowFormatter rf = tableInfo.getRowFormatter(heapValue);
                        int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], heapValue);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                        return true;
                    }
                    if (valClass == OffHeapRow.class) {
                        OffHeapRow ohValue = (OffHeapRow)((Object)value);
                        RowFormatter rf = tableInfo.getRowFormatter(ohValue);
                        int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], ohValue);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                        return true;
                    }
                    if (valClass == OffHeapRowWithLobs.class) {
                        OffHeapRowWithLobs ohValue = (OffHeapRowWithLobs)((Object)value);
                        RowFormatter rf = tableInfo.getRowFormatter(ohValue);
                        int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = rf.getColumn(keyPositions[index], ohValue);
                            if (keys[index] == null) {
                                keys[index] = dvd;
                                continue;
                            }
                            keys[index].setValue(dvd);
                        }
                        return true;
                    }
                    if (RegionEntryUtils.isValueToken(value)) {
                        return false;
                    }
                }
                return false;
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("entryKeyColumns: unexpected exception", se);
            }
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("entryKeyColumns");
    }

    public static final void entryKeyString(Object key, Object value, ExtraInfo tableInfo, StringBuilder sb) {
        try {
            if (tableInfo != null) {
                if (tableInfo.regionKeyPartOfValue()) {
                    int nCols = tableInfo.getPrimaryKeyColumns().length;
                    assert (nCols > 0) : "unexpected zero nCols";
                    sb.append('(');
                    if (nCols == 1) {
                        DataValueDescriptor dvd = RegionEntryUtils.entryKeyColumn(key, value, tableInfo, 0);
                        sb.append(dvd);
                    } else {
                        DataValueDescriptor[] keys = new DataValueDescriptor[nCols];
                        RegionEntryUtils.entryKeyColumns(key, value, tableInfo, keys);
                        for (int index = 0; index < keys.length; ++index) {
                            DataValueDescriptor dvd = keys[index];
                            if (index > 0) {
                                sb.append(',');
                            }
                            sb.append("element[").append(index).append("]=").append(dvd);
                        }
                    }
                    sb.append(')');
                } else if (key instanceof byte[]) {
                    sb.append(Arrays.toString((byte[])key));
                } else {
                    sb.append(key);
                }
            } else if (key instanceof byte[]) {
                sb.append(Arrays.toString((byte[])key));
            } else {
                sb.append(key);
            }
        }
        catch (Throwable e) {
            sb.append("RegionEntryUtils::entryKeyString:Exception in getting String for the entry. ExceptionString = ");
            sb.append(e.toString());
            sb.append(";value = ");
            ArrayUtils.objectString((Object)value);
        }
    }

    public static final Object entryGetRegionKey(Object key, Object value) {
        if (key != null && key.getClass() == CompactCompositeRegionKey.class) {
            CompactCompositeRegionKey ccrk;
            byte[] keyBytes;
            if (value != null) {
                Class<?> valClass = value.getClass();
                if (valClass == byte[].class || valClass == byte[][].class) {
                    return null;
                }
                if (OffHeapByteSource.isOffHeapBytesClass(valClass) || valClass == SimpleMemoryAllocatorImpl.DataAsAddress.class) {
                    return null;
                }
            }
            if ((keyBytes = (ccrk = (CompactCompositeRegionKey)key).getKeyBytes()) != null) {
                return keyBytes;
            }
        }
        return key;
    }

    public static final ExtraTableInfo entryGetTableInfo(Object owner, Object key, Object value) {
        GemFireContainer container;
        if (owner instanceof LocalRegion && (container = (GemFireContainer)((LocalRegion)owner).getUserAttribute()) != null) {
            return container.getExtraTableInfo(value);
        }
        if (key != null && key.getClass() == CompactCompositeRegionKey.class) {
            return ((CompactCompositeRegionKey)key).getTableInfo();
        }
        return null;
    }

    public static final RuntimeException checkCacheForNullTableInfo(String method) {
        Misc.checkIfCacheClosing(null);
        return new GemFireXDRuntimeException(method + ": tableInfo should be non-null by this time");
    }

    public static final RuntimeException checkCacheForNullKeyValue(String method) {
        Misc.checkIfCacheClosing(null);
        return new GemFireXDRuntimeException(method + ": either key or value should be valid by this time");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean entryEqualsCCKey(byte[] kbytes, Object value, ExtraInfo tableInfo, CompactCompositeKey other) throws IllegalAccessException {
        int tries = 1;
        do {
            byte[] otherKbytes;
            if ((otherKbytes = other.getKeyBytes()) != null) return Arrays.equals(kbytes, otherKbytes);
            ExtraInfo otherTableInfo = other.tableInfo;
            if (otherTableInfo == null) throw RegionEntryUtils.checkCacheForNullTableInfo("equals");
            Object otherVbytes = other.getValueByteSource();
            if (otherVbytes != null) {
                byte[] vbytes;
                Class<?> vclass = otherVbytes.getClass();
                if (vclass == byte[].class) {
                    vbytes = (byte[])otherVbytes;
                    return RegionEntryUtils.compareRowBytesToKeyBytes(vbytes, otherTableInfo.getRowFormatter(vbytes), kbytes, tableInfo.getPrimaryKeyFormatter(), tableInfo.getPrimaryKeyColumns());
                } else if (vclass == byte[][].class) {
                    vbytes = ((byte[][])otherVbytes)[0];
                    return RegionEntryUtils.compareRowBytesToKeyBytes(vbytes, otherTableInfo.getRowFormatter(vbytes), kbytes, tableInfo.getPrimaryKeyFormatter(), tableInfo.getPrimaryKeyColumns());
                } else {
                    OffHeapByteSource vbs = (OffHeapByteSource)((Object)otherVbytes);
                    try {
                        boolean bl = RegionEntryUtils.compareRowBytesToKeyBytes(vbs, otherTableInfo.getRowFormatter(vbs), kbytes, tableInfo.getPrimaryKeyFormatter(), tableInfo.getPrimaryKeyColumns());
                        return bl;
                    }
                    finally {
                        vbs.release();
                    }
                }
            }
            gfxdSystemCallbacks.entryCheckValue(value);
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("RegionEntryUtils#entryEqualsCCKey");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean entryEqualsKey(Object key, Object value, byte[] vbytes, OffHeapByteSource vbs, ExtraInfo tableInfo, CompactCompositeKey other) throws IllegalAccessException {
        ExtraInfo otherTableInfo = other.tableInfo;
        if (key != null) {
            Class<?> keyClass = key.getClass();
            if (keyClass == byte[].class) {
                return RegionEntryUtils.entryEqualsCCKey((byte[])key, value, otherTableInfo, other);
            }
            if (keyClass == CompactCompositeRegionKey.class || keyClass == Long.class || keyClass == CompositeRegionKey.class) {
                return key.equals(other);
            }
            GemFireXDUtils.throwAssert("entryEqualsKey:: unexpected key type: " + keyClass.getName());
            throw RegionEntryUtils.checkCacheForNullKeyValue("RegionEntryUtils#entryEqualsKey");
        }
        int tries = 1;
        do {
            byte[] otherKbytes = other.getKeyBytes();
            if (vbytes == null && vbs == null) {
                if (value != null) {
                    Class<?> valClass = value.getClass();
                    if (valClass == byte[].class) {
                        vbytes = (byte[])value;
                    } else if (valClass == byte[][].class) {
                        vbytes = ((byte[][])value)[0];
                    } else if (OffHeapByteSource.isOffHeapBytesClass(valClass)) {
                        vbs = (OffHeapByteSource)((Object)value);
                    } else if (valClass == SimpleMemoryAllocatorImpl.DataAsAddress.class) {
                        vbytes = (byte[])RegionEntryUtils.encodedAddressToObject(((SimpleMemoryAllocatorImpl.DataAsAddress)value).getEncodedAddress());
                    } else {
                        if (RegionEntryUtils.isValueToken(value)) {
                            throw new IllegalAccessException("key and value both invalid");
                        }
                        GemFireXDUtils.throwAssert("entryEqualsKey:: unexpected value type: " + valClass.getName());
                    }
                } else {
                    throw new IllegalAccessException("key and value both invalid");
                }
            }
            if (otherKbytes != null) {
                if (vbs == null) {
                    return RegionEntryUtils.compareRowBytesToKeyBytes(vbytes, tableInfo.getRowFormatter(vbytes), otherKbytes, otherTableInfo.getPrimaryKeyFormatter(), otherTableInfo.getPrimaryKeyColumns());
                }
                return RegionEntryUtils.compareRowBytesToKeyBytes(vbs, tableInfo.getRowFormatter(vbs), otherKbytes, otherTableInfo.getPrimaryKeyFormatter(), otherTableInfo.getPrimaryKeyColumns());
            }
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            Object otherVbytes = other.getValueByteSource();
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            if (otherVbytes != null) {
                try {
                    Object typedOtherVbytes;
                    RowFormatter rf;
                    if (otherTableInfo == null) {
                        throw RegionEntryUtils.checkCacheForNullTableInfo("entryEqualsKey");
                    }
                    int[] keyPositions = tableInfo.getPrimaryKeyColumns();
                    RowFormatter rowFormatter = rf = vbytes != null ? tableInfo.getRowFormatter(vbytes) : tableInfo.getRowFormatter(vbs);
                    if (otherVbytes.getClass() == byte[].class) {
                        typedOtherVbytes = (byte[])otherVbytes;
                        RowFormatter otherFormatter = other.tableInfo.getRowFormatter((byte[])typedOtherVbytes);
                        if (vbs == null) {
                            for (int index = 0; index < keyPositions.length; ++index) {
                                int keyIndex = keyPositions[index] - 1;
                                if (rf.processColumn(vbytes, keyIndex, checkColumnEqualityWithRow, typedOtherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
                                boolean bl = false;
                                return bl;
                            }
                        } else {
                            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                            int bytesLen = vbs.getLength();
                            long memAddr = vbs.getUnsafeAddress(0, bytesLen);
                            for (int index = 0; index < keyPositions.length; ++index) {
                                int keyIndex = keyPositions[index] - 1;
                                if (rf.processColumn(unsafe, memAddr, bytesLen, keyIndex, checkColumnEqualityWithRowOffHeap, typedOtherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
                                boolean bl = false;
                                return bl;
                            }
                        }
                    } else {
                        typedOtherVbytes = (OffHeapByteSource)((Object)otherVbytes);
                        RowFormatter otherFormatter = other.tableInfo.getRowFormatter((OffHeapByteSource)((Object)typedOtherVbytes));
                        if (vbytes != null) {
                            for (int index = 0; index < keyPositions.length; ++index) {
                                int keyIndex = keyPositions[index] - 1;
                                if (rf.processColumn(vbytes, keyIndex, checkOffHeapColumnEqualityWithRow, typedOtherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
                                boolean bytesLen = false;
                                return bytesLen;
                            }
                        } else {
                            UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                            int bytesLen = vbs.getLength();
                            long memAddr = vbs.getUnsafeAddress(0, bytesLen);
                            for (int index = 0; index < keyPositions.length; ++index) {
                                int keyIndex = keyPositions[index] - 1;
                                if (rf.processColumn(unsafe, memAddr, bytesLen, keyIndex, checkOffHeapColumnEqualityWithRowOffHeap, typedOtherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    SimpleMemoryAllocatorImpl.skipRefCountTracking();
                    other.releaseValueByteSource(otherVbytes);
                    SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                }
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("RegionEntryUtils#entryEqualsKey");
    }

    private static final boolean entryEqualsInternal(Object key, Object value, byte[] vbytes, OffHeapByteSource vbs, ExtraTableInfo tableInfo, RegionEntry entry, Object other, Class<?> otherClass) throws IllegalAccessException {
        if (otherClass == CompactCompositeRegionKey.class) {
            return RegionEntryUtils.entryEqualsKey(key, value, vbytes, vbs, tableInfo, (CompactCompositeRegionKey)other);
        }
        if (RegionKey.class.isAssignableFrom(otherClass) || RegionEntry.class.isAssignableFrom(otherClass)) {
            return false;
        }
        if (otherClass != WrapperRowLocationForTxn.class) {
            Assert.fail((Object)("unknown object compared in entryEquals: " + other + ", type=" + otherClass.getName()));
        }
        return false;
    }

    private static final boolean entryEqualsKeyBytes(byte[] key, Object value, ExtraTableInfo tableInfo, Object other, Class<?> otherClass) throws IllegalAccessException {
        if (otherClass == CompactCompositeRegionKey.class) {
            return RegionEntryUtils.entryEqualsCCKey(key, value, tableInfo, (CompactCompositeRegionKey)other);
        }
        if (RegionKey.class.isAssignableFrom(otherClass) || RegionEntry.class.isAssignableFrom(otherClass)) {
            return false;
        }
        if (otherClass != WrapperRowLocationForTxn.class) {
            Assert.fail((Object)("unknown object compared in entryEquals: " + other + ", type=" + otherClass.getName()));
        }
        return false;
    }

    private static final int computeIntHash(int intValue, int numBytesToBeWritten, int hash) {
        int i = 0;
        while (i < numBytesToBeWritten) {
            hash = ResolverUtils.addByteToHash((byte)((byte)intValue), (int)hash);
            ++i;
            intValue >>>= 8;
        }
        return hash;
    }

    static final boolean compareRowBytesToKeyBytes(byte[] rowBytes, RowFormatter rowFormat, byte[] keyBytes, RowFormatter keyFormat, int[] keyPositions) {
        for (int index = 0; index < keyPositions.length; ++index) {
            if (rowFormat.processColumn(rowBytes, keyPositions[index] - 1, checkColumnEqualityWithRow, keyBytes, -1, keyFormat, index) >= 0) continue;
            return false;
        }
        return true;
    }

    static final boolean compareRowBytesToKeyBytes(OffHeapByteSource bs, RowFormatter rowFormat, byte[] keyBytes, RowFormatter keyFormat, int[] keyPositions) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = bs.getLength();
        long memAddr = bs.getUnsafeAddress(0, bytesLen);
        for (int index = 0; index < keyPositions.length; ++index) {
            if (rowFormat.processColumn(unsafe, memAddr, bytesLen, keyPositions[index] - 1, checkColumnEqualityWithRowOffHeap, keyBytes, -1, keyFormat, index) >= 0) continue;
            return false;
        }
        return true;
    }

    static final boolean compareValueBytesToValueBytes(RowFormatter rf, int[] keyPositions, byte[] vbytes, byte[] otherVbytes, RowFormatter otherFormatter) {
        for (int index = 0; index < keyPositions.length; ++index) {
            int keyIndex = keyPositions[index] - 1;
            if (rf.processColumn(vbytes, keyIndex, checkColumnEqualityWithRow, otherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
            return false;
        }
        return true;
    }

    static final boolean compareValueBytesToValueBytes(RowFormatter rf, int[] keyPositions, OffHeapByteSource vbytes, byte[] otherVbytes, RowFormatter otherFormatter) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = vbytes.getLength();
        long memAddr = vbytes.getUnsafeAddress(0, bytesLen);
        for (int index = 0; index < keyPositions.length; ++index) {
            int keyIndex = keyPositions[index] - 1;
            if (rf.processColumn(unsafe, memAddr, bytesLen, keyIndex, checkColumnEqualityWithRowOffHeap, otherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
            return false;
        }
        return true;
    }

    static final boolean compareValueBytesToValueBytes(RowFormatter rf, int[] keyPositions, byte[] vbytes, OffHeapByteSource otherVbytes, RowFormatter otherFormatter) {
        for (int index = 0; index < keyPositions.length; ++index) {
            int keyIndex = keyPositions[index] - 1;
            if (rf.processColumn(vbytes, keyIndex, checkOffHeapColumnEqualityWithRow, otherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
            return false;
        }
        return true;
    }

    static final boolean compareValueBytesToValueBytes(RowFormatter rf, int[] keyPositions, OffHeapByteSource vbytes, OffHeapByteSource otherVbytes, RowFormatter otherFormatter) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int bytesLen = vbytes.getLength();
        long memAddr = vbytes.getUnsafeAddress(0, bytesLen);
        for (int index = 0; index < keyPositions.length; ++index) {
            int keyIndex = keyPositions[index] - 1;
            if (rf.processColumn(unsafe, memAddr, bytesLen, keyIndex, checkOffHeapColumnEqualityWithRowOffHeap, otherVbytes, -1, otherFormatter, keyIndex) >= 0) continue;
            return false;
        }
        return true;
    }
}

