/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.cache.SortedIndexKey;
import com.gemstone.gemfire.internal.concurrent.AtomicUpdaterFactory;
import com.gemstone.gemfire.internal.concurrent.SkipListNode;
import com.gemstone.gemfire.internal.concurrent.SkipListNodeFactory;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraIndexInfo;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CompactCompositeIndexKey
extends CompactCompositeKey
implements SkipListNode<Object, Object>,
SortedIndexKey {
    private static final long serialVersionUID = -5414797179905848493L;
    private volatile Object mapValue;
    private volatile CompactCompositeIndexKey next;
    private volatile int version;
    private static final AtomicReferenceFieldUpdater<CompactCompositeIndexKey, Object> valueUpdater = AtomicUpdaterFactory.newReferenceFieldUpdater(CompactCompositeIndexKey.class, Object.class, (String)"mapValue");
    private static final AtomicReferenceFieldUpdater<SkipListNode, SkipListNode> nextUpdater = AtomicUpdaterFactory.newReferenceFieldUpdater(CompactCompositeIndexKey.class, CompactCompositeIndexKey.class, (String)"next");
    private static final AtomicIntegerFieldUpdater<CompactCompositeIndexKey> versionUpdater = AtomicUpdaterFactory.newIntegerFieldUpdater(CompactCompositeIndexKey.class, (String)"version");

    public CompactCompositeIndexKey(Object value, ExtraIndexInfo tabInfo) {
        super(value, (ExtraInfo)tabInfo);
    }

    public CompactCompositeIndexKey(DataValueDescriptor[] value, ExtraIndexInfo tabInfo) throws StandardException {
        super(value, (ExtraInfo)tabInfo);
    }

    public CompactCompositeIndexKey(ExtraIndexInfo tabInfo, DataValueDescriptor[] key) throws StandardException {
        super(tabInfo, tabInfo.getPrimaryKeyFormatter().generateBytes(key));
    }

    public CompactCompositeIndexKey(ExtraIndexInfo tabInfo, byte[] indexKeyBytes) {
        super(tabInfo, indexKeyBytes);
    }

    public final ExtraIndexInfo getIndexInfo() {
        return (ExtraIndexInfo)this.tableInfo;
    }

    @Override
    public final byte[] getKeyBytes() {
        return (byte[])super.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLength() {
        int tries = 1;
        do {
            byte[] kbytes;
            if ((kbytes = (byte[])super.get()) != null) {
                return kbytes.length;
            }
            ExtraIndexInfo indexInfo = this.getIndexInfo();
            if (indexInfo != null) {
                Object vbytes = this.getValueByteSource();
                if (vbytes != null) {
                    if (vbytes.getClass() == byte[].class) {
                        byte[] vbs = (byte[])vbytes;
                        RowFormatter rf = indexInfo.getRowFormatter(vbs);
                        return rf.getColumnsWidth(vbs, indexInfo.getPrimaryKeyFixedColumns(), indexInfo.getPrimaryKeyVarColumns(), indexInfo.getPrimaryKeyFormatter());
                    }
                    OffHeapByteSource vbs = (OffHeapByteSource)((Object)vbytes);
                    try {
                        RowFormatter rf = indexInfo.getRowFormatter(vbs);
                        int n = rf.getColumnsWidth(vbs, indexInfo.getPrimaryKeyFixedColumns(), indexInfo.getPrimaryKeyVarColumns(), indexInfo.getPrimaryKeyFormatter());
                        return n;
                    }
                    finally {
                        vbs.release();
                    }
                }
            } else {
                throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeIndexKey#getLength");
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeIndexKey#getLength");
    }

    @Override
    public long estimateMemoryUsage() {
        byte[] kbytes = (byte[])super.get();
        int bytesLen = kbytes != null ? kbytes.length : 0;
        return bytesLen + ReflectionSingleObjectSizer.OBJECT_SIZE + ReflectionSingleObjectSizer.REFERENCE_SIZE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Object getValueByteSource() {
        Object retVal = null;
        int tries = 1;
        do {
            if ((retVal = super.getValueByteSource()) == null) return null;
            Class<?> valClass = retVal.getClass();
            if (valClass == byte[].class) {
                return retVal;
            }
            if (!OffHeapByteSource.isOffHeapBytesClass(valClass)) return retVal;
            OffHeapByteSource bs = (OffHeapByteSource)((Object)retVal);
            if (bs.retain()) {
                Object currentVal = super.getValueByteSource();
                if (currentVal != null && bs.equals(currentVal)) {
                    return retVal;
                }
                if (currentVal == null) {
                    bs.release();
                    return null;
                }
                bs.release();
            } else {
                byte[] keyBytes = this.getKeyBytes();
                if (keyBytes != null) {
                    this.compareAndSetValueBytes(retVal, null);
                }
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        Misc.checkIfCacheClosing(null);
        throw new IllegalStateException("Unable to retain byte source=" + retVal + " for index key ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean equalsValueBytes(Object otherVBytes) {
        ExtraIndexInfo indexInfo = this.getIndexInfo();
        if (indexInfo != null) {
            int[] keyPositions = indexInfo.getPrimaryKeyColumns();
            int tries = 1;
            do {
                RowFormatter otherFormatter;
                OffHeapByteSource oVbs;
                byte[] oVbytes;
                byte[] kbytes = this.getKeyBytes();
                if (otherVBytes == null || otherVBytes.getClass() == byte[].class) {
                    oVbytes = (byte[])otherVBytes;
                    oVbs = null;
                    otherFormatter = indexInfo.getRowFormatter(oVbytes);
                } else {
                    oVbytes = null;
                    oVbs = (OffHeapByteSource)((Object)otherVBytes);
                    otherFormatter = indexInfo.getRowFormatter(oVbs);
                }
                if (kbytes != null) {
                    RowFormatter keyFormatter = this.getKeyFormatter();
                    if (oVbytes != null) {
                        return RegionEntryUtils.compareRowBytesToKeyBytes(oVbytes, otherFormatter, kbytes, keyFormatter, keyPositions);
                    }
                    return RegionEntryUtils.compareRowBytesToKeyBytes(oVbs, otherFormatter, kbytes, keyFormatter, keyPositions);
                }
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                Object vbs = this.getValueByteSource();
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                if (vbs != null) {
                    if (vbs.getClass() == byte[].class) {
                        byte[] vbytes = (byte[])vbs;
                        RowFormatter rf = indexInfo.getRowFormatter(vbytes);
                        if (oVbs == null) {
                            return RegionEntryUtils.compareValueBytesToValueBytes(rf, keyPositions, vbytes, oVbytes, otherFormatter);
                        }
                        return RegionEntryUtils.compareValueBytesToValueBytes(rf, keyPositions, vbytes, oVbs, otherFormatter);
                    }
                    OffHeapByteSource vbytes = (OffHeapByteSource)((Object)vbs);
                    try {
                        RowFormatter rf = indexInfo.getRowFormatter(vbytes);
                        if (oVbs == null) {
                            boolean bl = RegionEntryUtils.compareValueBytesToValueBytes(rf, keyPositions, vbytes, oVbytes, otherFormatter);
                            return bl;
                        }
                        boolean bl = RegionEntryUtils.compareValueBytesToValueBytes(rf, keyPositions, vbytes, oVbs, otherFormatter);
                        return bl;
                    }
                    finally {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        vbytes.release();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                }
                if (tries % 1000 != 0) continue;
                Thread.yield();
            } while (tries++ <= 10000000);
            throw new IllegalStateException("Unable to obtain either key bytes or value bytes from the CCIK for ccik = " + this);
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeIndexKey#equalsValueBytes(Object)");
    }

    private CompactCompositeIndexKey(SkipListNode<Object, Object> next) {
        super((Object)null, (ExtraInfo)null);
        this.mapValue = this;
        this.next = (CompactCompositeIndexKey)next;
    }

    public final Object getMapKey() {
        return this.tableInfo != null ? this : null;
    }

    public final Object getMapValue() {
        return this.mapValue;
    }

    public final Object getValidValue() {
        Object v = this.mapValue;
        if (v != this && v != BASE_HEADER) {
            return v;
        }
        return null;
    }

    public final SkipListNode<Object, Object> getNext() {
        return this.next;
    }

    public final void setNext(SkipListNode<Object, Object> next) {
        this.next = (CompactCompositeIndexKey)next;
    }

    public final boolean casValue(Object cmp, Object val) {
        versionUpdater.incrementAndGet(this);
        return valueUpdater.compareAndSet(this, cmp, val);
    }

    public final boolean casNext(SkipListNode<Object, Object> cmp, SkipListNode<Object, Object> val) {
        return nextUpdater.compareAndSet(this, cmp, val);
    }

    public final int getVersion() {
        return this.version;
    }

    public final boolean isMarker() {
        return this.mapValue == this;
    }

    public final boolean isBaseHeader() {
        return this.mapValue == BASE_HEADER;
    }

    public boolean appendMarker(SkipListNode<Object, Object> f) {
        return this.casNext(f, new CompactCompositeIndexKey(f));
    }

    public void helpDelete(SkipListNode<Object, Object> bi, SkipListNode<Object, Object> fi) {
        CompactCompositeIndexKey b = (CompactCompositeIndexKey)bi;
        CompactCompositeIndexKey f = (CompactCompositeIndexKey)fi;
        if (f == this.next && this == b.next) {
            if (f == null || f.mapValue != f) {
                this.appendMarker(f);
            } else {
                b.casNext(this, f.next);
            }
        }
    }

    public AbstractMap.SimpleImmutableEntry<Object, Object> createSnapshot() {
        Object v = this.getValidValue();
        if (v != null) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(this, v);
        }
        return null;
    }

    public void setTransientValue(Object value) {
        this.mapValue = value;
    }

    public Object getTransientValue() {
        return this.mapValue;
    }

    public static SkipListNodeFactory<Object, Object> getNodeFactory() {
        return new NodeFactory();
    }

    private static final class NodeFactory
    implements SkipListNodeFactory<Object, Object>,
    Serializable {
        private static final long serialVersionUID = 3441201286289347935L;

        private NodeFactory() {
        }

        public SkipListNode<Object, Object> newNode(Object key, Object value, SkipListNode<Object, Object> next) {
            CompactCompositeIndexKey ccik = key != null ? (CompactCompositeIndexKey)key : new CompactCompositeIndexKey((Object)null, (ExtraIndexInfo)null);
            ccik.mapValue = value;
            ccik.next = (CompactCompositeIndexKey)next;
            return ccik;
        }
    }
}

