/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.EmptyRegionFunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.AckResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryStreamingResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.StatementCloseExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.PrepStatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractGemFireDistributionActivation
extends AbstractGemFireActivation {
    protected final Set<DistributedMember> prepStmntAwareMembers = new THashSet();
    protected final boolean orderedReplies;
    protected final MembershipManager membershipManager;
    protected volatile long lastUpdatedViewId;
    protected THashSet staticRoutingKeys;
    protected THashSet routingKeysToExecute;
    protected long routingComputeTime;
    protected boolean isVTIInvolved;
    protected short distributionLevel = 1;
    protected GfxdFunctionMessage<Object> functionMsg;

    public AbstractGemFireDistributionActivation(ExecPreparedStatement st, LanguageConnectionContext _lcc, DMLQueryInfo qi) throws StandardException {
        super(st, _lcc, qi);
        this.orderedReplies = (qi.getQueryFlag() & 0x19) != 0 || (qi.getQueryFlag() & 2) != 0 && ((SelectQueryInfo)qi).getGroupByQI().doReGrouping();
        this.connectionID = _lcc.getConnectionId();
        this.membershipManager = Misc.getDistributedSystem().getDM().getMembershipManager();
        this.lastUpdatedViewId = this.membershipManager != null ? this.membershipManager.getViewId() : -1L;
    }

    @Override
    public final void setupActivation(ExecPreparedStatement ps, boolean scrollable, String stmt_text) throws StandardException {
        super.setupActivation(ps, scrollable, stmt_text);
        if (ps == null) {
            return;
        }
        this.isVTIInvolved = this.qInfo.isTableVTI();
        if (this.isVTIInvolved) {
            this.staticRoutingKeys = new THashSet();
            this.staticRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
        } else if (!this.qInfo.isDynamic()) {
            this.staticRoutingKeys = new THashSet();
            this.staticRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
            this.computeNodesForStaticRoutingKeys((Set<Object>)this.staticRoutingKeys);
        } else {
            this.staticRoutingKeys = null;
        }
        if (this.observer != null) {
            this.observer.afterGemFireActivationCreate(this);
        }
    }

    protected void computeNodesForStaticRoutingKeys(Set<Object> staticRoutingKeys) throws StandardException {
        DataPolicy dataPolicy = this.qInfo.getRegion().getDataPolicy();
        if (dataPolicy.withPartitioning()) {
            this.qInfo.computeNodes(staticRoutingKeys, this, false);
        } else if (dataPolicy.withStorage()) {
            throw new UnsupportedOperationException("Region handling unknown for region=" + this.qInfo.getRegion());
        }
    }

    @Override
    void invokeAfterSetupCallback() {
    }

    @Override
    protected void executeWithResultSet(AbstractGemFireResultSet rs) throws StandardException {
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"AbstractGemFireDistributionActivation#executeWithResultSet entered");
        }
        boolean needKeysForRows = false;
        boolean isOuterJoin = this.qInfo.isOuterJoin();
        GfxdDDLRegion opRgn = this.isVTIInvolved ? Misc.getMemStore().getDDLQueueNoThrow().getRegion() : this.qInfo.getRegion();
        PartitionedRegion preg = null;
        List<Region> outerTablesList = null;
        if (opRgn.getPartitionAttributes() != null) {
            preg = (PartitionedRegion)opRgn;
            if (isOuterJoin) {
                outerTablesList = this.qInfo.getOuterJoinRegions();
                Iterator<Region> itr = outerTablesList.iterator();
                if (GemFireXDUtils.TraceOuterJoin) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("AbstractGemfireDistributionActivation::executeWithResultSetopRgnName: " + opRgn.getName() + " outerTablesList's size: " + outerTablesList.size()));
                }
                if (itr.hasNext()) {
                    LocalRegion r = (LocalRegion)itr.next();
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("AbstractGemfireDistributionActivation::executeWithResultSetopRgnName: " + opRgn.getName() + " left region name is " + r));
                    }
                    if (r.getPartitionAttributes() == null) {
                        needKeysForRows = true;
                        if (GemFireXDUtils.TraceOuterJoin) {
                            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("AbstractGemfireDistributionActivation::executeWithResultSetopRgnName: " + opRgn.getName() + " left region number is " + r + " so set need keys for rows to true"));
                        }
                        this.qInfo.setOuterJoinSpecialCase();
                        if (!preg.getRegionAdvisor().hasCreatedBuckets()) {
                            opRgn = r;
                            preg = null;
                        }
                    }
                }
            }
        }
        if (GemFireXDUtils.TraceOuterJoin) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("AbstractGemfireDistributionActivation::executeWithResultSetopRgnName: " + opRgn.getName() + " isouterjoin: " + isOuterJoin + " needKeysForRows: " + needKeysForRows + " and outerTablesList: " + outerTablesList));
        }
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        String defaultSchema = lcc.getDefaultSchema().getSchemaName();
        boolean isPossibleDuplicate = lcc.isPossibleDuplicate();
        GfxdResultCollector<Object> rc = null;
        try {
            if (this.observer != null) {
                this.observer.beforeGemFireResultSetExecuteOnActivation(this);
            }
            boolean enableStreaming = this.enableStreaming(lcc);
            Object ls = null;
            try {
                if (preg != null) {
                    long newrootID = this.rootID;
                    int newstmtLevel = this.statementLevel;
                    if (newstmtLevel == 0) {
                        newstmtLevel = 1;
                        if (this.rootID == 0L) {
                            newrootID = this.statementID;
                        }
                    }
                    if (this.isPrepStmntQuery) {
                        if (this.observer != null) {
                            this.observer.beforeComputeRoutingObjects(this);
                        }
                        this.routingKeysToExecute = null;
                        if (!isOuterJoin) {
                            this.routingKeysToExecute = new THashSet();
                            if (this.qInfo.isDynamic()) {
                                this.computeNodesForDynamicRoutingKeys(this.routingKeysToExecute);
                            } else {
                                this.routingKeysToExecute.addAll((Collection)this.staticRoutingKeys);
                            }
                        }
                        if (this.observer != null) {
                            this.observer.afterComputeRoutingObjects(this);
                            this.observer.setRoutingObjectsBeforeExecution((Set<Object>)this.routingKeysToExecute);
                        }
                        if (isOuterJoin || !this.routingKeysToExecute.isEmpty()) {
                            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation::execute: Prep Statement being excecuted has conn ID = " + this.connectionID + " statement ID = " + this.statementID + " root ID = " + this.rootID + " new-root ID = " + newrootID + " orig-statementLevel = " + this.statementLevel + " new-statementLevel = " + newstmtLevel));
                            }
                            if (this.routingKeysToExecute != null && this.routingKeysToExecute.contains(ResolverUtils.TOK_ALL_NODES)) {
                                this.routingKeysToExecute = null;
                            }
                            rc = this.getResultCollector(enableStreaming, rs);
                            if (this.connectionID != -2L) {
                                rc.setResultMembers(this.prepStmntAwareMembers);
                            }
                            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                                if (!this.prepStmntAwareMembers.isEmpty()) {
                                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation::execute: Prepared statement aware members: " + this.prepStmntAwareMembers + ". Query will be sent with query string"));
                                } else {
                                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"AbstractGemFireDistributionActivation::execute: No prepared statement aware members. Query will be sent with query string");
                                }
                            }
                            this.throwIfMissingParms();
                            PrepStatementExecutorMessage<Object> prepMsg = new PrepStatementExecutorMessage<Object>((ResultCollector<Object, Object>)rc, defaultSchema, this.connectionID, this.statementID, this.executionID, newrootID, newstmtLevel, this.preStmt.getSource(), this.qInfo.isSelect(), this.qInfo.optimizeForWrite(), this.qInfo.withSecondaries(), needKeysForRows, this.qInfo.isRemoteGfxdSubActivationNeeded(), this.qInfo.isSubqueryFlatteningAllowed(), this.qInfo.isSelectForUpdateQuery() && this.qInfo.needKeysForSelectForUpdate(), this.getParameterValueSet(), (LocalRegion)preg, (Set<Object>)this.routingKeysToExecute, this.qInfo.isInsertAsSubSelect(), lcc, this.getTimeOutMillis());
                            this.functionMsg = prepMsg;
                            prepMsg.setPartitionRegions(this.qInfo.getOtherRegions());
                            if (this.qInfo.hasUnionNode() || this.qInfo.hasIntersectOrExceptNode()) {
                                this.qInfo.verifySetOperationSupported();
                                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation::execute: Handle Union, Intersect or Except  for union =" + this.qInfo.hasUnionNode() + " and intersect or except = " + this.qInfo.hasIntersectOrExceptNode()));
                                }
                                prepMsg.setHasSetOperatorNode(true, this.qInfo.hasIntersectOrExceptNode());
                            }
                            if (this.qInfo.isNCJoinOnQN()) {
                                if (GemFireXDUtils.TraceNCJ) {
                                    SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)"AbstractGemFireDistributionActivation::execute: Set Flag for Non Collocated Join ");
                                }
                                prepMsg.setNCJoinOnQN(this.qInfo.getNCJMetaData(), lcc);
                            }
                            ls = this.functionMsg.executeFunction(enableStreaming, isPossibleDuplicate, rs, this.orderedReplies);
                        }
                    } else if (isOuterJoin || this.staticRoutingKeys != null && !this.staticRoutingKeys.isEmpty() || this.qInfo.isDynamic()) {
                        this.routingKeysToExecute = null;
                        if (this.qInfo.isDynamic()) {
                            this.routingKeysToExecute = new THashSet();
                            this.computeNodesForDynamicRoutingKeys(this.routingKeysToExecute);
                        } else {
                            this.routingKeysToExecute = this.staticRoutingKeys;
                        }
                        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation::execute: Nodes to execute query using statement  = " + (isOuterJoin ? ResolverUtils.TOK_ALL_NODES : this.routingKeysToExecute)));
                        }
                        if (isOuterJoin || this.routingKeysToExecute.contains(ResolverUtils.TOK_ALL_NODES)) {
                            this.routingKeysToExecute = null;
                        }
                        rc = this.getResultCollector(enableStreaming, rs);
                        StatementExecutorMessage<Object> unprepMsg = new StatementExecutorMessage<Object>((ResultCollector<Object, Object>)rc, defaultSchema, this.connectionID, this.statementID, this.executionID, newrootID, newstmtLevel, this.preStmt.getSource(), this.qInfo.isSelect(), this.qInfo.optimizeForWrite(), this.qInfo.withSecondaries(), needKeysForRows, this.qInfo.isRemoteGfxdSubActivationNeeded(), this.qInfo.isSubqueryFlatteningAllowed(), this.qInfo.isSelectForUpdateQuery() && this.qInfo.needKeysForSelectForUpdate(), this.pvs, (LocalRegion)preg, (Set<Object>)this.routingKeysToExecute, this.qInfo.isInsertAsSubSelect(), lcc, this.getTimeOutMillis());
                        this.functionMsg = unprepMsg;
                        unprepMsg.setPartitionRegions(this.qInfo.getOtherRegions());
                        if (this.qInfo.hasUnionNode() || this.qInfo.hasIntersectOrExceptNode()) {
                            this.qInfo.verifySetOperationSupported();
                            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"AbstractGemFireDistributionActivation::execute: Handle Union, Intersect or Except ");
                            }
                            unprepMsg.setHasSetOperatorNode(true, this.qInfo.hasIntersectOrExceptNode());
                        }
                        if (this.qInfo.isNCJoinOnQN()) {
                            if (GemFireXDUtils.TraceNCJ | GemFireXDUtils.TraceNCJ) {
                                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)"AbstractGemFireDistributionActivation::execute: Set Flag for Non Collocated Join ");
                            }
                            unprepMsg.setNCJoinOnQN(this.qInfo.getNCJMetaData(), lcc);
                        }
                        ls = this.functionMsg.executeFunction(enableStreaming, isPossibleDuplicate, rs, this.orderedReplies);
                    }
                } else {
                    rc = this.getResultCollector(enableStreaming, rs);
                    ls = this.operateOnNonPartitionedRegion((LocalRegion)opRgn, rs, (ResultCollector<Object, Object>)rc, defaultSchema, needKeysForRows, enableStreaming, lcc);
                }
            }
            catch (EmptyRegionFunctionException erfe) {
                ls = null;
            }
            catch (GemFireException gfeex) {
                throw Misc.processGemFireException(gfeex, gfeex, "execution of " + this.preStmt.getSource(), true);
            }
            if (ls == null) {
                rs.setup(null, 0);
            }
            if (this.observer != null) {
                this.observer.afterGemFireResultSetExecuteOnActivation(this);
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                if (ls instanceof Collection) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation#execute: streaming=" + enableStreaming + " results list size=" + ((Collection)ls).size()));
                } else {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation#execute: streaming=" + enableStreaming + " result: " + ls));
                }
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception e) {
            throw Misc.processFunctionException("AbstractGemFireDistribution::execute", e, null, opRgn);
        }
        finally {
            this.cleanupPrepStatementAwareMemberList();
        }
    }

    private void computeNodesForDynamicRoutingKeys(THashSet routingKeysToExecute) throws StandardException {
        routingKeysToExecute.add(ResolverUtils.TOK_ALL_NODES);
        this.qInfo.computeNodes((Set<Object>)routingKeysToExecute, this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupPrepStatementAwareMemberList() {
        long viewId;
        long lastViewId = this.lastUpdatedViewId;
        if (this.membershipManager != null && (viewId = this.membershipManager.getViewId()) != lastViewId) {
            Set<DistributedMember> members;
            Set<DistributedMember> set = members = this.prepStmntAwareMembers;
            synchronized (set) {
                Set<DistributedMember> liveMembers = GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
                if (liveMembers != null) {
                    members.retainAll(liveMembers);
                } else {
                    members.clear();
                }
                this.lastUpdatedViewId = viewId;
            }
        }
    }

    protected abstract boolean enableStreaming(LanguageConnectionContext var1);

    protected GfxdResultCollector<Object> getResultCollector(boolean enableStreaming, AbstractGemFireResultSet rs) throws StandardException {
        AbstractCollection rc = enableStreaming ? new GfxdQueryStreamingResultCollector() : new GfxdQueryResultCollector();
        rs.setupRC((GfxdResultCollector<?>)((Object)rc));
        return rc;
    }

    protected final Object operateOnNonPartitionedRegion(LocalRegion rgn, AbstractGemFireResultSet rs, ResultCollector<Object, Object> rc, String defaultSchema, boolean isSpecialCaseOuterJoin, boolean enableStreaming, LanguageConnectionContext lcc) throws StandardException, SQLException {
        Object result;
        boolean isPossibleDuplicate = lcc.isPossibleDuplicate();
        boolean isForSelectForUpdateQuery = this.qInfo.isSelectForUpdateQuery();
        long newrootID = this.rootID;
        int newstmtLevel = this.statementLevel;
        if (newstmtLevel == 0) {
            newstmtLevel = 1;
            if (this.rootID == 0L) {
                newrootID = this.statementID;
            }
        }
        if (this.isPrepStmntQuery) {
            StatementStats stats = lcc.getActiveStats();
            long begin = -1L;
            if (stats != null) {
                begin = stats.getStatTime();
            }
            this.throwIfMissingParms();
            this.functionMsg = new PrepStatementExecutorMessage<Object>(rc, defaultSchema, this.connectionID, this.statementID, this.executionID, newrootID, newstmtLevel, this.preStmt.getSource(), this.qInfo.isSelect(), this.qInfo.optimizeForWrite(), this.qInfo.withSecondaries(), isSpecialCaseOuterJoin, this.qInfo.isRemoteGfxdSubActivationNeeded(), this.qInfo.isSubqueryFlatteningAllowed(), isForSelectForUpdateQuery && this.qInfo.needKeysForSelectForUpdate(), this.getParameterValueSet(), rgn, null, this.qInfo.isInsertAsSubSelect(), lcc, this.getTimeOutMillis());
            this.setAllAreNonPartitionedRegion(rs, this.isVTIInvolved);
            if (this.isVTIInvolved) {
                this.functionMsg.setSendToAllReplicates(this.includeAdminForVTI());
            }
            if (this.qInfo.hasUnionNode() || this.qInfo.hasIntersectOrExceptNode()) {
                this.qInfo.verifySetOperationSupported();
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"AbstractGemFireDistributionActivation::operateOnNonPartitionedRegion: Handle Union, Intersect or Except ");
                }
                ((RegionExecutorMessage)this.functionMsg).setHasSetOperatorNode(true, this.qInfo.hasIntersectOrExceptNode());
            }
            result = this.functionMsg.executeFunction(enableStreaming, isPossibleDuplicate, rs, this.orderedReplies);
            if (stats != null) {
                assert (begin != -1L);
                stats.incRemoteExecutionTime(begin);
                stats.incNumRemoteExecution();
            }
        } else {
            this.functionMsg = new StatementExecutorMessage<Object>(rc, defaultSchema, this.connectionID, this.statementID, this.executionID, newrootID, newstmtLevel, this.preStmt.getSource(), this.qInfo.isSelect(), this.qInfo.optimizeForWrite(), this.qInfo.withSecondaries(), isSpecialCaseOuterJoin, this.qInfo.isRemoteGfxdSubActivationNeeded(), this.qInfo.isSubqueryFlatteningAllowed(), isForSelectForUpdateQuery && this.qInfo.needKeysForSelectForUpdate(), this.pvs, rgn, null, this.qInfo.isInsertAsSubSelect(), lcc, this.getTimeOutMillis());
            this.setAllAreNonPartitionedRegion(rs, this.isVTIInvolved);
            if (this.isVTIInvolved) {
                this.functionMsg.setSendToAllReplicates(this.includeAdminForVTI());
            }
            if (this.qInfo.hasUnionNode() || this.qInfo.hasIntersectOrExceptNode()) {
                this.qInfo.verifySetOperationSupported();
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"AbstractGemFireDistributionActivation::operateOnNonPartitionedRegion: Handle Union, Intersect or Except ");
                }
                ((RegionExecutorMessage)this.functionMsg).setHasSetOperatorNode(true, this.qInfo.hasIntersectOrExceptNode());
            }
            result = this.functionMsg.executeFunction(enableStreaming, isPossibleDuplicate, rs, this.orderedReplies);
        }
        return result;
    }

    private boolean includeAdminForVTI() {
        LocalRegion r;
        return !this.qInfo.isDriverTableInitialized() || (r = this.qInfo.getRegion()) == null || r.getScope().isLocal();
    }

    private void setAllAreNonPartitionedRegion(AbstractGemFireResultSet rs, boolean isVTIInvolved) {
        boolean isValidCase;
        boolean bl = isValidCase = !isVTIInvolved;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemFireDistributionActivation::setAllAreNonPartitionedRegion: Setting flag AllTablesReplicatedOnRemote to " + isValidCase + " isVTIInvolved=" + isVTIInvolved));
        }
        ((RegionExecutorMessage)this.functionMsg).setAllTablesAreReplicatedOnRemote(isValidCase);
        rs.setAllTablesReplicatedOnRemote(isValidCase);
    }

    @Override
    public final void setIsPrepStmntQuery(boolean flag) {
        this.isPrepStmntQuery = flag;
    }

    @Override
    public final boolean getIsPrepStmntQuery() {
        return this.isPrepStmntQuery;
    }

    @Override
    public final void distributeClose() {
        block13: {
            if (this.connectionID == -1L || this.connectionID == -2L) {
                return;
            }
            try {
                DM dm;
                Set<InternalDistributedMember> members;
                GfxdDDLRegion rgn = this.isVTIInvolved ? Misc.getMemStore().getDDLQueueNoThrow().getRegion() : this.qInfo.getRegion();
                DataPolicy dp = rgn.getDataPolicy();
                if (dp.withPartitioning()) {
                    RegionAdvisor ra = ((PartitionedRegion)rgn).getRegionAdvisor();
                    members = ra.adviseGeneric();
                    dm = ra.getDistributionManager();
                } else {
                    CacheDistributionAdvisor cda = ((DistributedRegion)rgn).getCacheDistributionAdvisor();
                    members = cda.adviseReplicates();
                    dm = cda.getDistributionManager();
                }
                if (members.isEmpty()) {
                    members = Collections.singleton(dm.getDistributionManagerId());
                } else {
                    members.add(dm.getDistributionManagerId());
                }
                StatementCloseExecutorMessage msg = new StatementCloseExecutorMessage(AckResultCollector.INSTANCE, members, this.connectionID, this.statementID);
                TXStateInterface tx = TXManagerImpl.getCurrentTXState();
                msg.executeFunction(false, false, null, false, tx == null);
                if (tx != null) {
                    tx.getProxy().addPendingResultCollector(msg.getReplyProcessor());
                }
            }
            catch (RegionDestroyedException rde) {
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemfireDistributionActivation::distributeClose: RegionDestroyedException in distributing Statement.close on remote nodes for table=" + this.qInfo.getFullTableName()), (Throwable)rde);
                }
            }
            catch (EmptyRegionFunctionException rde) {
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                    SystemFailure.initiateFailure((Error)err);
                    throw err;
                }
                SystemFailure.checkFailure();
                if (SanityManager.isFinerEnabled) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("AbstractGemfireDistributionActivation::distributeClose: Exception in distributing Statement.close on remote nodes for table=" + this.qInfo.getFullTableName()), (Throwable)t);
                }
                if (GemFireXDUtils.retryToBeDone(t)) break block13;
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("AbstractGemfireDistributionActivation::distributeClose: Exception in distributing Statement.close on remote nodes for table=" + this.qInfo.getFullTableName()), (Throwable)t);
            }
        }
    }
}

