/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalExecRowLocation;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdListPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.engine.procedure.DistributedProcedureCallFunction;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.DistributedProcedureCallNode;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorContextImpl;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureResultCollector;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProxyParameterValueSet;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProxyResultDescription;
import com.pivotal.gemfirexd.internal.engine.sql.execute.FunctionUtils;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ResultSetFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameter;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRow;
import com.pivotal.gemfirexd.procedure.ProcedureResultProcessor;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProcedureProxy
implements AbstractExecution.ExecutionNodesListener {
    private final Activation activation;
    private final GeneratedMethod startKeyGetter;
    private final int startSearchOperator;
    private final GeneratedMethod stopKeyGetter;
    private int stopSearchOperator;
    private final boolean sameStartStopPosition;
    private Set<String> groups;
    private final DataValueDescriptor[] probeValues;
    private UUID tableId;
    private final long indexId;
    private final int numColumns;
    private int resultSetNumber;
    private final ResultSet[][] outResultSets;
    private final ProcedureResultProcessor prp;
    private ProcedureResultCollector prc;
    private final DistributedProcedureCallNode dnode;
    private final boolean nowait;
    private final boolean all;
    private static Pattern pattern = Pattern.compile("\\s*(?i)(table)\\s+(\\S+)(\\s+(?i)(where)\\s+(\\S+.*))?");

    public ProcedureProxy(Activation activation, int tableIdIndex, long indexId, int numColumns, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, DataValueDescriptor[] probeValues, int ordering, boolean all, int serverGroupIdx, int distributedProcNodeIdx, boolean nowait, ProcedureResultProcessor prp, ResultSet[][] dynamicResultSets) {
        this.activation = activation;
        this.tableId = tableIdIndex == -1 ? null : (UUID)this.activation.getSavedObject(tableIdIndex);
        this.indexId = indexId;
        this.numColumns = numColumns;
        this.probeValues = probeValues;
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.sameStartStopPosition = sameStartStopPosition;
        this.nowait = nowait;
        ServerGroupsTableAttribute sgtattr = (ServerGroupsTableAttribute)activation.getSavedObject(serverGroupIdx);
        if (sgtattr != null) {
            this.groups = sgtattr.getServerGroupSet();
        }
        this.dnode = (DistributedProcedureCallNode)activation.getSavedObject(distributedProcNodeIdx);
        this.prp = prp;
        this.outResultSets = dynamicResultSets;
        this.all = all;
    }

    public void execute() throws Exception {
        int numParameters;
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        Region region = null;
        String sqlText = this.activation.getPreparedStatement().getSource();
        String[] temp = sqlText.split("(?i)( WITH )|( ON )");
        String sqlTextCohort = temp[0];
        if (sqlTextCohort != null && sqlTextCohort.charAt(0) == '{') {
            sqlTextCohort = sqlTextCohort.substring(1);
        }
        String whereClause = temp[1];
        String tableName = null;
        if (temp != null) {
            for (int i = 0; i < temp.length; ++i) {
                Matcher m = pattern.matcher(temp[i]);
                if (!m.find()) continue;
                tableName = m.group(2);
                whereClause = m.group(5);
                break;
            }
        }
        int outRSNum = this.outResultSets == null ? 0 : this.outResultSets.length;
        this.prc = new ProcedureResultCollector(outRSNum, sqlTextCohort);
        String defaultSchema = lcc.getDefaultSchema().getSchemaName();
        long connId = lcc.getConnectionId();
        long timeOutMillis = this.activation.getTimeOutMillis();
        long stmtId = this.activation.getStatementID();
        Properties props = new Properties();
        props.setProperty("query-HDFS", Boolean.toString(lcc.getQueryHDFS()));
        props.setProperty("ncj-batch-size", Integer.toString(lcc.getNcjBatchSize()));
        props.setProperty("ncj-cache-size", Integer.toString(lcc.getNcjCacheSize()));
        ProcedureProcessorContextImpl ppc = new ProcedureProcessorContextImpl(lcc, this.prc, region, whereClause, this.dnode, tableName);
        this.prp.init(ppc);
        ResultSetFactory rsf = this.activation.getExecutionFactory().getResultSetFactory();
        if (!(this.activation instanceof BaseActivation)) {
            throw new AssertionError((Object)"The superclass of this activation is not BaseActivation!");
        }
        BaseActivation ba = (BaseActivation)this.activation;
        if (outRSNum > 0) {
            ProxyResultDescription[] prds = new ProxyResultDescription[outRSNum];
            ResultDescription oldRD = ba.switchResultDescription(null);
            for (int i = 0; i < outRSNum; ++i) {
                ProxyResultDescription prd;
                ResultSet[] outResultSet = this.outResultSets[i];
                assert (outResultSet.length == 1) : "the output result set is supposed to be ResultSet[1]";
                NoPutResultSet rs = rsf.getProcedureProcessorResultSet(this.activation, i, this.prp);
                prds[i] = prd = new ProxyResultDescription(true);
                ba.switchResultDescription(prd);
                rs.markAsTopResultSet();
                rs.openCore();
                outResultSet[0] = ppc.getResultSet(rs);
            }
            ba.switchResultDescription(oldRD);
            this.prc.setProxyResultDescritptions(prds);
        }
        THashSet routingObjects = new THashSet();
        DataValueDescriptor[] inParameters = null;
        int[][] parameterInfo = null;
        GenericParameterValueSet pvs = (GenericParameterValueSet)this.activation.getParameterValueSet();
        if (pvs != null && (numParameters = pvs.getParameterCount()) > 0) {
            inParameters = new DataValueDescriptor[numParameters];
            parameterInfo = new int[numParameters][3];
            for (int i = 0; i < numParameters; ++i) {
                inParameters[i] = pvs.getParameter(i);
                GenericParameter gp = pvs.getGenericParameter(i);
                parameterInfo[i][0] = gp.getSQLType();
                parameterInfo[i][1] = gp.getScale();
                parameterInfo[i][2] = gp.getPrecision();
            }
        }
        boolean isPossibleDuplicate = lcc.isPossibleDuplicate();
        if (this.groups != null && this.groups.size() > 0) {
            this.callFunctionServiceOnServerGroups(sqlTextCohort, defaultSchema, connId, inParameters, parameterInfo, isPossibleDuplicate, props, timeOutMillis, stmtId);
        } else if (this.tableId != null) {
            DataDictionary db = lcc.getDataDictionary();
            TableDescriptor td = db.getTableDescriptor(this.tableId);
            region = Misc.getRegion(td, lcc, false, false);
            if (region != null && (this.startKeyGetter != null || this.stopKeyGetter != null)) {
                this.generateRoutingObjects(region, (Set<Object>)routingObjects);
            }
            if (routingObjects.size() == 0) {
                routingObjects = null;
            }
            this.callFunctionServiceOnTable(sqlTextCohort, (Set<Object>)routingObjects, region, whereClause, tableName, defaultSchema, connId, inParameters, parameterInfo, isPossibleDuplicate, props, timeOutMillis, stmtId);
        } else if (!this.all && this.tableId == null && (this.groups == null || this.groups.isEmpty())) {
            this.callFunctionServiceOnAllOrLocal(sqlTextCohort, region, whereClause, tableName, defaultSchema, connId, inParameters, parameterInfo, isPossibleDuplicate, false, props, timeOutMillis, stmtId);
        } else {
            this.callFunctionServiceOnAllOrLocal(sqlTextCohort, region, whereClause, tableName, defaultSchema, connId, inParameters, parameterInfo, isPossibleDuplicate, true, props, timeOutMillis, stmtId);
        }
        if (this.nowait) {
            this.dnode.setProcedureProxy(this);
        }
    }

    public void afterExecutionNodesSet(AbstractExecution execution) {
        this.prc.initializeResultSets(execution.getExecutionNodes());
    }

    public void reset() {
        this.prc.clearResults();
    }

    private void callFunctionServiceOnServerGroups(String sqlText, String defaultSchema, long connId, DataValueDescriptor[] parameters, int[][] parameterInfo, boolean isPossibleDuplicate, Properties props, long timeOutMillis, long stmtId) throws StandardException {
        DistributedProcedureCallFunction.DistributedProcedureCallFunctionArgs args = DistributedProcedureCallFunction.newDistributedProcedureCallFunctionArgs(sqlText, null, null, defaultSchema, connId, parameters, parameterInfo, props, timeOutMillis, stmtId);
        FunctionUtils.GfxdExecution exec = ServerGroupUtils.onServerGroups(this.groups, true);
        exec.setRequireExecutionNodes(this);
        InternalDistributedSystem iDS = Misc.getDistributedSystem();
        FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
        try {
            stats.incFunctionExecutionsRunning();
            ResultCollector<?, ?> rc = FunctionUtils.executeFunction(exec, args, "gfxd-DistributedProcedureCallFunction", sqlText, this.prc, this.nowait, isPossibleDuplicate, true, null, null);
            this.prc.setRC(rc);
            stats.decFunctionExecutionsRunning();
            stats.incFunctionExecutionsCompleted();
        }
        catch (GemFireException gfeex) {
            stats.decFunctionExecutionsRunning();
            throw Misc.processGemFireException(gfeex, gfeex, "execution of " + sqlText, true);
        }
    }

    private void callFunctionServiceOnTable(String sqlText, Set<Object> routingObjects, Region<?, ?> region, String whereClause, String tableName, String defaultSchema, long connId, DataValueDescriptor[] parameters, int[][] parameterInfo, boolean isPossibleDuplicate, Properties props, long timeOutMillis, long stmtId) throws StandardException {
        DistributedProcedureCallFunction.DistributedProcedureCallFunctionArgs args = DistributedProcedureCallFunction.newDistributedProcedureCallFunctionArgs(sqlText, whereClause, tableName, defaultSchema, connId, parameters, parameterInfo, props, timeOutMillis, stmtId);
        FunctionUtils.GfxdExecution execution = FunctionUtils.onRegion(region);
        execution.setRequireExecutionNodes(this);
        InternalDistributedSystem iDS = Misc.getDistributedSystem();
        FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
        try {
            stats.incFunctionExecutionsRunning();
            ResultCollector<?, ?> rc = FunctionUtils.executeFunction(execution, args, "gfxd-DistributedProcedureCallFunction", sqlText, this.prc, this.nowait, isPossibleDuplicate, true, null, routingObjects);
            this.prc.setRC(rc);
            stats.decFunctionExecutionsRunning();
            stats.incFunctionExecutionsCompleted();
        }
        catch (GemFireException gfeex) {
            stats.decFunctionExecutionsRunning();
            throw Misc.processGemFireException(gfeex, gfeex, "execution of " + sqlText, true);
        }
    }

    private void callFunctionServiceOnAllOrLocal(String sqlText, Region<?, ?> region, String whereClause, String tableName, String defaultSchema, long connId, DataValueDescriptor[] parameters, int[][] parameterInfo, boolean isPossibleDuplicate, boolean onAll, Properties props, long timeOutMillis, long stmtId) throws StandardException {
        DistributedProcedureCallFunction.DistributedProcedureCallFunctionArgs args = DistributedProcedureCallFunction.newDistributedProcedureCallFunctionArgs(sqlText, whereClause, tableName, defaultSchema, connId, parameters, parameterInfo, props, timeOutMillis, stmtId);
        FunctionUtils.GfxdExecution execution = region == null ? new FunctionUtils.GetMembersFunctionExecutor((DistributedSystem)Misc.getDistributedSystem(), null, true, !onAll) : FunctionUtils.onRegion(region);
        execution.setRequireExecutionNodes(this);
        InternalDistributedSystem iDS = Misc.getDistributedSystem();
        FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
        try {
            stats.incFunctionExecutionsRunning();
            ResultCollector<?, ?> rc = FunctionUtils.executeFunction(execution, args, "gfxd-DistributedProcedureCallFunction", sqlText, this.prc, this.nowait, isPossibleDuplicate, true, null, null);
            this.prc.setRC(rc);
            stats.decFunctionExecutionsRunning();
            stats.incFunctionExecutionsCompleted();
        }
        catch (GemFireException gfeex) {
            stats.decFunctionExecutionsRunning();
            throw Misc.processGemFireException(gfeex, gfeex, "execution of " + sqlText, true);
        }
    }

    protected void generateRoutingObjects(Region<?, ?> region, Set<Object> routingObjects) throws StandardException {
        GfxdPartitionResolver resolver = null;
        if (!(region instanceof PartitionedRegion)) {
            return;
        }
        resolver = (GfxdPartitionResolver)((PartitionedRegion)region).getPartitionResolver();
        assert (resolver != null) : "The resolver is not supposed to be null!";
        DataValueDescriptor[] startKey = null;
        DataValueDescriptor[] stopKey = null;
        Object retValue = null;
        retValue = this.startKeyGetter.invoke(this.activation);
        assert (retValue instanceof IndexRow) : " the key is supposed to IndexRow!";
        startKey = ((IndexRow)retValue).getRowArray();
        if (this.sameStartStopPosition) {
            stopKey = startKey;
            this.stopSearchOperator = this.startSearchOperator;
        } else {
            retValue = this.stopKeyGetter.invoke(this.activation);
            assert (retValue instanceof IndexRow) : " the key is supposed to IndexRow!";
            stopKey = ((IndexRow)retValue).getRowArray();
        }
        if (this.indexId == -1L) {
            this.searchRoutingObjectsOnPartitionColumns(this.probeValues, startKey, this.startSearchOperator, stopKey, this.stopSearchOperator, this.sameStartStopPosition, resolver, routingObjects);
        } else {
            this.searchRoutingObjectOnGlobalIndex(this.probeValues, startKey, this.startSearchOperator, stopKey, this.stopSearchOperator, this.sameStartStopPosition, routingObjects);
        }
    }

    protected void searchRoutingObjectsOnPartitionColumns(DataValueDescriptor[] probeValues, DataValueDescriptor[] startKey, int startSearchOperator, DataValueDescriptor[] stopKey, int stopSearchOperator, boolean sameStartStopPosition, GfxdPartitionResolver resolver, Set<Object> routingObjects) {
        if (probeValues == null) {
            this.generateRoutingObjectOnKeys(startKey, startSearchOperator, stopKey, stopSearchOperator, sameStartStopPosition, resolver, routingObjects);
        } else {
            for (int probeIndex = 0; probeIndex < probeValues.length; ++probeIndex) {
                startKey[0] = probeValues[probeIndex];
                stopKey[0] = probeValues[probeIndex];
                this.generateRoutingObjectOnKeys(startKey, startSearchOperator, stopKey, stopSearchOperator, sameStartStopPosition, resolver, routingObjects);
            }
        }
    }

    protected void generateRoutingObjectOnKeys(DataValueDescriptor[] startKey, int startSearchOperator, DataValueDescriptor[] stopKey, int stopSearchOperator, boolean sameStartStopPosition, GfxdPartitionResolver resolver, Set<Object> routingObjects) {
        if (resolver instanceof GfxdRangePartitionResolver) {
            boolean upperBoundInclusive;
            boolean lowerBoundInclusive = startSearchOperator == 1;
            boolean bl = upperBoundInclusive = stopSearchOperator != 1;
            assert (startKey.length > 0 && stopKey.length > 0) : "Each search key at least contains one element!";
            Object[] ros = resolver.getRoutingObjectsForRange(startKey[0], lowerBoundInclusive, stopKey[0], upperBoundInclusive);
            if (ros != null) {
                for (Object o : ros) {
                    routingObjects.add(o);
                }
            }
        } else if (resolver instanceof GfxdListPartitionResolver) {
            if (!sameStartStopPosition) {
                return;
            }
            assert (startKey.length > 0) : "Each search key at least contains one element!";
            Object[] ros = resolver.getRoutingObjectsForRange(startKey[0], true, stopKey[0], true);
            if (ros != null) {
                for (Object o : ros) {
                    routingObjects.add(o);
                }
            }
        } else if (sameStartStopPosition) {
            Object value = resolver.getRoutingObjectsForPartitioningColumns(startKey);
            routingObjects.add(value);
        }
    }

    protected void searchRoutingObjectOnGlobalIndex(DataValueDescriptor[] probeValue, DataValueDescriptor[] startKey, int startSearchOperator, DataValueDescriptor[] stopKey, int stopSearchOperator, boolean sameStartStopPosition, Set<Object> routingObjects) throws StandardException {
        GlobalExecRowLocation rowLocation = new GlobalExecRowLocation();
        DataValueDescriptor[] row = new DataValueDescriptor[this.numColumns];
        row[this.numColumns - 1] = rowLocation;
        FormatableBitSet scanColumnList = new FormatableBitSet(this.numColumns);
        scanColumnList.set(this.numColumns - 1);
        TransactionController tc = this.activation.getTransactionController();
        ScanController sc = null;
        if (this.probeValues == null) {
            sc = tc.openScan(this.indexId, false, 0, 6, 2, scanColumnList, startKey, startSearchOperator, null, stopKey, stopSearchOperator, null);
            if (sc.next()) {
                sc.fetch(row);
                Serializable routingObject = rowLocation.getRoutingObject();
                routingObjects.add(routingObject);
            }
        } else {
            for (int probeIndex = 0; probeIndex < probeValue.length; ++probeIndex) {
                startKey[0] = probeValue[probeIndex];
                stopKey[0] = probeValue[probeIndex];
                if (sc == null) {
                    sc = tc.openScan(this.indexId, false, 0, 6, 2, scanColumnList, startKey, startSearchOperator, null, stopKey, stopSearchOperator, null);
                } else {
                    sc.reopenScan(startKey, startSearchOperator, null, stopKey, stopSearchOperator, null);
                }
                if (!sc.next()) continue;
                sc.fetch(row);
                Serializable routingObject = rowLocation.getRoutingObject();
                routingObjects.add(routingObject);
            }
        }
    }

    public void setProxyParameterValueSet() {
        GenericParameterValueSet gpvs = (GenericParameterValueSet)this.activation.getParameterValueSet();
        ProxyParameterValueSet proxyPVS = new ProxyParameterValueSet(this.activation, gpvs, this.prp);
        ((BaseActivation)this.activation).setProxyParameterValueSet(proxyPVS);
    }
}

