/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.locks.DLockLogWriter;
import com.gemstone.gemfire.distributed.internal.locks.DLockReleaseProcessor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public final class GfxdDRWLockReleaseProcessor
extends DLockReleaseProcessor {
    public GfxdDRWLockReleaseProcessor(DM dm, InternalDistributedMember member, String serviceName, Object objectName) {
        super(dm, member, serviceName, objectName);
    }

    protected static void releaseDRWLock(DM dm, String serviceName, Object objectName, Object lockOwner, LogWriterI18n log) throws ReplyException {
        Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
        InternalDistributedMember myId = dm.getDistributionManagerId();
        boolean toSelf = members.remove(myId);
        GfxdDRWLockReleaseMessage.send(dm, members, toSelf, serviceName, objectName, lockOwner, true, log);
    }

    public static final class GfxdDRWLockReleaseReplyMessage
    extends GfxdReplyMessage {
        static final int EXCEPTION = 0;
        static final int OK = 1;
        static final int NOT_HELD = 2;
        protected String serviceName;
        protected int responseCode = 0;

        @Override
        public byte getGfxdID() {
            return 7;
        }

        @Override
        public GfxdResponseCode getResponseCode() {
            return null;
        }

        public void setException(ReplyException ex) {
            super.setException(ex);
            this.responseCode = 0;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.serviceName, (DataOutput)out);
            out.writeInt(this.responseCode);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString((DataInput)in);
            this.responseCode = in.readInt();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{GfxdDRWLockReleaseReplyMessage id=" + this.processorId);
            sb.append(" serviceName=" + this.serviceName);
            sb.append(" responseCode=");
            switch (this.responseCode) {
                case 0: {
                    sb.append("EXCEPTION");
                    break;
                }
                case 1: {
                    sb.append("OK");
                    break;
                }
                case 2: {
                    sb.append("NOT_HELD");
                    break;
                }
                default: {
                    sb.append(String.valueOf(this.responseCode));
                }
            }
            sb.append(" sender=" + this.getSender());
            sb.append(" processorId=" + this.processorId);
            sb.append("}");
            return sb.toString();
        }
    }

    public static final class GfxdDRWLockReleaseMessage
    extends GfxdMessage
    implements MessageWithReply {
        protected String serviceName;
        protected Object objectName;
        protected Object lockOwner;
        private transient boolean released;

        public static void send(DM dm, Set<DistributedMember> members, boolean toSelf, String serviceName, Object objectName, Object lockOwner, boolean ignoreError, LogWriterI18n log) throws ReplyException {
            GfxdDRWLockReleaseMessage msg = new GfxdDRWLockReleaseMessage();
            RWLockReleaseProcessor processor = new RWLockReleaseProcessor(dm, members, objectName, log, ignoreError);
            msg.processorId = processor.getProcessorId();
            msg.serviceName = serviceName;
            msg.objectName = objectName;
            msg.lockOwner = lockOwner;
            msg.setRecipients(members);
            GfxdDRWLockService svc = (GfxdDRWLockService)DistributedLockService.getServiceNamed((String)serviceName);
            try {
                if (toSelf) {
                    svc.getLocalLockService().writeUnlock(objectName, lockOwner);
                }
                if (members.size() > 0) {
                    if (DistributionManager.VERBOSE || log.fineEnabled()) {
                        log.fine(msg.toString() + "#send: sending writeLock release message " + "for object [" + objectName + "] with owner=" + lockOwner + ", to members: " + members + ", myId: " + dm.getDistributionManagerId());
                    }
                    dm.putOutgoing((DistributionMessage)msg);
                    processor.waitForReplies();
                }
            }
            catch (ReplyException ex) {
                Misc.checkIfCacheClosing(ex);
                if (!GemFireXDUtils.retryToBeDone(ex)) {
                    throw ex;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Misc.checkIfCacheClosing(ie);
            }
            catch (LockNotHeldException e) {
                RWLockReleaseProcessor.handleNotOwner(ignoreError, (DistributedMember)dm.getDistributionManagerId(), serviceName, objectName, log);
            }
        }

        @Override
        protected void processMessage(DistributionManager dm) {
            this.released = false;
            DLockLogWriter log = new DLockLogWriter(dm.getLoggerI18n());
            DistributedLockService svc = DistributedLockService.getServiceNamed((String)this.serviceName);
            this.released = true;
            if (svc != null && svc instanceof GfxdDRWLockService) {
                GfxdDRWLockService rwsvc = (GfxdDRWLockService)svc;
                if (log.fineEnabled()) {
                    log.fine("GfxdDRWLockReleaseMessage#process: releasing write lock for object [" + this.objectName + "] for owner=" + this.lockOwner);
                }
                try {
                    rwsvc.getLocalLockService().writeUnlock(this.objectName, this.lockOwner);
                }
                catch (LockNotHeldException e) {
                    this.released = false;
                }
                if (log.fineEnabled()) {
                    log.fine("GfxdDRWLockReleaseMessage#process: writeUnlock for object [" + this.objectName + "] for owner=" + this.lockOwner + ", was " + (this.released ? "successful" : "unsuccessful with current owner " + rwsvc.getWriteLockOwner(this.objectName)));
                }
            }
        }

        @Override
        protected void sendReply(ReplyException ex, DistributionManager dm) {
            GfxdDRWLockReleaseReplyMessage response = new GfxdDRWLockReleaseReplyMessage();
            response.setProcessorId(this.getProcessorId());
            response.setRecipient(this.getSender());
            response.serviceName = this.serviceName;
            if (ex != null) {
                response.setException(new ReplyException((Throwable)ex));
                DLockLogWriter log = new DLockLogWriter(dm.getLoggerI18n());
                if (log.fineEnabled()) {
                    log.fine("While processing <" + this + ">, got exception, returning to sender", (Throwable)response.getException());
                }
            } else {
                response.responseCode = this.released ? 1 : 2;
            }
            dm.putOutgoing((DistributionMessage)response);
        }

        @Override
        protected boolean waitForNodeInitialization() {
            return false;
        }

        @Override
        public byte getGfxdID() {
            return 6;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.serviceName, (DataOutput)out);
            DataSerializer.writeObject((Object)this.objectName, (DataOutput)out);
            DataSerializer.writeObject((Object)this.lockOwner, (DataOutput)out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString((DataInput)in);
            this.objectName = DataSerializer.readObject((DataInput)in);
            this.lockOwner = DataSerializer.readObject((DataInput)in);
        }

        @Override
        protected void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            sb.append("; serviceName=").append(this.serviceName);
            sb.append("; name=").append(this.objectName);
            sb.append("; owner=").append(this.lockOwner);
            sb.append("; sender=").append(this.getSender());
        }
    }

    public static final class RWLockReleaseProcessor
    extends ReplyProcessor21 {
        private final Object objectName;
        private final boolean ignoreNotOwner;
        private final LogWriterI18n log;

        public RWLockReleaseProcessor(DM dm, Set<?> members, Object object, LogWriterI18n logger, boolean ignoreError) {
            super(dm, members);
            this.log = logger;
            this.objectName = object;
            this.ignoreNotOwner = ignoreError;
        }

        static void handleNotOwner(boolean ignoreNotOwner, DistributedMember sender, String serviceName, Object objectName, LogWriterI18n log) {
            if (!ignoreNotOwner) {
                if (log.fineEnabled()) {
                    log.fine(sender + " has responded GfxdDRWLockReleaseReplyMessage." + "NOT_HELD for " + objectName + " in " + serviceName);
                }
            } else if (log.warningEnabled()) {
                log.warning(LocalizedStrings.DEBUG, (Object)(sender + " has responded " + "GfxdDRWLockReleaseReplyMessage.NOT_HELD for " + objectName + " in " + serviceName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(DistributionMessage msg) {
            GfxdDRWLockReleaseReplyMessage reply = (GfxdDRWLockReleaseReplyMessage)msg;
            try {
                if (this.log.fineEnabled()) {
                    this.log.fine("Processing: " + reply);
                }
                if (reply.responseCode == 1) {
                    if (this.log.fineEnabled()) {
                        this.log.fine(reply.getSender() + " has successfully " + "released write lock for " + this.objectName + " in " + reply.serviceName);
                    }
                } else if (reply.responseCode == 2) {
                    RWLockReleaseProcessor.handleNotOwner(this.ignoreNotOwner, (DistributedMember)reply.getSender(), reply.serviceName, this.objectName, this.log);
                } else if (reply.responseCode == 0) {
                    // empty if block
                }
            }
            finally {
                super.process(msg);
            }
        }

        protected boolean stopBecauseOfExceptions() {
            return false;
        }
    }
}

