/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SecondaryClauseQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;

public class OrderByQueryInfo
extends AbstractQueryInfo
implements SecondaryClauseQueryInfo {
    private final ColumnOrdering[] columnOrdering;
    private final ExecRow expectedRemoteExecRow;
    private final RowFormatter rowFormatter;
    private int[] projectMapping;

    public OrderByQueryInfo(QueryInfoContext qic, OrderByList ordering, ResultColumnList rclist, ResultColumnList parentRCL) throws StandardException {
        this.columnOrdering = ordering.getColumnOrdering();
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("OrderByQueryInfo column ordering size " + this.columnOrdering.length));
        }
        if (parentRCL != null && rclist.size() != parentRCL.size()) {
            this.projectMapping = new int[parentRCL.size()];
            for (int i = 0; i < parentRCL.size(); ++i) {
                this.projectMapping[i] = i + 1;
            }
        }
        this.expectedRemoteExecRow = rclist.buildEmptyRow();
        this.rowFormatter = OrderByQueryInfo.getRowFormatterFromRCL(rclist, null);
    }

    @Override
    public ColumnOrdering[] getColumnOrdering() {
        return this.columnOrdering;
    }

    @Override
    public ExecRow getInComingProjectionExecRow() {
        return this.expectedRemoteExecRow;
    }

    @Override
    public final RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    @Override
    public int[] getProjectMapping() {
        return this.projectMapping;
    }
}

