/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.Scope;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ColumnQueryInfo
extends AbstractQueryInfo
implements AbstractColumnQueryInfo {
    private final String exposedColumnName;
    private final int virtualColumnNumber;
    private final String actualColumnName;
    private final int actualColumnNumber;
    final DataTypeDescriptor columnType;
    final ColumnDescriptor columnDescriptor;
    private final TableDescriptor td;
    private int partitioningColPos = -1;
    private TableQueryInfo tqi;
    private int tableNum = -1;
    private GfxdPartitionResolver resolver = null;
    private boolean isOuterScope = false;

    public ColumnQueryInfo(ColumnReference cr, QueryInfoContext qic) throws StandardException {
        ResultColumn rc = cr.getSource();
        this.tableNum = cr.getTableNumber();
        this.columnDescriptor = this.searchColumnDescriptor(rc);
        if (this.columnDescriptor != null) {
            this.actualColumnName = this.columnDescriptor.getColumnName();
            this.actualColumnNumber = this.columnDescriptor.getPosition();
            this.columnType = this.columnDescriptor.getType();
            this.td = this.columnDescriptor.getTableDescriptor();
        } else {
            String columnName = rc.getSourceColumnName();
            if (columnName == null) {
                columnName = rc.getActualName();
            }
            this.actualColumnName = columnName;
            this.actualColumnNumber = rc.getColumnPosition();
            this.columnType = rc.getType();
            this.td = null;
        }
        this.exposedColumnName = this.actualColumnName;
        this.virtualColumnNumber = this.actualColumnNumber;
        if (this.tableNum > -1) {
            DMLQueryInfo current = qic.getCurrentScopeQueryInfo();
            this.tqi = current.getTableQueryInfo(this.tableNum);
            if (this.tqi != null) {
                this.initResolverForColumnIfApplicable();
            } else {
                Scope owningScope;
                DMLQueryInfo root = qic.getRootQueryInfo();
                if (root.isSelect() && qic.getNestingLevelOfScope() > 0 && (owningScope = qic.findOwningScope(this.tableNum)) != null) {
                    this.initResolverForOuterScopeColumn(cr, qic, owningScope);
                    this.isOuterScope = true;
                }
            }
        }
    }

    ColumnQueryInfo(ColumnDescriptor cd, TableQueryInfo tqi, int tableNum) throws StandardException {
        this.actualColumnName = cd.getColumnName();
        this.actualColumnNumber = cd.getPosition();
        this.columnDescriptor = cd;
        this.td = cd.getTableDescriptor();
        this.columnType = cd.getType();
        this.tqi = tqi;
        this.exposedColumnName = this.actualColumnName;
        this.virtualColumnNumber = this.actualColumnNumber;
        assert (this.columnDescriptor != null);
    }

    ColumnQueryInfo(ResultColumn rc, QueryInfoContext qic) throws StandardException {
        ColumnDescriptor cd = this.searchColumnDescriptor(rc);
        if (cd != null) {
            this.actualColumnName = cd.getColumnName();
            this.actualColumnNumber = cd.getPosition();
            this.columnDescriptor = cd;
            this.columnType = cd.getType();
            this.td = cd.getTableDescriptor();
        } else {
            String columnName = rc.getSourceColumnName();
            if (columnName == null) {
                columnName = rc.getActualName();
            }
            this.actualColumnName = columnName;
            this.actualColumnNumber = rc.getColumnPosition();
            this.columnType = rc.getType();
            this.td = null;
            this.columnDescriptor = new ColumnDescriptor(this.actualColumnName, this.actualColumnNumber, this.columnType, null, null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
        }
        if (this.tableNum > -1) {
            DMLQueryInfo currentTop = qic.getCurrentScopeQueryInfo();
            this.tqi = currentTop.getTableQueryInfo(this.tableNum);
        }
        this.exposedColumnName = rc.getName();
        this.virtualColumnNumber = rc.getVirtualColumnId();
        assert (this.columnDescriptor != null);
    }

    private final ColumnDescriptor searchColumnDescriptor(ResultColumn rc) throws StandardException {
        ColumnDescriptor cd;
        block5: {
            ResultColumn rs = rc;
            cd = rc.getTableColumnDescriptor();
            if (this.tableNum < 0) {
                this.tableNum = rc.getTableNumber();
            }
            if (cd != null) {
                return cd;
            }
            do {
                ValueNode vn;
                if ((vn = rs.getExpression()) instanceof ColumnReference) {
                    rs = ((ColumnReference)vn).getSource();
                } else {
                    vn = rs.getExpression();
                    if (!(vn instanceof VirtualColumnNode)) break block5;
                    rs = ((VirtualColumnNode)vn).getSourceColumn();
                }
                if (rs == null) break block5;
            } while ((cd = rs.getTableColumnDescriptor()) == null);
            this.tableNum = rs.getTableNumber();
        }
        return cd;
    }

    @Override
    public final int getActualColumnPosition() {
        return this.actualColumnNumber;
    }

    @Override
    public String getActualColumnName() {
        return this.actualColumnName;
    }

    public String getExposedName() {
        return this.exposedColumnName;
    }

    public ColumnDescriptor getColumnDescriptor() {
        return this.columnDescriptor;
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.columnType;
    }

    public int getVirtualPosition() {
        return this.virtualColumnNumber;
    }

    public boolean isResultColumnMatchingTableColumn(ColumnQueryInfo resultColumn) {
        return this.actualColumnNumber == resultColumn.actualColumnNumber && resultColumn.exposedColumnName.equals(this.actualColumnName) && this.tqi.getTableNumber() == resultColumn.tqi.getTableNumber();
    }

    public int getTableNumber() {
        return this.tqi.getTableNumber();
    }

    @Override
    public String getTableName() {
        return this.td != null ? this.td.getName() : (this.tqi != null ? this.tqi.getTableName() : "");
    }

    @Override
    public String getFullTableName() {
        return this.td != null ? this.td.getSchemaName() + '.' + this.td.getName() : (this.tqi != null ? this.tqi.getFullTableName() : "");
    }

    @Override
    public String getSchemaName() {
        return this.td != null ? this.td.getSchemaName() : (this.tqi != null ? this.tqi.getSchemaName() : "");
    }

    @Override
    public AbstractRegion getRegion() {
        return this.tqi != null ? this.tqi.getRegion() : (this.td != null ? (AbstractRegion)Misc.getRegionByPath(this.td, null, false) : null);
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.td;
    }

    int getTableNumberforColocationCriteria() {
        if (this.tqi == null) {
            return 0;
        }
        return this.isOuterScope ? 0 : this.tqi.getTableNumberforColocationCriteria();
    }

    void setMissingTableInfo(TableQueryInfo tqi) {
        this.tqi = tqi;
        this.initResolverForColumnIfApplicable();
    }

    boolean isTableInfoMissing() {
        return this.tqi == null;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Full table name = ");
        sbuff.append(this.getFullTableName());
        sbuff.append("; Actual column name = ");
        sbuff.append(this.actualColumnName);
        sbuff.append("; Exposed Column Name = ");
        sbuff.append(this.exposedColumnName);
        return sbuff.toString();
    }

    boolean isUsedInPartitioning() {
        boolean ok = false;
        if (this.tqi == null) {
            return ok;
        }
        LocalRegion rgnOwningColumn = this.tqi.getRegion();
        assert (rgnOwningColumn != null);
        RegionAttributes ra = rgnOwningColumn.getAttributes();
        DataPolicy policy = ra.getDataPolicy();
        if (policy.withPartitioning()) {
            PartitionedRegion pr = (PartitionedRegion)rgnOwningColumn;
            GfxdPartitionResolver rslvr = (GfxdPartitionResolver)pr.getPartitionResolver();
            ok = rslvr != null && rslvr.isUsedInPartitioning(this.actualColumnName);
        }
        return ok;
    }

    boolean isPartOfPrimaryKey(int[][] pkCols) {
        boolean partOfPK = false;
        if (pkCols != null) {
            for (int i = 0; i < pkCols.length; ++i) {
                if (pkCols[i][0] != this.actualColumnNumber) continue;
                partOfPK = true;
                break;
            }
        }
        return partOfPK;
    }

    List<ConglomerateDescriptor> getAvailableGlobalHashIndexForColumn() {
        if (this.tqi == null) {
            return Collections.emptyList();
        }
        TableDescriptor td = this.tqi.getTableDescriptor();
        assert (td != null);
        ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
        Iterator itr = cdl.iterator();
        ArrayList<ConglomerateDescriptor> globalIndexes = new ArrayList<ConglomerateDescriptor>(2);
        block0: while (itr.hasNext()) {
            int[] baseColPos;
            IndexRowGenerator id;
            ConglomerateDescriptor cd = (ConglomerateDescriptor)itr.next();
            if (!cd.isIndex() && !cd.isConstraint() || !(id = cd.getIndexDescriptor()).indexType().equals("GLOBALHASH")) continue;
            for (int colPos : baseColPos = id.baseColumnPositions()) {
                if (colPos != this.actualColumnNumber) continue;
                globalIndexes.add(cd);
                continue block0;
            }
        }
        return globalIndexes;
    }

    int getPartitionColumnPosition() {
        return this.partitioningColPos;
    }

    void isNotNullCriteriaSatisfied(DataValueDescriptor dvd) throws StandardException {
        if (!this.columnType.isNullable() && (dvd == null || dvd.isNull())) {
            throw StandardException.newException("23502", this.exposedColumnName);
        }
    }

    boolean isReferencedByUniqueConstraint() throws StandardException {
        TableDescriptor td = this.tqi.getTableDescriptor();
        ConstraintDescriptorList cdl = td.getConstraintDescriptorList();
        Iterator itr = cdl.iterator();
        boolean isReferenced = false;
        while (itr.hasNext()) {
            ConstraintDescriptor cd = (ConstraintDescriptor)itr.next();
            if (cd.getConstraintType() != 3 || this.isColumnReferencedByConstraint(cd) == -1) continue;
            isReferenced = true;
            break;
        }
        return isReferenced;
    }

    int isColumnReferencedByConstraint(ConstraintDescriptor cd) {
        int[] referencedColumns = cd.getReferencedColumns();
        int index = -1;
        for (int i = 0; i < referencedColumns.length; ++i) {
            if (referencedColumns[i] != this.actualColumnNumber) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public GfxdPartitionResolver getResolverIfSingleColumnPartition() {
        return this.partitioningColPos != -1 && this.resolver.getColumnNames().length == 1 && !this.isOuterScope ? this.resolver : null;
    }

    private void initResolverForOuterScopeColumn(ColumnReference cr, QueryInfoContext qic, Scope owningScope) throws StandardException {
        int tableNumber = cr.getTableNumber();
        DMLQueryInfo owningDML = owningScope.getDMLQueryInfo();
        this.tqi = owningDML.getTableQueryInfo(tableNumber);
        this.initResolverForColumnIfApplicable();
        SubQueryInfo sqi = (SubQueryInfo)qic.getCurrentScopeQueryInfo();
        if (this.resolver != null) {
            int independentPRScopeLevel = sqi.getLastPushedPRBasedIndependentScopeLevel();
            if (owningScope.getScopeLevel() < independentPRScopeLevel) {
                throw StandardException.newException("0A000.S.10");
            }
            LocalRegion master = qic.getScopeAt(independentPRScopeLevel).getDMLQueryInfo().getRegion();
            assert (master.getDataPolicy().withPartitioning());
            this.resolver = GemFireXDUtils.getResolver((AbstractRegion)master);
        }
    }

    private void initResolverForColumnIfApplicable() {
        assert (this.tqi != null);
        LocalRegion rgn = this.tqi.getRegion();
        GfxdPartitionResolver rslvr = GemFireXDUtils.getResolver((AbstractRegion)rgn);
        if (rslvr != null && rslvr.isUsedInPartitioning(this.actualColumnName)) {
            this.resolver = rslvr;
            this.partitioningColPos = rslvr.getPartitioningColumnIndex(this.actualColumnName);
        }
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    @Override
    public boolean isTableVTI() {
        return this.columnDescriptor == null || this.columnDescriptor.getTableDescriptor().getTableType() == 5;
    }

    @Override
    public boolean routeQueryToAllNodes() {
        return this.columnDescriptor == null || this.columnDescriptor.getTableDescriptor().routeQueryToAllNodes();
    }
}

