/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeExecutorMsg;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBlob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class SnappyResultHolder
extends GfxdDataSerializable {
    private transient SparkSQLExecute exec;
    private transient ByteArrayDataInput dis;
    private volatile transient String[] colNames;
    private volatile transient String[] tableNames;
    private volatile transient boolean[] nullability;
    private volatile transient int[] colTypes;
    private volatile transient int[] precisions;
    private volatile transient int[] scales;
    private DataValueDescriptor[] templateDVDRow;
    private ValueRow execRow;
    private DataTypeDescriptor[] dtds;
    private int numEightColGrps = -1;
    private int numPartialCols = 0;

    public SnappyResultHolder(SparkSQLExecute exec) {
        this.exec = exec;
    }

    public SnappyResultHolder() {
    }

    @Override
    public byte getGfxdID() {
        return 120;
    }

    public void setMetadata(SnappyResultHolder other) {
        this.tableNames = other.tableNames;
        this.colNames = other.colNames;
        this.nullability = other.nullability;
        this.colTypes = other.colTypes;
        this.precisions = other.precisions;
        this.scales = other.scales;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.exec.serializeRows(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        int numBytes = InternalDataSerializer.readArrayLength((DataInput)in);
        if (numBytes > 0) {
            byte[] rawData = DataSerializer.readByteArray((DataInput)in, (int)numBytes);
            Version v = InternalDataSerializer.getVersionForDataStreamOrNull((DataInput)in);
            this.fromSerializedData(rawData, numBytes, v);
        }
    }

    public final void fromSerializedData(byte[] rawData, int numBytes, Version v) throws IOException {
        ByteArrayDataInput dis = new ByteArrayDataInput();
        dis.initialize(rawData, 0, numBytes, v);
        byte metaInfo = dis.readByte();
        if (metaInfo == 1) {
            this.tableNames = DataSerializer.readStringArray((DataInput)dis);
            this.colNames = DataSerializer.readStringArray((DataInput)dis);
            this.nullability = DataSerializer.readBooleanArray((DataInput)dis);
            int totCols = this.colNames.length;
            this.precisions = new int[totCols];
            this.scales = new int[totCols];
            this.dtds = new DataTypeDescriptor[totCols];
            this.colTypes = new int[totCols];
            for (int i = 0; i < totCols; ++i) {
                int columnType;
                this.colTypes[i] = columnType = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                if (columnType == 200) {
                    this.precisions[i] = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                    this.scales[i] = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                    continue;
                }
                this.precisions[i] = -1;
                this.scales[i] = -1;
            }
        }
        this.dis = dis;
    }

    private void makeTemplateDVDArr() {
        this.dtds = new DataTypeDescriptor[this.colTypes.length];
        DataValueDescriptor[] dvds = new DataValueDescriptor[this.colTypes.length];
        for (int i = 0; i < this.colTypes.length; ++i) {
            DataValueDescriptor dvd;
            int typeId = this.colTypes[i];
            dvds[i] = dvd = this.getNewNullDVD(typeId, i, this.dtds, this.precisions[i], this.scales[i]);
        }
        this.templateDVDRow = dvds;
        this.execRow = new ValueRow(this.templateDVDRow);
        int numCols = this.colTypes.length;
        if (this.numEightColGrps < 0) {
            this.numEightColGrps = numCols / 8;
            this.numPartialCols = numCols % 8;
        }
    }

    public String[] getColumnNames() {
        return this.colNames;
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public void prepareSend(LeadNodeExecutorMsg msg) {
        this.exec.packRows(msg, this);
    }

    public ExecRow getNextRow() throws IOException, ClassNotFoundException, StandardException {
        if (this.dis != null && this.dis.available() > 0) {
            if (this.templateDVDRow == null) {
                this.makeTemplateDVDArr();
            }
            CallbackFactoryProvider.getClusterCallbacks().readDVDArray(this.templateDVDRow, this.colTypes, this.dis, this.numEightColGrps, this.numPartialCols);
            return this.execRow;
        }
        this.dis = null;
        return null;
    }

    private DataValueDescriptor getNewNullDVD(int storeType, int colNum, DataTypeDescriptor[] dtds, int precision, int scale) {
        DataTypeDescriptor dtd;
        DataType dvd;
        boolean nullable = this.nullability[colNum];
        switch (storeType) {
            case 31: {
                dvd = new SQLTimestamp();
                int jdbcTypeId = 93;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 77: {
                dvd = new SQLBlob();
                int jdbcTypeId = 16;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 298: {
                dvd = new SQLDate();
                int jdbcTypeId = 91;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 84: {
                dvd = new SQLLongint();
                int jdbcTypeId = -5;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 83: {
                dvd = new SQLSmallint();
                int jdbcTypeId = 5;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 199: {
                dvd = new SQLTinyint();
                int jdbcTypeId = 4;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 80: {
                dvd = new SQLInteger();
                int jdbcTypeId = 4;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 200: {
                dvd = new SQLDecimal();
                try {
                    dtd = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", precision, scale, nullable, precision);
                    break;
                }
                catch (StandardException e) {
                    throw new GemFireXDRuntimeException(e);
                }
            }
            case 81: {
                dvd = new SQLReal();
                int jdbcTypeId = 7;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 79: {
                dvd = new SQLDouble();
                int jdbcTypeId = 8;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 85: 
            case 447: {
                dvd = new SQLClob();
                int jdbcTypeId = 2005;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            default: {
                throw new IllegalStateException("SnappyResultHolder: cannot handle type: " + storeType);
            }
        }
        dtds[colNum] = dtd;
        return dvd;
    }

    public DataTypeDescriptor[] getDtds() {
        this.makeTemplateDVDArr();
        return this.dtds;
    }
}

