/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollectorHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.OffHeapReleaseUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class GfxdQueryStreamingResultCollector
extends LinkedBlockingQueue<Object>
implements GfxdResultCollector<Object> {
    private static final long serialVersionUID = -3092253414028358183L;
    private volatile GemFireException gemfireException;
    private volatile DistributedMember cancelledMember;
    private final GfxdResultCollectorHelper helper;
    private transient ReplyProcessor21 processor;
    private volatile boolean endReached;
    private transient boolean getInvoked;
    private static final String NAME = GfxdQueryStreamingResultCollector.class.getSimpleName();
    private static final Object EOF = new Object(){

        public final String toString() {
            return NAME + ".EOF";
        }
    };

    public GfxdQueryStreamingResultCollector() {
        this(new GfxdResultCollectorHelper());
    }

    private GfxdQueryStreamingResultCollector(GfxdResultCollectorHelper helper) {
        this.helper = helper;
    }

    @Override
    public final void setResultMembers(Set<DistributedMember> members) {
        this.helper.setResultMembers(members);
    }

    @Override
    public final Set<DistributedMember> getResultMembers() {
        return this.helper.getResultMembers();
    }

    @Override
    public final boolean setupContainersToClose(Collection<GemFireContainer> containers, GemFireTransaction tran) throws StandardException {
        return this.helper.setupContainersToClose(this, containers, tran);
    }

    @Override
    public void setNumRecipients(int n) {
    }

    @Override
    public GfxdResultCollectorHelper getStreamingHelper() {
        return this.helper;
    }

    public final void setProcessor(ReplyProcessor21 processor) {
        this.processor = processor;
    }

    public final ReplyProcessor21 getProcessor() {
        return this.processor;
    }

    public void addResult(DistributedMember member, Object resultOfSingleExecution) {
        boolean addMember;
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#addResult: adding result: " + resultOfSingleExecution + " from member: " + member));
        }
        if (resultOfSingleExecution == null) {
            return;
        }
        if (resultOfSingleExecution instanceof Throwable) {
            this.processException((Throwable)resultOfSingleExecution, member);
            addMember = false;
        } else {
            addMember = true;
            if (resultOfSingleExecution instanceof ResultHolder) {
                ((ResultHolder)resultOfSingleExecution).applyRemoteTXChanges(member);
            }
            this.offer(resultOfSingleExecution);
        }
        if (addMember) {
            this.helper.addResultMember(member);
        }
    }

    public LinkedBlockingQueue<Object> getResult() throws FunctionException, ReplyException {
        this.getInvoked = true;
        if (this.processor != null) {
            this.processor.startWait();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endResults() {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#endResults: ending results by adding EOF"));
        }
        try {
            if (this.processor != null) {
                this.processor.endWait();
            }
        }
        finally {
            this.offer(EOF);
            this.helper.closeContainers(this, true);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new Itr();
    }

    public Iterator<Object> reusableIterator() {
        return super.iterator();
    }

    public final LinkedBlockingQueue<Object> getResult(long timeout, TimeUnit unit) throws FunctionException {
        throw new UnsupportedOperationException("getResult with timeout not expected to be invoked in GemFireXD");
    }

    public void setException(Throwable exception) {
        this.processException(exception, (DistributedMember)GemFireStore.getMyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResults() {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#clearResults: clearing results and exceptions"));
        }
        this.gemfireException = null;
        this.cancelledMember = null;
        this.helper.clear(this);
        this.processor = null;
        if (this.getInvoked) {
            Object element = null;
            while (!this.endReached) {
                try {
                    do {
                        if ((element = this.poll(5L, TimeUnit.SECONDS)) != null) continue;
                        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                    } while (element == null);
                    if (element != EOF) continue;
                    this.endReached = true;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ie);
                    break;
                }
                finally {
                    if (this.endReached || !GemFireXDUtils.isOffHeapEnabled() || !(element instanceof ResultHolder)) continue;
                    OffHeapReleaseUtil.freeOffHeapReference(element);
                }
            }
            this.getInvoked = false;
        } else {
            if (GemFireXDUtils.isOffHeapEnabled()) {
                try {
                    Object element;
                    do {
                        element = this.poll(5L, TimeUnit.SECONDS);
                        try {
                            if (element == null) {
                                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                            }
                            if (element != EOF) continue;
                            break;
                        }
                        finally {
                            if (GemFireXDUtils.isOffHeapEnabled() && element instanceof ResultHolder) {
                                OffHeapReleaseUtil.freeOffHeapReference((ResultHolder)element);
                            }
                        }
                    } while (element != null);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ie);
                }
            }
            super.clear();
        }
    }

    @Override
    public String toString() {
        return NAME + '@' + Integer.toHexString(System.identityHashCode(this)) + "[processor: " + this.processor + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processException(Throwable t, DistributedMember member) {
        if (GemFireXDUtils.TraceFunctionException) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#processException: from member [" + member + "] got exception"), (Throwable)t);
        }
        GfxdQueryStreamingResultCollector gfxdQueryStreamingResultCollector = this;
        synchronized (gfxdQueryStreamingResultCollector) {
            member = StandardException.fixUpRemoteException(t, member);
            if (t instanceof ReplyException) {
                t = t.getCause();
            }
            if (GemFireXDUtils.retryToBeDone(t)) {
                this.gemfireException = t instanceof GemFireException ? (GemFireException)t : new FunctionException(t);
                this.cancelledMember = member;
                return true;
            }
            if (this.cancelledMember == null) {
                if (this.gemfireException == null) {
                    if (t instanceof FunctionException) {
                        this.gemfireException = (FunctionException)t;
                        if (t.getCause() != null) {
                            t = t.getCause();
                        }
                    } else {
                        this.gemfireException = new FunctionException(t);
                    }
                }
                ((FunctionException)((Object)this.gemfireException)).addException(t);
            }
        }
        return false;
    }

    @Override
    public GfxdResultCollector<Object> cloneCollector() {
        return new GfxdQueryStreamingResultCollector();
    }

    private final class Itr
    implements Iterator<Object> {
        private transient Object current;

        public Itr() {
            this.moveNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != EOF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            Object current = this.current;
            if (current == EOF) {
                throw new NoSuchElementException();
            }
            boolean ok = false;
            try {
                this.moveNext();
                ok = true;
                Object object = current;
                return object;
            }
            finally {
                if (!ok && GemFireXDUtils.isOffHeapEnabled()) {
                    OffHeapReleaseUtil.freeOffHeapReference(current);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not expected to be invoked");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveNext() {
            block17: {
                try {
                    while (true) {
                        this.current = GfxdQueryStreamingResultCollector.this.poll(1L, TimeUnit.SECONDS);
                        if (this.current != null) break;
                        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                    }
                    Throwable cause = GfxdQueryStreamingResultCollector.this.gemfireException;
                    if (cause == null) {
                        if (this.current == EOF) {
                            GfxdQueryStreamingResultCollector.this.endReached = true;
                        }
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(GfxdQueryStreamingResultCollector.this.toString() + ".Iterator#moveNext: took a new value from queue: " + String.valueOf(this.current)));
                        }
                        break block17;
                    }
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(GfxdQueryStreamingResultCollector.this.toString() + ".Iterator#moveNext: got exception"), (Throwable)cause);
                    }
                    if (GemFireXDUtils.isOffHeapEnabled() && this.current instanceof ResultHolder) {
                        OffHeapReleaseUtil.freeOffHeapReference(this.current);
                    }
                    while (this.current != EOF) {
                        this.current = GfxdQueryStreamingResultCollector.this.poll(1L, TimeUnit.SECONDS);
                        try {
                            if (this.current != null) continue;
                            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                        }
                        finally {
                            if (!GemFireXDUtils.isOffHeapEnabled() || !(this.current instanceof ResultHolder)) continue;
                            OffHeapReleaseUtil.freeOffHeapReference(this.current);
                        }
                    }
                    GfxdQueryStreamingResultCollector gfxdQueryStreamingResultCollector = GfxdQueryStreamingResultCollector.this;
                    synchronized (gfxdQueryStreamingResultCollector) {
                        GfxdQueryStreamingResultCollector.this.endReached = true;
                        while (cause instanceof FunctionExecutionException || cause.getClass().equals(FunctionException.class) && cause.getMessage().equals(String.valueOf(cause.getCause()))) {
                            cause = cause.getCause();
                        }
                        GemFireXDRuntimeException gfxdEx = new GemFireXDRuntimeException(cause);
                        if (GfxdQueryStreamingResultCollector.this.cancelledMember != null) {
                            gfxdEx.setOrigin(GfxdQueryStreamingResultCollector.this.cancelledMember);
                        }
                        throw gfxdEx;
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ie);
                }
            }
        }
    }
}

