/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.db;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactoryContext;
import com.pivotal.gemfirexd.internal.iapi.services.loader.JarReader;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.property.PersistentSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

final class StoreClassFactoryContext
extends ClassFactoryContext {
    private final AccessFactory store;
    private final JarReader jarReader;

    StoreClassFactoryContext(ContextManager cm, ClassFactory cf, AccessFactory store, JarReader jarReader) {
        super(cm, cf);
        this.store = store;
        this.jarReader = jarReader;
    }

    @Override
    public CompatibilitySpace getLockSpace() throws StandardException {
        if (this.store == null) {
            return null;
        }
        TransactionController tc = this.store.getTransaction(this.getContextManager());
        if (tc == null || tc.isClosed()) {
            return null;
        }
        return tc.getLockSpace();
    }

    @Override
    public PersistentSet getPersistentSet() throws StandardException {
        if (this.store == null) {
            return null;
        }
        return this.store.getTransaction(this.getContextManager());
    }

    @Override
    public JarReader getJarReader() {
        return this.jarReader;
    }
}

