/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.db;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TLongHashSet;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.db.DatabaseContextImpl;
import com.pivotal.gemfirexd.internal.engine.db.StoreClassFactoryContext;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLQueueEntry;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.ReplayableConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.sql.execute.DistributionObserver;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.JarReader;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.FileInfoDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdDiskStoreDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.util.DoubleProperties;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarResource;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public final class FabricDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    public static final String PROPERTY_NAME = GfxdConstants.GFXD_PREFIX + "database-object";
    private static final String TEMP_DIR_PREFIX = "gemfirexdtemp_";
    private volatile boolean active;
    private AuthenticationService authenticationService;
    private AuthenticationService peerAuthenticationService;
    protected GemFireStore memStore;
    protected PropertyFactory pf;
    protected volatile ClassFactory cfDB;
    private GfxdDataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private LogFactory logFactory;
    private DataValueFactory dataValueFactory;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;
    private boolean disableStatementOptimization;
    private boolean runtimeStatisticsOn;
    private DirFile tempDir;
    public static boolean SKIP_SPS_PRECOMPILE = SystemProperties.getServerInstance().getBoolean("gemfirexd.SKIP_SPS_PRECOMPILE", false);
    private final boolean allowBootWithFailures = Boolean.getBoolean("gemfirexd.datadictionary.allow-startup-errors");

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        return Monitor.isDesiredCreateType(startParams, this.getEngineType());
    }

    public boolean allowBootWithFailures() {
        return this.allowBootWithFailures;
    }

    @Override
    public synchronized void boot(boolean create, Properties startParams) throws StandardException {
        String localeID;
        if (this.active) {
            return;
        }
        create = true;
        boolean hadoopLoner = "true".equalsIgnoreCase(startParams.getProperty("hadoop.gemfirexd.loner.mode"));
        if (hadoopLoner) {
            ClassSize.setDummyCatalog();
        }
        InternalDistributedSystem.setHadoopGfxdLonerMode((boolean)hadoopLoner);
        ModuleFactory monitor = Monitor.getMonitor();
        if (startParams.getProperty("gemfirexd.__rt.storage.createWithNoLog") == null) {
            startParams.put("gemfirexd.__rt.storage.createWithNoLog", "true");
        }
        if ((localeID = startParams.getProperty("territory")) == null) {
            localeID = Locale.getDefault().toString();
        }
        Locale locale = monitor.setLocale(startParams, localeID);
        this.setLocale(locale);
        this.bootValidation(create, startParams);
        startParams.put(PROPERTY_NAME, this);
        this.dataValueFactory = (DataValueFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory", startParams);
        this.logFactory = (LogFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory", startParams);
        this.authenticationService = this.bootAuthenticationService(create, startParams);
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Failed to set the Authentication service for the database");
        this.bootStore(create, startParams);
        assert (this.pf != null && this.memStore != null);
        this.myUUID = this.makeDatabaseID(create, startParams);
        DoubleProperties allParams = new DoubleProperties(this.getAllDatabaseProperties(), startParams);
        this.pf.addPropertySetNotification(this);
        this.bootClassFactory(create, allParams);
        ClassPathLoader.setLatestToDefaultWithCustomLoader((boolean)Boolean.getBoolean("gemfire.excludeThreadContextClassLoader"), (ClassPathLoader.ClassLoaderInterface)this.getClassFactory());
        this.dd = (GfxdDataDictionary)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary", allParams);
        this.lcf = (LanguageConnectionFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory", allParams);
        this.lf = (LanguageFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory", allParams);
        this.bootResourceAdapter(create, allParams);
        if (create && this.lastToBoot && startParams.getProperty("gemfirexd.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.disableStatementOptimization = Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING));
        if (this.memStore.restrictedDDLStmtQueue()) {
            this.memStore.getDDLQueueNoThrow().initializeQueue(this.dd);
        } else {
            this.memStore.getDDLStmtQueue().initializeQueue(this.dd);
        }
        this.active = true;
        GfxdManagementService.handleEvent(2, this.memStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void postCreate(EngineConnection conn, Properties bootProps) throws StandardException {
        block18: {
            if (this.memStore.initialDDLReplayDone()) {
                return;
            }
            try {
                String postScriptsPath;
                GfxdDiskStoreDescriptor dsd;
                UUID id;
                EmbedConnection embedConn = (EmbedConnection)conn;
                GemFireCacheImpl cache = this.memStore.getGemFireCache();
                LogWriter logger = cache.getLogger();
                LanguageConnectionContext lcc = embedConn.getLanguageConnection();
                GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
                UUIDFactory factory = this.dd.getUUIDFactory();
                DiskStoreImpl ds = cache.findDiskStore("GFXD-DD-DISKSTORE");
                if (ds != null) {
                    id = factory.recreateUUID(ds.getName());
                    dsd = new GfxdDiskStoreDescriptor(this.dd, id, (DiskStore)ds, ds.getDiskDirs()[0].getAbsolutePath());
                    this.dd.addDescriptor(dsd, null, 20, false, this.dd.getTransactionExecute());
                }
                if ((ds = this.memStore.getDefaultDiskStore()) != null) {
                    id = factory.recreateUUID(ds.getName());
                    dsd = new GfxdDiskStoreDescriptor(this.dd, id, (DiskStore)ds, ds.getDiskDirs()[0].getAbsolutePath());
                    this.dd.addDescriptor(dsd, null, 20, false, this.dd.getTransactionExecute());
                }
                GfxdManagementService.handleEvent(4, embedConn);
                this.postCreateDDLReplay(embedConn, bootProps, lcc, tc, logger);
                FabricService service = FabricServiceManager.currentFabricServiceInstance();
                if (service != null) {
                    ((FabricServiceImpl)service).notifyRunning();
                }
                if ((postScriptsPath = bootProps.getProperty("init-scripts")) != null && postScriptsPath.length() > 0) {
                    String[] postScriptPaths = postScriptsPath.split(",");
                    GemFireXDUtils.executeSQLScripts((Connection)embedConn, postScriptPaths, false, logger, null, null, false);
                }
                if (!this.memStore.isSnappyStore() || this.memStore.getMyVMKind() != GemFireStore.VMKind.DATASTORE) break block18;
                boolean writeLockTaken = false;
                try {
                    writeLockTaken = this.dd.lockForWriting(tc, false);
                    this.memStore.initExternalCatalog();
                }
                finally {
                    if (writeLockTaken) {
                        this.dd.unlockAfterWriting(tc, false);
                    }
                }
            }
            catch (Throwable t) {
                StandardException se;
                SQLException sqle;
                try {
                    LogWriter logger = Misc.getCacheLogWriter();
                    if (logger != null) {
                        logger.warning("got throwable: " + t.getMessage() + " calling shut down", t);
                    }
                    Monitor.getMonitor().shutdown();
                }
                catch (CancelException logger) {
                    // empty catch block
                }
                if (GemFireXDUtils.TraceFabricServiceBoot) {
                    SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Failed to boot database", (Throwable)t);
                }
                Throwable checkEx = t;
                if (t instanceof GemFireXDRuntimeException) {
                    checkEx = t.getCause();
                }
                if (checkEx instanceof SQLException && (sqle = (SQLException)checkEx).getSQLState() != null && sqle.getSQLState().startsWith("XBM")) {
                    throw Misc.wrapSQLException(sqle, sqle);
                }
                if (checkEx instanceof StandardException && (se = (StandardException)checkEx).getSQLState() != null && se.getSQLState().startsWith("XBM")) {
                    throw se;
                }
                throw StandardException.newException("XJ040.C", t, (Object)"gemfirexd");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCreateDDLReplay(EmbedConnection embedConn, Properties bootProps, LanguageConnectionContext lcc, GemFireTransaction tc, LogWriter logger) throws Exception {
        Object sync;
        GfxdDDLRegionQueue ddlStmtQueue = this.memStore.getDDLQueueNoThrow();
        String initSchema = lcc.getCurrentSchemaName();
        String lastCurrentSchema = initSchema != null ? initSchema : "APP";
        lcc.setIsConnectionForRemote(true);
        lcc.setIsConnectionForRemoteDDL(false);
        lcc.setSkipLocks(true);
        lcc.setQueryRouting(false);
        tc.resetActiveTXState();
        GemFireStore.VMKind vmKind = this.memStore.getMyVMKind();
        boolean skipSPSPrecompile = SKIP_SPS_PRECOMPILE;
        if (skipSPSPrecompile) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Skipping precompilation of inbuilt procedures");
        }
        this.dd.createSystemSps(tc, vmKind.isAccessorOrStore() && !skipSPSPrecompile && !this.memStore.isHadoopGfxdLonerMode());
        String initScriptsPath = bootProps.getProperty("config-scripts");
        if (initScriptsPath != null && initScriptsPath.length() > 0) {
            String[] initScriptPaths = initScriptsPath.split(",");
            GemFireXDUtils.executeSQLScripts((Connection)embedConn, initScriptPaths, false, logger, null, null, false);
        }
        Object object = sync = this.memStore.getInitialDDLReplaySync();
        synchronized (object) {
            this.memStore.setInitialDDLReplayInProgress(true);
            sync.notifyAll();
        }
        this.memStore.getDistributionAdvisor().distributeNodeStatus(false);
        lcc.setIsConnectionForRemote(true);
        lcc.setSkipLocks(true);
        int maxIterations = 4;
        GfxdDDLQueueEntry qEntry = null;
        boolean acquiredReplayLock = false;
        boolean ddReadLockAcquired = false;
        ArrayList<GemFireContainer> uninitializedContainers = new ArrayList<GemFireContainer>();
        LinkedHashSet<GemFireContainer> uninitializedTables = new LinkedHashSet<GemFireContainer>();
        Statement stmt = embedConn.createStatement();
        try {
            while (maxIterations-- > 0) {
                int actualSize;
                List<GfxdDDLQueueEntry> currentQueue;
                TLongHashSet processedIds;
                ddReadLockAcquired = false;
                if (maxIterations == 0) {
                    ddReadLockAcquired = this.dd.lockForReadingInDDLReplayNoThrow(this.memStore, 0x3FFFFFFFFFFFFFFFL, true);
                }
                this.memStore.acquireDDLReplayLock(true);
                acquiredReplayLock = true;
                TLongHashSet tLongHashSet = processedIds = this.memStore.getProcessedDDLIDs();
                synchronized (tLongHashSet) {
                    currentQueue = ddlStmtQueue.peekAndRemoveFromQueue(-1, -1);
                    for (GfxdDDLQueueEntry entry : currentQueue) {
                        Object qVal = entry.getValue();
                        if (!(qVal instanceof ReplayableConflatable)) continue;
                        ((ReplayableConflatable)qVal).markExecuting();
                    }
                    if (maxIterations > 0) {
                        this.memStore.releaseDDLReplayLock(true);
                        acquiredReplayLock = false;
                    }
                    if ((actualSize = currentQueue.size()) == 0) {
                        if (maxIterations > 1) {
                            maxIterations = 1;
                        }
                        continue;
                    }
                    Iterator<GfxdDDLQueueEntry> iter = currentQueue.iterator();
                    while (iter.hasNext()) {
                        GfxdDDLQueueEntry entry;
                        entry = iter.next();
                        Long key = entry.getKey();
                        if (processedIds.add(key.longValue())) continue;
                        iter.remove();
                    }
                    actualSize = currentQueue.size();
                }
                if (logger.infoEnabled()) {
                    logger.info("FabricDatabase: initial replay remaining iters " + maxIterations + " with remaining queue size " + actualSize);
                }
                HashMap<DDLConflatable, DDLConflatable> skipRegionInit = new HashMap<DDLConflatable, DDLConflatable>();
                TObjectIntHashMap pre11TableSchemaVer = new TObjectIntHashMap();
                boolean traceConflation = GemFireXDUtils.TraceConflation | DistributionManager.VERBOSE | GemFireXDUtils.TraceIndex;
                List<GfxdDDLQueueEntry> preprocessedQueue = ddlStmtQueue.getPreprocessedDDLQueue(currentQueue, skipRegionInit, lastCurrentSchema, pre11TableSchemaVer, traceConflation);
                Iterator<GfxdDDLQueueEntry> i$ = preprocessedQueue.iterator();
                while (i$.hasNext()) {
                    block59: {
                        GemFireContainer container;
                        AbstractGfxdReplayableMessage msg;
                        GfxdDDLQueueEntry entry;
                        qEntry = entry = i$.next();
                        Object qVal = qEntry.getValue();
                        if (logger.infoEnabled()) {
                            logger.info("FabricDatabase: starting initial replay for entry: " + qEntry);
                        }
                        LocalRegion.clearInitializingRegion();
                        if (qVal instanceof GfxdSystemProcedureMessage) {
                            msg = (GfxdSystemProcedureMessage)qVal;
                            if (((GfxdSystemProcedureMessage)msg).getSysProcMethod().isOffHeapMethod() && this.memStore.getGemFireCache().getOffHeapStore() == null) {
                                if (!logger.severeEnabled()) continue;
                                logger.severe("FabricDatabase: aborted initial replay for message " + msg + " method " + ((GfxdSystemProcedureMessage)msg).getSysProcMethod().name());
                                continue;
                            }
                            try {
                                ((GfxdSystemProcedureMessage)msg).execute();
                                break block59;
                            }
                            catch (Exception ex) {
                                if (logger.severeEnabled()) {
                                    logger.severe("FabricDatabase: failed initial replay for message " + msg + " due to exception", (Throwable)ex);
                                }
                                this.throwBootException(ex, embedConn);
                                continue;
                            }
                        }
                        if (this.memStore.restrictedDDLStmtQueue()) continue;
                        if (qVal instanceof AbstractGfxdReplayableMessage) {
                            msg = (AbstractGfxdReplayableMessage)qVal;
                            try {
                                msg.execute();
                                break block59;
                            }
                            catch (Exception ex) {
                                if (logger.severeEnabled()) {
                                    logger.severe("FabricDatabase: failed initial replay for message " + msg + " due to exception", (Throwable)ex);
                                }
                                this.throwBootException(ex, embedConn);
                                continue;
                            }
                        }
                        DDLConflatable conflatable = (DDLConflatable)qVal;
                        String confTable = conflatable.getRegionToConflate();
                        boolean isCreateTable = conflatable.isCreateTable();
                        boolean skipInitialization = false;
                        int pre11SchemaVer = 0;
                        if (pre11TableSchemaVer.size() > 0 && (isCreateTable || conflatable.isAlterTable())) {
                            pre11SchemaVer = pre11TableSchemaVer.get((Object)confTable);
                        }
                        if (isCreateTable || conflatable.isCreateIndex() || conflatable.isAlterTable()) {
                            skipInitialization = true;
                        }
                        String schema = this.executeDDL(conflatable, stmt, skipInitialization, embedConn, lastCurrentSchema, lcc, tc, logger);
                        if (isCreateTable && skipInitialization) {
                            uninitializedTables.add((GemFireContainer)Misc.getRegionForTableByPath(confTable, true).getUserAttribute());
                        }
                        if (pre11SchemaVer > 0 && (container = (GemFireContainer)Misc.getRegionForTableByPath(confTable, true).getUserAttribute()) != null && container.getCurrentSchemaVersion() == pre11SchemaVer) {
                            if (logger.infoEnabled()) {
                                logger.info("FabricDatabase: setting schema version for pre 1.1 data to " + pre11SchemaVer + " for table " + confTable);
                            }
                            container.initPre11SchemaVersionOnRecovery(this.dd, lcc);
                            pre11TableSchemaVer.remove((Object)confTable);
                        }
                        if (schema == null) continue;
                        lastCurrentSchema = schema;
                    }
                    if (!logger.infoEnabled()) continue;
                    logger.info("FabricDatabase: successfully replayed entry having sequenceId=" + qEntry.getSequenceId());
                }
            }
            this.memStore.setInitialDDLReplayPart1Done(true);
            for (GemFireContainer container : this.memStore.getAllContainers()) {
                LocalRegion region = container.getRegion();
                if (region == null || uninitializedTables.contains(container) || region.isInitialized() || region.isDestroyed()) continue;
                uninitializedContainers.add(container);
            }
            for (GemFireContainer container : uninitializedTables) {
                LocalRegion lr = container.getRegion();
                if (lr == null || lr.isDestroyed() || lr.isInitialized() || this.memStore.findConglomerate(container.getId()) == null) continue;
                uninitializedContainers.add(container);
            }
            if (!uninitializedContainers.isEmpty()) {
                this.memStore.releaseDDLReplayLock(true);
                acquiredReplayLock = false;
            }
            for (GemFireContainer container : uninitializedContainers) {
                container.preInitializeRegion();
            }
            GemFireCacheImpl cache = Misc.getGemFireCache();
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            THashMap accountingMap = null;
            if (observer != null && observer.needIndexRecoveryAccounting()) {
                accountingMap = new THashMap();
                for (DiskStoreImpl dsi : cache.listDiskStores()) {
                    if (dsi.isUsedForInternalUse()) continue;
                    dsi.TEST_INDEX_ACCOUNTING_MAP = accountingMap;
                }
                observer.setIndexRecoveryAccountingMap(accountingMap);
            }
            this.memStore.markIndexLoadBegin();
            for (DiskStoreImpl dsi : cache.listDiskStores()) {
                if (dsi.isUsedForInternalUse()) continue;
                long start = 0L;
                if (logger.infoEnabled()) {
                    start = System.currentTimeMillis();
                    logger.info("FabricDatabase: waiting for index loading from " + dsi.getName());
                }
                dsi.waitForIndexRecoveryEnd(-1L);
                if (!logger.infoEnabled()) continue;
                long end = System.currentTimeMillis();
                logger.info(MessageFormat.format("FabricDatabase: Index loading completed for {0} in {1} ms", dsi.getName(), end - start));
            }
            for (GemFireContainer container : uninitializedContainers) {
                if (logger.infoEnabled()) {
                    logger.info("FabricDatabase: start initializing container: " + container);
                }
                container.initializeRegion();
                if (!logger.infoEnabled()) continue;
                logger.info("FabricDatabase: end initializing container: " + container);
            }
            ddlStmtQueue.clearQueue();
            String currentSchema = lcc.getCurrentSchemaName();
            if (currentSchema == null) {
                currentSchema = "APP";
            }
            this.memStore.postDDLReplayInitialization(tc);
            for (GemFireContainer container : uninitializedContainers) {
                if (GemFireXDUtils.TraceDDLReplay) {
                    logger.info("FabricDatabase: start initializing numRows for " + container);
                }
                container.initNumRows(container.getRegion());
                if (!GemFireXDUtils.TraceDDLReplay) continue;
                logger.info("FabricDatabase: end initializing numRows for " + container);
            }
            if (!lastCurrentSchema.equals(currentSchema)) {
                FabricDatabase.setupDefaultSchema(this.dd, lcc, tc, currentSchema, true);
            }
            if (!this.memStore.isHadoopGfxdLonerMode()) {
                SystemProcedures.SET_EXPLAIN_SCHEMA(lcc);
            }
            lcc.setIsConnectionForRemote(false);
            lcc.setSkipLocks(false);
            Object object2 = sync;
            synchronized (object2) {
                this.memStore.setInitialDDLReplayInProgress(false);
                this.memStore.setInitialDDLReplayDone(true);
                sync.notifyAll();
            }
            if (ddReadLockAcquired) {
                this.dd.unlockAfterReading(null);
                ddReadLockAcquired = false;
            }
            if (logger.infoEnabled()) {
                logger.info("FabricDatabase: initial DDL replay completed.");
            }
            AuthenticationServiceBase.refreshAuthenticationServices(this, this.memStore, this.pf, bootProps);
            if (logger.infoEnabled()) {
                logger.info("FabricDatabase: Authentication recheck successful.");
            }
        }
        finally {
            if (ddReadLockAcquired) {
                this.dd.unlockAfterReading(null);
                ddReadLockAcquired = false;
            }
            if (acquiredReplayLock) {
                this.memStore.releaseDDLReplayLock(true);
            }
            stmt.close();
            this.memStore.setInitialDDLReplayInProgress(false);
        }
        if (!ArrayUtils.objectEquals((Object)initSchema, (Object)lcc.getCurrentSchemaName())) {
            FabricDatabase.setupDefaultSchema(this.dd, lcc, tc, initSchema, true);
        }
    }

    @Override
    public void cleanupOnError(Throwable e) {
        AuthenticationServiceBase.cleanupOnError(this, this.memStore, this.pf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeDDL(DDLConflatable conflatable, Statement stmt, boolean skipRegionInitialization, EmbedConnection embedConn, String lastCurrentSchema, LanguageConnectionContext lcc, GemFireTransaction tc, LogWriter logger) throws Exception {
        String sqlText = conflatable.getValueToConflate();
        String currentSchema = conflatable.getCurrentSchema();
        if (currentSchema == null) {
            currentSchema = "APP";
        }
        if (!lastCurrentSchema.equals(currentSchema)) {
            SanityManager.DEBUG_PRINT((String)"info:TraceDDLReplay", (String)("Setting default schema to " + currentSchema));
            FabricDatabase.setupDefaultSchema(this.dd, lcc, tc, currentSchema, true);
            lastCurrentSchema = currentSchema;
        }
        if (GemFireXDUtils.TraceIndex && (conflatable.isCreateIndex() || conflatable.isCreateIndex())) {
            GfxdIndexManager.traceIndex("executeDDL::executing sqlText=%s and skipRegionInitialization=%s", sqlText, skipRegionInitialization);
        }
        try {
            try {
                lcc.setContextObject(conflatable.getAdditionalArgs());
                lcc.setSkipRegionInitialization(skipRegionInitialization);
                lcc.setDroppedFKConstraints(conflatable.getDroppedFKConstraints());
                lcc.setDefaultPersistent(conflatable.defaultPersistent());
                tc.setDDLId(conflatable.getId());
                stmt.execute(sqlText);
                GfxdMessage.logWarnings(stmt, sqlText, "FabricDatabase: SQL warning in initial replay of DDL: ", logger);
            }
            finally {
                if (!embedConn.isClosed()) {
                    embedConn.commit();
                }
                lcc.setSkipRegionInitialization(false);
                lcc.setContextObject(null);
                lcc.setDroppedFKConstraints(null);
                lcc.setDefaultPersistent(false);
                tc.setDDLId(0L);
            }
        }
        catch (Exception ex) {
            boolean ignoreException = false;
            if (ex instanceof SQLException && ("X0Y68".equals(((SQLException)ex).getSQLState()) && conflatable.isCreateSchemaText() || "42X86".equals(((SQLException)ex).getSQLState()) && conflatable.isAlterTableDropFKConstraint())) {
                ignoreException = true;
            }
            if (ignoreException) {
                if (logger.fineEnabled()) {
                    logger.fine("FabricDatabase: ignored exception for DDL [" + sqlText + "]. Exception SQLState=" + ((SQLException)ex).getSQLState());
                }
            }
            if (logger.severeEnabled()) {
                logger.severe("FabricDatabase: failed initial replay for DDL [" + sqlText + "] due to exception" + (ex instanceof SQLException ? " with severity=" + ((SQLException)ex).getErrorCode() : ""), (Throwable)ex);
            }
            this.throwBootException(ex, embedConn);
            return null;
        }
        return lastCurrentSchema;
    }

    private void throwBootException(Exception ex, EmbedConnection embedConn) throws Exception {
        if (!this.allowBootWithFailures) {
            if (embedConn.isClosed()) {
                throw ex;
            }
            boolean ignoreException = false;
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (t instanceof DerbySQLException) {
                    if (((SQLException)t).getErrorCode() >= 20000) {
                        throw ex;
                    }
                    ignoreException = true;
                    continue;
                }
                if (!(t instanceof StandardException)) continue;
                if (((StandardException)t).getErrorCode() >= 20000) {
                    throw ex;
                }
                ignoreException = true;
            }
            if (!ignoreException) {
                throw ex;
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.active = false;
        this.tempDir.deleteAll();
        this.tempDir = null;
        this.runtimeStatisticsOn = false;
    }

    @Override
    public int getEngineType() {
        return 2;
    }

    @Override
    public boolean isReadOnly() {
        return this.memStore.isReadOnly();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname, long connectionID, boolean isRemote) throws StandardException {
        TransactionController tc = this.getConnectionTransaction(cm, connectionID);
        cm.setLocaleFinder(this);
        this.pushDbContext(cm);
        LanguageConnectionContext lctx = this.lcf.newLanguageConnectionContext(cm, tc, this.lf, this, user, drdaID, connectionID, isRemote, dbname);
        this.pushClassFactoryContext(cm, this.lcf.getClassFactory());
        ExecutionFactory ef = this.lcf.getExecutionFactory();
        ef.newExecutionContext(cm);
        lctx.initialize();
        SchemaDescriptor defaultSchema = lctx.getDefaultSchema();
        if (defaultSchema.getUUID() == null) {
            FabricDatabase.setupDefaultSchema(this.dd, lctx, tc, lctx.getAuthorizationId(), false);
        }
        lctx.internalCommitNoSync(5);
        return lctx;
    }

    public static void setupDefaultSchema(DataDictionary dd, LanguageConnectionContext lcc, TransactionController tc, String in_defaultSchema, boolean doInitialLookup) throws StandardException {
        SchemaDescriptor defaultSchema = null;
        if (doInitialLookup) {
            defaultSchema = dd.getSchemaDescriptor(in_defaultSchema, tc, false);
        }
        if (defaultSchema == null) {
            defaultSchema = new SchemaDescriptor(dd, in_defaultSchema, in_defaultSchema, dd.getUUIDFactory().createUUID(), false);
            try {
                dd.addDescriptor(defaultSchema, null, 3, false, tc);
            }
            catch (StandardException ex) {
                if ("X0Y68".equals(ex.getSQLState())) {
                    defaultSchema = dd.getSchemaDescriptor(in_defaultSchema, tc, true);
                }
                throw ex;
            }
        }
        lcc.setDefaultSchema(defaultSchema);
    }

    @Override
    public final GfxdDataDictionary getDataDictionary() {
        return this.dd;
    }

    public final DataValueFactory getDataValueFactory() {
        return this.dataValueFactory;
    }

    public final LogFactory getLogFactory() {
        return this.logFactory;
    }

    public final LanguageConnectionFactory getConnectionFactory() {
        return this.lcf;
    }

    public final ClassFactory getClassFactory() {
        return this.cfDB;
    }

    @Override
    public void pushDbContext(ContextManager cm) {
        new DatabaseContextImpl(cm, this);
    }

    @Override
    public final AuthenticationService getAuthenticationService() {
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Unexpected - There is no valid authentication service for the database!");
        return this.authenticationService;
    }

    public final AuthenticationService getPeerAuthenticationService() {
        SanityManager.ASSERT((this.peerAuthenticationService != null ? 1 : 0) != 0, (String)"Unexpected - There is no valid peer authentication service for the database!");
        return this.peerAuthenticationService;
    }

    @Override
    public void freeze() throws SQLException {
        try {
            this.memStore.freeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void unfreeze() throws SQLException {
        try {
            this.memStore.unfreeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backup(String backupDir, boolean wait) throws SQLException {
        try {
            this.memStore.backup(backupDir, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws SQLException {
        try {
            this.memStore.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws SQLException {
        try {
            this.memStore.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void checkpoint() throws SQLException {
        try {
            this.memStore.checkpoint();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public final Locale getLocale() {
        return this.databaseLocale;
    }

    @Override
    public final UUID getId() {
        return this.myUUID;
    }

    @Override
    public final Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw FabricDatabase.noLocale();
    }

    @Override
    public final DateFormat getDateFormat() throws StandardException {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        throw FabricDatabase.noLocale();
    }

    @Override
    public final DateFormat getTimeFormat() throws StandardException {
        if (this.timeFormat != null) {
            return this.timeFormat;
        }
        throw FabricDatabase.noLocale();
    }

    @Override
    public DateFormat getTimestampFormat() throws StandardException {
        if (this.timestampFormat != null) {
            return this.timestampFormat;
        }
        throw FabricDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S");
    }

    @Override
    public final void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
        this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
        this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
    }

    @Override
    public final boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean create, Properties startParams) throws StandardException {
        String upgradeID = null;
        UUID databaseID = (UUID)this.memStore.getProperty("gemfirexd.distributedsystemID");
        if (databaseID == null) {
            UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
            upgradeID = startParams.getProperty("gemfirexd.distributedsystemID");
            databaseID = upgradeID == null ? uuidFactory.createUUID() : uuidFactory.recreateUUID(upgradeID);
            this.memStore.setProperty("gemfirexd.distributedsystemID", databaseID, true);
        }
        if (upgradeID != null) {
            startParams.remove("gemfirexd.distributedsystemID");
        }
        return databaseID;
    }

    @Override
    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("gemfirexd.engineType")) {
            throw StandardException.newException("XCY02.S", (Object)key, (Object)value);
        }
        if ("gemfirexd.distributedsystem.statement-explain-mode".equals(key) || "gemfirexd.distributedsystem.statistics-summary-mode".equals(key) || "gemfirexd.distributedsystem.statement-statistics-mode".equals(key)) {
            return true;
        }
        if (!key.equals("gemfirexd.distributedsystem.classpath")) {
            return false;
        }
        String newClasspath = (String)((Object)value);
        String[][] dbcp = null;
        if (newClasspath != null) {
            dbcp = IdUtil.parseDbClassPath(newClasspath);
        }
        if (dbcp != null) {
            for (int ix = 0; ix < dbcp.length; ++ix) {
                SchemaDescriptor sd = this.dd.getSchemaDescriptor(dbcp[ix][0], null, false);
                FileInfoDescriptor fid = null;
                if (sd != null) {
                    fid = this.dd.getFileInfoDescriptor(sd, dbcp[ix][1]);
                }
                if (fid != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(dbcp[ix]));
            }
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if ("gemfirexd.distributedsystem.statement-explain-mode".equals(key) || "gemfirexd.distributedsystem.statistics-summary-mode".equals(key) || "gemfirexd.distributedsystem.statement-statistics-mode".equals(key)) {
            if (value != null) {
                DistributionObserver.setObserver();
            } else {
                DistributionObserver.unsetObserver();
            }
            return null;
        }
        if (!key.equals("gemfirexd.distributedsystem.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String newClasspath = (String)((Object)value);
            if (newClasspath == null) {
                newClasspath = "";
            }
            this.cfDB.notifyModifyClasspath(newClasspath);
        }
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.memStore.createFinished();
    }

    protected String getClasspath(Properties startParams) {
        String cp = PropertyUtil.getPropertyFromSet(startParams, "gemfirexd.distributedsystem.classpath");
        if (cp == null) {
            cp = PropertyUtil.getSystemProperty("gemfirexd.distributedsystem.classpath", "");
        }
        return cp;
    }

    protected void bootClassFactory(boolean create, Properties startParams) throws StandardException {
        String classpath = this.getClasspath(startParams);
        IdUtil.parseDbClassPath(classpath);
        startParams.put("gemfirexd.__rt.distributedsystem.classpath", classpath);
        this.cfDB = (ClassFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory", startParams);
    }

    protected TransactionController getConnectionTransaction(ContextManager cm, long connectionID) throws StandardException {
        return this.memStore.getTransaction(cm, connectionID);
    }

    protected AuthenticationService bootAuthenticationService(boolean create, Properties props) throws StandardException {
        this.peerAuthenticationService = (AuthenticationService)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "peer.authentication", props);
        assert (this.peerAuthenticationService instanceof AuthenticationServiceBase);
        AuthenticationServiceBase.setPeerAuthenticationService((AuthenticationServiceBase)this.peerAuthenticationService);
        return (AuthenticationService)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "authentication", props);
    }

    protected void bootValidation(boolean create, Properties startParams) throws StandardException {
        String tempDir = startParams.getProperty("gemfirexd.storage.tempDirectory", PropertyUtil.getSystemProperty("gemfirexd.storage.tempDirectory"));
        if (tempDir == null && (tempDir = startParams.getProperty("gemfirexd.system.home", PropertyUtil.getSystemProperty("gemfirexd.system.home"))) == null && (tempDir = startParams.getProperty("sys-disk-dir", PropertyUtil.getSystemProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP))) == null) {
            tempDir = PropertyUtil.getSystemProperty("java.io.tmpdir");
        }
        try {
            final String tDir = tempDir;
            this.tempDir = AccessController.doPrivileged(new PrivilegedExceptionAction<DirFile>(){

                @Override
                public DirFile run() throws IOException {
                    int retry = 0;
                    do {
                        int rl = PartitionedRegion.rand.nextInt(Integer.MAX_VALUE);
                        DirFile df = new DirFile(tDir, FabricDatabase.TEMP_DIR_PREFIX + Integer.toString(rl) + ".d");
                        df.deleteOnExit();
                        if (!df.mkdirs()) continue;
                        assert (df.canWrite());
                        return df;
                    } while (retry++ < 10);
                    throw new IOException("Temp Directory couldn't be created on " + tDir);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ioe = pae.getException();
            if (ioe instanceof IOException) {
                throw StandardException.newException("XSLAQ.D", ioe);
            }
            throw GemFireXDRuntimeException.newRuntimeException("PrivilegedActionException", pae.getException());
        }
        this.tempDir.deleteOnExit();
        this.pf = (PropertyFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory", startParams);
    }

    protected void bootStore(boolean create, Properties startParams) throws StandardException {
        try {
            this.memStore = (GemFireStore)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory", startParams);
        }
        catch (StandardException se) {
            this.cleanupOnError(se);
            throw se;
        }
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        return this.memStore.getProperties();
    }

    protected void bootResourceAdapter(boolean create, Properties allParams) {
        try {
            this.resourceAdapter = Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter", allParams);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager cm, ClassFactory cf) {
        new StoreClassFactoryContext(cm, cf, this.memStore, this);
    }

    @Override
    public StorageFile getJarFile(String schemaName, String sqlName) throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(schemaName, null, true);
        FileInfoDescriptor fid = this.dd.getFileInfoDescriptor(sd, sqlName);
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)sqlName, (Object)schemaName);
        }
        long generationId = fid.getGenerationId();
        GfxdJarResource fr = this.memStore.getJarFileHandler();
        String externalName = schemaName + "." + sqlName;
        return fr.getAsFile(externalName, generationId);
    }

    @Override
    public void failover(String dbname) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInSlaveMode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean disableStatementOptimizationToGenericPlan() {
        return this.disableStatementOptimization;
    }

    public void setdisableStatementOptimizationToGenericPlan() {
        this.disableStatementOptimization = true;
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopReplicationMaster() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        throw new UnsupportedOperationException();
    }

    public final DirFile getTempDir() {
        return this.tempDir;
    }

    @Override
    public final boolean getRuntimeStatistics() {
        return this.runtimeStatisticsOn;
    }

    public static final void __setRuntimeStatistics(LanguageConnectionContext lcc, boolean onOff) {
        if (onOff) {
            DistributionObserver.setObserver();
        }
        lcc.setRunTimeStatisticsMode(onOff, false);
        if (onOff) {
            Iterator<XPLAINTableDescriptor> it = XPLAINTableDescriptor.getRegisteredDescriptors();
            while (it.hasNext()) {
                XPLAINTableDescriptor t = it.next();
                lcc.setExplainStatement(t.getCatalogName(), t.getTableInsert());
            }
        }
        if (!onOff) {
            DistributionObserver.unsetObserver();
        }
    }
}

