/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedLockObject;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSet;
import com.gemstone.gemfire.internal.concurrent.FetchFromMap;
import com.gemstone.gemfire.internal.shared.FinalizeHolder;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.access.GfxdTXStateProxy;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemIndexOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.entry.GfxdTXEntryState;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.WrapperRowLocationForTxn;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class SortedMap2IndexScanController
extends MemIndexScanController
implements FetchFromMap {
    private ConcurrentSkipListMap<Object, Object> skipListMap;
    private RowLocation initRowLocation;
    private Object currentKey;
    private Object currentIndexKey;
    private int currentNodeVersion;
    private Object lookupValue;
    private AbstractRowLocationIterator rlIterator;
    private RowLocationArrayIterator cachedArrayIterator;
    private RowLocationSetIterator cachedSetIterator;
    private Iterator<?> sourceIterator;
    private boolean fullIteratorForStats;
    private LocalRegion baseRegion;
    private int[] keyScanList;
    private boolean containRowLocation;
    private boolean needScanKey;
    private Set<Integer> localBucketSet;
    private int scanKeyGroupID = 0;
    protected final int[] lockFlags = new int[1];

    @Override
    public int getType() {
        return 3;
    }

    private void createKeyScanList(FormatableBitSet scanColumnList, int rowLocationColumn) throws StandardException {
        int numKeyScanList;
        int numBitsSet;
        this.needScanKey = true;
        if (scanColumnList == null || (numBitsSet = scanColumnList.getNumBitsSet()) == 0) {
            this.keyScanList = null;
            this.containRowLocation = true;
            return;
        }
        this.containRowLocation = scanColumnList.getLength() > rowLocationColumn ? scanColumnList.isSet(rowLocationColumn) : false;
        int n = numKeyScanList = this.containRowLocation ? numBitsSet - 1 : numBitsSet;
        if (numKeyScanList == 0) {
            this.needScanKey = false;
            return;
        }
        this.keyScanList = new int[numKeyScanList];
        int i = scanColumnList.anySetBit();
        for (int j = 0; i != -1 && j < numKeyScanList; ++j) {
            this.keyScanList[j] = i;
            i = scanColumnList.anySetBit(i);
        }
    }

    @Override
    protected void postProcessSearchCondition() throws StandardException {
        this.createKeyScanList(this.init_scanColumnList, this.openConglom.getConglomerate().rowLocationColumn);
        RowLocation startKeyRL = null;
        RowLocation stopKeyRL = null;
        if (this.init_startKeyValue != null && (startKeyRL = this.getRowLocation(this.init_startKeyValue)) != null) {
            this.init_startKeyValue = this.removeRowLocation(this.init_startKeyValue);
        }
        if (this.init_stopKeyValue != null && (stopKeyRL = this.getRowLocation(this.init_stopKeyValue)) != null) {
            this.init_stopKeyValue = this.removeRowLocation(this.init_stopKeyValue);
        }
        if (startKeyRL == null != (stopKeyRL == null)) {
            SanityManager.THROWASSERT((String)"unexpected mismatch of null values of start and stop RowLocations");
        }
        if (startKeyRL != null && stopKeyRL != null && startKeyRL != stopKeyRL) {
            SanityManager.THROWASSERT((String)"unexpected mismatch of start and stop RowLocations");
        }
        this.initRowLocation = startKeyRL;
        if (this.skipListMap == null) {
            this.skipListMap = this.openConglom.getGemFireContainer().getSkipListMap();
            SanityManager.ASSERT((this.skipListMap != null ? 1 : 0) != 0, (String)"this index container does not exist!");
        }
    }

    @Override
    protected void initEnumerator() throws StandardException {
        RowLocationSetIterator rlSetItr;
        if (GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery) {
            GfxdIndexManager.traceIndex("SortedMap2IndexScanController#initEnum: container %s startKey=%s, stopKey=%s", this.openConglom.getConglomerate(), this.init_startKeyValue, this.init_stopKeyValue);
        }
        this.rlIterator = null;
        if (this.cachedArrayIterator != null) {
            this.cachedArrayIterator = null;
        }
        if ((rlSetItr = this.cachedSetIterator) != null) {
            rlSetItr.close();
            this.cachedSetIterator = null;
        }
        this.scanKeyGroupID = 0;
        this.sourceIterator = null;
        this.fullIteratorForStats = false;
        this.currentDataRegion = null;
        GemFireContainer container = this.openConglom.getGemFireContainer();
        if (this.init_startSearchOperator == 7) {
            this.sourceIterator = this.skipListMap.descendingMap(this.statNumRowsVisited).entrySet().iterator();
        } else {
            boolean toInclusive;
            boolean fromInclusive = this.init_startSearchOperator == 1;
            boolean bl = toInclusive = this.init_stopSearchOperator == -1;
            if (this.init_startKeyValue == null && this.init_stopKeyValue == null) {
                this.sourceIterator = this.skipListMap.entrySet().iterator();
                if (this.statNumRowsVisited != null) {
                    this.fullIteratorForStats = true;
                }
            } else if (this.init_startKeyValue == null && this.init_stopKeyValue != null) {
                this.sourceIterator = this.skipListMap.headMap(OpenMemIndex.newLocalKeyObject(this.init_stopKeyValue, this.openConglom.getGemFireContainer()), toInclusive, this.statNumRowsVisited).entrySet().iterator();
            } else if (this.init_startKeyValue != null && this.init_stopKeyValue == null) {
                this.sourceIterator = this.skipListMap.tailMap(OpenMemIndex.newLocalKeyObject(this.init_startKeyValue, this.openConglom.getGemFireContainer()), fromInclusive, this.statNumRowsVisited).entrySet().iterator();
            } else if (this.init_startKeyValue == this.init_stopKeyValue && fromInclusive && this.baseContainer.isByteArrayStore()) {
                if (this.openConglom.getGemFireContainer().numColumns() == this.init_startKeyValue.length) {
                    this.sourceIterator = null;
                    this.lookupValue = this.skipListMap.get(OpenMemIndex.newLocalKeyObject(this.init_startKeyValue, container), (FetchFromMap)this, null);
                    if (this.lookupValue == MemIndexOperation.TOK_INDEX_KEY_DEL) {
                        this.lookupValue = null;
                    }
                } else {
                    this.sourceIterator = this.skipListMap.subMap(OpenMemIndex.newLocalKeyObject(this.init_startKeyValue, container), fromInclusive, OpenMemIndex.newLocalKeyObject(this.init_stopKeyValue, container), toInclusive, this.statNumRowsVisited).entrySet().iterator();
                }
            } else {
                this.sourceIterator = this.skipListMap.subMap(OpenMemIndex.newLocalKeyObject(this.init_startKeyValue, container), fromInclusive, OpenMemIndex.newLocalKeyObject(this.init_stopKeyValue, container), toInclusive, this.statNumRowsVisited).entrySet().iterator();
            }
        }
        if (this.sourceIterator != null && this.init_qualifier != null && this.baseContainer.isByteArrayStore()) {
            RowFormatter rf = this.openConglom.getGemFireContainer().getExtraIndexInfo().getPrimaryKeyFormatter();
            for (int idx = this.init_qualifier.length - 1; idx >= 0; --idx) {
                for (Qualifier q : this.init_qualifier[idx]) {
                    if (GemFireXDUtils.TraceByteComparisonOptimization) {
                        SanityManager.DEBUG_PRINT((String)"TraceByteCompareOptimization", (String)("attempting to re-align qualifier " + q));
                    }
                    q.alignOrderableCache(rf.getColumnDescriptor(q.getColumnId()), null);
                }
            }
        }
        this.baseRegion = this.baseContainer.getRegion();
        if (this.localBucketSet == null) {
            boolean bucketSetGotFromSingleHop = false;
            if (this.lcc != null) {
                Set<Integer> bset = this.lcc.getBucketIdsForLocalExecution();
                Region<?, ?> regionForBSet = null;
                boolean prpLEItr = false;
                if (bset != null && (regionForBSet = this.lcc.getRegionForBucketSet()) == this.baseRegion) {
                    prpLEItr = true;
                }
                if (SanityManager.TraceSingleHop) {
                    SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("SortedMap2IndexScanController::initEnumerator bucketSet: " + bset + " and forUpdate=" + (this.forUpdate != 0) + " base region is: " + this.baseRegion + " and lcc: " + this.lcc + " and region is: " + (regionForBSet != null ? regionForBSet.getName() : "(null)")));
                }
                if (prpLEItr) {
                    this.localBucketSet = bset;
                    bucketSetGotFromSingleHop = true;
                }
            }
            if (!bucketSetGotFromSingleHop) {
                this.localBucketSet = SortedMap2IndexScanController.getLocalBucketSet(container, this.baseRegion, this.activation, "SortedMap2IndexScanController");
            }
        }
        if (this.activation != null && this.localBucketSet == null && this.activation.getUseOnlyPrimaryBuckets() && this.baseContainer.isPartitioned()) {
            this.localBucketSet = ((PartitionedRegion)this.baseRegion).getDataStore().getAllLocalPrimaryBucketIds();
        }
        this.hasNext = true;
    }

    public void setMapKey(Object key, int version) {
        this.currentIndexKey = key;
        this.currentNodeVersion = version;
    }

    @Override
    public final Object getCurrentKey() {
        return this.currentIndexKey;
    }

    @Override
    public final int getCurrentNodeVersion() {
        return this.currentNodeVersion;
    }

    private RowLocation getRowLocation(DataValueDescriptor[] searchKey) {
        int lastIndex;
        if (searchKey == null || !(searchKey[lastIndex = searchKey.length - 1] instanceof RowLocation)) {
            return null;
        }
        return (RowLocation)searchKey[lastIndex];
    }

    @Override
    public boolean delete() throws StandardException {
        GemFireContainer container = this.openConglom.getGemFireContainer();
        Object value = this.baseContainer.isOffHeap() ? Long.valueOf(((OffHeapRegionEntry)this.currentRowLocation).getAddress()) : this.currentRowLocation.getValueOrOffHeapEntry(this.baseRegion);
        return SortedMap2IndexDeleteOperation.doMe(this.tran, container, OpenMemIndex.newLocalKeyObject(this.currentKey, container), this.currentRowLocation, this.openConglom.isUnique(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean next() throws StandardException {
        boolean ret;
        block21: {
            block22: {
                RegionEntry entry;
                TXState localTXState;
                LocalRegion dataRegion;
                if (!this.hasNext) {
                    this.currentDataRegion = null;
                    return false;
                }
                ret = false;
                while (true) {
                    RowLocation rl;
                    dataRegion = null;
                    this.currentDataRegion = null;
                    if (this.rlIterator == null) {
                        rl = this.moveRowLocationIterator();
                        if (rl == null) {
                            this.currentRowLocation = null;
                            ret = false;
                            break block21;
                        }
                    } else {
                        rl = this.rlIterator.next();
                        if (rl != null) {
                            if (this.statNumRowsVisited != null) {
                                this.statNumRowsVisited[0] = this.statNumRowsVisited[0] + 1;
                            }
                        } else {
                            rl = this.moveRowLocationIterator();
                            if (rl == null) {
                                this.currentRowLocation = null;
                                ret = false;
                                break block21;
                            }
                        }
                    }
                    localTXState = this.localTXState;
                    int bucketId = rl.getBucketID();
                    if (localTXState != null && !localTXState.isEmpty() && rl.getTXId() == null && (rl = (RowLocation)localTXState.getLocalEntry(this.baseRegion, dataRegion = this.baseRegion.getDataRegionForRead(rl.getKey(), null, bucketId, Operation.GET_ENTRY), bucketId, (AbstractRegionEntry)rl)) == null) {
                        this.currentRowLocation = null;
                        ret = false;
                        break block21;
                    }
                    this.currentRowLocation = rl;
                    GemFireXDQueryObserver observer = this.observer;
                    if (observer != null) {
                        observer.beforeInvokingContainerGetTxRowLocation(rl);
                    }
                    ret = false;
                    if (this.initRowLocation != null && rl != this.initRowLocation) continue;
                    ret = true;
                    if (this.readLockMode == null || this.txId.equals(rl.getTXId())) break block22;
                    entry = rl.getUnderlyingRegionEntry();
                    if (dataRegion == null) {
                        dataRegion = this.baseRegion.getDataRegionForRead(rl.getKey(), null, bucketId, Operation.GET_ENTRY);
                    }
                    if (this.forReadOnly) {
                        this.lockFlags[0] = 0;
                        if (localTXState.getProxy().lockEntry(entry, entry.getKey(), GemFireXDUtils.getRoutingObject(bucketId), this.baseRegion, dataRegion, false, TXEntryState.getReadOnlyOp(), this.lockFlags) == null) continue;
                        if (this.lockFlags[0] == 2) {
                            this.currentDataRegion = dataRegion;
                        }
                        break block22;
                    }
                    if (GemFireXDUtils.lockForRead(localTXState, this.lockPolicy, this.readLockMode, this.forUpdate, entry, this.baseContainer, dataRegion, this.observer)) break;
                }
                this.currentDataRegion = dataRegion;
                localTXState.addReadLockForScan((ExclusiveSharedLockObject)entry, this.readLockMode, dataRegion, this.lockContext);
            }
            if (GemFireXDUtils.TraceIndex && ret && this.currentRowLocation != null) {
                ExecRow row = this.currentRowLocation.getRowWithoutFaultIn(this.baseContainer);
                try {
                    Object regionKey = this.currentRowLocation.getKey();
                    GfxdIndexManager.traceIndex("SortedMap2IndexScanController: Entry found for region key=%s, bucketID=%s, baseContainer=%s, TX=%s (current TX: %s): %s", regionKey, this.currentRowLocation.getBucketID(), this.baseContainer, this.currentRowLocation.getTXId(), this.txState, row);
                }
                finally {
                    if (row != null) {
                        row.releaseByteSource();
                    }
                }
            }
        }
        if (ret) {
            if (this.init_startSearchOperator == 7) {
                this.hasNext = false;
            }
            ++this.statNumRowsQualified;
            return true;
        }
        this.checkCancelInProgress();
        return false;
    }

    @Override
    public int sizeOfIndex() {
        int retval = 0;
        for (Object value : this.skipListMap.values()) {
            if (value == null) continue;
            Class<?> valueCls = value.getClass();
            if (valueCls == RowLocation[].class) {
                retval += ((RowLocation[])value).length;
                continue;
            }
            if (valueCls == ConcurrentTHashSet.class) {
                retval += ((ConcurrentTHashSet)value).size();
                continue;
            }
            assert (value instanceof RowLocation) : "unexpected type in index " + valueCls.getName() + ": " + value;
            ++retval;
        }
        return retval;
    }

    @Override
    public void fetch(DataValueDescriptor[] destRow) throws StandardException {
        this.assembleRow(destRow);
    }

    private final void assembleRow(DataValueDescriptor[] destRow) throws StandardException {
        int num = 0;
        if (this.needScanKey) {
            Class<?> keyCls = this.currentKey.getClass();
            if (keyCls == CompactCompositeIndexKey.class) {
                num = GemFireXDUtils.fetchValue((CompactCompositeIndexKey)this.currentKey, destRow, this.keyScanList);
            } else if (keyCls == DataValueDescriptor[].class) {
                num = GemFireXDUtils.fetchValue((DataValueDescriptor[])this.currentKey, destRow, this.keyScanList);
            } else {
                if (this.keyScanList == null) {
                    assert (destRow[0] != null);
                    destRow[0].setValue((DataValueDescriptor)this.currentKey);
                } else {
                    destRow[this.keyScanList[0]].setValue((DataValueDescriptor)this.currentKey);
                }
                num = 1;
            }
        }
        if (this.containRowLocation && num < destRow.length) {
            num = destRow.length - 1;
            assert (destRow[num] != null);
            destRow[num] = this.currentRowLocation;
        }
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] destRow) throws StandardException {
        if (this.next()) {
            if (destRow.length > 0) {
                this.assembleRow(destRow);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void fetch(ExecRow destRow) throws StandardException {
        assert (destRow instanceof ValueRow || destRow instanceof ExecIndexRow) : "unexpected destRow " + destRow;
        this.assembleRow(destRow.getRowArray());
    }

    @Override
    public final boolean fetchNext(ExecRow destRow) throws StandardException {
        assert (destRow instanceof ValueRow || destRow instanceof ExecIndexRow) : "unexpected destRow " + destRow;
        DataValueDescriptor[] rowArray = destRow.getRowArray();
        if (this.next()) {
            if (rowArray.length > 0) {
                this.assembleRow(rowArray);
            }
            return true;
        }
        return false;
    }

    @Override
    public long getEstimatedRowCount() throws StandardException {
        if (this.estimatedRowCount == -1L) {
            this.estimatedRowCount = this.baseContainer.getNumRows();
            return this.estimatedRowCount;
        }
        return this.estimatedRowCount;
    }

    @Override
    protected void closeScan() {
        RowLocationSetIterator rlSetItr;
        this.skipListMap = null;
        this.localBucketSet = null;
        this.initRowLocation = null;
        this.currentKey = null;
        this.currentIndexKey = null;
        this.rlIterator = null;
        if (this.cachedArrayIterator != null) {
            this.cachedArrayIterator = null;
        }
        if ((rlSetItr = this.cachedSetIterator) != null) {
            rlSetItr.close();
            this.cachedSetIterator = null;
        }
        this.scanKeyGroupID = 0;
        this.sourceIterator = null;
        this.lookupValue = null;
        this.keyScanList = null;
        this.fullIteratorForStats = false;
        this.baseRegion = null;
        this.currentDataRegion = null;
        this.observer = null;
    }

    @Override
    public final int getScanKeyGroupID() {
        return this.scanKeyGroupID;
    }

    public String toString() {
        String string = "\nSortedMap2IndexScanController\tskiplist-congid = " + (this.baseContainer != null ? this.baseContainer.getId() : Integer.valueOf(-1)) + "\n\tinit_scanColumnList = " + this.init_scanColumnList + "\n\tinit_scanColumnList.size() = " + (this.init_scanColumnList != null ? this.init_scanColumnList.size() : 0) + "\n\tinit_startKeyValue = " + RowUtil.toString(this.init_startKeyValue) + "\n\tinit_startSearchOperator = " + (this.init_startSearchOperator == 1 ? "GE" : (this.init_startSearchOperator == -1 ? "GT" : Integer.toString(this.init_startSearchOperator))) + "\n\tinit_qualifier[]         = " + Arrays.deepToString((Object[])this.init_qualifier) + "\n\tinit_stopKeyValue = " + RowUtil.toString(this.init_stopKeyValue) + "\n\tinit_stopSearchOperator = " + (this.init_stopSearchOperator == 1 ? "GE" : (this.init_stopSearchOperator == -1 ? "GT" : Integer.toString(this.init_stopSearchOperator)));
        return string;
    }

    private final RowLocation moveRowLocationIterator() throws StandardException {
        RowLocationSetIterator rlSetItr;
        Object nextValue;
        while ((nextValue = this.nextMapValue()) != null) {
            RowLocation rl;
            Class<?> valueCls;
            Qualifier[][] qualifiers = this.init_qualifier;
            if (qualifiers != null) {
                Object ckey = this.currentKey;
                Class<?> keyCls = ckey.getClass();
                if (keyCls == CompactCompositeIndexKey.class) {
                    CompactCompositeIndexKey ccKey = (CompactCompositeIndexKey)ckey;
                    if (qualifiers != null && !RowFormatter.qualifyRow(ccKey, qualifiers)) {
                        continue;
                    }
                } else if (keyCls != DataValueDescriptor[].class ? qualifiers != null && !RowUtil.qualifyRow(null, (DataValueDescriptor)ckey, qualifiers, false) : qualifiers != null && !RowUtil.qualifyRow((DataValueDescriptor[])ckey, null, qualifiers, false)) continue;
            }
            if ((valueCls = nextValue.getClass()) == RowLocation[].class) {
                RowLocationArrayIterator arrayIter = this.cachedArrayIterator;
                if (arrayIter != null) {
                    arrayIter.reset((RowLocation[])nextValue);
                    this.rlIterator = arrayIter;
                } else {
                    this.cachedArrayIterator = new RowLocationArrayIterator((RowLocation[])nextValue, this.txState, this.baseContainer, this.localBucketSet, this.openMode);
                    this.rlIterator = this.cachedArrayIterator;
                }
                if ((rl = this.rlIterator.next()) == null) continue;
                ++this.scanKeyGroupID;
                return rl;
            }
            if (valueCls == ConcurrentTHashSet.class) {
                rl = this.scanHashSet((ConcurrentTHashSet)nextValue);
                if (rl == null) continue;
                ++this.scanKeyGroupID;
                return rl;
            }
            this.rlIterator = null;
            rl = AbstractRowLocationIterator.isRowLocationValid((RowLocation)nextValue, this.lcc, this.txState, this.baseContainer, this.localBucketSet, this.openMode);
            if (rl != null) {
                ++this.scanKeyGroupID;
                return rl;
            }
            ++this.statNumDeletedRowsVisited;
        }
        this.rlIterator = null;
        if (this.cachedArrayIterator != null) {
            this.cachedArrayIterator = null;
        }
        if ((rlSetItr = this.cachedSetIterator) != null) {
            rlSetItr.close();
            this.cachedSetIterator = null;
        }
        return null;
    }

    public final boolean qualifyRow(RowLocation rl, ExecRow row, Object indexKey, int nodeVersion) throws StandardException {
        if (row != null && indexKey.getClass() == CompactCompositeIndexKey.class) {
            CompactCompositeIndexKey ccKey = (CompactCompositeIndexKey)indexKey;
            int version = ccKey.getVersion();
            GemFireXDQueryObserver observer = this.observer;
            if (nodeVersion == version && !rl.isUpdateInProgress()) {
                if (observer != null) {
                    observer.afterIndexRowRequalification(null, ccKey, row, this.activation);
                }
                return true;
            }
            Object valueBytes = row.getByteSource();
            if (valueBytes != null) {
                boolean result = ccKey.equalsValueBytes(valueBytes);
                if (observer != null) {
                    observer.afterIndexRowRequalification(result, ccKey, row, this.activation);
                }
                return result;
            }
        }
        return true;
    }

    private final RowLocation scanHashSet(ConcurrentTHashSet<?> set) throws StandardException {
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("SortedMap2IndexScanController#scanHashMap: For index baseContainer %s for key [%s] qualified values: %s", this.baseContainer, this.currentKey, set);
        }
        if (this.initRowLocation != null) {
            this.rlIterator = null;
            if (set.contains((Object)this.initRowLocation)) {
                return AbstractRowLocationIterator.isRowLocationValid(this.initRowLocation, this.lcc, this.txState, this.baseContainer, this.localBucketSet, this.openMode);
            }
            return null;
        }
        RowLocationSetIterator setIter = this.cachedSetIterator;
        if (setIter != null) {
            setIter.reset(set);
            this.rlIterator = setIter;
        } else {
            this.cachedSetIterator = new RowLocationSetIterator(set, this.txState, this.baseContainer, this.localBucketSet, this.openMode);
            this.rlIterator = this.cachedSetIterator;
        }
        return this.rlIterator.next();
    }

    private final Object nextMapValue() throws StandardException {
        if (this.sourceIterator == null) {
            this.currentKey = this.init_startKeyValue;
            if (this.fullIteratorForStats) {
                this.statNumRowsVisited[0] = this.statNumRowsVisited[0] + 1;
            }
            Object result = this.lookupValue;
            this.lookupValue = null;
            return result;
        }
        Object retVal = null;
        while (this.sourceIterator.hasNext()) {
            ConcurrentSkipListMap.SimpleReusableEntry entry = (ConcurrentSkipListMap.SimpleReusableEntry)this.sourceIterator.next();
            this.currentKey = this.currentIndexKey = entry.getKey();
            this.currentNodeVersion = entry.getVersion();
            if (this.fullIteratorForStats) {
                this.statNumRowsVisited[0] = this.statNumRowsVisited[0] + 1;
            }
            if ((retVal = entry.getValue()) == MemIndexOperation.TOK_INDEX_KEY_DEL) continue;
        }
        return retVal;
    }

    private static final class RSLockManager
    extends FinalizeObject {
        private ConcurrentTHashSet<?> set;

        RSLockManager(RowLocationSetIterator itr, ConcurrentTHashSet<?> set) {
            super((Object)itr, true);
            this.init(set);
        }

        void init(ConcurrentTHashSet<?> set) {
            this.unlock();
            if (set != null) {
                set.lockAllSegmentsForRead();
                this.set = set;
            }
        }

        protected boolean doFinalize() throws Exception {
            this.unlock();
            return true;
        }

        final void unlock() {
            ConcurrentTHashSet<?> set = this.set;
            if (set != null) {
                set.unlockAllSegmentsAfterRead();
                this.set = null;
            }
        }

        protected final FinalizeHolder getHolder() {
            return RSLockManager.getServerHolder();
        }

        protected void clearThis() {
            this.unlock();
        }
    }

    private final class RowLocationSetIterator
    extends AbstractRowLocationIterator {
        private Object[] itrCache;
        private int itrPos;
        private ConcurrentTHashSet.Itr itr;
        private RSLockManager lockManager;

        RowLocationSetIterator(ConcurrentTHashSet<?> vals, TXStateInterface tx, GemFireContainer con, Set<Integer> localBucketSet, int openMode) {
            super(tx, con, localBucketSet, openMode);
            this.init(vals, tx);
        }

        @Override
        public RowLocation next() throws StandardException {
            block5: {
                block4: {
                    Object[] itrCache = this.itrCache;
                    if (this.itrCache == null) break block4;
                    int itrLen = itrCache.length;
                    while (this.itrPos < itrLen) {
                        RowLocation rl = (RowLocation)itrCache[this.itrPos++];
                        if ((rl = RowLocationSetIterator.isRowLocationValid(rl, SortedMap2IndexScanController.this.lcc, this.txState, this.container, this.localBucketSet, this.openMode)) != null) {
                            return rl;
                        }
                        ++SortedMap2IndexScanController.this.statNumDeletedRowsVisited;
                    }
                    break block5;
                }
                ConcurrentTHashSet.Itr itr = this.itr;
                if (itr == null) break block5;
                while (itr.hasNext()) {
                    RowLocation rl = RowLocationSetIterator.isRowLocationValid((RowLocation)itr.next(), SortedMap2IndexScanController.this.lcc, this.txState, this.container, this.localBucketSet, this.openMode);
                    if (rl != null) {
                        return rl;
                    }
                    ++SortedMap2IndexScanController.this.statNumDeletedRowsVisited;
                }
            }
            return null;
        }

        private final void init(ConcurrentTHashSet<?> vals, TXStateInterface tx) {
            if (tx == null) {
                this.itr = vals.iterator();
            } else if ((long)vals.size() <= DistributedRegion.MAX_PENDING_ENTRIES) {
                this.itrCache = vals.toArray();
                this.itrPos = 0;
                RSLockManager lm = this.lockManager;
                if (lm != null) {
                    lm.unlock();
                }
                this.itr = null;
            } else {
                RSLockManager lm = this.lockManager;
                if (lm != null) {
                    lm.init(vals);
                } else {
                    this.lockManager = new RSLockManager(this, vals);
                }
                this.itr = vals.iterator();
                this.itrCache = null;
                this.itrPos = 0;
            }
        }

        final void reset(ConcurrentTHashSet<?> vals) {
            this.init(vals, this.txState);
        }

        private final void close() {
            RSLockManager lm = this.lockManager;
            if (lm != null) {
                lm.clearAll();
                this.lockManager = null;
            }
            this.itr = null;
            this.itrCache = null;
            this.itrPos = 0;
        }
    }

    private final class RowLocationArrayIterator
    extends AbstractRowLocationIterator {
        private RowLocation[] rlArray;
        private int index;

        RowLocationArrayIterator(RowLocation[] array, TXStateInterface tx, GemFireContainer con, Set<Integer> localBucketSet, int openMode) {
            super(tx, con, localBucketSet, openMode);
            this.rlArray = array;
            this.index = 0;
        }

        @Override
        public RowLocation next() throws StandardException {
            while (this.index < this.rlArray.length) {
                RowLocation rl = RowLocationArrayIterator.isRowLocationValid(this.rlArray[this.index], SortedMap2IndexScanController.this.lcc, this.txState, this.container, this.localBucketSet, this.openMode);
                ++this.index;
                if (rl != null) {
                    return rl;
                }
                ++SortedMap2IndexScanController.this.statNumDeletedRowsVisited;
            }
            return null;
        }

        void reset(RowLocation[] newArray) {
            this.rlArray = newArray;
            this.index = 0;
        }
    }

    static abstract class AbstractRowLocationIterator {
        final TXStateInterface txState;
        final GemFireContainer container;
        final Set<Integer> localBucketSet;
        final int openMode;

        AbstractRowLocationIterator(TXStateInterface tx, GemFireContainer container, Set<Integer> localBucketSet, int openMode) {
            this.txState = tx;
            this.container = container;
            this.localBucketSet = localBucketSet;
            this.openMode = openMode;
        }

        public static final RowLocation isRowLocationValidForTransaction(RowLocation rl, TXId rlTXId, TXStateInterface tx, int openMode) {
            boolean sameTransaction;
            RowLocation ret = null;
            boolean bl = sameTransaction = tx != null && rlTXId.equals(tx.getTransactionId());
            if (!sameTransaction && tx != null && (openMode & 0x800000) != 0) {
                return rl;
            }
            if (rl.getClass() == WrapperRowLocationForTxn.class) {
                WrapperRowLocationForTxn wrl = (WrapperRowLocationForTxn)rl;
                if (GfxdTXStateProxy.LOG_FINE | GemFireXDUtils.TraceIndex) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("Iterator returning entry deleted in transaction " + rlTXId + " for current TX " + TXManagerImpl.getCurrentTXState() + " (GFXD cached TX: " + tx + "): " + ArrayUtils.objectRefString((Object)wrl.getRegionEntry())));
                }
                ret = !sameTransaction ? (RowLocation)wrl.getRegionEntry() : wrl.needsToBeConsideredForSameTransaction();
            } else {
                assert (rl instanceof GfxdTXEntryState) : "unknown type of transactional RowLocation " + rl;
                if (GfxdTXStateProxy.LOG_FINE | GemFireXDUtils.TraceIndex) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("Iterator returning entry inserted in transaction " + rlTXId + " for current TX " + TXManagerImpl.getCurrentTXState() + " (GFXD cached TX: " + tx + "): " + ArrayUtils.objectRefString((Object)rl)));
                }
                if (sameTransaction) {
                    ret = rl;
                }
            }
            return ret;
        }

        public static final RowLocation isRowLocationValid(RowLocation rowloc, LanguageConnectionContext lcc, TXStateInterface tx, GemFireContainer container, Set<Integer> localBucketSet, int openMode) {
            TXId rlTXId;
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("SortedMap2IndexScanController#isRowLocationValid: For index baseContainer %s checking if RowLocation [%s] is valid for TX %s, openMode=%s, buckets: %s", container.getId(), ArrayUtils.objectRefString((Object)rowloc), tx != null ? tx.getTransactionId() : "(null)", Integer.toHexString(openMode), localBucketSet);
            }
            if ((rlTXId = rowloc.getTXId()) != null && (rowloc = AbstractRowLocationIterator.isRowLocationValidForTransaction(rowloc, rlTXId, tx, openMode)) == null) {
                if (GfxdTXStateProxy.LOG_FINEST | GemFireXDUtils.TraceIndex) {
                    SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)"SortedMap2IndexScanController#isRowLocationValid: returning null RowLocation due to TX mismatch");
                }
                return null;
            }
            int bucketID = rowloc.getBucketID();
            if (bucketID > -1 && container.hasBucketRowLoc()) {
                if (localBucketSet != null && !localBucketSet.contains(bucketID)) {
                    if (GemFireXDUtils.TraceIndex) {
                        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)"SortedMap2IndexScanController#isRowLocationValid: returning null RowLocation due to bucketId mismatch");
                    }
                    return null;
                }
            } else assert (container == null || !container.isPartitioned() || !container.isRedundant() && !container.isOverFlowType()) : "unexpected bucketID < 0 " + bucketID + " for RowLocation (" + rowloc + ") in baseContainer: " + container;
            if (!rowloc.getRegionEntry().isDestroyedOrRemoved()) {
                Collection<RowLocation> refCheckRows;
                if (lcc != null && (refCheckRows = lcc.getReferencedKeyCheckRows()) != null && refCheckRows.contains(rowloc)) {
                    if (GemFireXDUtils.TraceIndex) {
                        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)"SortedMap2IndexScanController#isRowLocationValid: returning null RowLocation due to existing self-reference row");
                    }
                    return null;
                }
                if (GemFireXDUtils.TraceIndex) {
                    SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("SortedMap2IndexScanController#isRowLocationValid: returning valid RowLocation " + rowloc));
                }
                return rowloc;
            }
            if (GemFireXDUtils.TraceIndex) {
                SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)"SortedMap2IndexScanController#isRowLocationValid: returning null RowLocation due to existing existing entry destroyed");
            }
            return null;
        }

        protected abstract RowLocation next() throws StandardException;
    }
}

