/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.types.BinarySQLHybridType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.Serializable;

public final class OpenMemIndex {
    private GemFireTransaction tran;
    private MemIndex conglomerate;
    private DataValueDescriptor[] rowForExportTemplate;

    void init(GemFireTransaction tran, MemIndex conglomerate, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        this.tran = tran;
        this.conglomerate = conglomerate;
        conglomerate.openContainer(this.tran, openMode, lockLevel, locking);
    }

    public boolean[] getColumnSortOrderInfo() throws StandardException {
        return this.conglomerate.ascDescInfo;
    }

    public final ContainerKey getContainerKey() {
        return this.conglomerate.id;
    }

    public final GemFireTransaction getTransaction() {
        return this.tran;
    }

    public final GemFireContainer getGemFireContainer() {
        return this.conglomerate.container;
    }

    public void close() {
        this.tran = null;
        this.rowForExportTemplate = null;
    }

    public final boolean isClosed() {
        return this.tran == null;
    }

    public final RegionKey newGlobalKeyObject(DataValueDescriptor[] keyValue) throws StandardException {
        assert (keyValue != null && keyValue.length >= 1);
        if (this.conglomerate.container.numColumns() == 1) {
            return keyValue[0];
        }
        return new CompositeRegionKey(keyValue);
    }

    public static final Object newLocalKeyObject(DataValueDescriptor[] keyValue, GemFireContainer container) throws StandardException {
        assert (keyValue != null && keyValue.length >= 1);
        GemFireContainer baseContainer = container.getBaseContainer();
        if (baseContainer.isByteArrayStore()) {
            RowFormatter rf = container.getExtraIndexInfo().getPrimaryKeyFormatter();
            if (container.numColumns() == 1) {
                DataTypeDescriptor dtd = rf.getColumnDescriptor((int)0).columnType;
                return BinarySQLHybridType.getHybridTypeIfNeeded(keyValue[0], dtd);
            }
            int numColumns = keyValue.length;
            boolean needHybrid = false;
            for (int index = 0; index < numColumns && !(needHybrid = BinarySQLHybridType.needsTransformToEquivalent(keyValue[index], rf.getColumnDescriptor((int)index).columnType)); ++index) {
            }
            if (needHybrid) {
                DataValueDescriptor[] newKey = new DataValueDescriptor[numColumns];
                for (int index = 0; index < numColumns; ++index) {
                    DataTypeDescriptor dtd = rf.getColumnDescriptor((int)index).columnType;
                    newKey[index] = BinarySQLHybridType.getHybridTypeIfNeeded(keyValue[index], dtd);
                }
                return newKey;
            }
            return keyValue;
        }
        if (container.numColumns() == 1) {
            return keyValue[0];
        }
        return keyValue;
    }

    public static final Object newLocalKeyObject(Object keyValue, GemFireContainer container) throws StandardException {
        assert (keyValue != null);
        Class<?> cls = keyValue.getClass();
        if (cls == DataValueDescriptor[].class) {
            return OpenMemIndex.newLocalKeyObject((DataValueDescriptor[])keyValue, container);
        }
        if (cls == CompactCompositeIndexKey.class) {
            return keyValue;
        }
        assert (keyValue instanceof DataValueDescriptor);
        GemFireContainer baseContainer = container.getBaseContainer();
        if (baseContainer.isByteArrayStore()) {
            RowFormatter rf = container.getExtraIndexInfo().getPrimaryKeyFormatter();
            DataTypeDescriptor dtd = rf.getColumnDescriptor((int)0).columnType;
            return BinarySQLHybridType.getHybridTypeIfNeeded((DataValueDescriptor)keyValue, dtd);
        }
        return keyValue;
    }

    public final MemIndex getConglomerate() {
        return this.conglomerate;
    }

    public final GemFireContainer getBaseContainer() {
        return this.conglomerate.baseContainer;
    }

    protected final Serializable getKey(DataValueDescriptor[] row, boolean doClone, boolean isLocalIndex) throws StandardException {
        DataValueDescriptor[] key;
        int i;
        DataValueDescriptor[] keyValues;
        assert (row.length >= 2);
        DataValueDescriptor value = row[row.length - 1];
        if (isLocalIndex && value instanceof RegionEntry) {
            Object rawValue = ((RegionEntry)value)._getValue();
            boolean notExists = false;
            if (rawValue != null) {
                Class<?> valueClass = rawValue.getClass();
                if (valueClass == byte[].class) {
                    return new CompactCompositeIndexKey((Object)((byte[])rawValue), this.conglomerate.container.getExtraIndexInfo());
                }
                if (valueClass == byte[][].class) {
                    return new CompactCompositeIndexKey((Object)((byte[][])rawValue)[0], this.conglomerate.container.getExtraIndexInfo());
                }
                if (Token.isInvalidOrRemoved((Object)rawValue)) {
                    notExists = true;
                } else if (StoredObject.class.isAssignableFrom(valueClass)) {
                    throw new UnsupportedOperationException("asif: implement it");
                }
            } else {
                notExists = true;
            }
            if (notExists) {
                DataValueDescriptor[] keyValues2 = new DataValueDescriptor[row.length - 1];
                for (int i2 = 0; i2 < keyValues2.length; ++i2) {
                    keyValues2[i2] = row[i2];
                }
                return new CompactCompositeIndexKey(this.conglomerate.container.getExtraIndexInfo(), keyValues2);
            }
        }
        if (doClone) {
            if (row.length > 2) {
                keyValues = new DataValueDescriptor[row.length - 1];
                for (i = 0; i < keyValues.length; ++i) {
                    keyValues[i] = row[i].getClone();
                }
                key = keyValues;
            } else {
                key = row[0].getClone();
            }
        } else if (row.length > 2) {
            keyValues = new DataValueDescriptor[row.length - 1];
            for (i = 0; i < keyValues.length; ++i) {
                keyValues[i] = row[i];
            }
            key = keyValues;
        } else {
            key = row[0];
        }
        if (isLocalIndex) {
            return key;
        }
        return this.conglomerate.getGlobalHashIndexKey((Serializable)key);
    }

    protected RowLocation getValue(DataValueDescriptor[] row) {
        assert (row != null && row.length > 1 && row[row.length - 1] instanceof RowLocation);
        return (RowLocation)row[row.length - 1];
    }

    protected long getKeySize() {
        return 1L;
    }

    public final boolean isUnique() {
        return this.conglomerate.unique;
    }

    public DataValueDescriptor[] getRowForExport() throws StandardException {
        return RowUtil.newRowFromTemplate(this.getRowForExportTemplate());
    }

    public final DataValueDescriptor[] getRowForExportTemplate() throws StandardException {
        if (this.rowForExportTemplate == null) {
            GemFireTransaction tran = this.tran;
            this.rowForExportTemplate = RowUtil.newTemplate(tran != null ? tran.getDataValueFactory() : Misc.getMemStoreBooting().getDatabase().getDataValueFactory(), null, this.conglomerate.format_ids, this.conglomerate.collation_ids);
        }
        return this.rowForExportTemplate;
    }

    public String toString() {
        return "OpenMemIndex on " + this.conglomerate;
    }
}

