/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Properties;

class BackingStoreHashTableFromScan
extends BackingStoreHashtable {
    private ScanManager open_scan;

    public BackingStoreHashTableFromScan(TransactionController tc, long conglomId, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, long max_rowcnt, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean collect_runtimestats, boolean skipNullKeyColumns, boolean keepAfterCommit, Activation activation) throws StandardException {
        super(tc, null, key_column_numbers, remove_duplicates, estimated_rowcnt, max_inmemory_rowcnt, initialCapacity, loadFactor, skipNullKeyColumns, keepAfterCommit);
        this.open_scan = (ScanManager)tc.openScan(conglomId, false, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, activation);
        this.open_scan.fetchSet(max_rowcnt, key_column_numbers, this);
        if (collect_runtimestats) {
            Properties prop = new Properties();
            this.open_scan.getScanInfo().getAllScanInfo(prop);
            this.setAuxillaryRuntimeStats(prop);
            prop = null;
        }
    }

    @Override
    public void close() throws StandardException {
        this.open_scan.close();
        super.close();
    }
}

