/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.thrift.server;

import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.pivotal.gemfirexd.thrift.common.GfxdTSSLSocket;
import com.pivotal.gemfirexd.thrift.common.SocketParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GfxdTSSLServerSocket
extends TServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GfxdTSSLServerSocket.class.getName());
    private final ServerSocket serverSocket;
    private final SocketParameters socketParams;

    public GfxdTSSLServerSocket(ServerSocket serverSocket, InetSocketAddress bindAddress, SocketParameters params) throws TTransportException {
        this.socketParams = params;
        try {
            this.serverSocket = serverSocket;
            serverSocket.setReuseAddress(true);
            if (!serverSocket.isBound()) {
                serverSocket.bind(bindAddress, 100);
            }
        }
        catch (IOException ioe) {
            throw new TTransportException(1, "Could not bind to host:port " + bindAddress.toString(), (Throwable)ioe);
        }
    }

    public void listen() throws TTransportException {
        try {
            this.serverSocket.setSoTimeout(0);
        }
        catch (SocketException se) {
            LOGGER.error("Could not set socket timeout to 0.", (Throwable)se);
        }
    }

    protected GfxdTSSLSocket acceptImpl() throws TTransportException {
        try {
            Socket srvSock = this.serverSocket.accept();
            return new GfxdTSSLSocket(srvSock, this.socketParams.getReadTimeout(0), this.socketParams, SystemProperties.getServerInstance());
        }
        catch (IOException ioe) {
            throw new TTransportException((Throwable)ioe);
        }
    }

    public void close() {
        try {
            this.serverSocket.close();
        }
        catch (IOException ioe) {
            LOGGER.warn("Could not close server socket.", (Throwable)ioe);
        }
    }

    public void interrupt() {
        this.close();
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }
}

