/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotPacket;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.util.Hex;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegion;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSON;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBlob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.tools.dataextractor.Timer;
import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerMember;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class GFXDSnapshotExporter {
    private static final String DDL_META_REGION_PATH = "/_DDL_STMTS_META_REGION";
    private static final String SQL_COMMENT = "--";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String QUEUE_FILE_PREFIX = "QUEUE__";
    private static final String NULL_STRING = "NULL";
    private static final String EMPTY_STRING = "";
    private String schemaName = null;
    private String tableName = null;
    private String bucketName = null;
    private String queueSchemaName = null;
    private String queueTableName = null;
    private BufferedWriter writer;
    private long newestTimeStamp = Integer.MIN_VALUE;
    private List listOfStats;
    private GFXDSnapshotExportStat stats;
    private File file;
    private String regionName;
    public static Map<String, RowFormatter> tableNameRowFormatterMap;
    private boolean isDDLExport = false;
    private boolean isQueueExport = false;
    private Map<Long, String> seqIdDdlMap = new TreeMap<Long, String>();
    private Map<Long, DDLConflatable> seqIdDdlConflatableMap = new TreeMap<Long, DDLConflatable>();
    private long maxSeqId = Long.MIN_VALUE;
    private int numDdlStmts = 0;
    private String stringDelimiter;
    private String lastSchema = "APP";
    private Map<Long, HDFSGatewayEventImpl> seqIdToEventsMap = new TreeMap<Long, HDFSGatewayEventImpl>();
    private Timer exportTimer = new Timer();
    private boolean initOk = false;

    public GFXDSnapshotExporter(File out, String region, List listOfStats, RegionViewInfoPerMember regionViewInfo, String stringDelimiter) throws IOException {
        this.file = out;
        this.listOfStats = listOfStats;
        this.stringDelimiter = stringDelimiter;
        this.regionName = region;
        if (region.equals(DDL_META_REGION_PATH)) {
            this.tableName = region;
            this.isDDLExport = true;
            this.initOk = true;
        } else if (region.startsWith("/_") || region.equals("/GFXD_PdxTypes")) {
            this.initOk = true;
            this.tableName = region;
        } else if (region.contains("GF_QUEUE")) {
            this.isQueueExport = true;
            this.initOk = true;
        } else {
            String[] regionStrings = region.split("/");
            this.schemaName = regionStrings[1];
            this.tableName = regionStrings[2];
            if (regionStrings.length > 4) {
                this.bucketName = regionStrings[4];
                this.bucketName = this.bucketName.replace("/", "_");
            }
            try {
                RowFormatter formatter = this.getRowFormatter(this.schemaName, this.tableName);
                this.initOk = true;
            }
            catch (StandardException e) {
                GemFireXDDataExtractorImpl.logInfo("Unable to locate meta data for table: " + this.schemaName + "." + this.tableName);
                return;
            }
            catch (NullPointerException e) {
                GemFireXDDataExtractorImpl.logInfo("Could not get the meta data for " + this.schemaName + "." + this.tableName);
                return;
            }
        }
        this.writer = new BufferedWriter(new FileWriter(out), 65536);
        this.exportTimer.start();
        this.stats = new GFXDSnapshotExportStat(this.schemaName, this.tableName, this.bucketName, regionViewInfo);
    }

    public void writeSnapshotEntry(Object key, Object value, VersionTag versionTag, long lastModified) throws IOException {
        if (this.isDDLExport) {
            if (value instanceof GfxdDDLRegion.RegionValue) {
                try {
                    Long seqId = (Long)key;
                    if (this.maxSeqId < seqId) {
                        this.maxSeqId = seqId;
                    }
                    if (((GfxdDDLRegion.RegionValue)value).getValue() instanceof DDLConflatable) {
                        DDLConflatable ddl = (DDLConflatable)((GfxdDDLRegion.RegionValue)value).getValue();
                        StringBuilder sb = new StringBuilder();
                        sb.append(ddl.getValueToConflate()).append(";").append(SQL_COMMENT).append(Long.toString(lastModified));
                        this.seqIdDdlMap.put(seqId, sb.toString());
                        this.seqIdDdlConflatableMap.put(seqId, ddl);
                        if (this.newestTimeStamp < lastModified) {
                            this.newestTimeStamp = lastModified;
                        }
                        ++this.numDdlStmts;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.isQueueExport) {
            Object entryObj = value;
            if (entryObj instanceof HDFSGatewayEventImpl) {
                HDFSGatewayEventImpl event = (HDFSGatewayEventImpl)entryObj;
                String regionName = event.getRegionToConflate();
                String[] tokens = regionName.split("/");
                String schemaName = tokens[1];
                String tableName = tokens[2];
                RowFormatter formatter = null;
                try {
                    formatter = this.getRowFormatter(schemaName, tableName);
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                if (formatter != null) {
                    this.seqIdToEventsMap.put(event.getEventSequenceID().getSequenceID(), event);
                }
            }
        } else {
            if (this.tableName.startsWith("/_") || this.tableName.equals("/GFXD_PdxTypes")) {
                return;
            }
            try {
                RowFormatter formatter = this.getRowFormatter(this.schemaName, this.tableName);
                this.writeRow(formatter, null, value);
                if (versionTag != null) {
                    if (this.newestTimeStamp < versionTag.getVersionTimeStamp()) {
                        this.newestTimeStamp = versionTag.getVersionTimeStamp();
                    }
                } else if (this.newestTimeStamp < lastModified) {
                    this.newestTimeStamp = lastModified;
                }
            }
            catch (StandardException e) {
                this.stats.addEntryDecodeError("Did not complete decoding file for table:" + this.schemaName + "/" + this.tableName);
                this.stats.setCompletedFile(false);
                e.printStackTrace();
            }
        }
    }

    public void writeSnapshotEntry(SnapshotPacket.SnapshotRecord entry, VersionTag versionTag, long lastModified) throws IOException {
    }

    public RowFormatter getRowFormatter(String schemaName, String tableName) throws StandardException {
        StringBuilder sb = new StringBuilder(schemaName).append(tableName);
        String tableNameSchemaName = sb.toString();
        RowFormatter rowFormatter = tableNameRowFormatterMap.get(tableNameSchemaName);
        if (rowFormatter == null) {
            TransactionController tc;
            SchemaDescriptor sd;
            GfxdDataDictionary dd = Misc.getMemStore().getDatabase().getDataDictionary();
            TableDescriptor tableDescriptor = dd.getTableDescriptor(tableName, sd = dd.getSchemaDescriptor(schemaName, tc = Misc.getLanguageConnectionContext().getTransactionCompile(), true), tc);
            if (tableDescriptor == null) {
                sd = dd.getSchemaDescriptor("APP", tc, true);
                tableDescriptor = dd.getTableDescriptor(tableName, sd, tc);
            }
            GemFireContainer container = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, tableDescriptor.getHeapConglomerateId()));
            rowFormatter = container.getCurrentRowFormatter();
            tableNameRowFormatterMap.put(tableNameSchemaName, rowFormatter);
        }
        return rowFormatter;
    }

    public void writeRowFromHDFSEvent(HDFSGatewayEventImpl event, BufferedWriter writer, SnapshotPacket.SnapshotRecord entry, Object newParam) throws IOException, StandardException {
        StringBuilder sb = new StringBuilder();
        String regionName = event.getRegionToConflate();
        String[] tokens = regionName.split("/");
        String schemaName = tokens[1];
        String tableName = tokens[2];
        RowFormatter formatter = null;
        try {
            formatter = this.getRowFormatter(schemaName, tableName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (formatter != null) {
            sb.append(SQL_COMMENT);
            sb.append(" Operation : ").append(event.getOperation());
            sb.append(" Version : ").append(event.getVersionTag().getEntryVersion());
            sb.append(" Table : " + tableName);
            sb.append(" Schema : " + schemaName);
            if (this.queueSchemaName == null && this.queueTableName == null) {
                this.queueSchemaName = schemaName;
                this.queueTableName = tableName;
            }
            writer.write(sb.toString());
            writer.newLine();
            this.writeRow(formatter, entry, event.getValue());
        }
    }

    public void writeRow(RowFormatter formatter, SnapshotPacket.SnapshotRecord entry, Object deserializedObject) throws IOException {
        if (deserializedObject == null || Token.isInvalidOrRemoved((Object)deserializedObject) || Token.isDestroyed((Object)deserializedObject)) {
            this.stats.incrementNumValuesNotDecoded();
            return;
        }
        this.stats.incrementNumValuesDecoded();
        int numColumns = formatter.getNumColumns();
        DataValueDescriptor[] dvds = new DataValueDescriptor[numColumns];
        Timer decodeTimer = new Timer();
        decodeTimer.start();
        Class<?> c = deserializedObject.getClass();
        try {
            if (c == byte[].class) {
                formatter.getColumns((byte[])deserializedObject, dvds, null);
            } else if (c == byte[][].class) {
                formatter.getColumns((byte[][])deserializedObject, dvds, null);
            } else if (c == OffHeapRow.class) {
                formatter.getColumns((OffHeapRow)((Object)deserializedObject), dvds, null);
            } else {
                formatter.getColumns((OffHeapRowWithLobs)((Object)deserializedObject), dvds, null);
            }
        }
        catch (StandardException se) {
            se.printStackTrace();
        }
        for (int index = 0; index < numColumns; ++index) {
            DataValueDescriptor dvd = dvds[index];
            try {
                if (dvd != null) {
                    Class<?> cls = dvd.getClass();
                    if (cls == SQLClob.class || cls == CollatorSQLClob.class) {
                        this.writer.append(this.stringDelimiter);
                        char[] chars = ((SQLClob)dvd).getCharArray();
                        for (int i = 0; i < chars.length; ++i) {
                            this.writer.append(chars[i]);
                        }
                        this.writer.append(this.stringDelimiter);
                    } else if (cls == JSON.class) {
                        this.writer.append(this.stringDelimiter);
                        this.writer.append("'{\"JSON\":\"JSON\"}'");
                        this.writer.append(this.stringDelimiter);
                    } else if (cls == SQLBlob.class) {
                        this.writeString(this.writer, Hex.toHex((byte[])((SQLBlob)dvd).getBytes()), true);
                    } else if (cls == XML.class) {
                        this.writeString(this.writer, ((XML)dvd).getString(), true);
                    } else if (SQLVarchar.class.isAssignableFrom(cls)) {
                        this.writeString(this.writer, dvd.toString(), true);
                    } else {
                        this.writeString(this.writer, dvd.toString(), false);
                    }
                } else {
                    this.writeString(this.writer, NULL_STRING, false);
                }
                if (index + 1 >= numColumns) continue;
                this.writer.append(",");
                continue;
            }
            catch (StandardException e) {
                e.printStackTrace();
            }
        }
        this.writer.newLine();
    }

    private void writeString(Writer writer, String string, boolean useStringDelimiter) throws IOException {
        if (string.equals(NULL_STRING)) {
            writer.append(EMPTY_STRING);
        } else if (useStringDelimiter) {
            writer.append(this.stringDelimiter).append(string).append(this.stringDelimiter);
        } else {
            writer.append(string);
        }
    }

    public long getNewestTimeStamp() {
        return this.newestTimeStamp;
    }

    public boolean isInitOk() {
        return this.initOk;
    }

    public void close() throws IOException {
        if (this.isDDLExport) {
            for (Map.Entry<Long, DDLConflatable> entry : this.seqIdDdlConflatableMap.entrySet()) {
                Long seqId = entry.getKey();
                DDLConflatable ddl = entry.getValue();
                this.writer.write(NEW_LINE);
                if (!ddl.getCurrentSchema().equals(this.lastSchema)) {
                    this.lastSchema = ddl.getCurrentSchema();
                    this.writer.write("SET CURRENT SCHEMA " + this.lastSchema + ";");
                    this.writer.write(NEW_LINE);
                }
                StringBuilder sb = new StringBuilder();
                String ddlStatment = ddl.getValueToConflate();
                if (ddlStatment.endsWith(";")) {
                    this.writer.write(ddlStatment);
                } else {
                    this.writer.write(sb.append(ddl.getValueToConflate()).append(";").toString());
                }
                this.writer.write(NEW_LINE);
            }
        } else if (this.isQueueExport) {
            if (!this.seqIdToEventsMap.isEmpty()) {
                Iterator<Map.Entry<Long, HDFSGatewayEventImpl>> queueIter = this.seqIdToEventsMap.entrySet().iterator();
                GemFireXDDataExtractorImpl.logInfo("Writing hdfs events from Queue :  " + this.regionName);
                while (queueIter.hasNext()) {
                    Map.Entry<Long, DDLConflatable> entry;
                    entry = queueIter.next();
                    try {
                        this.writeRowFromHDFSEvent((HDFSGatewayEventImpl)entry.getValue(), this.writer, null, null);
                    }
                    catch (StandardException e) {
                        GemFireXDDataExtractorImpl.logInfo("Error occurred while writing the HDFS queue event", e);
                    }
                }
                this.seqIdToEventsMap.clear();
            } else {
                GemFireXDDataExtractorImpl.logInfo("No queued HDFS events in Queue : " + this.regionName);
                this.file.delete();
                return;
            }
        }
        this.writer.flush();
        this.writer.close();
        if (!this.isDDLExport && !this.isQueueExport && this.stats.numValuesDecoded == 0 && this.stats.numValuesNotDecoded == 0) {
            this.file.delete();
        } else {
            String newFileName = EMPTY_STRING;
            boolean renamed = false;
            String tableType = EMPTY_STRING;
            if (this.isDDLExport) {
                newFileName = "exported_ddl.sql";
                renamed = this.file.renameTo(new File(this.file.getParentFile(), newFileName));
                this.stats.setMaxSeqId(this.maxSeqId);
                this.stats.setNumDdlStmts(this.numDdlStmts);
                this.stats.setLastModifiedTime(this.getNewestTimeStamp());
            } else if (this.isQueueExport) {
                newFileName = "QUEUE___" + this.queueSchemaName + "_" + this.queueTableName + ".csv";
                renamed = this.file.renameTo(new File(this.file.getParentFile(), newFileName));
                this.stats.setQueueExport(true);
            } else {
                tableType = this.bucketName == null ? "RR" : "PR";
                newFileName = tableType + "-" + this.schemaName + "-" + this.tableName;
                if (this.bucketName != null) {
                    newFileName = newFileName + "-" + this.bucketName;
                }
                newFileName = newFileName + "-" + this.getNewestTimeStamp() + ".csv";
                if (!this.stats.isCompletedFile() || this.stats.getEntryDecodeErrors().size() > 0) {
                    newFileName = "ERROR_" + newFileName;
                }
                renamed = this.file.renameTo(new File(this.file.getParentFile(), newFileName));
            }
            if (!this.isQueueExport && this.tableName.startsWith("/_") && !this.tableName.equals(DDL_META_REGION_PATH)) {
                return;
            }
            this.stats.setFileName(this.file.getParentFile().getAbsolutePath() + File.separator + newFileName);
            this.stats.setTableType(tableType);
            this.listOfStats.add(this.stats);
            if (!renamed) {
                throw new IOException("unable to rename file to desired csv file name: " + newFileName);
            }
        }
    }
}

