/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.jdbc.EmbeddedDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class AutoloadedDriver
implements Driver {
    private static boolean _engineForcedDown = false;
    private static Driver _driverModule;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return !_engineForcedDown && InternalDriver.embeddedDriverAcceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!InternalDriver.embeddedDriverAcceptsURL(url)) {
            return null;
        }
        return AutoloadedDriver.getDriverModule().connect(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return AutoloadedDriver.getDriverModule().getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMajorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMinorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return AutoloadedDriver.getDriverModule().jdbcCompliant();
        }
        catch (SQLException se) {
            return false;
        }
    }

    public static Driver getDriverModule() throws SQLException {
        if (!AutoloadedDriver.isBooted()) {
            EmbeddedDriver.boot();
        }
        if (_engineForcedDown) {
            throw new SQLException(MessageService.getTextMessage("I015"));
        }
        return _driverModule;
    }

    static void registerDriverModule(Driver driver) {
        _driverModule = driver;
        _engineForcedDown = false;
    }

    static void unregisterDriverModule() {
        _driverModule = null;
        _engineForcedDown = true;
    }

    private static boolean isBooted() {
        return _driverModule != null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    static {
        try {
            DriverManager.registerDriver(new AutoloadedDriver());
        }
        catch (SQLException se) {
            String message = MessageService.getTextMessage("I026", se.getMessage());
            throw new IllegalStateException(message);
        }
    }
}

