/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Undoable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ContainerBasicOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ContainerUndoOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ContainerOperation
extends ContainerBasicOperation
implements Undoable {
    protected byte operation;
    protected transient boolean hasCreateByteArray = true;
    protected ByteArray createByteArray;
    protected static final byte CREATE = 1;
    protected static final byte DROP = 2;
    protected static final byte REMOVE = 4;

    protected ContainerOperation(RawContainerHandle hdl, byte operation) throws StandardException {
        super(hdl);
        this.operation = operation;
    }

    public ContainerOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.operation);
        if (this.operation == 1) {
            try {
                this.createByteArray = this.containerHdl.logCreateContainerInfo();
            }
            catch (StandardException se) {
                throw new IOException(se.toString());
            }
            this.createByteArray.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.operation = in.readByte();
        if (this.operation == 1 && this.hasCreateByteArray) {
            this.createByteArray = new ByteArray();
            this.createByteArray.readExternal(in);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 242;
    }

    @Override
    protected RawContainerHandle findContainerForRedoRecovery(RawTransaction xact) throws StandardException {
        SanityManager.ASSERT((this.createByteArray != null ? 1 : 0) != 0, (String)"cannot reCreate container in load tran, createByteArray is null");
        long sid = this.containerId.getSegmentId();
        long cid = this.containerId.getContainerId();
        xact.reCreateContainerForRedoRecovery(sid, cid, this.createByteArray);
        return xact.openDroppedContainer(this.containerId, null);
    }

    @Override
    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        switch (this.operation) {
            case 2: {
                this.containerHdl.dropContainer(instant, true);
                break;
            }
            case 4: {
                this.containerHdl.removeContainer(instant);
                break;
            }
        }
        this.releaseResource(tran);
    }

    public void undoMe(Transaction tran, RawContainerHandle hdl, LogInstant CLRInstant, LimitObjectInput in) throws StandardException {
        switch (this.operation) {
            case 2: {
                SanityManager.ASSERT((hdl != null ? 1 : 0) != 0, (String)"container handle is null");
                SanityManager.ASSERT((hdl.getContainerStatus() != 4 ? 1 : 0) != 0, (String)"Undoing a drop but the container status is not dropped");
                hdl.dropContainer(CLRInstant, false);
                break;
            }
            case 1: {
                hdl.removeContainer(CLRInstant);
                break;
            }
            case 4: {
                SanityManager.THROWASSERT((String)"cannot undo REMOVE, should not have generated a CLR in the first place");
            }
        }
        this.releaseResource(tran);
    }

    @Override
    public Compensation generateUndo(Transaction tran, LimitObjectInput in) throws StandardException {
        if (this.operation == 4) {
            return null;
        }
        RawContainerHandle undoContainerHandle = this.findContainer(tran);
        return new ContainerUndoOperation(undoContainerHandle, this);
    }

    @Override
    public String toString() {
        String str = super.toString();
        switch (this.operation) {
            case 1: {
                str = str + " CREATE container " + this.containerId;
                break;
            }
            case 2: {
                str = str + " DROP container " + this.containerId;
                break;
            }
            case 4: {
                str = str + " REMOVE container " + this.containerId;
            }
        }
        return str;
    }
}

