/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.io.TypedFormat;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.LogicalUndo;
import com.pivotal.gemfirexd.internal.iapi.store.raw.AuxObject;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.FetchDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseContainerHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.LongColumnException;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.OverflowInputStream;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.RecordId;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.StoredRecordHeader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;

abstract class BasePage
implements Page,
Observer,
TypedFormat {
    private AuxObject auxObj;
    protected PageKey identity;
    private StoredRecordHeader[] headers;
    private int recordCount;
    private RecordId protectionHandle;
    protected BaseContainerHandle owner;
    private int nestedLatch;
    protected boolean inClean;
    protected boolean preLatch;
    private LogInstant lastLog;
    private long pageVersion = 0L;
    private byte pageStatus;
    public static final byte VALID_PAGE = 1;
    public static final byte INVALID_PAGE = 2;
    public static final int INIT_PAGE_REUSE = 1;
    public static final int INIT_PAGE_OVERFLOW = 2;
    public static final int INIT_PAGE_REUSE_RECORDID = 4;
    public static final int LOG_RECORD_DEFAULT = 0;
    public static final int LOG_RECORD_FOR_UPDATE = 1;
    public static final int LOG_RECORD_FOR_PURGE = 2;
    private static final RecordHandle InvalidRecordHandle = new RecordId(new PageKey(new ContainerKey(0L, 0L), -1L), 0);

    protected BasePage() {
    }

    protected void initialize() {
        this.setAuxObject(null);
        this.identity = null;
        this.protectionHandle = null;
        this.recordCount = 0;
        this.clearLastLogInstant();
        if (this.nestedLatch != 0) {
            SanityManager.THROWASSERT((String)("nestedLatch is non-zero in initialize - value =  " + this.nestedLatch));
        }
        if (this.inClean) {
            SanityManager.THROWASSERT((String)"inClean is true in initialize");
        }
        if (this.preLatch) {
            SanityManager.THROWASSERT((String)"preLatch is true in initialize");
        }
    }

    protected void initializeHeaders(int numRecords) {
        if (this.recordCount != 0) {
            SanityManager.THROWASSERT((String)("record count = " + this.recordCount + " before initSlotTable is called"));
        }
        this.headers = new StoredRecordHeader[numRecords];
    }

    protected void fillInIdentity(PageKey key) {
        SanityManager.ASSERT((this.identity == null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.protectionHandle == null ? 1 : 0) != 0);
        this.identity = key;
    }

    public void clearIdentity() {
        SanityManager.ASSERT((!this.isLatched() ? 1 : 0) != 0);
        this.identity = null;
        this.cleanPageForReuse();
    }

    protected void cleanPageForReuse() {
        this.setAuxObject(null);
        this.protectionHandle = null;
        this.recordCount = 0;
    }

    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public final RecordHandle getInvalidRecordHandle() {
        return InvalidRecordHandle;
    }

    @Override
    public final RecordHandle getProtectionRecordHandle() {
        if (this.protectionHandle == null) {
            this.protectionHandle = new RecordId(this.getPageId(), 1);
        }
        SanityManager.ASSERT((boolean)this.getPageId().equals(this.protectionHandle.getPageId()), (String)"PageKey for cached protection handle doesn't match identity");
        return this.protectionHandle;
    }

    public static final RecordHandle MakeRecordHandle(PageKey pkey, int recordHandleConstant) throws StandardException {
        if (recordHandleConstant >= 6) {
            throw StandardException.newException("XSDAE.S", new Long(recordHandleConstant));
        }
        return new RecordId(pkey, recordHandleConstant);
    }

    @Override
    public final RecordHandle makeRecordHandle(int recordHandleConstant) throws StandardException {
        return BasePage.MakeRecordHandle(this.getPageId(), recordHandleConstant);
    }

    @Override
    public final long getPageNumber() {
        SanityManager.ASSERT((boolean)this.isLatched(), (String)"page is not latched.");
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0, (String)"identity is null.");
        return this.identity.getPageNumber();
    }

    @Override
    public final RecordHandle getRecordHandle(int recordId) {
        SanityManager.ASSERT((boolean)this.isLatched());
        int slot = this.findRecordById(recordId, 0);
        if (slot < 0) {
            return null;
        }
        return this.getRecordHandleAtSlot(slot);
    }

    @Override
    public final RecordHandle getRecordHandleAtSlot(int slot) {
        return this.getHeaderAtSlot(slot).getHandle(this.getPageId(), slot);
    }

    @Override
    public final boolean recordExists(RecordHandle handle, boolean ignoreDelete) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (handle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", handle);
        }
        if (handle.getPageNumber() != this.getPageNumber()) {
            return false;
        }
        int slot = this.findRecordById(handle.getId(), handle.getSlotNumberHint());
        return slot >= 0 && (ignoreDelete || !this.isDeletedAtSlot(slot));
    }

    @Override
    public RecordHandle fetchFromSlot(RecordHandle rh, int slot, Object[] row, FetchDescriptor fetchDesc, boolean ignoreDelete) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (rh != null) {
            SanityManager.ASSERT((this.getSlotNumber(rh) == slot ? 1 : 0) != 0);
        }
        this.checkSlotOnPage(slot);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        if (rh == null) {
            rh = recordHeader.getHandle(this.getPageId(), slot);
        }
        if (!ignoreDelete && recordHeader.isDeleted()) {
            return null;
        }
        return this.restoreRecordFromSlot(slot, row, fetchDesc, rh, recordHeader, true) ? rh : null;
    }

    @Override
    public final RecordHandle fetchFieldFromSlot(int slot, int fieldId, Object column) throws StandardException {
        Object[] row = new Object[fieldId + 1];
        row[fieldId] = column;
        FetchDescriptor fetchDesc = new FetchDescriptor(fieldId + 1, fieldId);
        return this.fetchFromSlot(null, slot, row, fetchDesc, true);
    }

    @Override
    public final int getSlotNumber(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        int slot = this.findRecordById(handle.getId(), handle.getSlotNumberHint());
        if (slot < 0) {
            throw StandardException.newException("XSRS9.S", handle);
        }
        return slot;
    }

    @Override
    public final int getNextSlotNumber(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        int slot = this.findNextRecordById(handle.getId());
        return slot;
    }

    @Override
    public RecordHandle insertAtSlot(int slot, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int overflowThreshold) throws StandardException {
        if (overflowThreshold == 0) {
            SanityManager.THROWASSERT((String)"overflowThreshold cannot be 0");
        }
        if ((insertFlag & 1) == 1) {
            return this.insertNoOverflow(slot, row, validColumns, undo, insertFlag, overflowThreshold);
        }
        if (undo != null) {
            SanityManager.THROWASSERT((String)("logical undo with overflow allowed on insert " + undo.toString()));
        }
        return this.insertAllowOverflow(slot, row, validColumns, 0, insertFlag, overflowThreshold, null);
    }

    protected RecordHandle insertNoOverflow(int slot, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int overflowThreshold) throws StandardException {
        int recordId;
        RecordId handle;
        SanityManager.ASSERT((boolean)this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (slot < 0 || slot > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        if (!this.allowInsert()) {
            return null;
        }
        RawTransaction t = this.owner.getTransaction();
        if (undo != null) {
            t.checkLogicalOperationOk();
        }
        do {
            recordId = this.newRecordIdAndBump();
            handle = new RecordId(this.getPageId(), recordId, slot);
        } while (!this.owner.getLockingPolicy().lockRecordForWrite(t, handle, true, false));
        this.owner.getActionSet().actionInsert(t, this, slot, recordId, row, validColumns, undo, insertFlag, 0, false, -1, null, -1, overflowThreshold);
        return handle;
    }

    @Override
    public final RecordHandle insert(Object[] row, FormatableBitSet validColumns, byte insertFlag, int overflowThreshold) throws StandardException {
        if (overflowThreshold == 0) {
            SanityManager.THROWASSERT((String)"overflowThreshold much be greater than 0");
        }
        if ((insertFlag & 1) == 1) {
            return this.insertAtSlot(this.recordCount, row, validColumns, null, insertFlag, overflowThreshold);
        }
        return this.insertAllowOverflow(this.recordCount, row, validColumns, 0, insertFlag, overflowThreshold, null);
    }

    public RecordHandle insertAllowOverflow(int slot, Object[] row, FormatableBitSet validColumns, int startColumn, byte insertFlag, int overflowThreshold, RecordHandle nextPortionHandle) throws StandardException {
        BasePage curPage = this;
        if (!curPage.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RecordId headHandle = null;
        RecordId handleToUpdate = null;
        RawTransaction t = curPage.owner.getTransaction();
        while (true) {
            SanityManager.ASSERT((boolean)curPage.isLatched());
            if (!curPage.allowInsert()) {
                return null;
            }
            if (curPage != this) {
                slot = curPage.recordCount;
            }
            boolean isLongColumns = false;
            int realStartColumn = -1;
            int realSpaceOnPage = -1;
            DynamicByteArrayOutputStream logBuffer = null;
            int recordId = curPage.newRecordIdAndBump();
            RecordId handle = new RecordId(curPage.getPageId(), recordId, slot);
            if (curPage == this) {
                if (handleToUpdate == null) {
                    while (!this.owner.getLockingPolicy().lockRecordForWrite(t, handle, true, false)) {
                        recordId = curPage.newRecordIdAndBump();
                        handle = new RecordId(curPage.getPageId(), recordId, slot);
                    }
                }
                headHandle = handle;
            }
            do {
                try {
                    startColumn = this.owner.getActionSet().actionInsert(t, curPage, slot, recordId, row, validColumns, null, insertFlag, startColumn, false, realStartColumn, logBuffer, realSpaceOnPage, overflowThreshold);
                    isLongColumns = false;
                }
                catch (LongColumnException lce) {
                    logBuffer = new DynamicByteArrayOutputStream(lce.getLogBuffer());
                    RecordHandle longColumnHandle = this.insertLongColumn(curPage, lce, insertFlag);
                    int overflowFieldLen = 0;
                    try {
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                    realStartColumn = lce.getNextColumn() + 1;
                    realSpaceOnPage = lce.getRealSpaceOnPage() - (overflowFieldLen += this.appendOverflowFieldHeader(logBuffer, longColumnHandle));
                    isLongColumns = true;
                }
            } while (isLongColumns);
            if (handleToUpdate != null) {
                this.updateOverflowDetails(handleToUpdate, handle);
            }
            if (startColumn == -1) {
                if (curPage != this) {
                    curPage.unlatch();
                }
                if (nextPortionHandle != null) {
                    this.updateOverflowDetails(handle, nextPortionHandle);
                }
                return headHandle;
            }
            handleToUpdate = handle;
            BasePage nextPage = curPage.getOverflowPageForInsert(slot, row, validColumns, startColumn);
            if (curPage != this) {
                curPage.unlatch();
            }
            curPage = nextPage;
        }
    }

    protected RecordHandle insertLongColumn(BasePage mainChainPage, LongColumnException lce, byte insertFlag) throws StandardException {
        Object[] row = new Object[]{lce.getColumn()};
        RecordId firstHandle = null;
        RecordId handle = null;
        RecordId prevHandle = null;
        BasePage curPage = mainChainPage;
        BasePage prevPage = null;
        boolean isFirstPage = true;
        int startColumn = 0;
        RawTransaction t = curPage.owner.getTransaction();
        do {
            if (!isFirstPage) {
                prevPage = curPage;
                prevHandle = handle;
            }
            curPage = this.getNewOverflowPage();
            SanityManager.ASSERT((boolean)curPage.isLatched());
            SanityManager.ASSERT((boolean)curPage.allowInsert());
            int slot = curPage.recordCount;
            int recordId = curPage.newRecordId();
            handle = new RecordId(curPage.getPageId(), recordId, slot);
            if (isFirstPage) {
                firstHandle = handle;
            }
            startColumn = this.owner.getActionSet().actionInsert(t, curPage, slot, recordId, row, null, null, insertFlag, startColumn, true, -1, null, -1, 100);
            if (!isFirstPage) {
                prevPage.updateFieldOverflowDetails(prevHandle, handle);
                prevPage.unlatch();
                prevPage = null;
                continue;
            }
            isFirstPage = false;
        } while (startColumn != -1);
        if (curPage != null) {
            curPage.unlatch();
            curPage = null;
        }
        return firstHandle;
    }

    public abstract void preDirty();

    public abstract void updateOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract void updateFieldOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract int appendOverflowFieldHeader(DynamicByteArrayOutputStream var1, RecordHandle var2) throws StandardException, IOException;

    public abstract BasePage getOverflowPageForInsert(int var1, Object[] var2, FormatableBitSet var3, int var4) throws StandardException;

    protected abstract BasePage getNewOverflowPage() throws StandardException;

    @Override
    public final RecordHandle updateAtSlot(int slot, Object[] row, FormatableBitSet validColumns) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (this.isDeletedAtSlot(slot)) {
            throw StandardException.newException("XSDA2.S");
        }
        RecordHandle handle = this.getRecordHandleAtSlot(slot);
        RawTransaction t = this.owner.getTransaction();
        this.doUpdateAtSlot(t, slot, handle.getId(), row, validColumns);
        return handle;
    }

    public abstract void doUpdateAtSlot(RawTransaction var1, int var2, int var3, Object[] var4, FormatableBitSet var5) throws StandardException;

    @Override
    public RecordHandle updateFieldAtSlot(int slot, int fieldId, Object newValue, LogicalUndo undo) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        SanityManager.ASSERT((newValue != null ? 1 : 0) != 0);
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (this.isDeletedAtSlot(slot)) {
            throw StandardException.newException("XSDA2.S");
        }
        RawTransaction t = this.owner.getTransaction();
        RecordHandle handle = this.getRecordHandleAtSlot(slot);
        this.owner.getActionSet().actionUpdateField(t, this, slot, handle.getId(), fieldId, newValue, undo);
        return handle;
    }

    @Override
    public final int fetchNumFields(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        return this.fetchNumFieldsAtSlot(this.getSlotNumber(handle));
    }

    @Override
    public int fetchNumFieldsAtSlot(int slot) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        return this.getHeaderAtSlot(slot).getNumberFields();
    }

    @Override
    public RecordHandle deleteAtSlot(int slot, boolean delete, LogicalUndo undo) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (delete) {
            if (this.isDeletedAtSlot(slot)) {
                throw StandardException.newException("XSDA2.S");
            }
        } else if (!this.isDeletedAtSlot(slot)) {
            throw StandardException.newException("XSDA5.S");
        }
        RawTransaction t = this.owner.getTransaction();
        if (undo != null) {
            t.checkLogicalOperationOk();
        }
        RecordHandle handle = this.getRecordHandleAtSlot(slot);
        this.owner.getActionSet().actionDelete(t, this, slot, handle.getId(), delete, undo);
        return handle;
    }

    @Override
    public void purgeAtSlot(int slot, int numpurges, boolean needDataLogged) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (this.isOverflowPage()) {
            SanityManager.THROWASSERT((String)("purge committed deletes on an overflow page.  Page = " + this));
        }
        if (numpurges <= 0) {
            return;
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (slot < 0 || slot + numpurges > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        RawTransaction t = this.owner.getTransaction();
        int[] recordIds = new int[numpurges];
        PageKey pageId = this.getPageId();
        for (int i = 0; i < numpurges; ++i) {
            recordIds[i] = this.getHeaderAtSlot(slot + i).getId();
            RecordHandle handle = this.getRecordHandleAtSlot(slot);
            this.owner.getLockingPolicy().lockRecordForWrite(t, handle, false, true);
            if (this.owner.isTemporaryContainer() || this.entireRecordOnPage(slot + i)) continue;
            RecordHandle headRowHandle = this.getHeaderAtSlot(slot + i).getHandle(pageId, slot + i);
            this.purgeRowPieces(t, slot + i, headRowHandle, needDataLogged);
        }
        this.owner.getActionSet().actionPurge(t, this, slot, numpurges, recordIds, needDataLogged);
    }

    protected abstract void purgeRowPieces(RawTransaction var1, int var2, RecordHandle var3, boolean var4) throws StandardException;

    @Override
    public void copyAndPurge(Page destPage, int src_slot, int num_rows, int dest_slot) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (num_rows <= 0) {
            throw StandardException.newException("XSDAD.S");
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (src_slot < 0 || src_slot + num_rows > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        SanityManager.ASSERT((boolean)(destPage instanceof BasePage), (String)"must copy from BasePage to BasePage");
        BasePage dpage = (BasePage)destPage;
        PageKey pageId = this.getPageId();
        if (!pageId.getContainerId().equals(dpage.getPageId().getContainerId())) {
            throw StandardException.newException("XSDAC.S", (Object)pageId.getContainerId(), (Object)dpage.getPageId().getContainerId());
        }
        int[] recordIds = new int[num_rows];
        RawTransaction t = this.owner.getTransaction();
        for (int i = 0; i < num_rows; ++i) {
            RecordHandle handle = this.getRecordHandleAtSlot(src_slot + i);
            this.owner.getLockingPolicy().lockRecordForWrite(t, handle, false, true);
            recordIds[i] = this.getHeaderAtSlot(src_slot + i).getId();
        }
        dpage.copyInto(this, src_slot, num_rows, dest_slot);
        this.owner.getActionSet().actionPurge(t, this, src_slot, num_rows, recordIds, true);
    }

    @Override
    public void unlatch() {
        SanityManager.ASSERT((boolean)this.isLatched());
        this.releaseExclusive();
    }

    @Override
    public final synchronized boolean isLatched() {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
        return this.owner != null;
    }

    @Override
    public final int recordCount() {
        SanityManager.ASSERT((boolean)this.isLatched());
        return this.recordCount;
    }

    protected abstract int internalDeletedRecordCount();

    protected int internalNonDeletedRecordCount() {
        if (this.pageStatus != 1) {
            return 0;
        }
        int deletedCount = this.internalDeletedRecordCount();
        if (deletedCount == -1) {
            int count = 0;
            int maxSlot = this.recordCount;
            for (int slot = 0; slot < maxSlot; ++slot) {
                if (this.isDeletedOnPage(slot)) continue;
                ++count;
            }
            return count;
        }
        int delCount = 0;
        int maxSlot = this.recordCount;
        for (int slot = 0; slot < maxSlot; ++slot) {
            if (!this.recordHeaderOnDemand(slot).isDeleted()) continue;
            ++delCount;
        }
        if (delCount != deletedCount) {
            SanityManager.THROWASSERT((String)("incorrect deleted row count.  Should be: " + delCount + ", instead got: " + deletedCount + ", maxSlot = " + maxSlot + ", recordCount = " + this.recordCount));
        }
        return this.recordCount - deletedCount;
    }

    @Override
    public int nonDeletedRecordCount() {
        SanityManager.ASSERT((boolean)this.isLatched());
        return this.internalNonDeletedRecordCount();
    }

    @Override
    public boolean shouldReclaimSpace(int num_non_deleted_rows, int slot_just_deleted) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        boolean ret_val = false;
        if (this.internalNonDeletedRecordCount() <= num_non_deleted_rows) {
            ret_val = true;
        } else if (!this.entireRecordOnPage(slot_just_deleted)) {
            ret_val = true;
        }
        return ret_val;
    }

    protected final boolean isDeletedOnPage(int slot) {
        return this.getHeaderAtSlot(slot).isDeleted();
    }

    @Override
    public boolean isDeletedAtSlot(int slot) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        this.checkSlotOnPage(slot);
        return this.isDeletedOnPage(slot);
    }

    @Override
    public void setAuxObject(AuxObject obj) {
        SanityManager.ASSERT((this.identity == null || this.isLatched() ? 1 : 0) != 0);
        if (this.auxObj != null) {
            this.auxObj.auxObjectInvalidated();
        }
        this.auxObj = obj;
    }

    @Override
    public AuxObject getAuxObject() {
        SanityManager.ASSERT((boolean)this.isLatched());
        return this.auxObj;
    }

    @Override
    public void update(Observable obj, Object arg) {
        SanityManager.ASSERT((boolean)this.isLatched());
        SanityManager.ASSERT((obj == this.owner ? 1 : 0) != 0);
        this.releaseExclusive();
    }

    public final PageKey getPageId() {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExclusive(BaseContainerHandle requester) throws StandardException {
        RawTransaction t = requester.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && t == this.owner.getTransaction()) {
                if (t.inAbort()) {
                    ++this.nestedLatch;
                    return;
                }
                SanityManager.THROWASSERT((String)"Attempted to latch page twice");
            }
            while (this.owner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            this.preLatch(requester);
            SanityManager.ASSERT((boolean)this.isLatched(), (String)"page not latched");
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.preLatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setExclusiveNoWait(BaseContainerHandle requester) throws StandardException {
        RawTransaction t = requester.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && t == this.owner.getTransaction() && t.inAbort()) {
                ++this.nestedLatch;
                return true;
            }
            if (this.owner == null) {
                this.preLatch(requester);
            } else {
                return false;
            }
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.preLatch = false;
        }
        SanityManager.ASSERT((boolean)this.isLatched(), (String)"page not latched");
        return true;
    }

    protected synchronized void releaseExclusive() {
        if (!this.isLatched()) {
            SanityManager.THROWASSERT((String)("releaseExclusive failed, nestedLatch = " + this.nestedLatch));
        }
        if (this.nestedLatch > 0) {
            --this.nestedLatch;
            return;
        }
        this.owner.deleteObserver(this);
        this.owner = null;
        this.notifyAll();
    }

    private void preLatch(BaseContainerHandle requester) {
        SanityManager.ASSERT((!this.isLatched() ? 1 : 0) != 0, (String)"Attempted to pre-latch a latched page");
        this.owner = requester;
        requester.addObserver(this);
        this.preLatch = true;
    }

    protected final void setHeaderAtSlot(int slot, StoredRecordHeader rh) {
        if (slot < this.headers.length) {
            if (rh != null) {
                this.headers[slot] = rh;
            }
        } else {
            StoredRecordHeader[] new_headers = new StoredRecordHeader[slot + 1];
            System.arraycopy(this.headers, 0, new_headers, 0, this.headers.length);
            this.headers = new_headers;
            this.headers[slot] = rh;
        }
    }

    protected final void bumpRecordCount(int number) {
        this.recordCount += number;
    }

    public final StoredRecordHeader getHeaderAtSlot(int slot) {
        if (slot < this.headers.length) {
            StoredRecordHeader rh = this.headers[slot];
            return rh != null ? rh : this.recordHeaderOnDemand(slot);
        }
        return this.recordHeaderOnDemand(slot);
    }

    public abstract boolean entireRecordOnPage(int var1) throws StandardException;

    public abstract StoredRecordHeader recordHeaderOnDemand(int var1);

    private final void checkSlotOnPage(int slot) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (slot >= 0 && slot < this.recordCount) {
            return;
        }
        throw StandardException.newException("XSDA1.S");
    }

    public int setDeleteStatus(int slot, boolean delete) throws StandardException, IOException {
        this.checkSlotOnPage(slot);
        return this.getHeaderAtSlot(slot).setDeleted(delete);
    }

    public void deallocatePage() throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RawTransaction t = this.owner.getTransaction();
        this.owner.getActionSet().actionInvalidatePage(t, this);
    }

    public void initPage(int initFlag, long pageOffset) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RawTransaction t = this.owner.getTransaction();
        this.owner.getActionSet().actionInitPage(t, this, initFlag, this.getTypeFormatId(), pageOffset);
    }

    public int findRecordById(int recordId, int slotHint) {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (slotHint == 0) {
            slotHint = recordId - 6;
        }
        int maxSlot = this.recordCount();
        if (slotHint > 0 && slotHint < maxSlot && recordId == this.getHeaderAtSlot(slotHint).getId()) {
            return slotHint;
        }
        for (int slot = 0; slot < maxSlot; ++slot) {
            if (recordId != this.getHeaderAtSlot(slot).getId()) continue;
            return slot;
        }
        return -1;
    }

    private int findNextRecordById(int recordId) {
        SanityManager.ASSERT((boolean)this.isLatched());
        int maxSlot = this.recordCount();
        for (int slot = 0; slot < maxSlot; ++slot) {
            if (this.getHeaderAtSlot(slot).getId() <= recordId) continue;
            return slot;
        }
        return -1;
    }

    private void copyInto(BasePage srcPage, int src_slot, int num_rows, int dest_slot) throws StandardException {
        if (dest_slot < 0 || dest_slot > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        RawTransaction t = this.owner.getTransaction();
        int[] recordIds = new int[num_rows];
        PageKey pageId = this.getPageId();
        for (int i = 0; i < num_rows; ++i) {
            recordIds[i] = i == 0 ? this.newRecordId() : this.newRecordId(recordIds[i - 1]);
            RecordId handle = new RecordId(pageId, recordIds[i], i);
            this.owner.getLockingPolicy().lockRecordForWrite(t, handle, false, true);
        }
        this.owner.getActionSet().actionCopyRows(t, this, srcPage, dest_slot, num_rows, src_slot, recordIds);
    }

    protected void removeAndShiftDown(int slot) {
        SanityManager.ASSERT((boolean)this.isLatched());
        SanityManager.ASSERT((slot >= 0 && slot < this.recordCount ? 1 : 0) != 0);
        System.arraycopy(this.headers, slot + 1, this.headers, slot, this.headers.length - (slot + 1));
        this.headers[this.headers.length - 1] = null;
        --this.recordCount;
    }

    protected StoredRecordHeader shiftUp(int low) {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (low < 0 || low > this.recordCount) {
            SanityManager.THROWASSERT((String)("shiftUp failed, low must be between 0 and recordCount.  low = " + low + ", recordCount = " + this.recordCount + "\n page = " + this));
        }
        if (low < this.headers.length) {
            System.arraycopy(this.headers, low, this.headers, low + 1, this.headers.length - (low + 1));
            this.headers[low] = null;
        }
        return null;
    }

    public void compactRecord(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (handle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", handle);
        }
        if (handle.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAK.S", handle);
        }
        if (this.isOverflowPage()) {
            throw StandardException.newException("XSDAL.S", handle);
        }
        int slot = this.findRecordById(handle.getId(), handle.getSlotNumberHint());
        if (slot >= 0) {
            this.compactRecord(this.owner.getTransaction(), slot, handle.getId());
        }
    }

    public final LogInstant getLastLogInstant() {
        return this.lastLog;
    }

    protected final void clearLastLogInstant() {
        this.lastLog = null;
    }

    protected final void updateLastLogInstant(LogInstant instant) {
        SanityManager.ASSERT((boolean)this.isLatched());
        if (instant != null) {
            this.lastLog = instant;
        }
    }

    public final long getPageVersion() {
        return this.pageVersion;
    }

    protected final long bumpPageVersion() {
        SanityManager.ASSERT((boolean)this.isLatched());
        return ++this.pageVersion;
    }

    public final void setPageVersion(long v) {
        this.pageVersion = v;
    }

    protected void setPageStatus(byte status) {
        this.pageStatus = status;
    }

    public byte getPageStatus() {
        return this.pageStatus;
    }

    protected abstract boolean restoreRecordFromSlot(int var1, Object[] var2, FetchDescriptor var3, RecordHandle var4, StoredRecordHeader var5, boolean var6) throws StandardException;

    protected abstract void restorePortionLongColumn(OverflowInputStream var1) throws StandardException, IOException;

    public abstract int newRecordId() throws StandardException;

    public abstract int newRecordIdAndBump() throws StandardException;

    protected abstract int newRecordId(int var1) throws StandardException;

    public abstract boolean spaceForCopy(int var1, int[] var2) throws StandardException;

    public abstract int getTotalSpace(int var1) throws StandardException;

    public abstract int getReservedCount(int var1) throws IOException;

    public abstract int getRecordLength(int var1) throws IOException;

    public abstract void restoreRecordFromStream(LimitObjectInput var1, Object[] var2) throws StandardException, IOException;

    public abstract void logRecord(int var1, int var2, int var3, FormatableBitSet var4, OutputStream var5, RecordHandle var6) throws StandardException, IOException;

    public abstract int logRow(int var1, boolean var2, int var3, Object[] var4, FormatableBitSet var5, DynamicByteArrayOutputStream var6, int var7, byte var8, int var9, int var10, int var11) throws StandardException, IOException;

    public abstract void logField(int var1, int var2, OutputStream var3) throws StandardException, IOException;

    public abstract void logColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4, int var5) throws StandardException, IOException;

    public abstract int logLongColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4) throws StandardException, IOException;

    public abstract void storeRecord(LogInstant var1, int var2, boolean var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void storeField(LogInstant var1, int var2, int var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void reserveSpaceForSlot(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract void skipField(ObjectInput var1) throws StandardException, IOException;

    public abstract void skipRecord(ObjectInput var1) throws StandardException, IOException;

    public abstract void setDeleteStatus(LogInstant var1, int var2, boolean var3) throws StandardException, IOException;

    public abstract void purgeRecord(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    protected abstract void compactRecord(RawTransaction var1, int var2, int var3) throws StandardException;

    public abstract void setPageStatus(LogInstant var1, byte var2) throws StandardException;

    public abstract void initPage(LogInstant var1, byte var2, int var3, boolean var4, boolean var5) throws StandardException;

    public abstract void setReservedSpace(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract boolean isOverflowPage();

    public abstract boolean allowInsert();

    public abstract boolean unfilled();

    public abstract void setContainerRowCount(long var1);

    protected abstract byte[] getPageArray() throws StandardException;

    protected String slotTableToString() {
        String str = null;
        str = new String();
        for (int slot = 0; slot < this.recordCount; ++slot) {
            StoredRecordHeader rh = this.getHeaderAtSlot(slot);
            str = rh != null ? str + "Slot " + slot + " recordId " + rh.getId() : str + "Slot " + slot + " null record";
            str = str + "\n";
        }
        return str;
    }
}

