/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeSort;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.Scan;

public abstract class SortScan
extends Scan {
    protected MergeSort sort = null;
    protected TransactionManager tran = null;
    protected ExecRow current;
    protected boolean hold;

    SortScan(MergeSort sort, TransactionManager tran, boolean hold) {
        this.sort = sort;
        this.tran = tran;
        this.hold = hold;
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        boolean ret_val = this.next();
        if (ret_val) {
            this.fetch(row);
        }
        return ret_val;
    }

    @Override
    public final void fetch(DataValueDescriptor[] result) throws StandardException {
        SanityManager.ASSERT((this.sort != null ? 1 : 0) != 0);
        if (this.current == null) {
            throw StandardException.newException("XSAS1.S");
        }
        this.sort.checkColumnTypes(result);
        System.arraycopy(this.current.getRowArray(), 0, result, 0, result.length);
    }

    @Override
    public final void fetchWithoutQualify(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    @Override
    public void close() {
        this.sort = null;
        this.current = null;
        this.tran.closeMe(this);
    }
}

