/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeSort;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.SortBuffer;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.SortScan;

public class SortBufferScan
extends SortScan {
    protected SortBuffer sortBuffer;

    SortBufferScan(MergeSort sort, TransactionManager tran, SortBuffer sortBuffer, boolean hold) {
        super(sort, tran, hold);
        SanityManager.ASSERT((sortBuffer != null ? 1 : 0) != 0);
        this.sortBuffer = sortBuffer;
    }

    @Override
    public boolean next() throws StandardException {
        SanityManager.ASSERT((this.sortBuffer != null ? 1 : 0) != 0, (String)"next() called on scan after scan was closed.");
        this.current = this.sortBuffer.removeFirst();
        return this.current != null;
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) {
        if (closeHeldScan || !this.hold) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer);
        }
        super.close();
        this.sortBuffer = null;
    }

    public void setCurrentRakInfoInInputArray(ExecRow inputRow) {
        if (this.current != null && inputRow != null) {
            inputRow.setAllRegionAndKeyInfo(this.current.getAllRegionAndKeyInfo());
        }
    }
}

