/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.Heap;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapController;

class HeapPostCommit
implements Serviceable {
    private AccessFactory access_factory = null;
    private Heap heap = null;
    private long page_number = -1L;

    HeapPostCommit(AccessFactory access_factory, Heap heap, long input_page_number) {
        this.access_factory = access_factory;
        this.heap = heap;
        this.page_number = input_page_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void purgeCommittedDeletes(HeapController heap_control, long pageno) throws StandardException {
        Page page = heap_control.getUserPageWait(pageno);
        boolean purgingDone = false;
        if (page != null) {
            try {
                int num_possible_commit_delete = page.recordCount() - page.nonDeletedRecordCount();
                if (num_possible_commit_delete > 0) {
                    for (int slot_no = page.recordCount() - 1; slot_no >= 0; --slot_no) {
                        RecordHandle rh;
                        boolean row_is_committed_delete = page.isDeletedAtSlot(slot_no);
                        if (!row_is_committed_delete || !(row_is_committed_delete = heap_control.lockRowAtSlotNoWaitExclusive(rh = page.fetchFromSlot(null, slot_no, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                        purgingDone = true;
                        page.purgeAtSlot(slot_no, 1, false);
                        if (!SanityManager.DEBUG_ON((String)"verbose_heap_post_commit")) continue;
                        SanityManager.DEBUG_PRINT((String)"HeapPostCommit", (String)("Purging row[" + slot_no + "]" + "on page:" + pageno + ".\n"));
                    }
                }
                if (page.recordCount() != 0) return;
                purgingDone = true;
                heap_control.removePage(page);
                if (!SanityManager.DEBUG_ON((String)"verbose_heap_post_commit")) return;
                SanityManager.DEBUG_PRINT((String)"HeapPostCommit", (String)("Calling Heap removePage().; pagenumber=" + pageno + "\n"));
                return;
            }
            finally {
                if (!purgingDone) {
                    page.unlatch();
                    page = null;
                }
            }
        } else {
            if (!SanityManager.DEBUG_ON((String)"verbose_heap_post_commit")) return;
            SanityManager.DEBUG_PRINT((String)"HeapPostCommit", (String)("Get No Wait returned null. page num = " + pageno + "\n"));
            SanityManager.showTrace((Throwable)new Throwable());
        }
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    @Override
    public int performWork(ContextManager contextMgr) throws StandardException {
        boolean requeue_work;
        TransactionManager internal_xact;
        block4: {
            TransactionManager tc = (TransactionManager)this.access_factory.getAndNameTransaction(contextMgr, "SystemTransaction");
            internal_xact = tc.getInternalTransaction();
            requeue_work = false;
            if (SanityManager.DEBUG_ON((String)"verbose_heap_post_commit")) {
                SanityManager.DEBUG_PRINT((String)"HeapPostCommit", (String)"starting internal xact\n");
            }
            try {
                HeapController heapcontroller = (HeapController)this.heap.open(internal_xact, internal_xact.getRawStoreXact(), false, 132, 6, internal_xact.getRawStoreXact().newLockingPolicy(1, 4, true), this.heap, null);
                this.purgeCommittedDeletes(heapcontroller, this.page_number);
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("40XL1") && !se.getMessageId().equals("40001")) break block4;
                requeue_work = true;
            }
        }
        internal_xact.commitNoSync(1);
        internal_xact.destroy();
        if (SanityManager.DEBUG_ON((String)"verbose_heap_post_commit") && requeue_work) {
            SanityManager.DEBUG_PRINT((String)"HeapPostCommit", (String)("requeueing on page num = " + this.page_number));
        }
        return requeue_work ? 2 : 1;
    }
}

