/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BranchRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.LeafControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.OpenBTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.SearchParameters;

public class BranchControlRow
extends ControlRow {
    protected SQLLongint left_child_page = null;
    transient SQLLongint child_pageno_buf = null;
    private static final int CR_LEFTCHILD = 7;
    private static final int CR_COLID_LAST = 7;
    private static final int CR_NCOLUMNS = 8;
    protected static final FormatableBitSet CR_LEFTCHILD_BITMAP = new FormatableBitSet(8);

    public BranchControlRow() {
    }

    public BranchControlRow(OpenBTree open_btree, Page page, int level, ControlRow parent, boolean isRoot, long left_child) throws StandardException {
        super(open_btree, page, level, parent, isRoot);
        this.left_child_page = new SQLLongint(left_child);
        this.row[7] = this.left_child_page;
        this.child_pageno_buf = new SQLLongint();
    }

    @Override
    protected final void controlRowInit() {
        this.child_pageno_buf = new SQLLongint();
    }

    @Override
    public boolean isLeftmostLeaf() throws StandardException {
        return false;
    }

    @Override
    public boolean isRightmostLeaf() throws StandardException {
        return false;
    }

    @Override
    protected final int getNumberOfControlRowColumns() {
        return 8;
    }

    public static long restartSplitFor(OpenBTree open_btree, DataValueDescriptor[] template, BranchControlRow parent, ControlRow child, DataValueDescriptor[] newbranchrow, DataValueDescriptor[] splitrow, int flag) throws StandardException {
        parent.release();
        child.release();
        parent = null;
        child = null;
        ControlRow root = ControlRow.get(open_btree, 1L);
        SanityManager.ASSERT((boolean)root.page.isLatched());
        return root.splitFor(open_btree, template, null, newbranchrow, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControlRow search(SearchParameters sp) throws StandardException {
        ControlRow childpage = null;
        boolean got_error = true;
        try {
            this.searchForEntry(sp);
            if (sp.searchForOptimizer) {
                float left_rows = sp.resultSlot;
                int row_count = this.page.recordCount();
                if (this.getIsRoot()) {
                    sp.current_fraction = 1.0f;
                    sp.left_fraction = 0.0f;
                }
                sp.left_fraction += sp.current_fraction * (left_rows / (float)row_count);
                sp.current_fraction *= 1.0f / (float)row_count;
            }
            childpage = this.getChildPageAtSlot(sp.btree, sp.resultSlot);
            this.release();
            got_error = false;
            ControlRow controlRow = childpage.search(sp);
            return controlRow;
        }
        finally {
            if (got_error) {
                if (childpage != null) {
                    childpage.release();
                }
                if (this.page.isLatched()) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ControlRow searchLeft(OpenBTree btree) throws StandardException {
        ControlRow childpage = null;
        boolean got_error = true;
        try {
            childpage = this.getLeftChild(btree);
            this.release();
            got_error = false;
            ControlRow controlRow = childpage.searchLeft(btree);
            return controlRow;
        }
        finally {
            if (got_error) {
                if (childpage != null) {
                    childpage.release();
                }
                if (this.page.isLatched()) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ControlRow searchRight(OpenBTree btree) throws StandardException {
        ControlRow childpage = null;
        boolean got_error = true;
        try {
            childpage = this.getRightChild(btree);
            this.release();
            got_error = false;
            ControlRow controlRow = childpage.searchRight(btree);
            return controlRow;
        }
        finally {
            if (got_error) {
                if (childpage != null) {
                    childpage.release();
                }
                if (this.page.isLatched()) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shrinkFor(OpenBTree open_btree, DataValueDescriptor[] shrink_key) throws StandardException {
        ControlRow childpage = null;
        boolean shrinkme = false;
        try {
            SanityManager.ASSERT((boolean)this.page.isLatched());
            BranchRow branch_template = BranchRow.createEmptyTemplate(open_btree.getRawTran(), open_btree.getConglomerate());
            SearchParameters sp = new SearchParameters(shrink_key, 1, branch_template.getRow(), open_btree, false);
            this.searchForEntry(sp);
            childpage = this.getChildPageAtSlot(sp.btree, sp.resultSlot);
            if (childpage.shrinkFor(open_btree, shrink_key)) {
                if (sp.resultSlot != 0) {
                    this.page.purgeAtSlot(sp.resultSlot, 1, true);
                } else if (this.page.recordCount() > 1) {
                    long leftchildpageid = this.getChildPageIdAtSlot(open_btree, 1);
                    this.setLeftChildPageno(leftchildpageid);
                    this.page.purgeAtSlot(1, 1, true);
                } else if (this.getIsRoot()) {
                    SanityManager.ASSERT((this.page.recordCount() == 1 ? 1 : 0) != 0);
                    LeafControlRow newleafroot = new LeafControlRow(open_btree, this.page, null, true);
                    newleafroot.page.updateAtSlot(0, newleafroot.getRow(), null);
                    newleafroot.release();
                    shrinkme = true;
                } else if (this.unlink(open_btree)) {
                    shrinkme = true;
                }
            }
        }
        finally {
            if (!shrinkme) {
                this.release();
            }
        }
        return shrinkme;
    }

    @Override
    protected long splitFor(OpenBTree open_btree, DataValueDescriptor[] template, BranchControlRow parent, DataValueDescriptor[] splitrow, int flag) throws StandardException {
        SanityManager.ASSERT((parent != null || this.getIsRoot() ? 1 : 0) != 0);
        SanityManager.ASSERT((parent == null || parent.page.isLatched() ? 1 : 0) != 0, (String)"parent page is not latched");
        SanityManager.ASSERT((boolean)this.page.isLatched(), (String)"page is not latched:");
        int n = this.page.recordCount() - 1;
        open_btree.getConglomerate();
        if (n >= BTree.maxRowsPerPage || !this.page.spaceForInsert(splitrow, null, 50)) {
            BranchControlRow pagetofollow;
            if (this.page.recordCount() == 1) {
                throw StandardException.newException("XSCB6.S");
            }
            if (this.getIsRoot()) {
                BranchControlRow.growRoot(open_btree, template, this);
                parent = (BranchControlRow)ControlRow.get(open_btree, 1L);
                return parent.splitFor(open_btree, template, null, splitrow, flag);
            }
            SanityManager.ASSERT((!this.getIsRoot() ? 1 : 0) != 0);
            SanityManager.ASSERT((parent != null ? 1 : 0) != 0);
            int splitpoint = (this.page.recordCount() - 1) / 2 + 1;
            if ((flag & 4) != 0) {
                splitpoint = 1;
            } else if ((flag & 1) != 0) {
                splitpoint = this.page.recordCount() - 1;
            }
            if (splitpoint <= 0) {
                SanityManager.THROWASSERT((String)(this + "yikes! splitpoint of 0!"));
            }
            BranchRow split_branch_row = BranchRow.createEmptyTemplate(open_btree.getRawTran(), open_btree.getConglomerate());
            this.page.fetchFromSlot(null, splitpoint, split_branch_row.getRow(), null, true);
            BranchRow newbranchrow = split_branch_row.createBranchRowFromOldBranchRow(-1L);
            if (!parent.page.spaceForInsert(newbranchrow.getRow(), null, 50)) {
                return BranchControlRow.restartSplitFor(open_btree, template, parent, this, newbranchrow.getRow(), splitrow, flag);
            }
            ControlRow childpage = this.getChildPageAtSlot(open_btree, splitpoint);
            BranchControlRow newbranch = BranchControlRow.allocate(open_btree, childpage, this.getLevel(), parent);
            newbranch.linkRight(open_btree, this);
            if (SanityManager.DEBUG_ON((String)"branch_split_abort1")) {
                throw StandardException.newException("XSCB9.S");
            }
            childpage.release();
            newbranchrow.setPageNumber(newbranch.page.getPageNumber());
            BranchRow branch_template = BranchRow.createEmptyTemplate(open_btree.getRawTran(), open_btree.getConglomerate());
            SearchParameters sp = new SearchParameters(newbranchrow.getRow(), 1, branch_template.getRow(), open_btree, false);
            parent.searchForEntry(sp);
            byte insertFlag = 0;
            insertFlag = (byte)(insertFlag | 1);
            insertFlag = (byte)(insertFlag | 2);
            if (parent.page.insertAtSlot(sp.resultSlot + 1, newbranchrow.getRow(), null, null, insertFlag, 50) == null) {
                throw StandardException.newException("XSCB6.S");
            }
            if (SanityManager.DEBUG_ON((String)"branch_split_abort2")) {
                throw StandardException.newException("XSCB9.S");
            }
            newbranchrow = null;
            int num_rows_to_move = this.page.recordCount() - (splitpoint + 1);
            if (num_rows_to_move > 0) {
                this.page.copyAndPurge(newbranch.page, splitpoint + 1, num_rows_to_move, 1);
            }
            this.page.purgeAtSlot(splitpoint, 1, true);
            if (SanityManager.DEBUG_ON((String)"branch_split_abort3")) {
                throw StandardException.newException("XSCB9.S");
            }
            if (SanityManager.DEBUG_ON((String)"branch_split_abort4")) {
                throw StandardException.newException("XSCB9.S");
            }
            if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
                parent.checkConsistency(open_btree, null, false);
                newbranch.checkConsistency(open_btree, parent, false);
                this.checkConsistency(open_btree, parent, false);
            }
            newbranch.fixChildrensParents(open_btree, null);
            open_btree.getXactMgr().commit();
            if (BranchControlRow.compareIndexRowToKey(splitrow, split_branch_row.getRow(), split_branch_row.getRow().length - 1, 0, open_btree.getConglomerate().ascDescInfo) >= 0) {
                pagetofollow = newbranch;
                this.release();
            } else {
                pagetofollow = this;
                newbranch.release();
            }
            SanityManager.ASSERT((parent != null ? 1 : 0) != 0);
            SanityManager.ASSERT((boolean)parent.page.isLatched());
            SanityManager.ASSERT((boolean)pagetofollow.page.isLatched());
            return pagetofollow.splitFor(open_btree, template, parent, splitrow, flag);
        }
        if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
            this.checkConsistency(open_btree, parent, false);
        }
        if (parent != null) {
            parent.release();
        }
        BranchRow branch_template = BranchRow.createEmptyTemplate(open_btree.getRawTran(), open_btree.getConglomerate());
        SearchParameters sp = new SearchParameters(splitrow, 1, branch_template.getRow(), open_btree, false);
        this.searchForEntry(sp);
        ControlRow childpage = this.getChildPageAtSlot(open_btree, sp.resultSlot);
        return childpage.splitFor(open_btree, template, this, splitrow, flag);
    }

    @Override
    public int checkConsistency(OpenBTree btree, ControlRow parent, boolean check_other_pages) throws StandardException {
        this.checkGeneric(btree, parent, check_other_pages);
        SanityManager.ASSERT((this.getLevel() > 0 ? 1 : 0) != 0, (String)"branch not above level 0");
        SanityManager.ASSERT((this.page.fetchNumFieldsAtSlot(0) == 8 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.getLeftChildPageno() != -1L ? 1 : 0) != 0);
        SanityManager.ASSERT((this.getLeftChildPageno() >= 1L ? 1 : 0) != 0);
        int numslots = this.page.recordCount();
        for (int slot = 1; slot < numslots; ++slot) {
            if (this.page.fetchNumFieldsAtSlot(slot) != btree.getConglomerate().nKeyFields + 1) {
                SanityManager.THROWASSERT((String)("row[" + slot + "]" + " has " + this.page.fetchNumFieldsAtSlot(slot) + " columns, should have at least " + (btree.getConglomerate().nKeyFields + 1)));
            }
            SanityManager.ASSERT((this.getChildPageIdAtSlot(btree, slot) != -1L ? 1 : 0) != 0);
            SanityManager.ASSERT((!this.page.isDeletedAtSlot(slot) ? 1 : 0) != 0);
            SanityManager.ASSERT((this.getLeftChildPageno() >= 1L ? 1 : 0) != 0);
        }
        if (check_other_pages) {
            this.checkChildOrderAgainstRowOrder(btree);
        }
        int nchildren = 0;
        if (check_other_pages) {
            nchildren = this.checkChildren(btree);
        }
        return nchildren + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkChildren(OpenBTree btree) throws StandardException {
        int nchildren = 0;
        ControlRow childpage = null;
        try {
            childpage = this.getLeftChild(btree);
            nchildren += childpage.checkConsistency(btree, this, true);
            childpage.release();
            childpage = null;
            int numslots = this.page.recordCount();
            for (int slot = 1; slot < numslots; ++slot) {
                childpage = this.getChildPageAtSlot(btree, slot);
                nchildren += childpage.checkConsistency(btree, this, true);
                childpage.release();
                childpage = null;
            }
            int n = nchildren;
            return n;
        }
        finally {
            if (childpage != null) {
                childpage.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChildOrderAgainstRowOrder(OpenBTree btree) throws StandardException {
        ControlRow cur = null;
        ControlRow prev = null;
        try {
            prev = this.getLeftChild(btree);
            int numslots = this.page.recordCount();
            for (int slot = 1; slot < numslots; ++slot) {
                long shouldbeprev_pageno;
                cur = this.getChildPageAtSlot(btree, slot);
                long shouldbecur_pageno = prev.getrightSiblingPageNumber();
                if (shouldbecur_pageno != cur.page.getPageNumber()) {
                    SanityManager.THROWASSERT((String)("child linkage error going right.\ncur page control row = " + cur + "\n" + "prev page control row = " + prev + "\n"));
                }
                SanityManager.ASSERT(((shouldbeprev_pageno = cur.getleftSiblingPageNumber()) == prev.page.getPageNumber() ? 1 : 0) != 0, (String)"child linkeage error going left");
                prev.release();
                prev = cur;
                cur = null;
            }
            prev.release();
            prev = null;
        }
        finally {
            if (prev != null) {
                prev.release();
            }
            if (cur != null) {
                cur.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printTree(OpenBTree btree) throws StandardException {
        SanityManager.DEBUG_PRINT((String)"p_tree", (String)this.debugPage(btree));
        ControlRow child = null;
        try {
            child = this.getLeftChild(btree);
            child.printTree(btree);
            child.release();
            child = null;
            int numslots = this.page.recordCount();
            for (int slot = 1; slot < numslots; ++slot) {
                child = this.getChildPageAtSlot(btree, slot);
                child.printTree(btree);
                child.release();
                child = null;
            }
        }
        finally {
            if (child != null) {
                child.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void growRoot(OpenBTree open_btree, DataValueDescriptor[] template, BranchControlRow root) throws StandardException {
        ControlRow leftchild = null;
        ControlRow branch = null;
        try {
            SanityManager.ASSERT((boolean)root.page.isLatched());
            SanityManager.ASSERT((boolean)root.getIsRoot());
            leftchild = root.getLeftChild(open_btree);
            branch = BranchControlRow.allocate(open_btree, leftchild, root.getLevel(), root);
            root.page.copyAndPurge(((BranchControlRow)branch).page, 1, root.page.recordCount() - 1, 1);
            root.setLeftChild(branch);
            root.setLevel(root.getLevel() + 1);
            super.fixChildrensParents(open_btree, leftchild);
            if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
                root.checkConsistency(open_btree, null, false);
                ((BranchControlRow)branch).checkConsistency(open_btree, root, false);
                leftchild.checkConsistency(open_btree, branch, false);
            }
            open_btree.getXactMgr().commit();
        }
        finally {
            root.release();
            if (branch != null) {
                branch.release();
            }
            if (leftchild != null) {
                leftchild.release();
            }
        }
    }

    private static BranchControlRow allocate(OpenBTree open_btree, ControlRow leftchild, int level, ControlRow parent) throws StandardException {
        Page page = open_btree.container.addPage();
        BranchControlRow control_row = new BranchControlRow(open_btree, page, level, parent, false, leftchild.page.getPageNumber());
        byte insertFlag = 0;
        insertFlag = (byte)(insertFlag | 1);
        page.insertAtSlot(0, control_row.getRow(), null, null, insertFlag, 50);
        return control_row;
    }

    protected void setLeftChildPageno(long leftchild_pageno) throws StandardException {
        if (this.left_child_page == null) {
            this.left_child_page = new SQLLongint(leftchild_pageno);
        } else {
            this.left_child_page.setValue(leftchild_pageno);
        }
        this.page.updateFieldAtSlot(0, 7, this.left_child_page, null);
    }

    protected void setLeftChild(ControlRow leftchild) throws StandardException {
        this.setLeftChildPageno(leftchild.page.getPageNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixChildrensParents(OpenBTree btree, ControlRow leftchild) throws StandardException {
        ControlRow child = null;
        try {
            if (leftchild == null) {
                child = this.getLeftChild(btree);
                child.setParent(this.page.getPageNumber());
                if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
                    child.checkConsistency(btree, this, false);
                }
                child.release();
                child = null;
            } else {
                leftchild.setParent(this.page.getPageNumber());
                if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
                    leftchild.checkConsistency(btree, this, false);
                }
            }
            int numslots = this.page.recordCount();
            for (int slot = 1; slot < numslots; ++slot) {
                child = this.getChildPageAtSlot(btree, slot);
                child.setParent(this.page.getPageNumber());
                if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
                    child.checkConsistency(btree, this, false);
                }
                child.release();
                child = null;
            }
        }
        finally {
            if (child != null) {
                child.release();
            }
        }
    }

    private long getChildPageIdAtSlot(OpenBTree btree, int slot) throws StandardException {
        long child_page_id;
        if (slot == 0) {
            child_page_id = this.getLeftChildPageno();
        } else {
            this.page.fetchFieldFromSlot(slot, btree.getConglomerate().nKeyFields, this.child_pageno_buf);
            child_page_id = this.child_pageno_buf.getLong();
        }
        return child_page_id;
    }

    protected ControlRow getChildPageAtSlot(OpenBTree open_btree, int slot) throws StandardException {
        ControlRow child_control_row;
        if (slot == 0) {
            child_control_row = this.getLeftChild(open_btree);
        } else {
            this.page.fetchFieldFromSlot(slot, open_btree.getConglomerate().nKeyFields, this.child_pageno_buf);
            child_control_row = ControlRow.get(open_btree, this.child_pageno_buf.getLong());
        }
        return child_control_row;
    }

    @Override
    public ControlRow getLeftChild(OpenBTree open_btree) throws StandardException {
        return ControlRow.get(open_btree, this.getLeftChildPageno());
    }

    @Override
    protected ControlRow getRightChild(OpenBTree open_btree) throws StandardException {
        int num_slots = this.page.recordCount();
        ControlRow right_child = num_slots == 1 ? ControlRow.get(open_btree, this.getLeftChildPageno()) : this.getChildPageAtSlot(open_btree, num_slots - 1);
        return right_child;
    }

    long getLeftChildPageno() throws StandardException {
        if (this.left_child_page == null) {
            this.left_child_page = new SQLLongint();
            this.scratch_row[7] = this.left_child_page;
            this.fetchDesc.setValidColumns(CR_LEFTCHILD_BITMAP);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.left_child_page.getLong();
    }

    @Override
    public int getTypeFormatId() {
        return 134;
    }

    @Override
    public DataValueDescriptor[] getRowTemplate(OpenBTree open_btree) throws StandardException {
        return BranchRow.createEmptyTemplate(open_btree.getRawTran(), open_btree.getConglomerate()).getRow();
    }

    @Override
    public String toString() {
        String string = super.toString();
        try {
            string = string + "left child page = " + this.getLeftChildPageno() + ";";
        }
        catch (Throwable t) {
            string = string + "error encountered while doing ControlRow.toString()";
        }
        return string;
    }

    static {
        CR_LEFTCHILD_BITMAP.set(7);
    }
}

