/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import java.util.Properties;

public class IndexChanger {
    private IndexRowGenerator irg;
    private long indexCID;
    private DynamicCompiledOpenConglomInfo indexDCOCI;
    private StaticCompiledOpenConglomInfo indexSCOCI;
    private String indexName;
    private ConglomerateController baseCC;
    private TransactionController tc;
    private int lockMode;
    private FormatableBitSet baseRowReadMap;
    private ConglomerateController indexCC = null;
    private ScanController indexSC = null;
    private ExecIndexRow ourIndexRow = null;
    private ExecIndexRow ourUpdatedIndexRow = null;
    private TemporaryRowHolderImpl rowHolder = null;
    private boolean rowHolderPassedIn;
    private int isolationLevel;
    private final Activation activation;
    private boolean ownIndexSC = true;

    public IndexChanger(IndexRowGenerator irg, long indexCID, StaticCompiledOpenConglomInfo indexSCOCI, DynamicCompiledOpenConglomInfo indexDCOCI, String indexName, ConglomerateController baseCC, TransactionController tc, int lockMode, FormatableBitSet baseRowReadMap, int isolationLevel, Activation activation) throws StandardException {
        this.irg = irg;
        this.indexCID = indexCID;
        this.indexSCOCI = indexSCOCI;
        this.indexDCOCI = indexDCOCI;
        this.baseCC = baseCC;
        this.tc = tc;
        this.lockMode = lockMode;
        this.baseRowReadMap = baseRowReadMap;
        this.rowHolderPassedIn = false;
        this.isolationLevel = isolationLevel;
        this.activation = activation;
        this.indexName = indexName;
        if (activation != null && activation.getIndexConglomerateNumber() == indexCID) {
            this.ownIndexSC = false;
        }
        SanityManager.ASSERT((tc != null ? 1 : 0) != 0, (String)"TransactionController argument to constructor is null");
        SanityManager.ASSERT((irg != null ? 1 : 0) != 0, (String)"IndexRowGenerator argument to constructor is null");
    }

    public void setRowHolder(TemporaryRowHolderImpl rowHolder) {
        this.rowHolder = rowHolder;
        this.rowHolderPassedIn = rowHolder != null;
    }

    public void setBaseCC(ConglomerateController baseCC) {
        this.baseCC = baseCC;
    }

    private void setOurIndexRow(ExecRow baseRow, RowLocation baseRowLoc) throws StandardException {
        if (this.ourIndexRow == null) {
            this.ourIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(baseRow, baseRowLoc, this.ourIndexRow, this.baseRowReadMap);
    }

    private void setOurUpdatedIndexRow(ExecRow baseRow, RowLocation baseRowLoc) throws StandardException {
        if (this.ourUpdatedIndexRow == null) {
            this.ourUpdatedIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(baseRow, baseRowLoc, this.ourUpdatedIndexRow, this.baseRowReadMap);
    }

    private boolean indexRowChanged() throws StandardException {
        int numColumns = this.ourIndexRow.nColumns();
        for (int index = 1; index <= numColumns; ++index) {
            DataValueDescriptor newOrderable;
            DataValueDescriptor oldOrderable = this.ourIndexRow.getColumn(index);
            if (oldOrderable.compare(2, newOrderable = this.ourUpdatedIndexRow.getColumn(index), true, true)) continue;
            return true;
        }
        return false;
    }

    private void setScan() throws StandardException {
        if (!this.ownIndexSC) {
            this.indexSC = this.activation.getIndexScanController();
        } else if (this.indexSC == null) {
            RowLocation templateBaseRowLocation = this.baseCC.newRowLocationTemplate();
            this.indexSC = this.indexSCOCI == null ? this.tc.openScan(this.indexCID, false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1, null) : this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1, this.indexSCOCI, this.indexDCOCI);
        } else {
            this.indexSC.reopenScan(this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1, null);
        }
    }

    private void closeIndexCC() throws StandardException {
        if (this.indexCC != null) {
            this.indexCC.close();
        }
        this.indexCC = null;
    }

    private void closeIndexSC() throws StandardException {
        if (this.ownIndexSC && this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
    }

    private void doDelete() throws StandardException {
        if (this.ownIndexSC && !this.indexSC.next()) {
            if (GemFireXDUtils.TracePersistIndex) {
                ((MemIndexScanController)this.indexSC).dumpIndex(null);
            }
            SanityManager.THROWASSERT((String)("Index row " + RowUtil.toString(this.ourIndexRow) + " not found in conglomerateid " + this.indexCID + "Current scan = " + this.indexSC + " the size of the index : " + ((MemIndexScanController)this.indexSC).sizeOfIndex()));
            Object[] args = new Object[]{this.ourIndexRow.getRowArray()[this.ourIndexRow.getRowArray().length - 1], this.indexCID};
            Monitor.getStream().println(MessageService.getCompleteMessage("X0Y83.S", args));
            return;
        }
        this.indexSC.delete();
    }

    private void doInsert() throws StandardException {
        this.insertAndCheckDups(this.ourIndexRow);
    }

    private void doDeferredInsert() throws StandardException {
        if (this.rowHolder == null) {
            Properties properties = new Properties();
            this.openIndexCC().getInternalTablePropertySet(properties);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties);
        }
        if (!this.rowHolderPassedIn) {
            this.rowHolder.insert(this.ourIndexRow);
        }
    }

    private void insertAndCheckDups(ExecIndexRow row) throws StandardException {
        this.openIndexCC();
        int insertStatus = this.indexCC.insert(row.getRowArray());
        if (insertStatus == 1) {
            String indexOrConstraintName = this.indexName;
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            DataDictionary dd = lcc.getDataDictionary();
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.indexCID);
            UUID tableID = cd.getTableID();
            TableDescriptor td = dd.getTableDescriptor(tableID);
            String tableName = td.getName();
            if (indexOrConstraintName == null) {
                ConstraintDescriptor conDesc = dd.getConstraintDescriptor(td, cd.getUUID());
                indexOrConstraintName = conDesc.getConstraintName();
            }
            StandardException se = StandardException.newException("23505", (Object)indexOrConstraintName, (Object)tableName);
            throw se;
        }
        if (insertStatus != 0) {
            SanityManager.THROWASSERT((String)("Unknown insert status " + insertStatus));
        }
    }

    private ConglomerateController openIndexCC() throws StandardException {
        if (this.indexCC == null) {
            this.indexCC = this.indexSCOCI == null ? this.tc.openConglomerate(this.indexCID, false, 16388, this.lockMode, this.isolationLevel) : this.tc.openCompiledConglomerate(false, 16388, this.lockMode, this.isolationLevel, this.indexSCOCI, this.indexDCOCI);
        }
        return this.indexCC;
    }

    public void open() throws StandardException {
    }

    public void delete(ExecRow baseRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(baseRow, baseRowLocation);
        this.setScan();
        this.doDelete();
    }

    public void update(ExecRow oldBaseRow, ExecRow newBaseRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(oldBaseRow, baseRowLocation);
        this.setOurUpdatedIndexRow(newBaseRow, baseRowLocation);
        if (this.indexRowChanged()) {
            this.setScan();
            this.doDelete();
            this.insertForUpdate(newBaseRow, baseRowLocation);
        }
    }

    public void insert(ExecRow newRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(newRow, baseRowLocation);
        this.doInsert();
    }

    void insertForUpdate(ExecRow newRow, RowLocation baseRowLocation) throws StandardException {
        this.setOurIndexRow(newRow, baseRowLocation);
        if (this.irg.isUnique() || this.irg.isUniqueWithDuplicateNulls()) {
            this.doDeferredInsert();
        } else {
            this.doInsert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws StandardException {
        if (this.rowHolder != null) {
            CursorResultSet rs = this.rowHolder.getResultSet();
            try {
                ExecRow deferredRow;
                rs.open();
                while ((deferredRow = rs.getNextRow()) != null) {
                    if (!(deferredRow instanceof ExecIndexRow)) {
                        SanityManager.THROWASSERT((String)("deferredRow isn't an instance of ExecIndexRow as expected. It is an " + deferredRow.getClass().getName()));
                    }
                    this.insertAndCheckDups((ExecIndexRow)deferredRow);
                }
            }
            finally {
                rs.close(false);
                if (!this.rowHolderPassedIn) {
                    this.rowHolder.close();
                }
            }
        }
    }

    public void close() throws StandardException {
        this.closeIndexCC();
        this.closeIndexSC();
        if (this.rowHolder != null && !this.rowHolderPassedIn) {
            this.rowHolder.close();
        }
        this.baseCC = null;
    }
}

