/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.AsyncQueueCreateOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdAsyncEventListenerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.services.reflect.JarLoader;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.Set;

public class CreateAsyncEventListenerConstantAction
extends DDLConstantAction {
    private final String id;
    private final ServerGroupsTableAttribute serverGroups;
    private final AsyncQueueCreateOperation queueCreateOp;
    public static final String REGION_PREFIX_FOR_CONFLATION = "__GFXD_INTERNAL_ASYNCLISTENER_";

    CreateAsyncEventListenerConstantAction(String id, ServerGroupsTableAttribute serverGroups, boolean manualStart, boolean enableBatchConflation, int batchSize, int batchTimeInterval, boolean enablePersistence, boolean diskSync, String diskStoreName, int maximumQueueMemory, int alertThreshold, boolean isParallel, String className, String initParams) {
        this.queueCreateOp = new AsyncQueueCreateOperation(id, manualStart, enableBatchConflation, batchSize, batchTimeInterval, enablePersistence, diskSync, diskStoreName, maximumQueueMemory, alertThreshold, isParallel, className, initParams);
        this.id = id;
        this.serverGroups = serverGroups;
    }

    public String toString() {
        return this.constructToString("CREATE ASYNCEVENTLISTENER", this.id);
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return REGION_PREFIX_FOR_CONFLATION + this.id;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        String servers;
        Set<DistributedMember> members;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        try {
            GemFireXDUtils.initializePrivateKey("AES", 128, lcc);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
        }
        if (!this.queueCreateOp.isParallel && !ServerGroupUtils.isDataStore()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Skipping create gateway receiver for " + this.id + " on JVM of kind " + GemFireXDUtils.getMyVMKind()));
            return;
        }
        if (this.serverGroups != null) {
            members = GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(this.serverGroups.getServerGroupSet());
            servers = SharedUtils.toCSV(this.serverGroups.getServerGroupSet());
        } else {
            members = GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(null);
            servers = "";
        }
        InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
        boolean self = members.remove(myId);
        Class c = null;
        try {
            c = ClassPathLoader.getLatest().forName(this.queueCreateOp.className);
            if (self) {
                GemFireTransaction gft = (GemFireTransaction)lcc.getTransactionExecute();
                gft.logAndDo(this.queueCreateOp);
            }
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
        }
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        UUID uid = dd.getUUIDFactory().recreateUUID(this.id);
        GfxdAsyncEventListenerDescriptor ghd = new GfxdAsyncEventListenerDescriptor(dd, uid, this.id, this.queueCreateOp.className, servers, this.queueCreateOp.manualStart, this.queueCreateOp.enableBatchConflation, this.queueCreateOp.batchSize, this.queueCreateOp.batchTimeInterval, this.queueCreateOp.enablePersistence, this.queueCreateOp.diskSync, this.queueCreateOp.diskStoreName, this.queueCreateOp.maximumQueueMemory, this.queueCreateOp.alertThreshold, !this.queueCreateOp.manualStart, this.queueCreateOp.initParams);
        dd.addDescriptor(ghd, null, 22, false, tc);
        Misc.getMemStore().getUUID_IDMap().put((Object)uid, (Object)this.id);
        DependencyManager dm = dd.getDependencyManager();
        ClassLoader loader = c.getClassLoader();
        if (loader instanceof JarLoader) {
            dm.addDependency(ghd, (JarLoader)loader, lcc.getContextManager());
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateAsyncEventListenerNode:: inserted AsyncEventListener configuration for " + this.id + " in SYS table"));
    }
}

